## [4.1.1375] - 20240814

### 新增

1. [通用] 支持期权按照系列收取申报费：如果柜台支持按照系列收取，则信息量和费率查询也是系列级别；



### 优化

1. [通用] 行情订阅接口注释和文档优化，增加订阅/取消订阅`所有合约`的注释说明；
2. [通用] 使用手册文档完善看穿式监管信息的说明；
3. [通用] 成交明细日志打印优化，增加对合约编号的边界控制处理；



### 修复

1. [通用] 修复“国债期权报价衍生单成交时，占用保证金计算不正确”的问题；
2. [上期能源所] 修复“标准算法场景下，根据行情更新占用保证金和冻结保证金时，冻结保证金可能会因为条件判断错误而未更新”的问题；
3. [上期能源所] 修复“平仓时`fixedLongMarginPerLot`与`fixedShortMarginPerLot`取反导致的错误”；



## [4.1.1360] - 20240628

### 新增

1. [通用] 支持接入柜台的一档行情功能；
2. [通用] 支持合约级别的申报费计算开关功能；



### 优化

1. `XTFMarketData`结构体字段调整：删除averagePrice字段，增加openPrice字段，调整snapTime字段顺序；



### 修复

1. [郑商所] 修复行权冻结后，可用仓位与柜台计算不一致的问题；
2. [上期能源所] 修复SPMM组保算法与柜台占用保证金计算不一致的问题；



## [4.1.1350] - 20240619

### 新增

1. [通用] 低延迟网卡功能支持配置网卡类型和网卡名称：如果配置`XNIC_NAME`，则使用该网卡；如果配置`XNIC_TYPE`，则使用该类型网卡的驱动；
2. [通用] 支持指定前置撤单；
3. [通用] `XTFInstrument`支持信息量查询接口：`getMessageAmount()`接口查询信息量；`getNextOrderCommissionRate()`接口计算下一笔报单的申报费率；
4. [通用] 增加配置选项`CHECK_VERSION_ENABLED`，用于控制头文件和库文件的版本一致性检测。默认为启用检测；
5. [做市商] 支持中金所报价顶单；



### 优化

1. [通用] 资金可用比例不能为0，以兼容老版本柜台；
2. [通用] 组合持仓处理兼容老版本柜台的处理流程；
3. [通用] 如果订单回报和成交回报乱序，通过订单对象查询的交易所单号可能为0。增加此种场景的异常保护处理，确保成交回报到达时交易所单号有效；



### 修复

1. [广期所] 修复组合合约ID匹配错误导致的组合仓位计算不正确的问题；
2. [大商所] 修复大商所RULE合约行权冻结保证金计算不正确的问题；
3. [郑商所] 修复非SPBM合约行权冻结保证金计算不正确的问题；



## [4.1.1314] - 20240522

### 优化

1. [通用] 调整行权冻结保证金计算公式，与`CTP`保持一致；
2. [通用] 申报费查询 `XTFInstrument.getOrderCommissionRatio(int, int)` 接口增加下标溢出保护；



## [4.1.1300] - 20240513

### 新增

1. [通用] 投资者账号的登录密码支持强密码规则校验，密码需要满足6~12位长度，至少三种类型的字符组合（数字、大写字母、小写字母、特殊字符）；
2. [做市商] 增加做市商大批量撤普通单接口；
3. [做市商] 增加做市商大批量撤报价单接口；



### 优化

1. [通用] 资金可用度盘中推送增加PrcID的保护判断，以防出现其他事件可能导致的资金可用度被异常更新；
2. [通用] 增加说明：配置选项`COMBINATION_TYPES`和`COMBINATION_ENABLED`在1225版本及之后生效；



### 修复

1. [中金所] 修复开仓价计算错误而导致的浮动盈亏差异问题；
2. [大商所] 修复RULE保证金存在附加保证金时，冻结保证金计算错误的问题；
3. [大商所/上期能源所/郑商所] 修复多头期权在行权时，可平仓位与柜台不一致的问题；



## [4.1.1260] - 20240415

### 新增

1. [通用] XTFAccount 结构体增加 getMarginType() 接口查询柜台的保证金计算类型；
2. [大商所] 增加对新型组合保证金算法（RULE）的支持；
3. [大商所] 报单类型增加小节有效 （GIS）类型的支持；



### 优化

1. [通用] example-06增加修改密码功能演示；



### 修复

1. [通用] 修复一键多条件撤单接口判断 XTF_PCF_All 枚举值为无效值的问题；
2. [通用] 修复柜台重启后API自动重连的场景下，订单对象资源因为被回收但部分字段未重置，导致计算资金错误的问题；

3. [郑商所] 修复行权没有冻结保证金的问题；
4. [广期大商] 修复期权对冲单号不允许重复的问题。对冲单号按照合约是唯一的，应允许报单时重复；



## [4.1.1225] - 20240315

### 新增

1. [上期所] 增加对新型组合保证金算法（SPMM）的支持；
2. [通用] 增加投资者指定席位优先级的接口；



### 优化

1. [通用] 优化订单的索引处理，取消对用户本地单号的依赖；
2. [通用] 用户登录过程中，增加心跳发送处理，防止登录时间过长而导致断开；
3. [通用] 看穿式监管信息采集处理优化；
4. [通用] 完善错误日志记录及优化部分头文件的注释说明；



### 修复

1. [通用] 修复账户的资金可用比例边界值问题，使其包含0%的场景；
2. [通用] 修复部分数据查询接口入参无效导致的异常，增加入参有效性检查；
3. [通用] 修复无法使用最大允许本地单号撤单的问题，边界值处理有误导致；
4. [通用] 修复成交明细日志记录时交易所单号格式化的错误；
5. [通用] 修复柜台盘中重启后API自动重连时，订单对象资源回收但未初始化导致资金计算错误的问题；
6. [郑商所] 修复对冲规则数据异常时可能引起的API非法访问错误，增加保护处理；



## [4.1.1072] - 20231226

### 新增

1. [通用] [做市商] 新增配置项 `HISTORICAL_FINISHED_ORDER_FILTER_ENABLED`，用于过滤历史完结定单的流水。极简模式下历史回报过滤无效，仅正常模式有效；
2. [大商所/广期所] 新增配置项 `COMBINATION_TYPES` 组合类型与 `COMBINATION_ENABLED` 自动组合开关，用于指定自动组合的类型；`COMBINATION_TYPES`可设置多个`XTFCombType`枚举值，使用英文逗号分隔开，枚举值的填入顺序对组合优先级没有影响，柜台仍按交易所优先级进行处理；
3. [通用] 更新密码增加对新密码的复杂度校验；



### 修复

1. [通用] 修复流水回报的isHistory字段在撤单被拒时出现的未更新赋值问题；
2. [通用] 修复交易所单号撤单在部分场景下撤销失败，报错“-21004报单没有找到”的问题；
3. [通用] 修复多实例报单在部分场景下偶现“-23001合约找不到”的问题；
4. [通用] 2012错误码描述修改为与2023相同；
5. [通用] 快速手册文档更新订单状态转移图；
6. [通用] 调整头文件注释，去掉不准确的描述；



## [4.1.1068] - 20231127

### 新增

1. 配置文件增加选项`REGISTER_SIGNAL_ENABLED`，用于控制API内部是否自动注册信号处理函数。当设置为`false`时表示不自动注册，默认为`true`会自动注册API内部的信号处理函数；



### 优化

1. 郑商所SPBM组合保证金，优化附加保证金部分的计算方法，防止某些极端场合下保证金收取不足问题；
2. 提供英文版本的头文件说明描述；



### 修复

1. 修复批量撤单接口，当撤单数组传入的订单全部不存在时，没有提示“订单不存在”错误的问题；
2. 修复席位重连后，IP地址变更未实时更新的错误；
3. 修复双交易所场景下，如果用户对某个交易所没有交易权限，则不再推送该交易所的onExchange事件；
4. 修复双交易所场景下，能源所合约无法行权的问题；
5. 修复冻结保证金价格类型与占用保证金价格类型不同时，占用保证金计算错误的问题；



## [4.1.1053] - 20231017

### 新增

1. 前置席位优选增加FixedThenAuto类型。用户如果指定的前置席位不合法，则使用自动优选模式自动选择席位。此功能需要柜台版本不低于Release004-P1；



## [4.1.1048] - 20231016

### 新增

1. 新增错误码信息描述的推送流程，避免不同版本下的错误描述不一致问题。新旧版本柜台，API会自动判断是否需要订阅；
2. 新增资金可用比参数的推送流程，API根据资金可用度计算可用资金；
3. 新增组保计算模型参数的推送流程，API判断是否需要订阅组保参数的推送；

### 修复

1. 修复899之后的版本，API停止后重新启动会报错的问题；
2. 修复冻结手续费计算错误的问题；



## [4.1.1019] - 20230914

### 新增

1. 新增用户自定义报单分组编号的功能。启动API之前，可以通过setConfig或配置文件，设置报单分组编号；
2. 回报过滤条件增加了是否启用报单分组过滤的选项，true表示仅收到报单分组的回报，false表示收到全部回报；
3. 报单回报、成交回报和报价回报，增加了orderGroupID字段，表示该报单所属的分组编号；



### 修复

1. 修复报价单AskHedgeFlag和BidHedgeFlag字段未初始化的问题；



## [4.1.990] - 20230829

### 新增

1. 增加获取高精度纳秒级时间戳的接口`getXTFNanoTimestamp()`；
2. 增加Onload版本自动检测功能：如果版本小于7.x或大于7.x，提示相应的告警日志。此日志不影响正常使用，但可能存在由于驱动版本不一致导致的不可预知风险；
3. 增加低延迟网卡功能开关配置：配置项为`XNIC_ENABLED`，true表示启用，false表示禁用。如果是禁用状态，无论是否安装低延迟网卡，都使用默认的系统通道进行报撤单。默认为启用；



### 修复

1. 修复“按过滤条件查询成交明细，设置时间条件会导致查询为空”的问题；



## [4.1.956] - 20230825

### 修复

1. 修改流水推送时序列号管理没有初始化的问题；



## [4.1.955] - 20230824

### 优化

1. onload驱动版本从201811-u1改成7.1.3；
2. 发送报单时增加多线程互斥保护处理；
3. 增加日志，错误时打印数据内容；



### 修复

1. 修改获取默认网关时，IP地址错误的问题；



## [4.1.936] - 20230802

### 新增

1. 增加运行模式配置项`RUN_MODE`管理，0表示正常模式，1表示极简模式，默认为正常模式；
2. 增加API极简模式，此模式下API不再保存任何的交易（订单和成交）信息，由用户自行管理；
3. 增加通过单号和交易所参数进行撤单的接口；



### 优化

1. 优化报撤单接口的性能，支持Solarflare和Exablaze网卡的加速处理；
2. 报单接口增加参数有效性判断；
3. 新增XTFCombInstrumentID类型定义，XTFCombInstrument对象的合约编号从32字节扩展为36字节；
4. 常量名XTF_MPT_MaxLastSettlementPriceOrLastPrice 改成 XTF_MPT_MaxPreSettlementPriceOrLastPrice；
5. 常量名XTF_MPT_LastSettlementPrice 改成 XTF_MPT_PreSettlementPrice；



### 修复

1. 修复以本地单号撤单时的偶发性报单查找不到的问题；
2. 修复多线程访问共享资源增加保护处理以免发生潜在冲突问题；
3. 修复报单响应和报单回报发生乱序时，IOC单（未成已撤状态）回报中的交易所编号为0的问题；



## [4.1.901] - 20230629

### 新增

1. 新增配置参数`RELEASE_FINISHED_ORDER_ENABLED`，可以启用完结状态下的报单内存自动回收功能，以减少内存占用；



## [4.1.892] - 20230621

### 新增

1. 新增回报订阅功能，登录前设置回报规则白名单，登录后设置无效；
2. 新增本地单号撤单功能，需要投资者具有本地单号撤单权限，且对本地单号有更严格的限制约束；
3. 新增一键批量撤单功能，用户可以指定匹配规则进行大批量撤单；
4. 报单增加用户可自定义的userRef字段，交易柜台原值返回；
5. 增加信息量统计和申报费计算功能；
6. 新增参数推送：1）柜台是否支持做市商功能；2）投资者是否支持本地单号撤单及最大允许的本地单号；
7. 新增做市功能接口：做市商版本支持做市接口，普通交易版本不支持做市接口；
8. 新增Python版本接口；
9. 新增C版本接口；

### 优化

1. 合约结构XTFInstrument增加状态变更时间和原因等字段；
2. 样例代码优化：增加Readme.txt文件描述各演示代码的功能；增加多线程报单演示代码；增加做市商接口演示代码；
3. 交易日志增加ErrorCode的打印：配置文件增加 `TRADE_LOG_ENABLED=true` 一行可以启用交易日志的打印，会稍微影响下行回报的处理，正常情况下不建议启用此调试选项；
4. TCP连接相关的操作系统错误码，做兼容性处理，以免和业务错误码冲突；
5. 优化编译脚本，支持多种不同版本的编译；



## [4.1.761] - 20230511

### 修复

1. 修复连续快速报单场景下，可能出现预冻结/释放乱序而引起资金计算错误的问题；



## [4.1.757] - 20230404

### 增加

1. 增加日志启用/禁用接口`setXTFLogEnabled()`；



### 修复

1. 修复广期所和大商所的行权仓位数据冻结错误；



## [4.1.755] - 20230330

### 增加

1. XTFErrorCode.h增加错误码中文注释；
2. 增加Example07演示两个API实例报单时发生混淆的场景；



### 优化

1. 行权对冲报单，在收到交易所报单应答后状态为Accepted，收到报单回报后状态是Queuing；
2. subscribe和unsubscribe接口支持nullptr参数，表示订阅所有合约的行情回调事件；



## [4.1.754] - 20230328

### 修复

1. 修复行权单从API发送到柜台后，接收到的回报字段中OrderStatus不正确的问题；
2. 修复大商所上场资金计算与柜台保持一致；



## [4.1.751] - 20230323

### 优化

1. 报单和成交流水本地存储优化，增加预分配功能，减少运行时期间的动态分配；
2. 完善快速入门手册的报单回报流程描述；



### 修复

1. 修复`放弃行权和对冲`报单在每个投资者只能有一个有效报单的场景下，状态更新错误问题；
2. 修复`行权和对冲`报单应答和回报乱序时，offsetFlag字段没有更新的问题；
3. 修复`Oracle Linux 8.3`版本编译遇到的兼容性问题；
4. 修复Example中`std::map`迭代器在撤单时可能失效的问题；
5. 修复stop调用之后没有onStop回调的问题；



## [4.1.723] - 20230314

### 优化

1. 柜台增加合约交易所保证金率的推送；
2. 修改期权组合保证金大边选择的判断条件，从合约保证金率改成交易所保证金率计算；



### 修复

1. 修复行权/对冲回报中ExchangeOrderID无效的问题，应答此字段无效，以回报为准；



## [4.1.720] - 20230309

### 优化

1. 文档增加行权和对冲部分；
2. 报单状态增加`XTF_OS_Received`，表示柜台收到报单请求并已通过柜台风控。此状态在交易所接受报单`XTF_OS_Accepted`状态之前到达；



### 修复

1. 行权计算冻结保证金计算公式与柜台保持一致；



## [4.1.718] - 20230306

### 新增

1. XTFDataStruct.h文件定义的由API内部创建的数据结构对象中，增加用户可自定义的数据变量，以方便用户存储关联的临时数据；



## [4.1.717] - 20230303

### 优化

1. 完善示例代码：example03增加预热报单的构造和发送；example06修复状态判断的逻辑错误；



## [4.1.716] - 20230302

### 优化

1. 期权组合保证金计算价格类型支持MAX（昨结算价，最新价）；
2. 单精度浮点数改成双精度浮点数，防止资金计算时精度丢失；



## [4.1.712] - 20230227

### 修复

1. 修复报单价计算期权保证金时，老仓的保证金按照报单价计算的问题，改成按照昨结算价计算老仓的保证金；



## [4.1.711] - 20230224

### 增加

1. 增加行权手续费的冻结；



### 优化

1. 优化看穿式监管信息获取的兼容性；
2. 优化配置文件的注释描述；
3. 合约状态数据推送时如果流水序号不连续，不认为是错误；
4. 期权期货组合的期货保证金使用昨结算价计算；



## [4.1.702] - 20230222

### 新增

1. 支持大商所商品期权功能；
2. 支持广期所商品期权功能；
3. 支持上期所商品期权功能；
4. 支持期权行权功能；
5. 支持期权对冲功能；



## [4.1.690] - 20230210

### 优化

1. 撤单时间交易所暂不支持，当报单状态为撤销时，使用最后一次更新时间来标记撤单时间；
2. 合约状态常量增加`TransactionMatchPause | TransactionTradePause | Alarm`的定义；
3. 增加限制登录的错误码：2022；



## [4.1.688] - 20230209

### 新增

1. 日志默认写入当前目录的子目录`xtf-api-log/`；



## [4.1.686] - 20230208

### 修复

1. 修复UDP通信打开失败后，无法自动重连的问题；
2. 修复禁用资金和仓位计算场景下，设置交易所特性没有空指针保护的问题；



## [4.1.681] - 20230207

### 新增

1. 修复广期所和大商所手续费计算与柜台存在偏差的问题；



## [4.1.669] - 20230202

### 新增

1. Release版本增加Info级别的日志记录；



## [4.1.667] - 20230120

### 优化

1. 风控事件结构体字段从`investorID`修改为`accountID`，大小为20字节；
2. 删除未使用的接口`getXTFLoginPacket`；



## [4.1.664] - 20230118

### 新增

1. 报撤单接口增加线程安全模式，在配置文件增加配置选项`ORDER_MT_ENABLED=true` 可以启用报单线程安全模式。默认为线程不安全，开启线程安全会略微增加报单延时；



## [4.1.651] - 20230111

### 修复

1. 修复上期中金冻结保证金与柜台计算不一致的问题；



## [4.1.648] - 20230106

### 修复

1. 修复持仓组合与拆组合导致的资金计算问题；



## [4.1.641] - 20221230

### 修复

1. 发送TCP数据时增加多线程同步机制，以防数据交替发送造成异常；



## [4.1.640] - 20221229

### 优化

1. 优化使用手册文档；
2. 规范错误码的定义；



## [4.1.629] - 20221220

### 优化

1. 优化返回的错误码；

### 修复

1. 修复组合持仓明细与柜台不一致的问题；
2. 修复成交回报历史流水推送的边界问题；



## [4.1.618] - 20221209

### 优化

1. 增加报单接口`多线程不安全`的注释说明；



## 修复

1. 修复API本地缓存数据异常导致的崩溃问题；
2. 修复组合持仓的冻结保证金计算问题；



## [4.1.612] - 20221207

### 新增

1. 组合持仓结构体XTFCombPosition增加组合对冲标志字段combHedgeFlag；



### 优化

1. 优化登录流程对AccountID的校验处理；



### 修复

1. 修复组合持仓计算的错误；
2. 修改最后一笔流水数据History标记错误的问题；
3. 修复FAK报单当MinVolume>1时，返回InsertType类型有误的问题；
4. 修复组合持仓柜台重启后API重新登录残留数据没有清理导致非法访问的错误；
5. 修复柜台重新启动，API出现两次onStart()的问题；
6. 修复网络异常中断情况下，onStop()没有通知的问题；



## [4.1.598] - 20221201

### 新增

1. 新增创建预热报单接口`buildWarmOrder()`；
2. 增加昨日余额字段，与静态权益区分；



## [4.1.593] - 20221130

### 新增

1. 提供资金同步接口`syncFunds()`，接口默认超时时间50ms；
2. XTFAccount结构体增加交割保证金字段；
3. 中金期权空头保证金增加根据最新价和昨结算价的较大值来计算；
4. 中金期权空头冻结保证金增加根据最新价和昨结算价的较大值来计算；



### 修复

1. 修复动态权益和可用资金的计算问题；



## [4.1.586] - 20221122

### 新增

1. 推送柜台配置的交易所特性参数；
2. 增加对柜台版本的校验，对于版本号过低的柜台，提示不兼容；



### 修复

1. 修改报单出现无效合约时出现的访问非法；
2. 修复中金所期权计算使用的手续费率错误问题；
3. 修复中金所资金计算少了现货期权的问题；
4. 修复柜台清流启动时本地报单编号处理冲突的问题；
5. 修复中金所资金计算期权保证金买平时未释放的问题；
6. 修复中金所资金期权计算平今手续费时，没有区分多空今仓数量的问题；



## [4.1.571] - 20221116

### 新增

1. 账户字段扩展为20字节，详细变更如下：
   XTFAccountID类型从16字节变更为20字节；
   XTFAccount结构体需要关注一下对accountID的处理；
   其他的结构体暂不涉及改动；



### 修复

1. 修复双交易所场景下计算昨持仓占用保证金错误的问题；
2. 修复无法通过本地报单编号撤销乱序场景历史报单的问题；
3. 修复某些场景下API登录柜台获取不到MAC地址和IP地址的问题；
4. 修复大批量报单流水场景下登录可能超时的问题；
5. 修复部分内存泄漏的问题；



## [4.1.546] - 20221107

### 增加

1. 增加组合合约查询接口；
2. 增加组合持仓查询接口；
3. 增加交易流水的日志记录功能；



### 优化

1. 日出流水数据推送处理优化，兼容未知消息类型的数据报处理；



### 修复

1. 修复使用带参数的login()接口登录时返回失败的问题；
2. 修复getConfig接口在连续调用后使用printf格式化时可能存在string内存复用的问题；
3. 报单响应和报单回报如果接收乱序，则不再通知用户Accepted该状态的事件；
4.  修复报单响应和报单回报乱序时，重复创建报单对象的问题（需要用户确保`交易日内LocalOrderID是唯一的`）；



## [4.1.508] - 20221020

### 增加

1. 快速入门手册增加事件序列图，说明API各事件的触发顺序；



### 修复

1. 修复多点登录，子账户同步报单字段错误的问题；
2. 报单插入错误回报处理时，如果报单合约不存在，关联的合约指针对象为空。修复此场景下查询时出现的异常问题；
3. 修复报单在不可撤销状态下依然可以发送撤单请求的问题；
4. 修复错单回报`是否历史流水`字段未赋值问题，优化报单回报和成交回报`是否历史流水`字段，onLoadFinished()接口调用之前都赋值为true，之后都赋值为false；
5. 修复使用手册缺失图片的问题，并提供PDF版本的使用手册；
6. 修复配置文件DOS格式兼容性问题；



## [4.1.492] - 20221017

### 新增

1. 增加示例代码Example04，演示了如何不使用配置文件的方式创建和配置API参数；



## 修复

1. 修复冻结手续费计算时的手续费率错误问题；



## [4.1.486] - 20221013

## 优化

1. 报单插入错误回报处理优化：收到非本API报单（或协议报单）的报单插入错误回报时，自动创建XTFOrder对象，并通知用户接口；



## [4.1.479] - 20221011

## 新增

1. 持仓结构体XTFPosition增加今持仓量字段todayPosition；



## 优化

1. UDP预热报单优化；



## [4.1.475] - 20221010

## 新增

1. 增加协议方式报单的示例代码Example03，演示了如何使用API登录柜台以及使用协议方式发送报撤单；
2. 合约结构体XTFInstrument增加期权类型字段XTFOptionsType，增加获取期权对应的基础合约的接口getUnderlyingInstrument()；



## [4.1.471] - 20221008

### 优化

1. 合约结构体XTFInstrument中的expireDate字段，从int改成字符数组类型；



## [4.1.468] - 20220930

### 修复

1. 登录时偶现应答无法收到的问题；
2. 修复报单响应和报单回报乱序时，出现realChannelID字段值不一致的问题；



## [4.1.465] - 20220929

### 新增

1. 增加错误码查询接口，支持错误消息内容的中英文版本；
2. makeXTFApi()接口允许配置文件路径为空，启动API之前，通过API的setConfig()接口来设置参数；

### 优化

1. 优化资金和仓位计算；
2. XTFOrder结构体中的realChannelID字段默认为0xFF，表示无效值。当收到非0xFF时，表示realChannelI字段有效；

### 修复

1. 修复XTFOrder报单状态乱序的问题，将报单状态的顺序进行检测和约束；避免报单状态可能`先进入Queuing、PartTraded或者AllTraded，再进入Accepted状态`。
2. 修复同一API实例多次登录登出时偶先的崩溃问题；



## [4.1.454] - 20220927

### 新增
1. 数据回报处理线程增加开关配置项TCP\_WORKER\_BUSY\_LOOP\_ENABLED，如果配置为false，则不启用BusyLoop运行模式，以降低CPU核的负载。默认为true，表示启用BusyLoop运行模式。
2. XTFExchange增加字段标记是否支持席位编号IP地址查询，如果支持IP地址查询，则可以通过getChannelIP()和getChannelIPByID()接口查询IP地址。
3. XTFAccount增加最近一次本地撤单编号lastActionOrderID。

### 修复
1. 修复裸协议报单无法收到OnRsp事件的问题。



## [4.1.445] - 20220921

### 新增

1. XTFInputOrder增加minVolume字段；
2. XTFOrder增加orderMinVolume字段；



## [4.1.441] - 20220920

### 新增

1. 柜台在交易时段发生重启的通知接口`onServerReboot()`；
   1. 柜台在交易时段如果发生重启，API中断后会自动重连；
   2. 重新连接后，API会清空上一次登录的所有数据，并重新从柜台加载数据；
   3. 由于API的本地数据发生了变化，因此所有外部使用的指针数据会失效，用户需要在收到onReboot事件后，清理上一次的所有数据指针。此刻这些数据指针依然有效，当onReboot事件处理之后，数据指针将会失效。



## [4.1.437] - 20220919

### 新增

1. 配置文件标注线程的BusyLoop模式；
2. XTFExchange增加tradingDay字段；
3. XTFAccount增加lastLocalOrderID字段；

### 优化

1. 完善LocalOrderID的注释说明；



## [4.1.430] - 20220916

### 优化

1. 时间字段从整型改成字符串类型，报单增加插入日期、更新时间、撤单时间；
2. 撤单时间字段交易所暂不支持，使用最后一次更新时间来标记撤单时间；
3. 收到错误的数据包后，断开TCP连接；
4. 行情结构体未使用的字段标记说明；
5. XTFAccount接口功能添加注释说明；
6. xtf_trader_api.config TCP接收线程注释修改为回报处理线程；
7. 完善看穿式监管信息采集，如果发生错误则禁止登录；



## [4.1.425] - 20220915

### 优化

1. XTFOrder启用insertTime字段；
2. XTFOrderFilter和XTFTradeFilter增加时间字段含义的说明；



## [4.1.414] - 20220913

### 修复

1. 修复没有席位时无法获得交易所ID字符串的问题；
2. 修复realChannelID查询为0的问题；
3. onBookUpdate接口参数由引用对象改成指针对象；



## [4.1.411] - 20220909

### 新增

1. 新增onCancelOrder接口专门用于处理撤单回报的场景；

### 优化

1. onOrder接口去掉actionCode参数，移入XTFOrder结构体内部；去掉XTFError参数，改成errorCode；调整参数顺序和个数；

### 删除

1. 删除onOrder接口里撤单的相关通知；



## [4.1.398] - 20220907

### 优化

1. Example01-演示API登录登出和报单撤单功能；
2. Example02-演示使用一个简单策略基于行情驱动进行报撤单功能；



## [4.1.395] - 20220906

### 新增

1. 按条件查询报单数据的接口`findOrders()`；
2. 按条件查询成交数据`findTrades()`；

### 优化

1. 优化预热功能以提高穿透性能；
2. 优化API接口方法的注释说明；

### 修复

1. 修复login()接口登录失败的问题；
2. 修复部分报单回报没有通知回调的问题；



## [4.1.376] - 20220831

### 新增

1. 按柜台流水号撤销报单；
2. 按柜台流水号批量撤销报单；



## [4.1.372] - 20220830

### 新增

1. 初始版本功能发布。