/*! 
* \file  EESQuoteDefine.h
* \brief EESͶͷļ
*  
* ļʹEES͵Ķ
*  
* \author  SHENGLI
* \version 1.0
* \date    2014-04-18
*/  

#pragma  once 

#include <string.h>

#define EES_EQS_API_VERSION    "5.2.4.11"				///<  api汾

/// \brief EESEQSʶ
#define EES_EQS_ID_LEN         15

/// \brief EESEQS¼
#define EES_EQS_USER_ID_LEN    15

/// \brief EESEQS¼볤
#define EES_EQS_PASSWORD_LEN   32

/// \brief EES
enum EesEqsIntrumentType
{
  EQS_INVALID_TYPE = '0', ///< Ч
  EQS_SH_STOCK,           ///< ϺƱ
  EQS_SZ_STOCK,           ///< ڹƱ
  EQS_STOCK_OPTION,       ///< ƱȨ
  EQS_FUTURE_OPTION,      ///< ڻȨ
  EQS_INDEX_OPTION,       ///< ָȨ
  EQS_FUTURE,             ///< ڻ
  EQS_SGE ,				  ///< ƽ
};

/// \brief ־
enum EesEqsLogLevel
{
  QUOTE_LOG_LV_DEBUG = 0,  ///< Ϣ
  QUOTE_LOG_LV_INFO  = 1,  ///< Ϣ
  QUOTE_LOG_LV_WARN  = 2,  ///< 
  QUOTE_LOG_LV_ERROR = 3,  ///< 
  QUOTE_LOG_LV_FATAL = 4,  ///< 
  QUOTE_LOG_LV_USER  = 5,  ///< ڸûʾϢ
  QUOTE_LOG_LV_END         ///< β־
};

#pragma  pack(push, 1)

/////////////////////////////////////////////////////////////////////////
///EESQuoteDateTypeһ
/////////////////////////////////////////////////////////////////////////
typedef char EESQuoteDateType[9];
/////////////////////////////////////////////////////////////////////////
///EESQuoteInstrumentIDTypeһԼ
/////////////////////////////////////////////////////////////////////////
typedef char EESQuoteInstrumentIDType[31];
/////////////////////////////////////////////////////////////////////////
///EESQuoteExchangeIDTypeһ
/// ȡֵΧ
/// Ͻ SHH
///  SHZ
///  SHFE
/// н CFFEX
///  DCE
/// ֣ CZCE
/// ƽ  SGE
/////////////////////////////////////////////////////////////////////////
typedef char EESQuoteExchangeIDType[9];
/////////////////////////////////////////////////////////////////////////
///EESQuotePriceTypeһ۸
/////////////////////////////////////////////////////////////////////////
typedef double EESQuotePriceType;
/////////////////////////////////////////////////////////////////////////
///EESQuoteLargeVolumeTypeһ
/////////////////////////////////////////////////////////////////////////
typedef double EESQuoteLargeVolumeType;
/////////////////////////////////////////////////////////////////////////
///EESQuoteVolumeTypeһ
/////////////////////////////////////////////////////////////////////////
typedef int EESQuoteVolumeType;
/////////////////////////////////////////////////////////////////////////
///EESQuoteMoneyTypeһʽ
/////////////////////////////////////////////////////////////////////////
typedef double EESQuoteMoneyType;
/////////////////////////////////////////////////////////////////////////
///EESQuoteRatioTypeһ
/////////////////////////////////////////////////////////////////////////
typedef double EESQuoteRatioType;
/////////////////////////////////////////////////////////////////////////
///EESQuoteExchangeInstIDTypeһԼڽĴ
/////////////////////////////////////////////////////////////////////////
typedef char EESQuoteExchangeInstIDType[31];
/////////////////////////////////////////////////////////////////////////
///EESQuoteMillisecTypeһʱ䣨룩
/////////////////////////////////////////////////////////////////////////
typedef int EESQuoteMillisecType;
/////////////////////////////////////////////////////////////////////////
///TFtdcTimeTypeһʱ
/////////////////////////////////////////////////////////////////////////
typedef char EESQuoteTimeType[9];

/// \brief EES鲥Ϣÿӳһ鲥ַ
struct EqsMulticastInfo
{
	char m_mcIp[EES_EQS_ID_LEN + 1];			///< 鲥ַ
	unsigned short m_mcPort;					///< 鲥˿1-65535
	char m_mcLoacalIp[EES_EQS_ID_LEN + 1];		///< ַ
	unsigned short m_mcLocalPort;				///< ˿1-65535, δʹõĶ˿ں
	EESQuoteExchangeIDType	m_exchangeId;		///< 룬οEESQuoteExchangeIDTypeȡֵΧ
	EqsMulticastInfo()
	{
		memset(this, 0, sizeof(*this));
	}
};


/// \brief EESϢ
struct EqsTcpInfo
{
  EqsTcpInfo()
  {
      m_eqsId[0] = 0x00;
      m_eqsIp[0] = 0x00;
      m_eqsPort  = 0; 
  }

  char            m_eqsId[EES_EQS_ID_LEN + 1]; ///< ַ
  char            m_eqsIp[EES_EQS_ID_LEN + 1]; ///< TCPIPַ
  unsigned short  m_eqsPort;                   ///< TCP˿ں 
};

/// \brief EES½Ϣ
struct EqsLoginParam
{
  EqsLoginParam()
  {
      m_loginId[0]  = 0x00;
      m_password[0] = 0x00;
  }
  char  m_loginId[EES_EQS_USER_ID_LEN + 1];   ///< ¼
  char  m_password[EES_EQS_PASSWORD_LEN + 1]; ///< ¼
};

/// \brief EESṹ
struct EESMarketDepthQuoteData
{
  EESQuoteDateType            TradingDay;     ///<
  EESQuoteInstrumentIDType    InstrumentID;   ///<Լ
  EESQuoteExchangeIDType      ExchangeID;     ///<
  EESQuoteExchangeInstIDType  ExchangeInstID; ///<ԼڽĴ
  EESQuotePriceType           LastPrice;      ///<¼
  EESQuotePriceType           PreSettlementPrice; ///<ϴν
  EESQuotePriceType           PreClosePrice;    ///<
  EESQuoteLargeVolumeType     PreOpenInterest; ///<ֲ
  EESQuotePriceType           OpenPrice;       ///<
  EESQuotePriceType           HighestPrice;    ///<߼
  EESQuotePriceType           LowestPrice;     ///<ͼ
  EESQuoteVolumeType          Volume;          ///<
  EESQuoteMoneyType           Turnover;        ///<ɽ
  EESQuoteLargeVolumeType     OpenInterest;    ///<ֲ
  EESQuotePriceType           ClosePrice;      ///<
  EESQuotePriceType           SettlementPrice; ///<ν
  EESQuotePriceType           UpperLimitPrice; ///<ͣ
  EESQuotePriceType           LowerLimitPrice; ///<ͣ
  EESQuoteRatioType           PreDelta;        ///<ʵ
  EESQuoteRatioType           CurrDelta;       ///<ʵ
  EESQuoteTimeType            UpdateTime;      ///<޸ʱ
  EESQuoteMillisecType        UpdateMillisec;  ///<޸ĺ
  EESQuotePriceType           BidPrice1;       ///<һ
  EESQuoteVolumeType          BidVolume1;      ///<һ
  EESQuotePriceType           AskPrice1;       ///<һ
  EESQuoteVolumeType          AskVolume1;      ///<һ
  EESQuotePriceType           BidPrice2;       ///<۶
  EESQuoteVolumeType          BidVolume2;      ///<
  EESQuotePriceType           AskPrice2;       ///<۶
  EESQuoteVolumeType          AskVolume2;      ///<
  EESQuotePriceType           BidPrice3;       ///<
  EESQuoteVolumeType          BidVolume3;      ///<
  EESQuotePriceType           AskPrice3;       ///<
  EESQuoteVolumeType          AskVolume3;      ///<
  EESQuotePriceType           BidPrice4;       ///<
  EESQuoteVolumeType          BidVolume4;      ///<
  EESQuotePriceType           AskPrice4;       ///<
  EESQuoteVolumeType          AskVolume4;      ///<
  EESQuotePriceType           BidPrice5;       ///<
  EESQuoteVolumeType          BidVolume5;      ///<
  EESQuotePriceType           AskPrice5;       ///<
  EESQuoteVolumeType          AskVolume5;      ///<
  EESQuotePriceType           AveragePrice;    ///<վ
};

#pragma  pack(pop)