/*! \file  EesQueryDefine.h
 *  \brief EES׿ͻAPIʹõϢ嶨塣
 *
 *  ļϸEES׿ͻAPIʹõݽṹԼϢ塣 
*/
#pragma  once 




#ifndef _EES_QUERY_API_STRUCT_DEFINE_H_
#define _EES_QUERY_API_STRUCT_DEFINE_H_

#include "string.h"
#include "EesCommonDefine.h"

#pragma pack(push, 1)

#define SL_EES_API_VERSION    "5.2.4.11"				///<  api汾


/// ¼صϢ
struct EES_QueryLogonResponse
{
	EES_LogonResult		m_Result;							///< μĵEES_LogonResult
	EES_UserID			m_UserId;							///< ¼ӦûID
};

/// ѯĽṹ
struct EES_QueryAccountOrder
{
	EES_UserID			m_Userid;						///< ԭӵûӦLoginID
	EES_Nanosecond		m_Timestamp;					///< ʱ䣬1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_ClientToken		m_ClientOrderToken;				///< ԭӵtoken 
	EES_SideType		m_SideType;						///< 1 = 򵥣 2 = ƽ  3= 򵥣ƽ 4 =   5= 򵥣ƽ 6= ƽ 21ƽƽƽģʽ 22ƽƽƽģʽ 
	unsigned int		m_Quantity;						///< ƱΪڻΪ
	EES_SecType			m_InstrumentType;				///< 1Equity Ʊ 2Options Ȩ 3Futures ڻ
	EES_Symbol			m_Symbol;						///< Ʊ룬ڻȨ룬й׼ (Ŀǰ6λͿ)
	double				m_Price;						///< ۸
	EES_Account			m_Account;						///< 61 16  Alpha ͻʺ.  ǴĿͻʺš֤󣬱ֵҲӵȱʡֵ
	EES_ExchangeID		m_ExchengeID;					///< 100Ͻ  101=  102=н  103=  104=  105=֣  255= done-away  See appendix 
	EES_ForceCloseReason m_ForceCloseReason;			///<ǿƽԭ  0=ǿƽ, 1=ʽ,2=ͻ,3=Ա,4=ֲַ,5=Υ棬6=
	EES_Internal_Id	    m_InternalOrderId;				///< /<Remϵͳţtag37
	EES_OrderStatus		m_OrderStatus;					///< οEES_OrderStatusĶ
	EES_Nanosecond		m_CloseTime;					///< ر¼1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	int					m_FilledQty;					///< 0  4 Int4  ɽ
	unsigned int		m_MinQty;						///< ûµʱֵָ
	EES_MarketOrderId	m_MarketOrderId;				///< 
	EES_HedgeFlag		m_HedgeFlag;					///< Ͷ־
	EES_CustomFieldType m_CustomField;					///< ûԶֶ
	unsigned char		m_IOC;							///< 0:ͨҪFAK/FOKʱҪIOCΪ1
};

/// ѯĽṹ
struct EES_QueryAccountArbiOrder
{
	EES_UserID			m_Userid;						///< ԭӵûӦLoginID
	EES_Nanosecond		m_Timestamp;					///< ʱ䣬1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_ClientToken		m_ClientOrderToken;				///< ԭӵtoken 
	EES_SideType		m_SideType;						///< 1 = 򵥣 2 = ƽ  3= 򵥣ƽ 4 =   5= 򵥣ƽ 6= ƽ 21ƽƽƽģʽ 22ƽƽƽģʽ 
	unsigned int		m_Quantity;						///< ƱΪڻΪ
	EES_Symbol			m_Symbol;						///< Ʊ룬ڻȨ룬й׼ (Ŀǰ6λͿ)
	double				m_Price;						///< ۸
	EES_Account			m_Account;						///< ˻
	EES_ExchangeID		m_ExchengeID;					///< 100Ͻ  101=  102=н  103=  104=  105=֣  255= done-away  See appendix 
	EES_Internal_Id	    m_InternalOrderId;				///< Remϵͳţtag37
	EES_OrderStatus		m_OrderStatus;					///< ״̬-οEES_OrderStatusĶ
	int					m_FilledQty;					///< ɽ
	EES_Nanosecond		m_CloseTime;					///< ر¼1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	unsigned int		m_MinQty;						///< ûµʱֵָ
	EES_MarketOrderId	m_MarketOrderId;				///< 
	EES_HedgeFlag		m_HedgeFlag;					///< Ͷ־
	EES_CustomFieldType m_CustomField;					///< ûԶֶ
	unsigned char		m_IOC;							///< 0:ͨҪFAK/FOKʱҪIOCΪ1
};

/// ѯɽĽṹ
struct EES_QueryOrderExecution
{
	EES_UserID			m_Userid;						///< ԭӵûӦLoginID
	EES_Nanosecond		m_Timestamp;					///< ɽʱ䣬1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_ClientToken		m_ClientOrderToken;				///< ԭӵtoken
	EES_Internal_Id	    m_InternalOrderId;				///< Remϵͳţtag37
	unsigned int		m_ExecutedQuantity;				///< ӳɽ
	double				m_ExecutionPrice;				///< ӳɽ
	EES_MarketToken		m_ExecutionID;					///< ӳɽ(TAG 1017)
	EES_MarketExecId	m_MarketExecID;					///< ɽ
	unsigned char		m_LegNo;						///< Ⱥţͱ۵1һ2ڶȣֵΪ0
	unsigned char		m_OrderType;					///<  01234 
};

struct EES_QueryAccountQuote
{
	EES_UserID			m_Userid;						///< ԭӵûӦLoginID
	EES_Symbol		    m_Symbol;					    ///< Լ
	EES_ExchangeID		m_ExchengeID;
	EES_ClientToken		m_ClientQuoteToken;				///< ԭӵtoken
	EES_Internal_Id	    m_InternalQuoteId;				///< Remϵͳţtag37
	EES_Internal_Id	    m_BidInternalQuoteId;			///< Remϵͳţtag37
	EES_Internal_Id	    m_AskInternalQuoteId;			///< Remϵͳţtag37
	EES_MarketOrderId   m_MarketQuoteId;				///< г
	EES_MarketOrderId   m_BidOrderSysId;				///< г
	EES_MarketOrderId   m_AskOrderSysId;				///< г
	unsigned int        m_BidQty;						///< 
	unsigned int        m_AskQty;						///< 
	double              m_BidPrice;						///< 򷽵ӳɽ
	double              m_AskPrice;						///< ӳɽ
	EES_HedgeFlag	    m_BidHedgeFlag;					///< Ͷ־
	EES_HedgeFlag	    m_AskHedgeFlag;					///< Ͷ־
	unsigned char	    m_BidIsOffset;					///< ȨǷԳ壨1ǣ0
	unsigned char	    m_AskIsOffset;					///< ȨǷԳ壨1ǣ0
	EES_OrderState      m_BidState;						///< ״̬
	EES_OrderState      m_AskState;						///< ״̬
	unsigned int        m_BidFillQty;					///< 򷽳ɽ
	unsigned int        m_AskFillQty;					///< ɽ
	EES_CustomFieldType m_CustomField;					///< ûԶֶ
	unsigned char		m_IOC;							///< 0:ͨҪFAK/FOKʱҪIOCΪ1
};

/// һ˻жͳɽعɺϢ
struct EES_QueryAccountTradeFinish
{
	EES_Account			m_account;						///< ˻ID
};

struct EES_QueryAccountQuoteFinish
{
	EES_Account			m_account;						///< ˻ID
};

/// ʻϢϢ
struct EES_AccountInfo
{
	EES_Account			m_Account;						///< ʻID 
	EES_Previlege		m_Previlege;					///< ȨޣĿǰӲݲ֧֣Ҳ˵ȫȨ 99ȫ  1ֻ 2ֻƽ
	double				m_InitialBp;					///< ʼȨ
	double				m_AvailableBp;					///< ܿʽ
	double				m_Margin;						///< вλռõı֤
	double				m_FrozenMargin;					///< йҵı֤
	double				m_CommissionFee;				///< ѿ۳ܽ
	double				m_FrozenCommission;				///< ҵѽ
	unsigned char		m_AccountIdx;					///< ˻
};

/// ʻĲλϢ
struct EES_AccountPosition
{
	EES_Account			m_ActId;						///< ˻
	EES_Symbol			m_Symbol;						///< Լ/Ʊ
	EES_PosiDirection	m_PosiDirection;				///< շ 1ͷ 5ͷ
	unsigned int		m_InitOvnQty;					///< ҹֳʼֵ仯ͨHelpDeskֹ޸
	unsigned int		m_OvnQty;						///< ǰҹΪ0
	unsigned int		m_FrozenOvnQty;					///< 
	unsigned int		m_TodayQty;						///< ǰΪ0
	unsigned int		m_FrozenTodayQty;				///< Ľ
	double				m_OvnMargin;					///< ҹռñ֤
	double				m_TodayMargin;					///< ռõı֤
	double				m_PositionCost;
	EES_HedgeFlag		m_HedgeFlag;					///< λӦͶ־
};

struct EES_AccountComboPosition
{
	EES_Account			m_Account;						///< ˻
	unsigned char		m_ComboType;					///< 0 ȫ  1 ţп 2 п 3 п 4 ţп 5 ۲
	EES_Combo_Symbol    m_ComboSymbol;				    ///< ϺԼ
	EES_Symbol			m_FirstSymbol;					///< Լһ
	unsigned char		m_FirstDirection;				///< 1-࣬5-
	EES_Symbol			m_SecondSymbol;					///< Լڶ
	unsigned char		m_SecondDirection;				///< 1-࣬5-
	unsigned int		m_Qty;							///< ϳֲ
	unsigned int		m_InitQty;							///< ڳϳֲ
	double				m_ComboMargin;					///ϱ֤׼
	double				m_ReturnMargin;					///Żݱ֤׼*/
	EES_HedgeFlag		m_HedgeFlag;					///< λӦͶ־
};

struct EES_AccountComboRule
{
	unsigned char		m_RuleProdType;					///< ԲƷ 1 һڻ 2 ڻ 3 һȨ 4 Ȩ 5 ڻȨ
	EES_DATE			m_Trading_date;					///< 
	unsigned char		m_ComboType;					///< 0 ȫ  1 ţп 2 п 3 п 4 ţп 5 ۲
	unsigned int		m_Priority;						///< ȼ
	unsigned char		m_HedgeFlag;					///< 1:2Ͷ3ױ
	double				m_ComboMargin;					///< ϱ֤׼
	unsigned int		m_InstrId;						///< Լ
	EES_Combo_Symbol	m_ComboSymbol;				    ///< ϺԼ
	EES_Symbol			m_FirstSymbol;					///< һȺԼ
	unsigned char		m_FirstDirection;				///< 1-࣬5-
	double				m_FirstRegion;					///< һȺԼֱֲ
	EES_Symbol			m_SecondSymbol;					///< ڶȺԼ
	unsigned char		m_SecondDirection;				///< 1-࣬5-
	double				m_SecondRegion;					///< ڶȺԼֱֲ
};

struct EES_AccountOptionPosition
{
	EES_Account			m_ActId;						///< ˻
	EES_Symbol			m_Symbol;						///< Լ/Ʊ
	EES_PosiDirection	m_PosiDirection;				///< շ 1ͷ 5ͷ
	EES_Symbol			m_UnderlyingSymbol;				///< ȨڻԼ
	char				m_CallPut;                      ///< ȨϹϹ
	double				m_StrikePrice;                  ///< ȨԼִм
	unsigned int		m_ExpireDate;                   ///< 
	unsigned int		m_InitOvnQty;					///< ҹֳʼֵ仯ͨHelpDeskֹ޸		
	unsigned int		m_CurOvnQty;                    ///< ǰ
	unsigned int		m_CurTodayQty;                  ///< ʣ
	unsigned int		m_CoverOvnLockedQty;            ///< ƽƽģʽ²ʾ
	unsigned int		m_CoverTodayLockedQty;          ///< ƽƽģʽ²ʾ
	unsigned int		m_ExecPendingQty;               ///< Ȩշȥûгɽرʱֵ0κȨ
	unsigned int		m_ExecAppliedQty;               ///< ȨѾյر
	unsigned int		m_CxlExecPendingQty;            ///< Ȩ;
	double				m_LiquidPl;                     ///< ƽӯ
	double				m_AvgPrice;	                    ///< 
	double				m_TotalCommissionFee;           ///<
	EES_HedgeFlag		m_HedgeFlag;					///< λӦͶ־
};

/// ʻʽϢ
struct EES_AccountBP
{
	EES_Account			m_Account;						///< ˻
	double				m_InitialBp;					///< ʼȨ
	double				m_AvailableBp;					///< ܿʽ
	double				m_Margin;						///< вλռõı֤
	double				m_FrozenMargin;					///< йҵı֤
	double				m_CommissionFee;				///< ѿ۳ܽ
	double				m_FrozenCommission;				///< ҵѽ
	double				m_OvnInitMargin;				///< ʼֱ֤
	double				m_TotalLiquidPL;				///< ƽӯ
	double				m_TotalMarketPL;				///< ֲܳӯ
};

/// ʻĳϢ
struct EES_AccountCashInout
{
	EES_Account			m_Account;						///< Value  Notes
	double				m_AvailableBp;					///< ܿʽ
	double				m_CashInOut;	///< 	γ
	double				m_CashInTotal; ///< 	ۼ
	double				m_CashOutTotal; ///< 	ۼ

};

/// Լб
struct EES_SymbolField
{
	EES_SecType			m_SecType;						///< 3=FutureĿǰ֧ڻ
	EES_Symbol			m_Symbol;						///< Լ/Ʊ
	EES_SymbolName		m_SymbolName;					///< Լ
	EES_ExchangeID		m_ExchangeID;					///< 102=н   103=    104=    105=֣
	EES_ProductID		m_ProdID;						///< Ʒ
	unsigned int		m_DeliveryYear;					///< 
	unsigned int		m_DeliveryMonth;				///< 
	unsigned int		m_MaxMarketOrderVolume;			///< м۵µ
	unsigned int		m_MinMarketOrderVolume;			///< м۵Сµ
	unsigned int		m_MaxLimitOrderVolume;			///< ޼۵µ
	unsigned int		m_MinLimitOrderVolume;			///< ޼۵Сµ
	unsigned int		m_VolumeMultiple;				///< Լ
	double				m_PriceTick;					///< С䶯λ 
	unsigned int		m_CreateDate;					///< 
	unsigned int		m_OpenDate;						///< 
	unsigned int		m_ExpireDate;					///< , ȨҲøֵ
	unsigned int		m_StartDelivDate;				///< ʼ
	unsigned int		m_EndDelivDate;					///< 
	unsigned int		m_InstLifePhase;				///< Լ״̬   0=δ    1=    2=ͣ    3=
	unsigned int		m_IsTrading;					///< ǰǷ   0=δ    1=
	unsigned short      m_SymbolIdx;					///< Լ
};

/// ѯʻı֤
struct EES_AccountMargin
{
	EES_HedgeFlag		m_HedgeFlag;					///< Ͷ־
	EES_Symbol			m_Symbol;						///< Լ/Ʊ
	EES_ExchangeID		m_ExchangeID;					///< 102=н   103=    104=    105=֣
	EES_ProductID		m_ProdID;						///< 4  Alpha Ʒ
	double				m_LongMarginRatio;				///< ֱ֤
	double				m_ShortMarginRatio;				///< ղֱ֤ʣĿǰò
};

/// ʻԼʲѯ
struct EES_AccountFee
{
	EES_HedgeFlag		m_HedgeFlag;					///< Ͷ־
	EES_Symbol			m_Symbol;						///<  Լ/Ʊ
	EES_ExchangeID		m_ExchangeID;					///<  102=н    103=    104=    105=֣
	EES_ProductID		m_ProdID;						///<  Ʒ
	double				m_OpenRatioByMoney;				///<  ʣս
	double				m_OpenRatioByVolume;			///<  ʣ
	double				m_CloseYesterdayRatioByMoney;	///<  ƽʣս
	double				m_CloseYesterdayRatioByVolume;	///<  ƽʣ
	double				m_CloseTodayRatioByMoney;		///<  ƽʣս
	double				m_CloseTodayRatioByVolume;		///<  ƽʣ
	EES_PosiDirection	m_PositionDir;					///<  1: ͷ2: ͷ
};

struct EES_QuerySvrInfo
{
	char            m_RemoteQueryIp[16];  /// IP
	unsigned short  m_RemoteQueryTCPPort; /// TCP˿

	EES_QuerySvrInfo()
	{
		memset((void*)this, 0, sizeof(EES_QuerySvrInfo));
	}
};


#pragma pack(pop)

#endif
