/*! \file EesTraderApi.h
 *  \brief EES׿ͻͷļ   
 *  
 *  ĵϸEES׿ͻ˵Ľӿڶ塣
*/
#pragma  once 
#include "EesTraderDefine.h"
#include "EesTraderErr.h"
#include <time.h>

#ifdef WIN32
	#ifdef SL_EES_TRADE_EXPORTS
		#define SL_EES_TRADE_CLASS __declspec(dllexport)	  
		#define SL_EES_TRADE_FUN		extern "C" __declspec(dllexport)
	#else
		#define SL_EES_TRADE_CLASS __declspec(dllimport)	  
		#define SL_EES_TRADE_FUN		extern "C" __declspec(dllimport)
	#endif

	/// \brief EES׿ͻ˶̬
	#define EES_TRADER_DLL_NAME    "EESTraderApi.dll"
	/// \brief EES׿ͻ˾̬
	#define EES_TRADER_LIB_NAME    "EESTraderApi.lib"

	#include <windows.h>

#else	
	#define SL_EES_TRADE_CLASS 
	#define SL_EES_TRADE_FUN  extern "C" 

	#ifndef OUT
		#define OUT
	#endif

	#ifndef NULL
		#define NULL 0
	#endif

	/// \brief EES׿ͻ˶̬
	#define EES_TRADER_DLL_NAME    "libEESTraderApi_ef.so"

#endif

/// \brief EES׿ͻ˻ص
class  EESTraderEvent
{
public:	
	virtual ~EESTraderEvent()
	{

	}
	/// ϢĻص
	
		///	\brief	¼
		///	\param  errNo                   ӳɹϢ
		///	\param  pErrStr                 Ϣ
		///	\return void  
	
	virtual void OnConnection(ERR_NO errNo, const char* pErrStr ){}

	/// ӶϿϢĻص
	
		/// \brief	ϿյϢ
		/// \param  ERR_NO errNo         ӳɹϢ
		/// \param  const char* pErrStr  Ϣ
		/// \return void  
	
	virtual void OnDisConnection(ERR_NO errNo, const char* pErrStr ){}

	/// ¼ϢĻص
	
		/// \param  pLogon                  ¼ɹʧܵĽṹ
		/// \return void 
	
	virtual void OnUserLogon(EES_LogonResponse* pLogon, MY_SOCKET m_sock = -1){}


	/// Ȩ̨ϵͳܵ¼

	/// \brief ʾѾ̨ϵͳʽĽ
	/// \param  pAccept	                    ԺϢ
	/// \return void 

	virtual void OnSpecialOrderAccept(EES_SpecialOrderAcceptField* pAccept) {}

	/// µ̨ϵͳܵ¼
	
		/// \brief ʾѾ̨ϵͳʽĽ
		/// \param  pAccept	                    ԺϢ
		/// \return void 
	
	virtual void OnOrderAccept(EES_OrderAcceptField* pAccept ){}


	/// ϱ̨յ¼

	/// \brief ʾѾ̨ϵͳʽĽ
	/// \param  pAccept	                    ԺϢ
	/// \return void 

	virtual void OnComboAccept(EES_ComboAcceptField* pAccept) {}


	///۱̨ϵͳܵ¼

	/// \brief ʾ۵Ѿ̨ϵͳʽĽ
	/// \param  pAccept	                    ۵ԺϢ
	/// \return void 

	virtual void OnQuoteAccept(EES_QuoteAcceptField* pAccept) {}


	///Ȩгܵ¼

	/// \brief ʾѾʽĽ
	/// \param  pAccept	                    ԺϢ壬гID
	/// \return void 
	virtual void OnSpecialOrderMarketAccept(EES_SpecialOrderMarketAcceptField* pAccept) {}

	/// µгܵ¼

	    /// \brief ʾѾʽĽ
	    /// \param  pAccept	                    ԺϢ壬гID
	    /// \return void 
	virtual void OnOrderMarketAccept(EES_OrderMarketAcceptField* pAccept) {}


	/// ϱгܵ¼

	/// \brief ʾѾʽĽ
	/// \param  pAccept	                    ԺϢ壬гID
	/// \return void 
	virtual void OnComboMarketAccept(EES_ComboMarketAcceptField* pAccept) {}

	/// ۱гܵ¼

	/// \brief ʾѾʽĽ
	/// \param  pAccept	                    ۱ԺϢ壬гID
	/// \return void 
	virtual void OnQuoteMarketAccept(EES_QuoteMarketAcceptField* pAccept) {}


	/// г״̬仯

	/// \brief ʾ״̬˱仯
	/// \param  pReport	                    
	/// \return void 
	virtual void OnOrderMarketReport(EES_OrderMarketReportField* pReport) {}

	/// г״̬仯

	/// \brief ʾ״̬˱仯
	/// \param  pReport	                    
	/// \return void 
	virtual void OnQuoteMarketReport(EES_QuoteMarketReportField* pReport) {}

	///	µ̨ϵͳܾ¼
	
		/// \brief	̨ϵͳܾԲ鿴﷨Ƿؼ顣 
		/// \param  pReject	                    
		/// \return void 
	
	virtual void OnOrderReject(EES_OrderRejectField* pReject ){}


	///	Ϲ̨ϵͳܾ¼

	/// \brief	̨ϵͳܾԲ鿴﷨Ƿؼ顣 
	/// \param  pReject	                    
	/// \return void 

	virtual void OnComboReject(EES_ComboRejectField* pReject) {}

	///	Ȩ̨ϵͳܾ¼

	/// \brief	̨ϵͳܾԲ鿴﷨Ƿؼ顣 
	/// \param  pReject	                    
	/// \return void 

	virtual void OnSpecialOrderReject(EES_SpecialOrderRejectField* pReject) {}

	///	۵̨ϵͳܾ¼

	/// \brief	۵̨ϵͳܾԲ鿴﷨Ƿؼ顣 
	/// \param  pReject	                    
	/// \return void 

	virtual void OnQuoteReject(EES_QuoteRejectField* pReject) {}

	///	µгܾ¼

	/// \brief	гܾ 
	/// \param  pReject	                    
	/// \return void 

	virtual void OnOrderMarketReject(EES_OrderMarketRejectField* pReject) {}


	///	ϱгܾ¼

	/// \brief	гܾ 
	/// \param  pReject	                    
	/// \return void 

	virtual void OnComboMarketReject(EES_ComboMarketRejectField* pReject) {}


	///	Ȩгܾ¼

	/// \brief	гܾ 
	/// \param  pReject	                    
	/// \return void 

	virtual void OnSpecialOrderMarketReject(EES_SpecialOrderMarketRejectField* pReject) {}

	///	۵гܾ¼

	/// \brief	۵гܾ 
	/// \param  pReject	                    
	/// \return void 

	virtual void OnQuoteMarketReject(EES_QuoteMarketRejectField* pReject) {}

	///	ɽϢ¼
	
		/// \brief	ɽ˶гIDIDѯӦĶ
		/// \param  pExec	                   
		/// \return void 
	
	virtual void OnOrderExecution(EES_OrderExecutionField* pExec ){}

	///	̨
	
		/// \brief	
		/// \param  pCxled		               
		/// \return void 
	
	virtual void OnOrderActionAccept(EES_OrderActionAccept* pCxled ){}

	///	Ȩ̨

	/// \brief	
	/// \param  pCxled		               
	/// \return void 

	virtual void OnSpecialOrderActionAccept(EES_SpecialOrderActionAccept* pCxled) {}


	///	۵̨

	/// \brief	
	/// \param  pAction		               
	/// \return void 

	virtual void OnQuoteActionAccept(EES_QuoteActionAccept* pAction) {}


	///	ѯ֪ͨ¼
	/// \brief	ѯ۱źͺԼ ʱ
	/// \param  pRegForQuote		            ѯ۱źͺԼ ʱ
	/// \return void 

	virtual void OnInputRegForQuote(EES_InputRegForQuoteResponse* pRegForQuote) {}

	///	̨ܾϢ¼
	
		/// \brief	һڷͶԺյϢʾܾ
		/// \param  pReject	                   ܾϢ
		/// \return void 
	
	virtual void OnOrderActionReject(EES_OrderActionRej* pReject ){}


	//	Ȩ̨ܾϢ¼
	virtual void OnSpecialOrderActionReject(EES_SpecialOrderActionRej* pReject) {}

	///	۵̨ܾ¼
	virtual void OnQuoteActionReject(EES_QuoteActionRej* pAction) {}


	///
	virtual void OnOrderActionMarketAccept(EES_OrderActionMarketAcceptField* pAccept) {}

	///Ȩ
	virtual void OnSpecialOrderActionMarketAccept(EES_SpecialOrderActionMarketAcceptField* pAccept) {}

	///۲
	virtual void OnQuoteActionMarketAccept(EES_QuoteActionMarketAcceptField* pAccept) {}


	///ܾ
	virtual void OnOrderActionMarketReject(EES_OrderActionMarketRejectField* pReject) {}


	///Ȩܾ
	virtual void OnSpecialOrderActionMarketReject(EES_SpecialOrderActionMarketRejectField* pReject) {}

	///۲ܾ
	virtual void OnQuoteActionMarketReject(EES_QuoteActionMarketRejectField* pReject) {}

	///	ⲿ۵Ϣ

	/// \brief	
	/// \param  pPostQuote	                    
	/// \return void 

	virtual void OnPostQuote(EES_PostQuote* pPostOrder) {}

	///	ⲿϢ
	
		/// \brief	
		/// \param  pPostOrder	                    
		/// \return void 
	
	virtual void OnPostOrder(EES_PostOrder* pPostOrder ){}



	///	ȨⲿϢ

	/// \brief	
	/// \param  pPostSpecialOrder	                    
	/// \return void 

	virtual void OnPostSpecialOrder(EES_PostSpecialOrder* pPostOrder) {}

	///	ⲿɽϢ
	
		/// \brief	
		/// \param  pPostOrderExecution	             
		/// \return void 
	
	virtual void OnPostOrderExecution(EES_PostOrderExecution* pPostOrderExecution ){}

	///	˹Ϣ

	/// \brief	һϵͳ˹ʱõ
	/// \param  pInternalOrder	                    ˹Ľṹ
	/// \return void 

	virtual void OnInternalOrder(EES_InternalOrder* pInternalOrder) {}

	///	˹״̬Ϣ

	/// \brief	һϵͳ˹ʱõ
	/// \param  pInternalOrderAdjustStatus	       ˹״̬ϢĽṹ
	/// \return void 

	virtual void OnInternalOrderAdjustStatus(EES_InternalOrderAdjustStatus* pInternalOrderAdjustStatus) {}

	///	˹ɽϢ

	/// \brief	һϵͳ˹ʱõ
	/// \param  pInternalOrderExec	               ˹ɽĽṹ
	/// \return void 

	virtual void OnInternalOrderExec(EES_InternalOrderExecution* pInternalOrderExec) {}

	///	˹ܾϢ

	/// \brief	һϵͳ˹ʱõ
	/// \param  pInternalOrderAdjustMktRej	       ˹ܾϢĽṹ
	/// \return void 

	virtual void OnInternalOrderAdjustMktRej(EES_InternalOrderAdjustMktRej* pInternalOrderAdjustMktRej) {}


	///	ձ˹״̬Ϣ

	/// \brief	һϵͳ˹ʱõ
	/// \param  pInternalOrderAdjustStatus	       ˹״̬ϢĽṹ
	/// \return void 

	virtual void OnInternalQuoteAdjustStatus(EES_InternalQuoteAdjustStatus* pInternalQuoteAdjustStatus) {}

	///	ձ˹ܾϢ

	/// \brief	һϵͳ˹ʱõ
	/// \param  pInternalOrderAdjustMktRej	       ˹ܾϢĽṹ
	/// \return void 

	virtual void OnInternalQuoteAdjustMktRej(EES_InternalQuoteAdjustMktRej* pInternalQuoteAdjustMktRej) {}


	///	ѯӵӦ

	/// \brief	ÿǰϵͳֵ֧Ļ㱨һΣbFinish= trueʱʾнӦѵϢõϢ
	/// \param  pMarketSession	             ѯӵĽṹ
	/// \return void 
	virtual void OnQueryMarketSession(EES_ExchangeMarketSession* pMarketSession, bool bFinish) {}

	///	״̬仯棬

	/// \brief	ӷ/Ͽʱ״̬
	/// \param  MarketSessionId: Ӵ
	/// \param  ConnectionGood: trueʾfalseʾӶϿˡ
	/// \return void 
	virtual void OnMarketSessionStatReport(EES_MarketSessionId MarketSessionId, bool ConnectionGood) {}

	///	Լ״̬仯

	/// \brief	Լ״̬仯ʱ
	/// \param  pSymbolStatus: μEES_SymbolStatusԼ״̬ṹ嶨
	/// \return void 
	virtual void OnSymbolStatusReport(EES_SymbolStatus* pSymbolStatus) {}

	///	Լ״̬ѯӦ

	/// \brief  ӦԼ״̬ѯ
	/// \param  pSymbolStatus: μEES_SymbolStatusԼ״̬ṹ嶨
	/// \param	bFinish: ΪtrueʱʾѯнءʱpSymbolStatusΪָNULL
	/// \return void 
	virtual void OnQuerySymbolStatus(EES_SymbolStatus* pSymbolStatus, bool bFinish) {}

	/// ϯλŲѯӦ
	/// \param	pSessionID: μEES_SessionIDϯλŽṹ嶨
	/// \return void 
	virtual void OnQuerySessionID(EES_SessionID* pSessionID) {}
};

/// \brief EES׿ͻ˴
class SL_EES_TRADE_CLASS EESTraderApi
{
public:
	virtual ~EESTraderApi()
	{
	}

	///ȡAPI汾
	/// \return api_verson  Apiİ汾ţһַ4.2.4.71
	virtual const char*  GetTradeApiVersion() = 0;

	///ǷԶConnServer֮ǰʹ
	/// \return ûзֵ
	virtual void SetAutoReconnect(bool autoConnect) = 0;

	/// ýӵȴ¼ʱ
	/// \param  int tradeWaitTime			ӵȴ¼ʱ
	/// \return ûзֵ
	virtual void SetMaxWaitTime(int tradeWaitTime) = 0;

	/// ȡµʱ
	/// \param  long long timestamps	ʱ
	/// \param  int count				С
	/// \return ûзֵ
	virtual void GetTimestamps(long long timestamps[], int& count) = 0;


	/// ӷ
	virtual RESULT	ConnServer(const EES_TradeSvrInfo& param, EESTraderEvent* pEvent, bool mixProtocol = false)  = 0 ;
	
	/// Ͽ
	
		/// \return RESULT						ο EesTraderErr.hļ
	
	virtual RESULT	DisConnServer()  = 0 ;

	/// û¼
	
		/// \brief	Ĳʻû
		/// \param  const char* logonId		    ¼û
		/// \param  const char* userPwd		    û¼
		/// \param  const char* appId		    AppId
		/// \param  const char* authCode		Ȩ
		/// \return RESULT			ֵο EesTraderErr.hļ
	
	virtual RESULT UserLogon(const char* logonId, const char* userPwd, const char* appId, const char* authCode) = 0 ;

	/// ȡ   token ֵ
	/// \brief	ȡ   token ֵ
	/// \param  EES_ClientToken * orderToken	Ҫֵ
	/// \return RESULT			ֵοEesTraderErr.hļ
	virtual RESULT GetMaxToken(OUT EES_ClientToken* orderToken) = 0  ;


	/// µ
	
		/// \param  EES_EnterOrderField* pOrder	֯õĶṹ
		/// \return RESULT			ֵοEesTraderErr.hļ
	
	virtual RESULT	EnterOrder(EES_EnterOrderField* pOrder ) = 0  ;


	/// 

	/// \param  EES_EnterComboField* pCombo	֯õϽṹ
	/// \return RESULT			ֵοEesTraderErr.hļ
	virtual RESULT	EnterCombo(EES_EnterComboField* pCombo) = 0;

	///Ȩ
	/// \param  EES_EnterSpecialOrderField* pOrder	֯õĶṹ
	/// \return RESULT			ֵοEesTraderErr.hļ
	virtual RESULT	EnterSpecialOrder(EES_EnterSpecialOrderField* pOrder) = 0;


	///ģʽµ
	/// \param  EES_EnterOrderFieldSimple* pOrder	֯õĶṹ
	/// \return RESULT			ֵοEesTraderErr.hļ
	virtual RESULT	EnterOrderSimple(EES_EnterOrderSimpleField* pOrder, const char* accountId, const char* symbol) = 0;

	///ģʽ±
	virtual RESULT EnterQuoteSimple(EES_EnterQuoteSimpleField* pQuote, const char* accountId, const char* symbol) = 0;


	/// Ȩ

	/// \param  EES_CancelSpecialOrder* pCxlOrder		ṹ
	/// \return RESULT			ֵοEesTraderErr.hļ

	virtual RESULT	CancelSpecialOrder(EES_CancelSpecialOrder* pCxlOrder) = 0;

	///
	virtual RESULT EnterQuote(EES_EnterQuoteField* pQuote) = 0;

	/// ¼ȵ
	virtual void EnterOrderWarm() = 0;


	/// ¼ȵ
	virtual void EnterQuoteWarm() = 0;
	/// ָ
	
		/// \param  EES_CancelOrder* pCxlOrder		ṹ
		/// \return RESULT			ֵοEesTraderErr.hļ
	
	virtual RESULT	CancelOrder(EES_CancelOrder* pCxlOrder)  = 0 ;

	///۲ָ
	virtual RESULT QuoteAction(EES_QuoteAction* pQuoteAction) = 0;


	/// ʱתڽAPIеEES_NanosecondͣתCԱ׼struct tmṹ壬Լʱһڵ

	/// \param  EES_Nanosecond timeStamp		APIṹеʱֵ
	/// \param  tm& tmResult					ڽսstruct tmṹ
	/// \param  unsigned int& nanosecond 		ڽս
	/// \return ûзֵ
	virtual void ConvertFromTimestamp(EES_Nanosecond timeStamp, tm& tmResult, unsigned int& nanosecond) = 0;

	/// ־أĬΪء

	/// \param  bool bOn		true: 򿪱־; false: رձ־
	/// \return ûзֵ
	virtual void SetLoggerSwitch(bool bOn) = 0;

	/// ־Ϣдļ
	/// \return ûзֵ
	virtual void LoggerFlush() = 0;

	/// ͻΪ첽ģʽConnectServer֮ǰʹãһʹãл
	/// ӿֻͼλֹµʹã򻯽ƽ̨ʹøýӿڻɽնӳٱ
	/// \return ûзֵ
	virtual void SetAsyncReceiveMode() = 0;

	/// ͻز
	/// ¼ɹ󣬿ɴӵ¼ϢṹEES_LogonResponseУȡǰ¼زλÿٺ룬ٴµ/
	/// ڷ˶µĿǸ˺ţϵͳһ˺Ŷ¼ͬʱµʵؿܻȻõĲϸ
	/// ṩýӿڣͻԸԼǷҪ¼µزиϸĵֹ˷شӶ۶ϵ¼
	/// ӿֻµֻܵø٣Ҳܽ0
	/// orderCountµ
	/// cancelCount³
	/// ӿڲ᷵ȷǴ˴Ĳԭ仯
	virtual RESULT ChangeFCParam(unsigned int orderCount, unsigned int cancelCount) = 0;

	/// Ͳѯϯλ	
	/// \return RESULT ӦEESTraderEvent::OnQueryMarketSessionз
	virtual RESULT QueryMarketSession() = 0;

	/// ͲѯԼ״̬ 
	/// \return RESULT ӦEESTraderEvent::OnQuerySymbolStatusз
	virtual RESULT QuerySymbolStatus() = 0;

	/// Ͳѯϯλ
	/// tradeNo: ϯλ
	/// exchangeID: ҪEES_ExchangeID_shfeʵʽ0,0ʾУ齻ֵ
	/// \return ɹ0ӦEESQueryEvent::OnQuerySessionIDз
	virtual RESULT QuerySessionID(const char* tradeNo, EES_ExchangeID exchangeID) = 0;


};

/// EES׿ͻʵĺ
#define CREATE_EES_TRADER_API_NAME ("CreateEESTraderApi")

/// EES׿ͻʵĺ
#define DESTROY_EES_TRADER_API_NAME ("DestroyEESTraderApi")

/// EES׿ͻʵ
SL_EES_TRADE_FUN EESTraderApi* CreateEESTraderApi(void) ; 

/// EES׿ͻʵ
SL_EES_TRADE_FUN void DestroyEESTraderApi(EESTraderApi* pEESTraderApi) ; 

/// EES׿ͻʵָ
typedef EESTraderApi* (*funcCreateEESTraderApi)(void) ;

/// EES׿ͻʵָ
typedef void (*funcDestroyEESTraderApi)(EESTraderApi* pEESTraderApi) ;

