/*! \file  EesTraderDefine.h
 *  \brief EES׿ͻAPIʹõϢ嶨塣
 *
 *  ļϸEES׿ͻAPIʹõݽṹԼϢ塣 
*/
#pragma  once 




#ifndef _EES_TRADE_API_STRUCT_DEFINE_H_
#define _EES_TRADE_API_STRUCT_DEFINE_H_

#include "string.h"
#include "EesCommonDefine.h"

#pragma pack(push, 1)

#define SL_EES_API_VERSION    "5.2.4.11"				///<  api汾

/// ¼صϢ
struct EES_LogonResponse
{
	unsigned int		m_Sequence;							///< кţUDP-SequenceУʹãĬϲУ
	EES_LogonResult		m_Result;							///< μĵEES_LogonResult
	EES_UserID			m_UserId;							///< ¼ӦûID
	unsigned int		m_TradingDate;						///< գʽΪyyyyMMddintֵ
	EES_ClientToken		m_MaxToken;							///< ǰ token 
	unsigned int		m_OrderFCCount;						///< µزλʱµƵĴ
	unsigned int		m_OrderFCInterval;					///< µزλʱµƵλʱ䣬΢ֵ
	unsigned int		m_CancelFCCount;					///< زλʱڳƵĴ
	unsigned int		m_CancelFCInterval;					///< زλʱڳƵλʱ䣬΢ֵ
};


struct EES_InputRegForQuoteResponse
{
	EES_QUOTE_ID		m_ReqForQuoteID;				///< ѯ۱
	EES_ExchangeID      m_Exchange;						///< 
	EES_Symbol          m_Symbol;						///< Լ
	EES_Nanosecond		m_MktTimestamp;					///< гѯ
};

struct EES_EnterOrderSimpleField
{
	unsigned short		m_SysUserInfo1;						///< ϵͳԤֶ,д
	unsigned short		m_SysUserInfo2;						///< ϵͳԤֶ,д
	unsigned int		m_Sequence;							///< кţUDP-SequenceУʹãĬϲУ
	unsigned char		m_SysUserInfo4;						///< ϵͳԤֶ,д
	unsigned char		m_SysUserInfo5;						///< ϵͳԤֶ,д
	unsigned short		m_SysUserInfo6;						///< ϵͳԤֶ,д
	EES_ExchangeID		m_Exchange;						///< 
	unsigned char		m_MarketSessionId;						///< ϯλ
	unsigned char		m_ForceMarketSessionId;				///< Ϊtrueͻָϯλ룬Ǹϯλû߷ǷʱָʾҪо͵ϯλǾܾµ
	EES_OrderPriceType	m_OrderPriceType;					///< ۸ͣĿǰ֧֣1=޼; 3=޼ֹӯ; 4=޼ֹ; 
	unsigned char		m_OrderType;						///<  01234 						
	EES_SideType		m_Side;								///<  1򿪲 2ƽ 3ƽ 4  5ƽ 6ƽ 21ƽ 22ƽ 
	EES_HedgeFlag		m_HedgeFlag;						///< Ͷ־
	unsigned char		m_IOC;								///< 0:ͨҪFAK/FOKʱҪIOCΪ1
	EES_ClientToken		m_ClientOrderToken;						///< ͻ˵,
	unsigned int		m_Qty;							///< 
	unsigned int		m_MinQty;						///< ҪFAK/FOKʱֵ=0ӳ佻FAK-
															///< ҪFAK/FOKʱֵ>0<m_Qtyӳ佻FAK-ССֵ
															///< ҪFAK/FOKʱֵ=m_Qtyӳ佻FOK
															///< ڱΪ0.ֵ>m_QtyREMϵͳܾ
	double			    m_Price;							///< ۸
	double				m_StopPrice;						///< m_OrderPriceTypeΪ 3/4/5/6 ʱ0
	unsigned char		m_IsOffset;						///< ȨǷԳ壨1ǣ0
	unsigned char		m_Reserved[3];
	EES_CustomFieldType m_CustomField;					    ///< ûԶֶ
	EES_EnterOrderSimpleField()
	{
		memset(this, 0, sizeof(*this));
		m_IOC = EES_OrderTif_Day;
		m_MinQty = 0;
		m_MarketSessionId = 0;
		m_HedgeFlag = EES_HedgeFlag_Speculation;
		m_ForceMarketSessionId = 0;
		m_OrderPriceType = EES_Order_Type_Limt;
	}
};

/// µϢ
struct EES_EnterOrderField
{
	unsigned int		m_Sequence;						///< кţUDP-SequenceУʹãĬϲУ
	EES_Account         m_Account;						///< û
	EES_SideType        m_Side;							///<   1򿪲 2ƽ 3ƽ 4  5ƽ 6ƽ 21ƽ 22ƽ 
	EES_ExchangeID      m_Exchange;						///< 
	EES_Symbol          m_Symbol;						///< Լ
	double              m_Price;						///< ۸
	unsigned int        m_Qty;							///< 
	EES_ForceCloseReason m_ForceCloseReason;			///< ǿƽԭ  0=ǿƽ, 1=ʽ,2=ͻ,3=Ա,4=ֲַ,5=Υ棬6=
	EES_ClientToken		m_ClientOrderToken;				///< ͻ˵ţ
	EES_OrderIOC		m_IOC;							///< 0:ͨҪFAK / FOKʱҪIOCΪ1 GISΪ2
	unsigned int		m_MinQty;						///< ҪFAK/FOKʱֵ=0ӳ佻FAK-
														///< ҪFAK/FOKʱֵ>0<m_Qtyӳ佻FAK-ССֵ
														///< ҪFAK/FOKʱֵ=m_Qtyӳ佻FOK
														///< ڱΪ0.ֵ>m_QtyREMϵͳܾ
	
	EES_CustomFieldType m_CustomField;					///< ûԶֶΣintͣûµʱֵָOnOrderAcceptOnQueryTradeOrder¼з
	EES_MarketSessionId m_MarketSessionId;				///< ϯλ룬OnResponseQueryMarketSessionIdȡϷֵ0ǷֵREMϵͳо͵ϯλ	m_ForceMarketSessionIdΪtrue
	EES_HedgeFlag		m_HedgeFlag;					///< Ͷ־ 1  2 Ͷ 3 ױ
	unsigned char		m_ForceMarketSessionId;			///< Ϊtrueͻָϯλ룬Ǹϯλû߷ǷʱָʾҪо͵ϯλǾܾµ
	unsigned char		m_DoNotAdjustCoverSide;			///< Ĭ£н/ġƽ/ƽ򡱶APIԶ֮תΪƽֵ֡Ϊtrue򲻽дתһڲԳ
	unsigned char		m_OrderType;					///< OrderType 01234 
	EES_OrderPriceType	m_OrderPriceType;				///< Ŀǰ֧֣1=޼; 3=޼ֹӯ; 4=޼ֹ; 
	double				m_StopPrice;					///< m_OrderPriceTypeΪ 3/4/5/6 ʱ0
	unsigned char		m_IsOffset;						///< ȨǷԳ壨1ǣ0
	EES_EnterOrderField()
	{
		memset(this, 0, sizeof(*this));
		m_IOC = EES_OrderTif_Day;
		m_MinQty = 0;
		m_MarketSessionId = 0;
		m_HedgeFlag = EES_HedgeFlag_Speculation;
		m_ForceMarketSessionId = 0;
		m_DoNotAdjustCoverSide = 0;
		m_OrderPriceType = EES_Order_Type_Limt;
	}

};

struct EES_EnterComboField
{
	unsigned int		m_Sequence;						///< кţUDP-SequenceУʹãĬϲУ
	EES_Account         m_Account;						///< û
	EES_ExchangeID      m_Exchange;						///< 
	EES_Combo_Symbol    m_ComboSymbol;				    ///< ϺԼ  HO2312-C-2950,-HO2312-C-2950
	unsigned int        m_Qty;						    ///< 
	EES_ClientToken		m_ClientComboToken;				///< ͣ뱣֤αϴεֵ󣬲һҪ֤
	EES_MarketSessionId m_MarketSessionId;				///< ϯλ룬OnResponseQueryMarketSessionIdȡϷֵ0ǷֵREMϵͳо͵ϯλ	m_ForceMarketSessionIdΪtrue
	EES_HedgeFlag		m_HedgeFlag;					///< Ͷ־ 1  2 Ͷ 3 ױ
	unsigned char		m_ForceMarketSessionId;			///< Ϊtrueͻָϯλ룬Ǹϯλû߷ǷʱָʾҪо͵ϯλǾܾµ
	unsigned char	    m_ComboDirection;				///< ָ֤ 0 1
	EES_EnterComboField()
	{
		memset(this, 0, sizeof(*this));
		m_MarketSessionId = 0;
		m_HedgeFlag = EES_HedgeFlag_Speculation;
		m_ForceMarketSessionId = 0;
	}
};

struct EES_EnterSpecialOrderField
{
	unsigned int		m_Sequence;						///< кţUDP-SequenceУʹãĬϲУ
	EES_Account         m_Account;						///< û
	EES_SideType        m_Side;							///<  11 =Ȩƽ12=Ȩƽ13=Ȩ 14=Ȩ 15=Ȩ 16=Ȩ 17=ԶԳ 18=ԼԳ
	EES_ExchangeID      m_Exchange;						///< 
	EES_Symbol          m_Symbol;						///< Լ
	unsigned int        m_Qty;							///< 
	EES_ForceCloseReason m_ForceCloseReason;			///< ǿƽԭ  0=ǿƽ, 1=ʽ,2=ͻ,3=Ա,4=ֲַ,5=Υ棬6=
	EES_ClientToken		m_ClientOrderToken;				///< ͣ뱣֤αϴεֵ󣬲һҪ֤
	EES_CustomFieldType m_CustomField;					///< ûԶֶΡûµʱֵָOnOrderAcceptOnQueryTradeOrder¼з
	EES_MarketSessionId m_MarketSessionId;				///< ϯλ룬OnResponseQueryMarketSessionIdȡϷֵ0ǷֵREMϵͳо͵ϯλ	m_ForceMarketSessionIdΪtrue
	EES_HedgeFlag		m_HedgeFlag;					///< Ͷ־ 1  2 Ͷ 3 ױ
	unsigned char		m_ForceMarketSessionId;			///< Ϊtrueͻָϯλ룬Ǹϯλû߷ǷʱָʾҪо͵ϯλǾܾµ
	unsigned char		m_IsOffset;						///< ȨǷԳ壨1ǣ0
	EES_EnterSpecialOrderField()
	{
		memset(this, 0, sizeof(*this));
		m_MarketSessionId = 0;
		m_HedgeFlag = EES_HedgeFlag_Speculation;
		m_ForceMarketSessionId = 0;
	}

};

struct EES_EnterQuoteSimpleField
{
	unsigned short		m_SysUserInfo1;											///< ϵͳԤֶ,д
	unsigned short		m_SysUserInfo2;											///< ϵͳԤֶ,д
	unsigned int		m_Sequence;												///< кţUDP-SequenceУʹãĬϲУ
	unsigned char		m_SysUserInfo4;											///< ϵͳԤֶ,д
	unsigned char		m_SysUserInfo5;											///< ϵͳԤֶ,д
	unsigned short		m_SysUserInfo6;											///< ϵͳԤֶ,д
	EES_ExchangeID		m_Exchange;												///< 
	unsigned char		m_MarketSessionId;										///< ϯλ
	unsigned char		m_ForceMarketSessionId;									///< Ϊtrueͻָϯλ룬Ǹϯλû߷ǷʱָʾҪо͵ϯλǾܾµ
	unsigned char		m_IOC;													///< 0:ͨҪFAK / FOKʱҪIOCΪ1 GISΪ2
	unsigned int 		m_BidQty;												///< 
	unsigned int		m_AskQty;												///< 
	double				m_BidPrice;												///< ۸
	double				m_AskPrice;												///< ۸
	EES_HedgeFlag 		m_BidHedgeFlag;											///< Ͷ־0=2 Ͷ; 1: ; 3:ױ
	EES_HedgeFlag		m_AskHedgeFlag;											///< Ͷ־0=2 Ͷ; 1: ; 3:ױ
	unsigned char 		m_BidIsOffset;											///< 򷽿ƽ־ 0- 1-ƽ
	unsigned char 		m_AskIsOffset;											///< ƽ־
	EES_ClientToken		m_ClientOrderToken;										///< ͻ˱۵(tag11)
	EES_CustomFieldType m_CustomField;											///< ûԶֶ
	unsigned char		m_Reserved1[4];	
	EES_EnterQuoteSimpleField()
	{
		memset(this, 0, sizeof(*this));
		m_MarketSessionId = 0;
		m_ForceMarketSessionId = 0;
		m_IOC = EES_OrderTif_Day;
		m_BidHedgeFlag = EES_HedgeFlag_Speculation;
		m_AskHedgeFlag = EES_HedgeFlag_Speculation;
	}
};

struct EES_EnterQuoteField
{
	unsigned int		m_Sequence;						///< кţUDP-SequenceУʹãĬϲУ
	EES_Account         m_Account;						///< û
	EES_Symbol          m_Symbol;						///< Լ
	EES_QUOTE_ID		m_MktQuoteId;					///< ۱ţΪգۣͨ"last":һʱ۶ָ۱ţָ۱Ŷ
	EES_ExchangeID      m_Exchange;						///< 
	EES_ClientToken		m_ClientOrderToken;				///< ͻ˵ţ
	unsigned char		m_BidIsOffset;					///< ƽ01ƽ 2 ƽ 3ƽ
	EES_HedgeFlag		m_BidHedgeFlag;					///< Ͷ־ 1  2 Ͷ 3 ױ
	double              m_BidPrice;						///< ۸
	unsigned int        m_BidQty;						///< 
	unsigned char		m_AskIsOffset;					///< ƽ01ƽ 2 ƽ 3ƽ
	EES_HedgeFlag		m_AskHedgeFlag;					///< Ͷ־ 1  2 Ͷ 3 ױ
	double              m_AskPrice;						///< ۸
	unsigned int        m_AskQty;						///< 
	EES_OrderIOC		m_IOC;							///< 0:ͨҪFAK / FOKʱҪIOCΪ1 GISΪ2
	EES_MarketSessionId m_MarketSessionId;				///< ϯλ룬OnResponseQueryMarketSessionIdȡϷֵ0ǷֵREMϵͳо͵ϯλ	m_ForceMarketSessionIdΪtrue
	unsigned char		m_ForceMarketSessionId;			///< Ϊtrueͻָϯλ룬Ǹϯλû߷ǷʱָʾҪо͵ϯλǾܾµ
	EES_CustomFieldType m_CustomField;					///< ûԶֶΡûµʱֵָOnOrderAcceptOnQueryTradeOrder¼з
	EES_EnterQuoteField()
	{
		memset(this, 0, sizeof(*this));
		m_MarketSessionId = 0;
		m_ForceMarketSessionId = 0;
		m_IOC = EES_OrderTif_Day;
		m_AskHedgeFlag = EES_HedgeFlag_Speculation;
		m_BidHedgeFlag = EES_HedgeFlag_Speculation;
	}
};



/// µ̨ϵͳϢ
struct EES_OrderAcceptField
{ 
	unsigned int		m_Sequence;						///< кţUDP-SequenceУʹãĬϲУ
	EES_ClientToken     m_ClientOrderToken;				///< µʱ򣬷ظtoken
	EES_Internal_Id     m_InternalOrderId;			    ///< Remϵͳţtag37
	EES_UserID          m_UserID;						///<  user id 
	EES_Nanosecond      m_SLTimestamp;					///< 1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_Account         m_Account;						///< û
	EES_SideType        m_Side;							///< 
	EES_Symbol          m_Symbol;						///< Լ
	double              m_Price;						///< ۸
	unsigned int        m_Qty;							///< 
	EES_ForceCloseReason m_ForceCloseReason;			///< ǿƽԭ  0=ǿƽ, 1=ʽ,2=ͻ,3=Ա,4=ֲַ,5=Υ棬6=
	unsigned int		m_MinQty;						///< ûµʱֵָ
	EES_CustomFieldType m_CustomField;					///< ûµʱֵָ
	EES_MarketSessionId m_MarketSessionId;				///< ϯλ룬пܺµʱָĲͬͬԭУǰϯλδӺãָϯλŷǷȣָ0REMо
	EES_HedgeFlag		m_HedgeFlag;					///< Ͷ־
};

struct EES_SpecialOrderAcceptField
{
	unsigned int		m_Sequence;						///< кţUDP-SequenceУʹãĬϲУ
	EES_ClientToken     m_ClientOrderToken;				///< µʱ򣬷ظtoken
	EES_Internal_Id     m_InternalOrderId;			    ///< Remϵͳţtag37
	EES_UserID          m_UserID;						///<  user id 
	EES_Nanosecond      m_SLTimestamp;					///< 1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_Account         m_Account;						///< û
	EES_SideType        m_Side;							///< 
	unsigned int        m_Qty;							///< 
	EES_Symbol          m_Symbol;						///< Լ
	EES_ForceCloseReason m_ForceCloseReason;			///< ǿƽԭ  0=ǿƽ, 1=ʽ,2=ͻ,3=Ա,4=ֲַ,5=Υ棬6=
	EES_CustomFieldType m_CustomField;					///< ûµʱֵָ
	EES_MarketSessionId m_MarketSessionId;				///< ϯλ룬пܺµʱָĲͬͬԭУǰϯλδӺãָϯλŷǷȣָ0REMо
	EES_HedgeFlag		m_HedgeFlag;					///< Ͷ־
};


struct EES_ComboAcceptField
{
	unsigned int		m_Sequence;						///< кţUDP-SequenceУʹãĬϲУ
	EES_ClientToken     m_ClientComboToken;				///< µʱ򣬷ظtoken
	EES_Internal_Id     m_InternalComboId;			    ///< Remϵͳţtag37
	EES_Nanosecond      m_SLTimestamp;					///< 1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_UserID          m_UserID;						///<  user id 
	EES_Account         m_Account;						///< û
	EES_ExchangeID      m_Exchange;						///< 
	EES_Combo_Symbol    m_ComboSymbol;				    ///< ϺԼ
	unsigned int        m_Qty;						    ///< 
	EES_MarketSessionId m_MarketSessionId;				///< ϯλ룬OnResponseQueryMarketSessionIdȡϷֵ0ǷֵREMϵͳо͵ϯλ	m_ForceMarketSessionIdΪtrue
	EES_HedgeFlag		m_HedgeFlag;					///< Ͷ־ 1  2 Ͷ 3 ױ
	unsigned char	    m_ComboDirection;				///< ָ֤ 0 1

};

struct EES_QuoteAcceptField
{
	unsigned int		m_Sequence;						///< кţUDP-SequenceУʹãĬϲУ
	EES_Account         m_Account;						///< û
	EES_UserID			m_UserID;						///<  user id 
	EES_Symbol          m_Symbol;						///< Լ
	unsigned char		m_BidIsOffset;					///< ƽ01ƽ 2 ƽ 3ƽ
	EES_HedgeFlag		m_BidHedgeFlag;					///< Ͷ־
	double              m_BidPrice;						///< ۸
	unsigned int        m_BidQty;						///< 
	unsigned char		m_AskIsOffset;					///< ƽ01ƽ 2 ƽ 3ƽ
	EES_HedgeFlag		m_AskHedgeFlag;					///< Ͷ־
	double              m_AskPrice;						///< ۸
	unsigned int        m_AskQty;						///< 
	EES_MarketSessionId m_MarketSessionId;				///< ϯλ룬OnResponseQueryMarketSessionIdȡϷֵ0ǷֵREMϵͳо͵ϯλ	m_ForceMarketSessionIdΪtrue
	EES_Internal_Id     m_InternalQuoteId;				///< Remϵͳţtag37
	EES_Internal_Id     m_BidInternalQuoteId;			///< Remϵͳţtag37
	EES_Internal_Id     m_AskInternalQuoteId;			///< Remϵͳţtag37
	EES_MarketOrderId	m_MktQuoteId;					///< г۵
	EES_ClientToken		m_QuoteToken;					///< ͻ˱۵(tag11)
	EES_Nanosecond		m_SLTimestamp;					///< 1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_CustomFieldType m_CustomField;					///< ûԶֶΡûµʱֵָOnOrderAcceptOnQueryTradeOrder¼з
	EES_OrderIOC		m_IOC;							///< 0:ͨҪFAK / FOKʱҪIOCΪ1 GISΪ2
};


/// µгϢ
struct EES_OrderMarketAcceptField
{
	unsigned int      m_Sequence;		  ///< кţUDP-SequenceУʹãĬϲУ
	EES_Account       m_Account;          ///< û
	EES_Internal_Id   m_InternalOrderId;  ///< Remϵͳţtag37
	EES_MarketOrderId m_MarketOrderId;    ///< г
	EES_Nanosecond    m_SLTimestamp;      ///< ʢʱϢ
	EES_UserID        m_UserID;			  ///<  user id 
	EES_ClientToken   m_ClientOrderToken; ///< ClientToken
};


struct EES_SpecialOrderMarketAcceptField
{
	unsigned int      m_Sequence;		  ///< кţUDP-SequenceУʹãĬϲУ
	EES_Account       m_Account;          ///< û
	EES_Internal_Id   m_InternalOrderId;  ///< Remϵͳţtag37
	EES_MarketOrderId m_MarketOrderId;    ///< г
	EES_Nanosecond    m_SLTimestamp;      ///< ʢʱϢ
	EES_UserID        m_UserID;			  ///<  user id 
	EES_ClientToken   m_ClientOrderToken; ///< ClientToken
};

struct EES_QuoteMarketAcceptField
{
	unsigned int      m_Sequence;			    ///< кţUDP-SequenceУʹãĬϲУ
	EES_Account       m_Account;				///< û
	EES_Internal_Id   m_InternalQuoteId;		///< Remϵͳţtag37
	EES_Internal_Id   m_InternalBidQuoteId;		///< Remϵͳţtag37
	EES_Internal_Id   m_InternalAskQuoteId;		///< Remϵͳţtag37
	EES_MarketOrderId m_MarketQuoteId;			///< г
	EES_Nanosecond    m_SLTimestamp;			///< ʱϢ
	EES_UserID        m_UserID;					///<  user id 
	EES_ClientToken   m_ClientQuoteToken;		///< ClientToken
	EES_OrderIOC	  m_IOC;					///< 0:ͨҪFAK / FOKʱҪIOCΪ1 GISΪ2
};

struct EES_ComboMarketAcceptField
{
	unsigned int      m_Sequence;			    ///< кţUDP-SequenceУʹãĬϲУ
	EES_Account       m_Account;				///< û
	EES_Combo_Symbol  m_ComboSymbol;			///< ϺԼ
	unsigned int      m_Qty;					///< 
	EES_HedgeFlag	  m_HedgeFlag;				///< Ͷ־
	EES_ClientToken	  m_ClientComboToken;		///< ԭӵtoken
	EES_Internal_Id   m_InternalComboId;		///< Remϵͳţtag37
	EES_Nanosecond    m_SLTimestamp;			///< ʱϢ
	EES_UserID        m_UserID;					///<  user id 
};


struct EES_OrderMarketReportField
{
	unsigned int      m_Sequence;		        ///< кţUDP-SequenceУʹãĬϲУ
	EES_Account       m_Account;				///< û
	EES_Symbol		  m_Symbol;					///< Լ
	EES_OrderPriceType	  m_OrderPriceType;		///< Ŀǰ֧֣1=޼; 3=޼ֹӯ; 4=޼ֹ;
	EES_SideType      m_Side;					///< 
	unsigned int      m_Qty;					///< 
	double            m_Price;					///< µ۸
	EES_HedgeFlag	  m_HedgeFlag;				///< Ͷ־
	double			  m_StopPrice;				///< ֹ
	unsigned int	  m_MinQty;					///< ûµʱֵָ
	unsigned char	  m_IsOffset;				///< ȨǷԳ壨1ǣ0
	EES_OrderState    m_OrderState;				///< ״̬(0 ӽ 1 Ӵ 2 ӹ 3Ӽ 4 ӳ 5 ֳɽ 6 ȫɽ)
	unsigned int	  m_ExecutedQuantity;		///< ӳɽ
	EES_UserID        m_UserID;					///<  user id 
	EES_ClientToken	  m_ClientOrderToken;		///< ԭӵtoken
	EES_Internal_Id   m_InternalOrderId;		///< Remϵͳţtag37
	EES_MarketOrderId m_MarketOrderId;			///< г
	EES_Nanosecond    m_SLTimestamp;			///< ʱϢ
	EES_Nanosecond    m_MktTimestamp;			///< ʱϢ
};


struct EES_QuoteMarketReportField
{
	unsigned int      m_Sequence;           ///< кţUDP-SequenceУʹãĬϲУ
	EES_Account       m_Account;			///< û
	EES_Symbol		  m_Symbol;				///< Լ
	unsigned int      m_BidQty;				///< 
	unsigned int      m_AskQty;				///< 
	double            m_BidPrice;			///< µ۸
	double            m_AskPrice;			///< µ۸
	EES_HedgeFlag	  m_BidHedgeFlag;		///< Ͷ־
	EES_HedgeFlag	  m_AskHedgeFlag;		///< Ͷ־
	unsigned char	  m_BidIsOffset;		///< ƽ01ƽ 2 ƽ 3ƽ
	unsigned char	  m_AskIsOffset;		///< ƽ01ƽ 2 ƽ 3ƽ
	unsigned int	  m_ExecutedQuantity;	///< ӳɽ
	EES_UserID        m_UserID;				///<  user id 
	EES_ClientToken	  m_ClientOrderToken;	///< ԭӵtoken
	EES_Internal_Id   m_InternalQuoteId;	///< Remϵͳţtag37
	EES_Internal_Id   m_BidInternalQuoteId; ///< Remϵͳţtag37
	EES_Internal_Id   m_AskInternalQuoteId; ///< Remϵͳţtag37
	EES_MarketOrderId m_MarketQuoteId;		///< г
	EES_MarketOrderId m_MarketBidQuoteId;   ///< г
	EES_MarketOrderId m_MarketAskQuoteId;	///< г
	EES_OrderState    m_QuoteState;			///< ״̬״̬(0 ӽ 1 Ӵ 2 ӹ 3Ӽ 4 ӳ 5 ֳɽ 6 ȫɽ)
	EES_Nanosecond    m_SLTimestamp;		///< ʱϢ
	EES_Nanosecond    m_MktTimestamp;		///< ʱϢ
	EES_OrderIOC	  m_IOC;				///< 0:ͨҪFAK / FOKʱҪIOCΪ1 GISΪ2
};

/// µ̨ϵͳܾ
struct EES_OrderRejectField
{
	unsigned int			m_Sequence;		    ///< кţUDP-SequenceУʹãĬϲУ
	EES_UserID				m_Userid;			///< ԭӵûӦLoginID
	EES_Nanosecond			m_SLTimestamp;		///< 1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_ClientToken			m_ClientOrderToken;	///< ԭӵtoken
	EES_RejectedMan			m_RejectedMan;		///< ˭ܾʢϵͳĽ 1=ʢ
	unsigned int			m_ErrorId;			///< ӱܾɡűӡ±
	EES_GrammerResultText	m_GrammerText;		///< ﷨Ľ
	EES_RiskResultText		m_RiskText;			///< ؼĽ			
};

struct EES_ComboRejectField
{
	unsigned int			m_Sequence;						///< кţUDP-SequenceУʹãĬϲУ
	EES_UserID				m_UserID;						///<  user id 
	EES_ClientToken			m_ClientComboToken;				///< µʱ򣬷ظtoken
	EES_Nanosecond			m_SLTimestamp;					///< 1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_RejectedMan			m_RejectedMan;					///< ˭ܾʢϵͳĽ 1=ʢ
	unsigned int			m_ErrorId;						///< ӱܾɡűӡ±
	EES_GrammerResultText	m_GrammerText;					///< ﷨Ľ
	EES_RiskResultText		m_RiskText;						///< ؼĽ		
};

struct EES_SpecialOrderRejectField
{
	unsigned int			m_Sequence;		    ///< кţUDP-SequenceУʹãĬϲУ
	EES_UserID				m_Userid;			///< ԭӵûӦLoginID
	EES_Nanosecond			m_SLTimestamp;		///< 1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_ClientToken			m_ClientOrderToken;	///< ԭӵtoken
	EES_RejectedMan			m_RejectedMan;		///< ˭ܾʢϵͳĽ 1=ʢ
	unsigned int			m_ErrorId;			///< ӱܾɡűӡ±
	EES_GrammerResultText	m_GrammerText;		///< ﷨Ľ
	EES_RiskResultText		m_RiskText;			///< ؼĽ			
};

struct EES_QuoteRejectField
{
	unsigned int			m_Sequence;			    ///< кţUDP-SequenceУʹãĬϲУ
	EES_UserID				m_UserId;				///< ԭӵûӦLoginID
	EES_Nanosecond			m_SLTimestamp;			///< 1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_ClientToken			m_QuoteToken;			///< ԭӵtoken
	EES_Internal_Id			m_InternalQuoteId;		///< Remϵͳţtag37
	EES_Internal_Id			m_BidInternalQuoteId;	///< REMϵͳ	
	EES_Internal_Id			m_AskInternalQuoteId;	///< REMϵͳ
	EES_RejectedMan			m_RejectedMan;			///< ˭ܾʢϵͳĽ 1=ʢ
	unsigned int			m_ErrorId;				///< ӱܾɡ
	EES_GrammerResultText	m_GrammerText;			///< ﷨Ľ
	EES_RiskResultText		m_RiskText;				///< ؼĽ		
};

/// µгܾ
struct EES_OrderMarketRejectField
{
	unsigned int	m_Sequence;			 ///< кţUDP-SequenceУʹãĬϲУ
	EES_Account     m_Account;           ///< û
	EES_Internal_Id m_InternalOrderId;	 ///< Remϵͳţtag37
	EES_Nanosecond  m_SLTimestamp;		 ///< ʱ 1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_ReasonText2  m_ReasonText;		 ///< صĴַGB2312
	EES_ExchangeID  m_ExchangeId;		 ///< Ľ
	int				m_ExchangeErrorId;	 ///< apiĴ
	EES_UserID      m_UserID;			 ///<  user id 
	EES_ClientToken m_ClientOrderToken;  ///< ClientToken
};


struct EES_ComboMarketRejectField
{
	unsigned int	m_Sequence;			 ///< кţUDP-SequenceУʹãĬϲУ
	EES_Account     m_Account;           ///< û
	EES_Internal_Id m_InternalComboId;	 ///< Remϵͳţtag37
	EES_Nanosecond  m_SLTimestamp;		 ///< ʱ 1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_ReasonText2 m_ReasonText;		 ///< صĴַGB2312
	EES_ExchangeID  m_ExchangeId;		 ///< Ľ
	int				m_ExchangeErrorId;	 ///< apiĴ
	EES_UserID      m_UserID;			 ///<  user id 
	EES_ClientToken m_ClientComboToken;  ///< ClientToken
};


struct EES_SpecialOrderMarketRejectField
{
	unsigned int	m_Sequence;			 ///< кţUDP-SequenceУʹãĬϲУ
	EES_Account     m_Account;           ///< û
	EES_Internal_Id m_InternalOrderId;	 ///< Remϵͳţtag37
	EES_Nanosecond  m_SLTimestamp;		 ///< remʱ 1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_ReasonText2  m_ReasonText;		 ///< صĴַGB2312
	EES_ExchangeID  m_ExchangeId;		 ///< Ľ
	int				m_ExchangeErrorId;	 ///< apiĴ
	EES_UserID      m_UserID;			 ///<  user id 
	EES_ClientToken m_ClientOrderToken;  ///< ClientToken
};


struct EES_QuoteMarketRejectField
{
	unsigned int	m_Sequence;			    ///< кţUDP-SequenceУʹãĬϲУ
	EES_Account     m_Account;				///< û
	EES_Internal_Id m_InternalQuoteId;		///< /<Remϵͳţtag37
	EES_Internal_Id m_BidInternalQuoteId;	///< /<Remϵͳţtag37
	EES_Internal_Id m_AskInternalQuoteId;	///< /<Remϵͳţtag37
	EES_Nanosecond  m_SLTimestamp;			///< ʱϢ, 1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_ReasonText2  m_ReasonText;			///< صĴַGB2312
	EES_ExchangeID  m_ExchangeId;			///< Ľ
	int				m_ExchangeErrorId;		///< apiĴ
	EES_UserID      m_UserID;				///<  user id 
	EES_ClientToken m_ClientOrderToken;		///< ClientToken
};

struct EES_OrderActionMarketRejectField
{
	unsigned int	m_Sequence;					    ///< кţUDP-SequenceУʹãĬϲУ
	EES_Internal_Id m_InternalOrderId;				///< Remϵͳţtag37
	EES_UserID      m_UserID;						///<  user id 
	EES_ClientToken m_ClientOrderToken;				///< ıصtag11
	unsigned char   m_ActionFlag;					///< 0=, 1=, 2=עںԴּ֧
	unsigned char   m_OrderIdType;                  ///< 0 ϵͳų  1 صųҪдصm_ClientOrderToken
	EES_UserID		m_OrigOrderUserId;				///< Ҫuser id
	EES_ClientToken	m_OrigOrderToken;				///< Ҫtag11		
	EES_Nanosecond  m_SLTimestamp;					///< ʱ 1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	int             m_ExchangeErrorId;				///< 
	EES_ReasonText  m_ReasonText;					///< صĴַGB2312
};


struct EES_SpecialOrderActionMarketRejectField
{
	unsigned int	m_Sequence;			 ///< кţUDP-SequenceУʹãĬϲУ
	EES_Internal_Id m_InternalOrderId;	 ///< /<Remϵͳţtag37
	EES_UserID      m_UserID;			 ///<  user id 
	EES_ClientToken m_ClientOrderToken;	 ///< صtag11
	unsigned char   m_OrderIdType;       ///< 0 ϵͳų  1 صųҪдصm_ClientOrderToken
	EES_UserID		m_OrigOrderUserId;	 ///<Ҫuser id
	EES_ClientToken	m_OrigOrderToken;	 ///<Ҫtag11	
	EES_Nanosecond  m_SLTimestamp;		 ///< 1970110ʱ00뿪ʼʱ
	int             m_ExchangeErrorId;   ///< 
	EES_ReasonText  m_ReasonText;		 ///< صĴַGB2312
};

struct EES_OrderActionMarketAcceptField
{
	unsigned int	m_Sequence;		    	///< кţUDP-SequenceУʹãĬϲУ
	EES_Internal_Id m_InternalOrderId;		///< Remϵͳţtag37
	EES_UserID      m_UserID;				///<  user id 
	EES_ClientToken   m_ClientOrderToken;	///< صtag11
	unsigned char   m_ActionFlag;			///< 0=, 1=, 2=עںԴּ֧
	unsigned char   m_OrderIdType;			///< 0 ϵͳų  1 صųҪдصm_ClientOrderToken
	EES_UserID		m_OrigOrderUserId;		///< Ҫuser id
	EES_ClientToken	m_OrigOrderToken;		///< Ҫtag11		 
	EES_Nanosecond    m_SLTimestamp;		///< ʱ
};

struct EES_SpecialOrderActionMarketAcceptField
{
	unsigned int	m_Sequence;			    ///< кţUDP-SequenceУʹãĬϲУ
	EES_Internal_Id m_InternalOrderId;		///< Remϵͳţtag37
	EES_UserID      m_UserID;				///<  user id 
	EES_ClientToken   m_ClientOrderToken;	///< صtag11
	unsigned char   m_OrderIdType;          ///< 0 ϵͳų  1 صųҪдصm_ClientOrderToken
	EES_UserID		m_OrigOrderUserId;		///< Ҫuser id
	EES_ClientToken	m_OrigOrderToken;		///< Ҫtag11		 
	EES_Nanosecond    m_SLTimestamp;		///< 1970110ʱ00뿪ʼʱ
};


struct EES_QuoteActionMarketRejectField
{
	unsigned int	m_Sequence;		    	///< кţUDP-SequenceУʹãĬϲУ
	EES_Internal_Id m_InternalQuoteId;		///< Remϵͳţtag37
	EES_UserID      m_UserID;				///< user id 
	EES_ClientToken   m_ClientQuoteToken;	///< صtag11
	unsigned char   m_ActionFlag;			///< 0=, 1=, 2=עںԴּ֧
	unsigned char   m_OrderIdType;			///< 0 ϵͳų  1 صųҪдصm_ClientOrderToken
	EES_UserID		m_OrigOrderUserId;		///< Ҫuser id
	EES_ClientToken	m_OrigOrderToken;		///< Ҫtag11		 
	EES_Nanosecond    m_SLTimestamp;		///< ʱ 1970110ʱ00뿪ʼʱ
	int             m_ExchangeErrorId;		///< ܾ
	EES_ReasonText  m_ReasonText;			///< صĴַGB2312
};

struct EES_QuoteActionMarketAcceptField
{
	unsigned int	m_Sequence;			    ///< кţUDP-SequenceУʹãĬϲУ
	EES_Internal_Id m_InternalQuoteId;		///< Remϵͳţtag37
	EES_UserID      m_UserID;				///< user id 
	EES_ClientToken   m_ClientQuoteToken;	///< صtag11
	unsigned char   m_ActionFlag;			///< 0=, 1=, 2=עںԴּ֧
	unsigned char   m_OrderIdType;			///< 0 ϵͳų  1 صųҪдصm_ClientQuoteToken
	EES_UserID		m_OrigQuoteUserId;		///< Ҫuser id
	EES_ClientToken	m_OrigQuoteToken;		///< Ҫtag11	
	EES_Nanosecond    m_SLTimestamp;		///< ʱ 1970110ʱ00뿪ʼʱ
};

/// ɽϢ
struct EES_OrderExecutionField
{
	unsigned int	  m_Sequence;		               	///< кţUDP-SequenceУʹãĬϲУ
	EES_UserID        m_Userid;							///< ԭӵûӦLoginID
	EES_Nanosecond    m_MktTimestamp;					///< ɽʱ䣬1970110ʱ00뿪ʼʱ
	EES_ClientToken   m_ClientOrderToken;				///< ԭӵtoken
	EES_Internal_Id	  m_InternalOrderId;				///< Remϵͳţtag37
	unsigned int      m_Quantity;						///< ӳɽ
	double            m_Price;							///< ӳɽ
	EES_MarketOrderId m_MarketOrderId;					///< г (Ӧ tag8037)
	EES_MarketExecId  m_MarketExecID;					///< ɽ
	EES_Nanosecond    m_SLTimestamp;					///< ʱ 1970110ʱ00뿪ʼʱ
	unsigned char	  m_OrderType;					    ///< OrderType 01234 
	EES_SideType	  m_SideType;						///< Buy/Sell Indicator 27  1 Int1  1 = 򵥣    2 = ƽ    3= 򵥣ƽ   4=    5= 򵥣ƽ   6= ƽ  21ƽƽƽģʽ 22ƽƽƽģʽ
	EES_Symbol		  m_Symbol;							///< Լ
	unsigned char     m_LegNo;						    ///< Ⱥţͱ۵1һ2ڶȣֵΪ0
};

/// µָ
struct EES_CancelOrder
{
	unsigned int	m_Sequence;							///< кţUDP-SequenceУʹãĬϲУ
	EES_Internal_Id	m_InternalOrderId;					///< Remϵͳţtag37
	unsigned int    m_Quantity;							///< ǸõӱȡϣʣµΪ0ĵΪȫȡйĿǰ0ֵ0
	EES_MarketSessionId m_MarketSessionId;				///< ϯλ룬OnResponseQueryMarketSessionIdȡϷֵ0ǷֵREMϵͳо͵ϯλ	m_ForceMarketSessionIdΪtrue	
	unsigned char	m_ForceMarketSessionId;				///< Ϊ1ͻָϯλ룬Ǹϯλû߷ǷʱָʾҪо͵ϯλǾܾµ
	unsigned char   m_ActionFlag;                       ///< 0=, 1=, 2=עںԴּ֧
	unsigned char   m_OrderIdType;                      ///< 0 ϵͳų  1 صųҪдصm_ClientOrderToken
	EES_ClientToken   m_ClientActionToken;				///< Ŀͻ˵,Уɲд
	EES_ClientToken  m_OrigOrderToken;					///< ԭص
	unsigned int    m_OrigOrderUserId;                  ///< Ϊָuser_Id ҲΪ0 0ѵ¼user_idԶ

	EES_CancelOrder()
	{
		memset(this, 0, sizeof(*this));
	}
};

struct EES_CancelSpecialOrder
{
	unsigned int		m_Sequence;							///< кţUDP-SequenceУʹãĬϲУ
	EES_Internal_Id		m_InternalOrderId;					///< /<Remϵͳţtag37
	unsigned int		m_Quantity;							///< ǸõӱȡϣʣµΪ0ĵΪȫȡйĿǰ0ֵ0
	EES_MarketSessionId m_MarketSessionId;					///< ϯλ룬OnResponseQueryMarketSessionIdȡϷֵ0ǷֵREMϵͳо͵ϯλ	m_ForceMarketSessionIdΪtrue	
	unsigned char		m_ForceMarketSessionId;				///< Ϊ1ͻָϯλ룬Ǹϯλû߷ǷʱָʾҪо͵ϯλǾܾµ
	unsigned char		m_OrderIdType;                      ///< 0 ϵͳų  1 صųҪдصm_ClientOrderToken
	EES_ClientToken		m_ClientActionToken;				///< Ŀͻ˵,Уɲд
	EES_ClientToken		m_OrigOrderToken;				    ///< ԭص
	unsigned int		m_OrigOrderUserId;                  ///< Ϊָuser_Id ҲΪ0 0ѵ¼user_idԶ

	EES_CancelSpecialOrder()
	{
		memset(this, 0, sizeof(*this));
	}
};

struct EES_QuoteAction
{
	unsigned int	m_Sequence;							///< кţUDP-SequenceУʹãĬϲУ
	EES_MarketSessionId m_MarketSessionId;				///< ϯλ룬OnResponseQueryMarketSessionIdȡϷֵ0ǷֵREMϵͳо͵ϯλ	m_ForceMarketSessionIdΪtrue	
	unsigned char	m_ForceMarketSessionId;				///< Ϊ1ͻָϯλ룬Ǹϯλû߷ǷʱָʾҪо͵ϯλǾܾµ
	unsigned char   m_ActionFlag;                       ///< 0=, 1=, 2=עںԴּ֧
	unsigned char   m_OrderIdType;                      ///< 0 ϵͳų  1 صųҪдصm_OrigQuoteToken
	unsigned int    m_ClientActionToken;				///< Ŀͻ˵,Уɲд
	unsigned int    m_OrigInternalQuoteId;				///< ҪRemϵͳ
	unsigned int    m_OrigQuoteToken;					///< ҪĿͻ˵
	unsigned int    m_OrigQuoteUserId;                  ///< Ϊָuser_Id ҲΪ0 0ѵ¼user_idԶ
	unsigned int    m_Quantity;							///< ǸõӱȡϣʣµΪ0ĵΪȫȡйĿǰ0ֵ0

	EES_QuoteAction()
	{
		memset(this, 0, sizeof(*this));
	}
};


/// 
struct EES_OrderActionAccept
{ 
	unsigned int	  m_Sequence;						///< кţUDP-SequenceУʹãĬϲУ
	EES_UserID        m_Userid;							///< ԭӵûӦLoginID
	EES_Nanosecond    m_SLTimestamp;					///< ʱ䣬1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_ClientToken   m_ClientOrderToken;				///< ԭӵtoken
	EES_UserID		  m_UserID;							///< Ҫ user idΪҲԭΪ0
	EES_Internal_Id	  m_InternalOrderId;				///< Remϵͳţtag37
	unsigned char	  m_ActionFlag;						///< 0=, 1=, 2=עںԴּ֧
};

struct EES_SpecialOrderActionAccept
{
	unsigned int	  m_Sequence;			            ///< кţUDP-SequenceУʹãĬϲУ
	EES_UserID        m_Userid;							///< ԭӵûӦLoginID
	EES_Nanosecond    m_SLTimestamp;					///< ʱ䣬1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_ClientToken   m_ClientOrderToken;				///< ԭӵtoken
	EES_UserID		  m_UserID;							///< Ҫ user idΪҲԭΪ0
	EES_Internal_Id	  m_InternalOrderId;				///< Remϵͳţtag37
};


struct EES_QuoteActionAccept
{
	unsigned int	m_Sequence;						    ///< кţUDP-SequenceУʹãĬϲУ
	unsigned int    m_Quantity;							///< ǸõӱȡϣʣµΪ0ĵΪȫȡйĿǰ0ֵ0
	EES_MarketSessionId m_MarketSessionId;				///< ϯλ룬OnResponseQueryMarketSessionIdȡϷֵ0ǷֵREMϵͳо͵ϯλ	m_ForceMarketSessionIdΪtrue	
	unsigned char	m_ForceMarketSessionId;				///< Ϊ1ͻָϯλ룬Ǹϯλû߷ǷʱָʾҪо͵ϯλǾܾµ
	unsigned char   m_ActionFlag;                       ///< 0=, 1=, 2=עںԴּ֧
	unsigned char   m_OrderIdType;                      ///< 0 ϵͳų  1 صųҪдصm_ClientOrderToken
	unsigned int    m_OrigInternalQuoteId;				///< ӵRemϵͳ
	unsigned int    m_OrigQuoteToken;					///< ӵĿͻ˵
	unsigned int    m_OrigQuoteUserId;                  ///< ûID
	EES_Nanosecond  m_SLTimestamp;						///< remʱ,1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
};

/// ܾϢ
struct EES_OrderActionRej
{
	unsigned int		m_Sequence;						///< кţUDP-SequenceУʹãĬϲУ
	EES_Internal_Id	    m_InternalOrderId;				///< Remϵͳţtag37
	unsigned int		m_ErrorID;					    ///< 룬ÿַӳһּԭ򣬼ļĩβĸ¼öλʾһԭ
	EES_ReasonText		m_ReasonText;					///< ַδʹ
	EES_UserID			m_UserID;						///< Ҫ user idΪҲԭΪ0
	EES_ClientToken		m_ClientOrderToken;				///< ҪClientTokenΪҲԭΪ0
	unsigned char		m_ActionFlag;                   ///< 0=, 1=, 2=עںԴּ֧
	EES_Nanosecond		m_SLTimestamp;					///< remʱ, 1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
};

struct EES_SpecialOrderActionRej
{
	unsigned int		m_Sequence;						///< кţUDP-SequenceУʹãĬϲУ
	EES_Internal_Id	    m_InternalOrderId;				///< Remϵͳţtag37
	unsigned int		m_ErrorID;					    ///< 룬ÿַӳһּԭ򣬼ļĩβĸ¼öλʾһԭ
	EES_ReasonText		m_ReasonText;					///< ַδʹ
	EES_UserID			m_UserID;						///< Ҫ user idΪҲԭΪ0
	EES_ClientToken		m_ClientOrderToken;				///< ҪClientTokenΪҲԭΪ0
	EES_Nanosecond		m_SLTimestamp;					///< remʱ, 1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
};

struct EES_QuoteActionRej
{
	unsigned int		m_Sequence;						///< кţUDP-SequenceУʹãĬϲУ
	EES_Internal_Id	    m_InternalQuoteId;				///< Remϵͳţtag37
	unsigned int		m_ReasonCode;					///< 룬ÿַӳһּԭ򣬼ļĩβĸ¼öλʾһԭ
	EES_ReasonText		m_ReasonText;					///< ַ
	EES_UserID			m_UserID;						///< Ҫ user idΪҲԭΪ0
	EES_ClientToken		m_ClientQuoteToken;				///< ҪClientTokenΪҲԭΪ0
	unsigned char		m_ActionFlag;                   ///< 0=, 1=, 2=עںԴּ֧
	EES_Nanosecond		m_SLTimestamp;					///< ʱ 1970110ʱ00뿪ʼʱ
};

/// 
struct EES_PostOrder
{
	unsigned int		m_Sequence;						///< кţUDP-SequenceУʹãĬϲУ
	EES_UserID			m_Userid;						///< ԭӵûӦLoginID
	EES_Nanosecond		m_SLTimestamp;					///< ʱ䣬1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_Internal_Id	    m_InternalOrderId;				///< Remϵͳţtag37
	EES_ClientToken		m_ClientOrderToken;				///< ãΪ
	EES_SideType		m_SideType;						///<   1 = 򵥣    2 = ƽ    3= 򵥣ƽ   4=    5= 򵥣ƽ   6= ƽ  21ƽƽƽģʽ 22ƽƽƽģʽ
	unsigned int		m_Quantity;						///< ƱΪڻΪ
	EES_Symbol			m_Symbol;						///< Ʊ룬ڻȨ룬й׼ (Ŀǰ6λͿ)
	double				m_Price;						///< ۸ 
	EES_Account			m_Account;						///< ˻
	EES_ExchangeID		m_ExchangeID;					///< 
	EES_ForceCloseReason m_ForceCloseReason;			///< ǿƽԭ  0=ǿƽ, 1=ʽ,2=ͻ,3=Ա,4=ֲַ,5=Υ棬6=
	EES_OrderState		m_OrderState;					///< ״̬
	EES_MarketOrderId	m_ExchangeOrderID;				///< ţ˹ֵΪհ
	EES_HedgeFlag		m_HedgeFlag;					///< Ͷ־
};


struct EES_PostSpecialOrder
{
	unsigned int		m_Sequence;						///< кţUDP-SequenceУʹãĬϲУ
	EES_UserID			m_Userid;						///< ԭӵûӦLoginID
	EES_Nanosecond		m_SLTimestamp;					///< ʱ䣬1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_Internal_Id	    m_InternalOrderId;				///< Remϵͳţtag37
	EES_ClientToken		m_ClientOrderToken;				///< ãΪ
	EES_SideType		m_SideType;						///< Buy/Sell Indicator 27  1 Int1  1 = 򵥣    2 = ƽ    3= 򵥣ƽ   4=    5= 򵥣ƽ   6= ƽ  21ƽƽƽģʽ 22ƽƽƽģʽ
	unsigned int		m_Quantity;						///< ƱΪڻΪ
	EES_Symbol			m_Symbol;						///< Ʊ룬ڻȨ룬й׼ (Ŀǰ6λͿ)
	EES_Account			m_Account;						///< ͻʺ.  ǴĿͻʺš֤󣬱ֵҲӵȱʡֵ
	EES_ExchangeID		m_ExchangeID;					///< 255=Done-away
	EES_ForceCloseReason m_ForceCloseReason;			///< ǿƽԭ  0=ǿƽ, 1=ʽ,2=ͻ,3=Ա,4=ֲַ,5=Υ棬6=
	EES_OrderState		m_OrderState;					///< ״̬
	EES_MarketOrderId	m_ExchangeOrderID;				///< ţ˹ֵΪհ
	EES_HedgeFlag		m_HedgeFlag;					///< Ͷ־
};

/// ˹
struct EES_InternalOrder
{
	unsigned int		m_Sequence;						///< кţUDP-SequenceУʹãĬϲУ
	EES_UserID			m_Userid;						///< ԭӵûӦLoginID
	EES_Nanosecond		m_SLTimestamp;					///< ʱ䣬1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_Internal_Id	    m_InternalOrderId;				///< Remϵͳţtag37
	EES_SideType		m_SideType;						///<   1 = 򵥣    2 = ƽ    3= 򵥣ƽ   4=    5= 򵥣ƽ   6= ƽ  21ƽƽƽģʽ 22ƽƽƽģʽ
	unsigned int		m_Quantity;						///< ƱΪڻΪ
	EES_Symbol			m_Symbol;						///< Ʊ룬ڻȨ룬й׼ (Ŀǰ6λͿ)
	double				m_Price;						///< ۸ 
	EES_Account			m_Account;						///< ˻
	EES_ExchangeID		m_ExchangeID;					///< 
	EES_MarketOrderId	m_MarketOrderID;				///< ţ˹ֵΪհ
	EES_HedgeFlag		m_HedgeFlag;					///< Ͷ־
};

/// ˹״̬ת
struct EES_InternalOrderAdjustStatus
{
	unsigned int		m_Sequence;						///< кţUDP-SequenceУʹãĬϲУ
	EES_UserID			m_Userid;						///< ԭӵûӦLoginID
	EES_Nanosecond		m_SLTimestamp;					///< ʱ䣬1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_Internal_Id	    m_InternalOrderId;				///< Remϵͳţtag37
	EES_MarketOrderId	m_MarketOrderID;				///< 
	EES_OrderState		m_OrderState;					///< 0ܣ1234
	unsigned char	    m_OrderType;					///< OrderType 01
	EES_SideType	    m_SideType;						///< Buy/Sell Indicator 27  1 Int1  1 = 򵥣    2 = ƽ    3= 򵥣ƽ   4=    5= 򵥣ƽ   6= ƽ  21ƽƽƽģʽ 22ƽƽƽģʽ
};

/// ˹ɽ
struct EES_InternalOrderExecution
{
	unsigned int		m_Sequence;						///< кţUDP-SequenceУʹãĬϲУ
	EES_UserID			m_Userid;						///< ԭӵûӦLoginID
	EES_Nanosecond		m_SLTimestamp;					///< ɽʱ䣬1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_Internal_Id	    m_InternalOrderId;				///< Remϵͳţtag37
	unsigned int		m_ExecutedQuantity;				///< ӳɽ
	double				m_ExecutionPrice;				///< ӳɽ
	EES_MarketToken		m_ExecutionNumber;				///< ӳɽ
	EES_MarketExecId	m_MarketExecID;					///< ɽ
	unsigned char	    m_OrderType;					///< OrderType 01
	EES_SideType	    m_SideType;						///< Buy/Sell Indicator 27  1 Int1  1 = 򵥣    2 = ƽ    3= 򵥣ƽ   4=    5= 򵥣ƽ   6= ƽ  21ƽƽƽģʽ 22ƽƽƽģʽ
};

/// ˹гܾ
struct EES_InternalOrderAdjustMktRej
{
	unsigned int	m_Sequence;			 ///< кţUDP-SequenceУʹãĬϲУ
	EES_UserID      m_Userid;			 ///<  user id 
	EES_Account     m_Account;           ///< û
	EES_Internal_Id m_InternalOrderId;	 ///< Remϵͳţtag37
	EES_ExchangeID  m_ExchangeId;		 ///< 
	int				m_ErrorId;			 ///< 
	EES_ClientToken m_ClientOrderToken;  ///< ClientToken
	EES_Nanosecond  m_SLTimestamp;		 ///< ʱ 1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
};

/// ˹״̬
struct EES_InternalQuoteAdjustStatus
{
	unsigned int      m_Sequence;           ///< кţUDP-SequenceУʹãĬϲУ
	EES_UserID		  m_Userid;				///< û
	EES_Account       m_Account;           ///< û
	EES_Internal_Id   m_InternalQuoteId;	///< Remϵͳţtag37
	EES_Internal_Id   m_BidInternalQuoteId; ///< Remϵͳţtag37
	EES_Internal_Id   m_AskInternalQuoteId; ///< Remϵͳţtag37
	EES_MarketOrderId m_MarketQuoteId;		///< г
	EES_MarketOrderId m_MarketBidQuoteId;   ///< г
	EES_MarketOrderId m_MarketAskQuoteId;	///< г
	EES_OrderState    m_QuoteState;			///< Ŀǰֻ0 ӽ
	EES_Nanosecond    m_SLTimestamp;		///< ʱϢ
};

/// ˹ܾ
struct EES_InternalQuoteAdjustMktRej
{
	unsigned int			m_Sequence;			    ///< кţUDP-SequenceУʹãĬϲУ
	EES_UserID				m_Userid;				///< û
	EES_Account             m_Account;              ///< û
	EES_ClientToken			m_QuoteToken;			///< ԭӵtoken
	EES_Internal_Id			m_InternalQuoteId;		///< Remϵͳţtag37
	EES_Internal_Id			m_BidInternalQuoteId;	///< REMϵͳ	
	EES_Internal_Id			m_AskInternalQuoteId;	///< REMϵͳ
	unsigned int			m_ErrorId;				///< ӱܾɡ
	EES_Nanosecond			m_SLTimestamp;			///< 1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ

};


struct EES_PostQuote
{
	unsigned int		m_Sequence;						///< кţUDP-SequenceУʹãĬϲУ
	EES_UserID			m_Userid;						///< ԭӵûӦLoginID
	EES_Nanosecond		m_MktTimestamp;					///< ʱ䣬1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_Internal_Id	    m_InternalQuoteId;				///< Remϵͳţtag37
	EES_Internal_Id	    m_BidInternalQuoteId;			///< Remϵͳţtag37
	EES_Internal_Id	    m_AskInternalQuoteId;			///< Remϵͳţtag37
	unsigned int		m_BidQuantity;					///< ƱΪڻΪ
	unsigned int		m_AskQuantity;					///< ƱΪڻΪ
	EES_Symbol			m_Symbol;						///< Ʊ룬ڻȨ룬й׼ (Ŀǰ6λͿ)
	double				m_Bidprice;						///< ۸ 
	double				m_Askprice;						///< ۸ 
	EES_Account			m_Account;						///< ͻʺ.  ǴĿͻʺš֤󣬱ֵҲӵȱʡֵ
	EES_ExchangeID		m_ExchangeID;					///< 
	EES_ForceCloseReason m_ForceCloseReason;			///< ǿƽԭ  0=ǿƽ, 1=ʽ,2=ͻ,3=Ա,4=ֲַ,5=Υ棬6=
	EES_OrderState		m_QuoteState;					///< ״̬
	EES_MarketOrderId	m_MarketQuoteId;				///< г
	EES_MarketOrderId	m_MarketBidQuoteId;				///< г
	EES_MarketOrderId	m_MarketAskQuoteId;				///< г
	unsigned char		m_BidIsOffset;					///< ƽ01ƽ 2 ƽ 3ƽ
	unsigned char		m_AskIsOffset;					///< ƽ01ƽ 2 ƽ 3ƽ
	EES_HedgeFlag		m_BidHedgeFlag;					///< Ͷ־
	EES_HedgeFlag		m_AskHedgeFlag;					///< Ͷ־
	EES_Nanosecond		m_SLTimestamp;					///< remʱ䣬1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ䡣
};

/// ɽ
struct EES_PostOrderExecution
{
	unsigned int		m_Sequence;						///< кţUDP-SequenceУʹãĬϲУ
	EES_UserID			m_Userid;						///< ԭӵûӦLoginID
	EES_Nanosecond		m_MktTimestamp;					///< ɽʱ䣬1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_Internal_Id	    m_InternalOrderId;				///< Remϵͳţtag37
	unsigned int		m_ExecutedQuantity;				///< ӳɽ
	double				m_ExecutionPrice;				///< ӳɽ
	EES_MarketToken		m_ExecutionNumber;				///< ӳɽ
	EES_MarketExecId	m_MarketExecID;					///< ɽ
	EES_Nanosecond		m_SLTimestamp;
	unsigned char	    m_OrderType;					///< OrderType 01234 
	EES_SideType	    m_SideType;						///< Buy/Sell Indicator 27  1 Int1  1 = 򵥣    2 = ƽ    3= 򵥣ƽ   4=    5= 򵥣ƽ   6= ƽ  21ƽƽƽģʽ 22ƽƽƽģʽ
	EES_Symbol		    m_Symbol;						///< Լ
	unsigned char		m_LegNo;						///< Ⱥţͱ۵1һ2ڶȣֵΪ0
};

struct EES_ExchangeMarketSession
{	
	EES_ExchangeID			m_ExchangeID;					///<  102=н    103=    104=    105=֣	
	unsigned char			m_SessionCount;					///< ýҲΪm_SessionIdǰλЧ255
	EES_MarketSessionId		m_SessionId[255];				///< ϷĽӴ
};

struct EES_SymbolStatus
{	
	EES_ExchangeID	m_ExchangeID;		///< 102=н    103=    104=    105=֣	
	EES_Symbol		m_Symbol;			///< Լ
	unsigned char	m_InstrumentStatus;	///< ״̬ '0':ǰ; '1':ǽ; '2':; '3':Ͼ۱; '4'Ͼۼ۸ƽ; '5':Ͼ۴; '6': ;
	unsigned int	m_TradingSegmentSN;	///< ׽׶α
	char			m_EnterTime[9];		///< 뱾״̬ʱ
	unsigned char	m_EnterReason;		///< 뱾״̬ԭ: '1': Զл; '2': ֶл; '3': ۶; '4': ۶ֶ;
};

struct EES_SessionID
{
	char				m_TradeNo[17];	///ϯλ
	unsigned int		m_Result;		///0:ɹ1:û󶨵˻ûͣȨޣ2:ǰϵͳ󶨲ڸýϯλĽϯλӦ
	int			        m_SessionID;	///ϯλ
};

struct EES_TradeSvrInfo
{
	char            m_RemoteTradeIp[16];	 /// IP
	unsigned short  m_RemoteTradeTCPPort;	 /// TCP˿
	unsigned short  m_RemoteTradeUDPPort;	 /// UDP˿

	char            m_LocalTradeIp[16];		 /// ؽIP
	unsigned short  m_LocalTradeUDPPort;	 /// ؽUDP˿
	bool			m_TimestampSwitch;		 /// ǷӲʱԹ
	bool			m_BlockRecvSwitch;	     /// Ƿ
	bool            m_EfviEnterSwitch;       /// ǷefviʽĬ10ͨģʽ
	bool            m_TcpdirectSwitch;	     /// tcpdirectأĬfalseر(ΪtrueʱʹSloarflareTCPDirectշTCP)
	bool            m_HandleSignalSwitch;    /// ǷҪCtrl+Cź 
	unsigned int    m_HeartBeatInterval;     /// (Ĭ5),0
	short			m_RspCpuId;			     /// а -1


	EES_TradeSvrInfo()
	{
		memset((void*)this, 0, sizeof(EES_TradeSvrInfo));
		m_EfviEnterSwitch = true;
		m_HandleSignalSwitch = true;
		m_TcpdirectSwitch = false;
		m_RspCpuId = -1;
		m_HeartBeatInterval = 5;
		
	}
};
#pragma pack(pop)

#endif
