/*! \file EesQueryApi.h
 *  \brief EES׿ͻͷļ   
 *  
 *  ĵϸEES׿ͻ˵Ľӿڶ塣
*/
#pragma  once 
#include "EesQueryDefine.h"
#include "EesQueryErr.h"
#include <time.h>

#ifdef WIN32
	#ifdef SL_EES_QUERY_EXPORTS
		#define SL_EES_QUERY_CLASS __declspec(dllexport)	  
		#define SL_EES_QUERY_FUN		extern "C" __declspec(dllexport)
	#else
		#define SL_EES_QUERY_CLASS __declspec(dllimport)	  
		#define SL_EES_QUERY_FUN		extern "C" __declspec(dllimport)
	#endif

	/// \brief EES׿ͻ˶̬
	#define EES_QUERY_DLL_NAME    "EESQueryApi.dll"
	/// \brief EES׿ͻ˾̬
	#define EES_QUERY_LIB_NAME    "EESQueryApi.lib"

	#include <windows.h>

#else	
	#define SL_EES_QUERY_CLASS 
	#define SL_EES_QUERY_FUN  extern "C" 

	#ifndef OUT
		#define OUT
	#endif

	#ifndef NULL
		#define NULL 0
	#endif

	/// \brief EES׿ͻ˶̬
	#define EES_QUERY_DLL_NAME    "libEESQueryApi.so"

#endif

/// \brief EES׿ͻ˻ص
class  EESQueryEvent
{
public:	
	virtual ~EESQueryEvent()
	{

	}
	/// ϢĻص
	
		///	\brief	¼
		///	\param  errNo                   ӳɹϢ
		///	\param  pErrStr                 Ϣ
		///	\return void  
	
	virtual void OnQueryConnection(ERR_NO errNo, const char* pErrStr ){}

	/// ӶϿϢĻص
	
		/// \brief	ϿյϢ
		/// \param  ERR_NO errNo         ӳɹϢ
		/// \param  const char* pErrStr  Ϣ
		/// \return void  
	
	virtual void OnQueryDisConnection(ERR_NO errNo, const char* pErrStr ){}

	/// ¼ϢĻص
	
		/// \param  pLogon                  ¼ɹʧܵĽṹ
		/// \return void 
	
	virtual void OnQueryUserLogon(EES_QueryLogonResponse* pLogon){}

	/// ޸Ӧص

	/// \param  nResult                  Ӧĳɹ񷵻
	/// \return void 

	virtual void OnQueryRspChangePassword(EES_ChangePasswordResult nResult){}

	/// ѯûʻķ¼
	
		/// \param  pAccountInfo	        ʻϢ
		/// \param  bFinish	                ûдɣֵ false ˣǸֵΪ true 
		/// \remark  bFinish == trueôǴ pAccountInfoֵЧ
		/// \return void 
	
	virtual void OnQueryUserAccount(EES_AccountInfo * pAccoutnInfo, bool bFinish){}

	/// ѯʻڻλϢķ¼	
		/// \param  pAccount	                ʻID 	
		/// \param  pAccoutnPosition	        ʻĲλϢ					   
		/// \param  bFinish	                    ûдɣֵfalseˣǸֵΪ true 
		/// \remark  bFinish == trueôǴ pAccountInfoֵЧ
		/// \return void 	
	virtual void OnQueryAccountPosition(const char* pAccount, EES_AccountPosition* pAccoutnPosition, bool bFinish){}	

	/// ѯʻȨλϢķ¼, עص, һOnQueryAccountPosition, һQueryAccountPosition, ֱ𷵻, ȷڻ, ٷȨ, ʹûȨλ, Ҳ᷵һbFinish=trueļ¼
	/// \param  pAccount	                ʻID 	
	/// \param  pAccoutnPosition	        ʻĲλϢ					   
	/// \param  bFinish	                    ûдɣֵfalseˣǸֵΪ true 
	/// \remark  bFinish == trueôǴ pAccountInfoֵЧ
	/// \return void 	
	virtual void OnQueryAccountOptionPosition(const char* pAccount, EES_AccountOptionPosition* pAccoutnOptionPosition, bool bFinish) {}


	/// ѯʻʽϢķ¼
	
		/// \param  pAccount	                ʻID 	
		/// \param  pAccoutnBP	                ʻʽϢ					   
		/// \return void 
	
	virtual void OnQueryAccountBP(const char* pAccount, EES_AccountBP* pAccoutnBP){}	


	/// ʽϢ¼

	/// \param  pAccount	                ʻID 	
	/// \param  pAccoutnBP	                ʻʽϢ					   
	/// \return void 
	virtual void OnAccountBPReport(const char* pAccount, EES_AccountBP* pAccoutnBP) {}

	/// ϸ

	/// \param  pAccount	                ʻID 	
	/// \param  pAccoutCashInout	        ʻĳϢ					   
	/// \return void 
	virtual void OnAccountCashInoutNotify(const char* pAccount, EES_AccountCashInout* pAccoutCashInout) {}


	/// ѯԼбķ¼
	
		/// \param  pSymbol	                    ԼϢ   
		/// \param  bFinish	                    ûдɣֵ falseˣǸֵΪ true   
		/// \remark  bFinish == trueôǴ pSymbol ֵЧ
		/// \return void 
	
	virtual void OnQuerySymbol(EES_SymbolField* pSymbol, bool bFinish){}

	/// ѯʻױ֤ķ¼
	
	    /// \param  pAccount                    ʻID 
		/// \param  pSymbolMargin               ʻı֤Ϣ 
		/// \param  bFinish	                    ûдɣֵ falseɣǸֵΪ true 
		/// \remark  bFinish == trueôǴ pSymbolMargin ֵЧ
		/// \return void 
	
	virtual void OnQueryAccountTradeMargin(const char* pAccount, EES_AccountMargin* pSymbolMargin, bool bFinish ){}

	/// ѯʻ׷õķ¼
	
		/// \param  pAccount                    ʻID 
		/// \param  pSymbolFee	                ʻķϢ	 
		/// \param  bFinish	                    ûдɣֵ falseˣǸֵΪ true    
		/// \remark  bFinish == true ôǴ pSymbolFee ֵЧ
		/// \return void 
	
	virtual void OnQueryAccountTradeFee(const char* pAccount, EES_AccountFee* pSymbolFee, bool bFinish ){}

	///	ѯķ¼
	
		/// \brief	ѯϢʱĻصҲܰǵǰûµĶ
		/// \param  pAccount                 ʻID 
		/// \param  pQueryOrder	             ѯĽṹ
		/// \param  bFinish	                 ûдɣֵ falseˣǸֵΪ true    
		/// \remark  bFinish == trueôǴ pQueryOrderֵЧ
		/// \return void 
	
	virtual void OnQueryTradeOrder(const char* pAccount, EES_QueryAccountOrder* pQueryOrder, bool bFinish  ){} 


	///	ѯķ¼

	/// \brief	ѯϢʱĻصҲܰǵǰûµĶ
	/// \param  pAccount                 ʻID 
	/// \param  pQueryArbiOrder	             ѯĽṹ
	/// \param  bFinish	                 ûдɣֵ falseˣǸֵΪ true    
	/// \remark  bFinish == trueôǴ pQueryOrderֵЧ
	/// \return void 

	virtual void OnQueryTradeArbiOrder(const char* pAccount, EES_QueryAccountArbiOrder* pQueryOrder, bool bFinish) {}


	///	Ϲѯ¼

	/// \brief	ѯϹʱĻص
	/// \param  pQueryCombo              Ϲṹ 
	/// \param  bFinish	                 ûдɣֵ falseˣǸֵΪ true    
	/// \remark  bFinish == trueôǴ pQueryComboֵЧ
	/// \return void 

	virtual void OnQueryComboRule(EES_AccountComboRule* pQueryCombo, bool bFinish) {}


	///	ϳֲֲѯ¼

	/// \brief	ѯϳֲʱĻص
	/// \param  pAccount                 ʻID 
	/// \param  pQueryCombo	             ϳֲֵĽṹ
	/// \param  bFinish	                 ûдɣֵ falseˣǸֵΪ true    
	/// \remark  bFinish == trueôǴ pQueryOrderֵЧ
	/// \return void 

	virtual void OnQueryComboPosition(const char* pAccount, EES_AccountComboPosition* pQueryCombo, bool bFinish) {}

	///	ѯ۵ķ¼

	/// \brief	ѯϢʱĻصҲܰǵǰûµı
	/// \param  pAccount                 ʻID 
	/// \param  pQueryQuote	             ѯ۵Ľṹ
	/// \param  bFinish	                 ûдɣֵ falseˣǸֵΪ true    
	/// \remark  bFinish == trueôǴ pQueryOrderֵЧ
	/// \return void 

	virtual void OnQueryTradeQuote(const char* pAccount, EES_QueryAccountQuote* pQueryQuote, bool bFinish) {}

	///	ѯķ¼
	
		/// \brief	ѯϢʱĻصҲܰǵǰûµĶɽ
		/// \param  pAccount                        ʻID 
		/// \param  pQueryOrderExec	                ѯɽĽṹ
		/// \param  bFinish	                        ûдɣֵfalseˣǸֵΪ true    
		/// \remark  bFinish == trueôǴpQueryOrderExecֵЧ
		/// \return void 
	
	virtual void OnQueryTradeOrderExec(const char* pAccount, EES_QueryOrderExecution* pQueryOrderExec, bool bFinish  ){}


};

/// \brief EES׿ͻ˴
class SL_EES_QUERY_CLASS EESQueryApi
{
public:
	virtual ~EESQueryApi()
	{
	}
	///ȡAPI汾
	///	\return const char*  Apiİ汾ţһַ4.2.4.71
	virtual const char* GetQueryApiVersion() = 0;

	///ǷԶConnServer֮ǰʹ
	/// \return ûзֵ
	virtual void SetQueryAutoReconnect(bool autoConnect) = 0;

	/// òѯӵȴ¼ʱ
	/// \param  int query_wait_time		    ѯӵȴ¼ʱ
	/// \return ûзֵ
	virtual void SetQueryMaxWaitTime(int query_wait_time) = 0;

	/// ӷ
	/// ṩ2ֽӿڣʽݼ°ĽӿڣһֽӿڼʹTCPģʽ
	virtual RESULT	ConnQueryServer(const char* svrAddr, int nPort, EESQueryEvent* pEvent) = 0;

	virtual RESULT	ConnQueryServer(const EES_QuerySvrInfo& param, EESQueryEvent* pEvent)  = 0 ;
	
	/// Ͽ
	
		/// \return RESULT						ο EesQueryErr.hļ
	
	virtual RESULT	DisConnQueryServer()  = 0 ;

	/// û¼
	
		/// \brief	Ĳʻû
		/// \param  const char* logon_id		¼û
		/// \param  const char* userPwd		    û¼
		/// \param  const char* app_id		    AppId
		/// \param  const char* auth_code		Ȩ
		/// \return RESULT			ֵο EesQueryErr.hļ
	
	virtual RESULT QueryUserLogon(const char* logon_id, const char* user_pwd) = 0 ;

	/// û޸ 

	/// \brief	¼ɹʹ
	/// \param  const char* oldPwd			
	/// \param  const char* newPwd		    
	/// \return RESULT			ֵο EesQueryErr.hļ

	virtual RESULT QueryChangePassword(const char* oldPwd, const char* newPwd )  = 0 ;

	/// ѯԼб
	
		/// \brief	ֻ᷵صЧĺԼ secType 0 ȫ  2Ȩ 3ڻ 4
		/// \return RESULT			ֵο EesQueryErr.hļ
	
	virtual RESULT QuerySymbolList(char secType = 0)  = 0 ;


	/// ѯûʻ
	
		/// \return RESULT			ֵο EesQueryErr.hļ
	
	virtual RESULT QueryUserAccount()  = 0 ;

	/// ѯʻλ
	
		/// \brief	
		/// \param  const char* accountId		ʻID  secType 0 ȫ  2Ȩ 3ڻ
		/// \return RESULT			ֵοEesQueryErr.hļ
	
	virtual RESULT QueryAccountPosition(const char* accountId, char secType = 0)  = 0 ;

	/// ѯʻBP
	
		/// \brief	
		/// \param  const char* accountId		ʻID
		/// \return RESULT			ֵοEesQueryErr.hļ
	
	virtual RESULT QueryAccountBP(const char* accountId)  = 0 ;


	/// ѯнϹ
	/// \brief	
	/// \param  comboType Ϲ  0 ȫ  1 ţп 2 п 3 п 4 ţп 5 ۲
	/// \param  hedgeFlag Ͷױ־  0 ȫ  1  2 Ͷ 3 ױ
	/// \return RESULT			ֵοEesQueryErr.hļ
	virtual RESULT QueryComboRule(unsigned char comboType,unsigned char hedgeFlag) = 0;


	/// ѯнϳֲ
	/// \brief	
	/// \param  const char* accountId		ʻID
	/// \return RESULT			ֵοEesQueryErr.hļ
	virtual RESULT QueryComboPosition(const char* accountId) = 0;


	/// ѯʻ֤
	
		/// \param  const char* accountId		ʻID
		/// \return RESULT			ֵοEesQueryErr.hļ
	
	virtual RESULT QueryAccountTradeMargin(const char* accountId )  = 0 ;

	/// ѯʻ
	
		/// \brief	ڣÿһʻķʲһÿһʻѯһ¡
		/// \param  const char* accountId		ʻID
		/// \return RESULT			ֵοEesQueryErr.hļ
	
	virtual RESULT QueryAccountTradeFee(const char* accountId ) = 0  ;


	/// ѯʻϢ 
	
		/// \param  const char* accountId		     ʻID secType 0 ȫ  2Ȩ 3ڻ
		/// \return RESULT			ֵοEesQueryErr.hļ
	
	virtual RESULT	QueryAccountOrder(const char* accountId, char secType = 0)  = 0 ;

	///ѯ˻Ϣ ʻID secType 0 ȫ 1ڻ 2Ȩ
	virtual RESULT QueryAccountQuote(const char* accountId, char secType = 0) = 0 ;


	///ѯ˻Ϣ
	/// \param  const char* accountId		     ʻID
	/// \return RESULT			ֵοEesQueryErr.hļ
	virtual RESULT QueryAccountArbiOrder(const char* accountId) = 0;

	/// ѯʻɽϢ
	
		/// \param  const char* accountId		     ʻID char secType 0 ȫ 2Ȩ 3ڻ  
		/// \return RESULT			ֵοEesQueryErr.hļ
	
	virtual RESULT	QueryAccountOrderExecution(const char* accountId, char secType = 0) = 0 ;


	/// ʱתڽAPIеEES_NanosecondͣתCԱ׼struct tmṹ壬Լʱһڵ

	/// \param  EES_Nanosecond timeStamp		APIṹеʱֵ
	/// \param  tm& tmResult					ڽսstruct tmṹ
	/// \param  unsigned int& nanoSsec 			ڽս
	/// \return ûзֵ
	virtual void QueryConvertFromTimestamp(EES_Nanosecond timeStamp, tm& tmResult, unsigned int& nanoSsec) = 0;


	/// ־أĬΪء

	/// \param  bool bOn		true: 򿪱־; false: رձ־
	/// \return ûзֵ
	virtual void SetQueryLoggerSwitch(bool bOn) = 0;


	/// ־Ϣдļ
	/// \return ûзֵ
	virtual void QueryLoggerFlush() = 0;

	/// ѯʻ

	/// \brief	
	/// \param  const char* accountId		ʻID
	/// \return RESULT			ֵοEesQueryErr.hļ

	virtual RESULT QueryAccountCashInOut(const char* accountId) = 0;

};

/// EES׿ͻʵĺ
#define CREATE_EES_QUERY_API_NAME ("CreateEESQueryApi")

/// EES׿ͻʵĺ
#define DESTROY_EES_QUERY_API_NAME ("DestroyEESQueryApi")

/// EES׿ͻʵ
SL_EES_QUERY_FUN EESQueryApi* CreateEESQueryApi(void) ; 

/// EES׿ͻʵ
SL_EES_QUERY_FUN void DestroyEESQueryApi(EESQueryApi* pEESQueryApi) ; 

/// EES׿ͻʵָ
typedef EESQueryApi* (*funcCreateEESQueryApi)(void) ;

/// EES׿ͻʵָ
typedef void (*funcDestroyEESQueryApi)(EESQueryApi* pEESQueryApi) ;

