/*! 
* \file  EESQuoteApi.h
* \brief EESͻͷļ
*  
* ļʹEESͻͺͺ
*  
* \author  SHENGLI
* \version 1.0
* \date    2014-04-18
*/  

#pragma once
#include "EESQuoteDefine.h"
#include <vector>
using std::vector;

#ifdef WIN32
    #ifdef SL_EES_QUOTE_EXPORTS
        #define SL_EES_QUOTE_CLASS   __declspec(dllexport)
        #define SL_EES_QUOTE_FUN     extern "C" __declspec(dllexport)
    #else
        #define SL_EES_QUOTE_CLASS   __declspec(dllimport)
        #define SL_EES_QUOTE_FUN     extern "C" __declspec(dllimport)
    #endif
    
     /// \brief EESͻ˶̬
    #define EES_QUOTE_DLL_NAME    "EESQuoteApi.dll"
    /// \brief EESͻ˾̬
    #define EES_QUOTE_LIB_NAME    "EESQuoteApi.lib"
    
#else // SHENGLI_LINUX
    #define SL_EES_QUOTE_CLASS 
    #define SL_EES_QUOTE_FUN extern "C"
    
    /// \brief EESͻ˶̬
    #define EES_QUOTE_DLL_NAME    "libEESQuoteApi.so"
#endif

/// \brief EES QuoteҪעĻص 
class EESQuoteEvent
{
public:
    virtual ~EESQuoteEvent() {}

	/// \brief ӳɹ¼ǰ, 鲥ģʽᷢ, ֻжInitMulticastֵ
    virtual void OnEqsConnected() {}

	/// \brief ӳɹϿʱã鲥ģʽᷢ¼
    virtual void OnEqsDisconnected() {}

	/// \brief ¼ɹʧʱã鲥ģʽᷢ
	/// \param bSuccess ½Ƿɹ־  
	/// \param pReason  ½ʧԭ  
    virtual void OnLoginResponse(bool bSuccess, const char* pReason) {}

	/// \brief յʱ,ʽinstrument_typeͬͬ
	/// \param chInstrumentType  EES
	/// \param pDepthQuoteData   EESͳһָ  
    virtual void OnQuoteUpdated(EesEqsIntrumentType chInstrumentType, EESMarketDepthQuoteData* pDepthQuoteData) {}

	/// \brief ־ӿڣʹ߰д־
	/// \param nlevel    ־
	/// \param pLogText  ־
	/// \param nLogLen   ־
    virtual void OnWriteTextLog(EesEqsLogLevel nlevel, const char* pLogText, int nLogLen) {}

	/// \brief עsymbolӦϢʱã鲥ģʽ֧ע
	/// \param chInstrumentType  EES
	/// \param pSymbol           Լ
	/// \param bSuccess          עǷɹ־
    virtual void OnSymbolRegisterResponse(EesEqsIntrumentType chInstrumentType, const char* pSymbol, bool bSuccess)  {}

	/// \brief  עsymbolӦϢʱã鲥ģʽ֧ע
	/// \param chInstrumentType  EES
	/// \param pSymbol           Լ
	/// \param bSuccess          עǷɹ־
    virtual void OnSymbolUnregisterResponse(EesEqsIntrumentType chInstrumentType, const char* pSymbol, bool bSuccess)  {}
	
	/// \brief ѯsymbolбӦϢʱã鲥ģʽֺ֧Լбѯ
	/// \param chInstrumentType  EES
	/// \param pSymbol           Լ
	/// \param bLast             һѯԼбϢıʶ
	/// \remark ѯԼбӦ, bLast = trueʱʾԼѾ,Чݡ
    virtual void OnSymbolListResponse(EesEqsIntrumentType chInstrumentType, const char* pSymbol, bool bLast)  {}

};

/// \brief EES QuoteĴ
class SL_EES_QUOTE_CLASS EESQuoteApi
{
public:
    virtual ~EESQuoteApi() {}

	/// \brief  EESͻ, ԺInitMulticastͬʱʹ
	/// \param  vecEti             һEES    
	/// \param  pQuoteEventHandler ¼֪ͨĻص
	/// \return true: EESɹ false:EESʧ
    virtual bool ConnServer(vector<EqsTcpInfo>& vecEti, EESQuoteEvent* pQuoteEventHandler) = 0;

	/// \brief  EESͻ, ԺInitMulticastһConnServerͬʱʹ
	/// \param  svrInfo             EES    
	/// \param  pQuoteEventHandler ¼֪ͨĻص
	/// \return true: EESɹ false:EESʧ
	virtual bool ConnServer(EqsTcpInfo& svrInfo, EESQuoteEvent* pQuoteEventHandler) = 0;

	/// \brief  EESͻ˼鲥ַ, ԺConneServerͬʱʹ
	/// \param  vecEti             һEES    
	/// \param  pQuoteEventHandler ¼֪ͨĻص
	/// \return true: EESɹ false:EESʧ
	virtual bool InitMulticast(vector<EqsMulticastInfo>& vecEmi, EESQuoteEvent* pQuoteEventHandler) = 0; 

	/// \brief  EESͻ˵½, ʹ鲥ģʽҪ
	/// \param  loginParam   ½ʱõû   
	/// \remark ˺޷, ½ɹڵ½ӦĻص֪ͨ
    virtual void LoginToEqs(EqsLoginParam& loginParam) = 0;

	/// \brief  EESԼб, 鲥ģʽ֧
    virtual void QuerySymbolList() = 0;

	/// \brief  EESͻעԼ, 鲥ģʽ֧
	/// \param  chInstrumentType  EES  
	/// \param  pSymbol           Լ
	/// \remark ˺޷, עɹעӦĻص֪ͨ
    virtual void RegisterSymbol(EesEqsIntrumentType chInstrumentType, const char* pSymbol) = 0;

	/// \brief  EESͻעԼ, 鲥ģʽ֧
	/// \param  chInstrumentType  EES  
	/// \param  pSymbol           Լ
	/// \return ˺޷, עɹעӦĻص֪ͨ
    virtual void UnregisterSymbol(EesEqsIntrumentType chInstrumentType, const char* pSymbol) = 0;

	/// \brief رEESͻ
	/// \remark ִд˺δʵڲϢ,Ҫʹ,Ҫʵٺ,´ʵ
    virtual void DisConnServer() = 0;
};


/// \brief EESͻʵĺ
#define CREATE_EES_QUOTE_API_NAME   ("CreateEESQuoteApi")

/// \brief EESͻʵĺ
#define DESTROY_EES_QUOTE_API_NAME  ("DestroyEESQuoteApi")

/// \brief EESͻʵĺ
SL_EES_QUOTE_FUN EESQuoteApi* CreateEESQuoteApi(void);

/// \brief EESͻʵĺ
SL_EES_QUOTE_FUN void DestroyEESQuoteApi(EESQuoteApi* pEESQuoteApi);

/// \brief EESͻʵĺָ
typedef EESQuoteApi* (*funcCreateEESQuoteApi)(void);

/// \brief EESͻʵĺָ
typedef void (*funcDestroyEESQuoteApi)(EESQuoteApi* pEESQuoteApi);


