/*!****************************************************************************
 @note   Copyright (coffee), 2005-2014, Shengli Tech. Co., Ltd.
 @file   EESTraderDemo.h
 @date   2014/4/27   12:46
 @author zhou.hu
 
 \brief  ʾEESAPIʹʾ

 @note 
******************************************************************************/
#pragma once
#ifdef WIN32
/// add by zhou.hu review 2014/4/22 Windwosƽ̨õͷļ
#include <Windows.h>

typedef HMODULE		T_DLL_HANDLE;

#else
/// add by zhou.hu review 2014/4/22 linuxƽ̨õͷļ
#include <stdlib.h>
#include <stdio.h>
#include <dlfcn.h>
#include <string.h>

typedef void*		T_DLL_HANDLE;

#endif

#include <string>
#include "EesTraderApi.h"

using std::string;

class TraderDemo : public EESTraderEvent
{
public:
	TraderDemo(void);
	virtual ~TraderDemo(void);

	/// \brief ں
	void Run();

private:
	/// \brief ʼ
	bool Init();
	/// \brief ر
	void Close();

	/// \brief ʱ
	void DemoSleep(int nMilliSeconds);
	/// \brief ͣ
	void Pause();

private:
	/// \brief EESAPIĶ̬
	bool LoadEESTrader();
	/// \brief ͷEESAPIĶ̬
	void UnloadEESTrader();

	/// \brief WindowsؽAPIĶ̬
	bool Windows_LoadEESTrader();
	/// \brief WindowsͷŽAPIĶ̬
	void Windows_UnloadEESTrader();

	/// \brief Linux汾ؽAPIĶ̬
	bool Linux_LoadEESTrader();
	/// \brief Linux汾ͷŽAPIĶ̬
	void Linux_UnloadEESTrader();

	/// \brief ʼ
	void InputParam();

	/// \brief ¼
	void Logon();
	/// \brief µ
	void NewOrder();
	/// \brief 
	void CxlOrder();

private:
	/// \brief ¼
	virtual void OnConnection(ERR_NO errNo, const char* pErrStr);
	/// \brief	ϿյϢ
	virtual void OnDisConnection(ERR_NO errNo, const char* pErrStr);
	/// \brief	¼ϢĻص
	virtual void OnUserLogon(EES_LogonResponse* pLogon);
	/// \brief	µREMܵ¼
	virtual void OnOrderAccept(EES_OrderAcceptField* pAccept);
	/// \brief	µгܵ¼
	virtual void OnOrderMarketAccept(EES_OrderMarketAcceptField* pAccept);
	///	\brief	µREMܾ¼
	virtual void OnOrderReject(EES_OrderRejectField* pReject);
	///	\brief	µгܾ¼
	virtual void OnOrderMarketReject(EES_OrderMarketRejectField* pReject);
	///	\brief	ɽϢ¼
	virtual void OnOrderExecution(EES_OrderExecutionField* pExec);
	///	\brief	ɹ¼
	virtual void OnOrderCxled(EES_OrderCxled* pCxled);
	///	\brief	ܾϢ¼
	virtual void OnCxlOrderReject(EES_CxlOrderRej* pReject);
	/// \brief	ӷ/Ͽʱ״̬
	virtual void OnMarketSessionStatReport(EES_MarketSessionId MarketSessionId, bool ConnectionGood);
	/// \brief	Լ״̬仯ʱ
	virtual void OnSymbolStatusReport(EES_SymbolStatus* pSymbolStatus);
	

private:
	EESTraderApi*				m_tradeApi;				///< EESAPIӿ
	T_DLL_HANDLE				m_handle;				///< EESAPI
	funcDestroyEESTraderApi		m_distoryFun;			///< EESAPI̬ٺ

	string						m_tradeServerIp;		///< ͨIPַ
	int							m_tradeServerPort;		///< ͨ˿
	string						m_queryServerIp;		///< ѯͨIPַ
	int							m_queryServerPort;		///< ѯͨ˿
	string						m_logonId;				///< ¼׷
	string						m_logonPwd;				///< ¼׷
	string						m_account;				///< ʺ
	string						m_symbol;				///< ׺Լ
	string						m_local_mac;			///< MACַ
	int							m_quantity;				///< 
	EES_MarketToken				m_marketOrderID;		///< г
	int							m_logonStatus;			///< 0-δ¼; 1-ڵ¼; 2-¼ɹ; 3-¼ʧܣѾϿ
};

