/*! \file EesTraderApi.h
 *  \brief EES׿ͻͷļ   
 *  
 *  ĵϸEES׿ͻ˵Ľӿڶ塣
*/
#pragma  once 
#include "EesTraderDefine.h"
#include "EesTraderErr.h"
#include <time.h>

#ifdef WIN32
	#ifdef SL_EES_TRADE_EXPORTS
		#define SL_EES_TRADE_CLASS __declspec(dllexport)	  
		#define SL_EES_TRADE_FUN		extern "C" __declspec(dllexport)
	#else
		#define SL_EES_TRADE_CLASS __declspec(dllimport)	  
		#define SL_EES_TRADE_FUN		extern "C" __declspec(dllimport)
	#endif

	/// \brief EES׿ͻ˶̬
	#define EES_TRADER_DLL_NAME    "EESTraderApi.dll"
	/// \brief EES׿ͻ˾̬
	#define EES_TRADER_LIB_NAME    "EESTraderApi.lib"

	#include <windows.h>

#else	
	#define SL_EES_TRADE_CLASS 
	#define SL_EES_TRADE_FUN  extern "C" 

	#ifndef OUT
		#define OUT
	#endif

	#ifndef NULL
		#define NULL 0
	#endif

	/// \brief EES׿ͻ˶̬
	#define EES_TRADER_DLL_NAME    "libEESTraderApi.so"

#endif

/// \brief EES׿ͻ˻ص
class  EESTraderEvent
{
public:	
	virtual ~EESTraderEvent()
	{

	}
	/// ϢĻص
	
		///	\brief	¼
		///	\param  errNo                   ӳɹϢ
		///	\param  pErrStr                 Ϣ
		///	\return void  
	
	virtual void OnConnection(ERR_NO errNo, const char* pErrStr ){}

	/// ӶϿϢĻص
	
		/// \brief	ϿյϢ
		/// \param  ERR_NO errNo         ӳɹϢ
		/// \param  const char* pErrStr  Ϣ
		/// \return void  
	
	virtual void OnDisConnection(ERR_NO errNo, const char* pErrStr ){}

	/// ¼ϢĻص
	
		/// \param  pLogon                  ¼ɹʧܵĽṹ
		/// \return void 
	
	virtual void OnUserLogon(EES_LogonResponse* pLogon){}

	/// ޸Ӧص

	/// \param  nResult                  Ӧĳɹ񷵻
	/// \return void 

	virtual void OnRspChangePassword(EES_ChangePasswordResult nResult){}

	/// ѯûʻķ¼
	
		/// \param  pAccountInfo	        ʻϢ
		/// \param  bFinish	                ûдɣֵ false ˣǸֵΪ true 
		/// \remark  bFinish == trueôǴ pAccountInfoֵЧ
		/// \return void 
	
	virtual void OnQueryUserAccount(EES_AccountInfo * pAccoutnInfo, bool bFinish){}

	/// ѯʻڻλϢķ¼	
		/// \param  pAccount	                ʻID 	
		/// \param  pAccoutnPosition	        ʻĲλϢ					   
		/// \param  nReqId		                ϢʱIDš
		/// \param  bFinish	                    ûдɣֵfalseˣǸֵΪ true 
		/// \remark  bFinish == trueôǴ pAccountInfoֵЧ
		/// \return void 	
	virtual void OnQueryAccountPosition(const char* pAccount, EES_AccountPosition* pAccoutnPosition, int nReqId, bool bFinish){}	

	/// ѯʻȨλϢķ¼, עص, һOnQueryAccountPosition, һQueryAccountPosition, ֱ𷵻, ȷڻ, ٷȨ, ʹûȨλ, Ҳ᷵һbFinish=trueļ¼
	/// \param  pAccount	                ʻID 	
	/// \param  pAccoutnPosition	        ʻĲλϢ					   
	/// \param  nReqId		                ϢʱIDš
	/// \param  bFinish	                    ûдɣֵfalseˣǸֵΪ true 
	/// \remark  bFinish == trueôǴ pAccountInfoֵЧ
	/// \return void 	
	virtual void OnQueryAccountOptionPosition(const char* pAccount, EES_AccountOptionPosition* pAccoutnOptionPosition, int nReqId, bool bFinish) {}


	/// ѯʻʽϢķ¼
	
		/// \param  pAccount	                ʻID 	
		/// \param  pAccoutnBP	                ʻʽϢ					   
		/// \param  nReqId		                ϢʱID
		/// \return void 
	
	virtual void OnQueryAccountBP(const char* pAccount, EES_AccountBP* pAccoutnBP, int nReqId ){}	


	/// ʽϢ¼

	/// \param  pAccount	                ʻID 	
	/// \param  pAccoutnBP	                ʻʽϢ					   
	/// \return void 
	virtual void OnAccountBPReport(const char* pAccount, EES_AccountBP* pAccoutnBP) {}

	/// ѯԼбķ¼
	
		/// \param  pSymbol	                    ԼϢ   
		/// \param  bFinish	                    ûдɣֵ falseˣǸֵΪ true   
		/// \remark  bFinish == trueôǴ pSymbol ֵЧ
		/// \return void 
	
	virtual void OnQuerySymbol(EES_SymbolField* pSymbol, bool bFinish){}

	/// ѯʻױ֤ķ¼
	
	    /// \param  pAccount                    ʻID 
		/// \param  pSymbolMargin               ʻı֤Ϣ 
		/// \param  bFinish	                    ûдɣֵ falseɣǸֵΪ true 
		/// \remark  bFinish == trueôǴ pSymbolMargin ֵЧ
		/// \return void 
	
	virtual void OnQueryAccountTradeMargin(const char* pAccount, EES_AccountMargin* pSymbolMargin, bool bFinish ){}

	/// ѯʻ׷õķ¼
	
		/// \param  pAccount                    ʻID 
		/// \param  pSymbolFee	                ʻķϢ	 
		/// \param  bFinish	                    ûдɣֵ falseˣǸֵΪ true    
		/// \remark  bFinish == true ôǴ pSymbolFee ֵЧ
		/// \return void 
	
	virtual void OnQueryAccountTradeFee(const char* pAccount, EES_AccountFee* pSymbolFee, bool bFinish ){}

	/// µ̨ϵͳܵ¼
	
		/// \brief ʾѾ̨ϵͳʽĽ
		/// \param  pAccept	                    ԺϢ
		/// \return void 
	
	virtual void OnOrderAccept(EES_OrderAcceptField* pAccept ){}


	/// µгܵ¼

	    /// \brief ʾѾʽĽ
	    /// \param  pAccept	                    ԺϢ壬гID
	    /// \return void 
	virtual void OnOrderMarketAccept(EES_OrderMarketAcceptField* pAccept) {}


	///	µ̨ϵͳܾ¼
	
		/// \brief	̨ϵͳܾԲ鿴﷨Ƿؼ顣 
		/// \param  pReject	                    ԺϢ
		/// \return void 
	
	virtual void OnOrderReject(EES_OrderRejectField* pReject ){}


	///	µгܾ¼

	/// \brief	гܾԲ鿴﷨Ƿؼ顣 
	/// \param  pReject	                    ԺϢ壬гID
	/// \return void 

	virtual void OnOrderMarketReject(EES_OrderMarketRejectField* pReject) {}


	///	ɽϢ¼
	
		/// \brief	ɽ˶гIDIDѯӦĶ
		/// \param  pExec	                   ԺϢ壬гID
		/// \return void 
	
	virtual void OnOrderExecution(EES_OrderExecutionField* pExec ){}

	///	ɹ¼
	
		/// \brief	ɽ˶гIDIDѯӦĶ
		/// \param  pCxled		               ԺϢ壬гID
		/// \return void 
	
	virtual void OnOrderCxled(EES_OrderCxled* pCxled ){}

	///	ܾϢ¼
	
		/// \brief	һڷͳԺյϢʾܾ
		/// \param  pReject	                   ܾϢ
		/// \return void 
	
	virtual void OnCxlOrderReject(EES_CxlOrderRej* pReject ){}

	///	ѯķ¼
	
		/// \brief	ѯϢʱĻصҲܰǵǰûµĶ
		/// \param  pAccount                 ʻID 
		/// \param  pQueryOrder	             ѯĽṹ
		/// \param  bFinish	                 ûдɣֵ falseˣǸֵΪ true    
		/// \remark  bFinish == trueôǴ pQueryOrderֵЧ
		/// \return void 
	
	virtual void OnQueryTradeOrder(const char* pAccount, EES_QueryAccountOrder* pQueryOrder, bool bFinish  ){} 

	///	ѯķ¼
	
		/// \brief	ѯϢʱĻصҲܰǵǰûµĶɽ
		/// \param  pAccount                        ʻID 
		/// \param  pQueryOrderExec	                ѯɽĽṹ
		/// \param  bFinish	                        ûдɣֵfalseˣǸֵΪ true    
		/// \remark  bFinish == trueôǴpQueryOrderExecֵЧ
		/// \return void 
	
	virtual void OnQueryTradeOrderExec(const char* pAccount, EES_QueryOrderExecution* pQueryOrderExec, bool bFinish  ){}

	///	ⲿϢ
	
		/// \brief	һϵͳ˹ʱõ
		/// \param  pPostOrder	                    ѯɽĽṹ
		/// \return void 
	
	virtual void OnPostOrder(EES_PostOrder* pPostOrder ){}	

	///	ⲿɽϢ
	
		/// \brief	һϵͳ˹ʱõ
		/// \param  pPostOrderExecution	             ѯɽĽṹ
		/// \return void 
	
	virtual void OnPostOrderExecution(EES_PostOrderExecution* pPostOrderExecution ){}

	///	ѯӵӦ

	/// \brief	ÿǰϵͳֵ֧Ļ㱨һΣbFinish= trueʱʾнӦѵϢõϢ
	/// \param  pMarketSession	             ѯMarketSessionĽṹ
	/// \return void 
	virtual void OnQueryMarketSession(EES_ExchangeMarketSession* pMarketSession, bool bFinish) {}

	///	״̬仯棬

	/// \brief	ӷ/Ͽʱ״̬
	/// \param  MarketSessionId: Ӵ
	/// \param  ConnectionGood: trueʾfalseʾӶϿˡ
	/// \return void 
	virtual void OnMarketSessionStatReport(EES_MarketSessionId MarketSessionId, bool ConnectionGood) {}

	///	Լ״̬仯

	/// \brief	Լ״̬仯ʱ
	/// \param  pSymbolStatus: μEES_SymbolStatusԼ״̬ṹ嶨
	/// \return void 
	virtual void OnSymbolStatusReport(EES_SymbolStatus* pSymbolStatus) {}


	///	Լ״̬ѯӦ

	/// \brief  ӦԼ״̬ѯ
	/// \param  pSymbolStatus: μEES_SymbolStatusԼ״̬ṹ嶨
	/// \param	bFinish: ΪtrueʱʾѯнءʱpSymbolStatusΪָNULL
	/// \return void 
	virtual void OnQuerySymbolStatus(EES_SymbolStatus* pSymbolStatus, bool bFinish) {}

	/// ѯӦ
	/// \param	pMarketMBLData: μEES_MarketMBLDataṹ嶨
	/// \param	bFinish: ΪtrueʱʾѯнءʱpMarketMBLData,m_RequestIdЧ
	/// \return void 
	virtual void OnQueryMarketMBLData(EES_MarketMBLData* pMarketMBLData, bool bFinish) {}


	/// ϯλŲѯӦ
	/// \param	pSessionID: μEES_SessionIDϯλŽṹ嶨
	/// \return void 
	virtual void OnQuerySessionID(EES_SessionID* pSessionID) {}

};

/// \brief EES׿ͻ˴
class SL_EES_TRADE_CLASS EESTraderApi
{
public:
	virtual ~EESTraderApi()
	{
	}

	///ǷԶConnServer֮ǰʹ
	/// \return ûзֵ
	virtual void SetAutoReconnect(bool autoConnect) = 0;

	/// ýסѯӵȴ¼ʱ
	/// \param  int trade_wait_time			ӵȴ¼ʱ
	/// \param  int query_wait_time		    ѯӵȴ¼ʱ
	/// \return ûзֵ
	virtual void SetMaxWaitTime(int trade_wait_time, int query_wait_time) = 0;

	/// ӷ
	/// ṩ2ֽӿڣʽݼ°ĽӿڣһֽӿڼʹTCPģʽ
	virtual RESULT	ConnServer(const char* svrAddr, int nPort, EESTraderEvent* pEvent, const char* qrySvrAddr, int nQrySvrPort) = 0;
	virtual RESULT	ConnServer(const EES_TradeSvrInfo& param, EESTraderEvent* pEvent)  = 0 ;
	
	/// Ͽ
	
		/// \return RESULT						ο EesTraderErr.hļ
	
	virtual RESULT	DisConnServer()  = 0 ;

	/// û¼
	
		/// \brief	Ĳʻû
		/// \param  const char* userId			û
		/// \param  const char* userPwd		    û¼
		/// \param  const char* app_id		    AppId
		/// \param  const char* auth_code		Ȩ
		/// \return RESULT			ֵο EesTraderErr.hļ
	
	virtual RESULT UserLogon(const char* user_id, const char* user_pwd, const char* app_id, const char* auth_code) = 0 ;

	/// û޸

	/// \brief	¼ɹʹ
	/// \param  const char* oldPwd			
	/// \param  const char* newPwd		    
	/// \return RESULT			ֵο EesTraderErr.hļ

	virtual RESULT ChangePassword(const char* oldPwd, const char* newPwd )  = 0 ;

	/// ѯԼб
	
		/// \brief	ֻ᷵صЧĺԼ
		/// \return RESULT			ֵο EesTraderErr.hļ
	
	virtual RESULT QuerySymbolList( )  = 0 ;


	/// ѯûʻ
	
		/// \return RESULT			ֵο EesTraderErr.hļ
	
	virtual RESULT QueryUserAccount()  = 0 ;

	/// ѯʻλ
	
		/// \brief	
		/// \param  const char* accountId		ʻID
		/// \param  int   nReqId			    ѯID
		/// \return RESULT			ֵοEesTraderErr.hļ
	
	virtual RESULT QueryAccountPosition(const char* accountId, int nReqId)  = 0 ;

	/// ѯʻBP
	
		/// \brief	
		/// \param  const char* accountId		ʻID
		/// \param  int   nReqId				ѯID
		/// \return RESULT			ֵοEesTraderErr.hļ
	
	virtual RESULT QueryAccountBP(const char* accountId, int nReqId)  = 0 ;

	/// ѯʻ֤
	
		/// \param  const char* accountId		ʻID
		/// \return RESULT			ֵοEesTraderErr.hļ
	
	virtual RESULT QueryAccountTradeMargin(const char* accountId )  = 0 ;

	/// ѯʻ
	
		/// \brief	ڣÿһʻķʲһÿһʻѯһ¡
		/// \param  const char* accountId		ʻID
		/// \return RESULT			ֵοEesTraderErr.hļ
	
	virtual RESULT QueryAccountTradeFee(const char* accountId ) = 0  ;


	/// ȡ   token ֵ
	/// \brief	ȡ   token ֵ
	/// \param  EES_ClientToken * orderToken	Ҫֵ
	/// \return RESULT			ֵοEesTraderErr.hļ
	virtual RESULT GetMaxToken(OUT EES_ClientToken* orderToken) = 0  ;


	/// µ
	
		/// \param  EES_EnterOrderField* pOrder	֯õĶṹ
		/// \return RESULT			ֵοEesTraderErr.hļ
	
	virtual RESULT	EnterOrder(EES_EnterOrderField* pOrder ) = 0  ;

	/// ָ
	
		/// \param  EES_CancelOrder* pCxlOrder		ṹ
		/// \return RESULT			ֵοEesTraderErr.hļ
	
	virtual RESULT	CancelOrder(EES_CancelOrder* pCxlOrder)  = 0 ;

	/// ѯʻϢ 
	
		/// \param  const char* accountId		     ʻID
		/// \return RESULT			ֵοEesTraderErr.hļ
	
	virtual RESULT	QueryAccountOrder(const char* accountId )  = 0 ;

	/// ѯʻɽϢ
	
		/// \param  const char* accountId		     ʻID
		/// \return RESULT			ֵοEesTraderErr.hļ
	
	virtual RESULT	QueryAccountOrderExecution(const char* accountId ) = 0 ; 

	/// Ͳѯϯλ	
	/// \return ûзֵӦEESTraderEvent::OnQueryMarketSessionз
	virtual RESULT QueryMarketSession() = 0;

	/// ʱתڽAPIеEES_NanosecondͣתCԱ׼struct tmṹ壬Լʱһڵ

	/// \param  EES_Nanosecond timeStamp		APIṹеʱֵ
	/// \param  tm& tmResult					ڽսstruct tmṹ
	/// \param  unsigned int& nanoSsec 			ڽս
	/// \return ûзֵ
	virtual void ConvertFromTimestamp(EES_Nanosecond timeStamp, tm& tmResult, unsigned int& nanoSsec) = 0;



	/// ־أĬΪء

	/// \param  bool bOn		true: 򿪱־; false: رձ־
	/// \return ûзֵ
	virtual void SetLoggerSwitch(bool bOn) = 0;

	/// ͲѯԼ״̬ 
	/// \return RESULT ӦEESTraderEvent::OnQuerySymbolStatusз
	virtual RESULT QuerySymbolStatus() = 0;

	/// ־Ϣдļ
	/// \return ûзֵ
	virtual void LoggerFlush() = 0;

	/// ͻΪ첽ģʽConnectServer֮ǰʹãһʹãл
	/// ӿֻͼλֹµʹã򻯽ƽ̨ʹøýӿڻɽնӳٱ
	/// \return ûзֵ
	virtual void SetAsyncReceiveMode() = 0;

	/// µһ16
	/// עÿĵOrderToken뱣֤ⲿúòظ
	/// pArrOrders: EES_EnterOrderFieldṹ飬16nCount >=1 <=16
	/// \return: ɹ0һд򷵻ط0ֵбᱻ
	virtual RESULT EnterMultiOrders(EES_EnterOrderField* pArrOrders, int nCount) = 0;

	/// һ37
	/// עÿĵOrderToken뱣֤ⲿúòظ
	/// pCxlOrders: EES_CancelOrderṹ飬37nCount >=1 <=37
	/// \return: ɹ0һд򷵻ط0ֵгᱻ
	virtual RESULT EnterMultiCxlOrders(EES_CancelOrder* pArrCxlOrders, int nCount) = 0;

	/// սѯע⣺̨ϵͳ֧飬ùܲŻṤ	
	/// nRequestId: ͻбţӦķ¼OnQueryMarketMBLDataУ᷵RequestIdͻƥԼĲѯ
	/// exchangeID: ҪEES_ExchangeID_shfeʵʽ	
	/// nSide: 0-˫ߣ 1-Bid 2-Ask
	/// \return: ɹ0OnQueryMarketMBLDataз
	virtual RESULT QueryMarketMBLData(int nRequestId, EES_ExchangeID exchangeID, int nSide) = 0;

	/// ָԼΧѯע⣺̨ϵͳ֧飬ùܲŻṤ	
	/// nRequestId: ͻбţӦķ¼OnQueryMarketMBLDataУ᷵RequestIdͻƥԼĲѯ	
	/// startSymbol , endSymbol: ʼѯԼֹѯԼϷĺԼ
	/// nSide: 0-˫ߣ 1-Bid 2-Ask
	/// \return: ɹ0OnQueryMarketMBLDataз
	virtual RESULT QueryMarketMBLData(int nRequestId, const char* startSymbol, const char* endSymbol, int nSide) = 0;

	/// ͻز
	/// ¼ɹ󣬿ɴӵ¼ϢṹEES_LogonResponseУȡǰ¼زλÿٺ룬ٴµ/
	/// ڷ˶µĿǸ˺ţϵͳһ˺Ŷ¼ͬʱµʵؿܻȻõĲϸ
	/// ṩýӿڣͻԸԼǷҪ¼µزиϸĵֹ˷شӶ۶ϵ¼
	/// ӿֻµֻܵø٣Ҳܽ0
	/// OrderCountµ
	/// CancelCount³
	/// ӿڲ᷵ȷǴ˴Ĳԭ仯
	virtual RESULT ChangeFCParam(unsigned int OrderCount, unsigned int CancelCount) = 0;

	/// Ͳѯϯλ	
	/// tradeNo: ϯλ
	/// exchangeID: ҪEES_ExchangeID_shfeʵʽ0,0ʾУ齻ֵ
	/// \return ɹ0ӦEESTraderEvent::OnQuerySessionIDз
	virtual RESULT QuerySessionID(const char* tradeNo,EES_ExchangeID exchangeID) = 0;

};

/// EES׿ͻʵĺ
#define CREATE_EES_TRADER_API_NAME ("CreateEESTraderApi")

/// EES׿ͻʵĺ
#define DESTROY_EES_TRADER_API_NAME ("DestroyEESTraderApi")

/// EES׿ͻʵ
SL_EES_TRADE_FUN EESTraderApi* CreateEESTraderApi(void) ; 

/// EES׿ͻʵ
SL_EES_TRADE_FUN void DestroyEESTraderApi(EESTraderApi* pEESTraderApi) ; 

/// EES׿ͻʵָ
typedef EESTraderApi* (*funcCreateEESTraderApi)(void) ;

/// EES׿ͻʵָ
typedef void (*funcDestroyEESTraderApi)(EESTraderApi* pEESTraderApi) ;

