/*! \file  EesTraderDefine.h
 *  \brief EES׿ͻAPIʹõϢ嶨塣
 *
 *  ļϸEES׿ͻAPIʹõݽṹԼϢ塣 
*/
#pragma  once 




#ifndef _EES_TRADE_API_STRUCT_DEFINE_H_
#define _EES_TRADE_API_STRUCT_DEFINE_H_

#include <string.h>


#define SL_EES_API_VERSION    "4.0.3.67"				///<  api汾

typedef int RESULT;										///< 巵ֵ 
typedef int ERR_NO;										///< ֵ 

typedef unsigned int			EES_ClientToken;					///< API˶ĿͻID
typedef int						EES_UserID;						///< ʻID
typedef long long int			EES_MarketToken;					///< г ID
typedef int						EES_TradingDate;					///< 
typedef unsigned long long int	EES_Nanosecond;					///< 1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ

typedef char    EES_Account[17];						///< ʻ
typedef char    EES_ProductID[5];						///< ڻĲƷ

typedef char    EES_ReasonText[88];						///< 
typedef char	EES_ReasonText2[81];					///< ͽгܾṹ
typedef char	EES_GrammerResultText[1024];			///< ﷨
typedef	char	EES_RiskResultText[1024];				///< ؼ

typedef char    EES_GrammerResult[32];					///< µ﷨
typedef char    EES_RiskResult[96];						///< µؼ
                              
typedef char    EES_Symbol[20];							///< ׺Լ
typedef char    EES_SymbolName[21];						///< ׺Լ

typedef char    EES_MarketOrderId[25];                  ///< 
typedef char	EES_MarketExecId[25];					///< ɽ
typedef unsigned char EES_MarketSessionId;				///< ϯλ

typedef unsigned char EES_SideType;						///< 
#define EES_SideType_open_long                  1		///< =򵥣
#define EES_SideType_close_today_long           2		///< =ƽ
#define EES_SideType_close_today_short          3		///< =򵥣ƽ
#define EES_SideType_open_short                 4		///< =
#define EES_SideType_close_ovn_short            5		///< =򵥣ƽ
#define EES_SideType_close_ovn_long             6		///< =ƽ
#define EES_SideType_today_opt_exec				11		///< =Ȩƽ
#define EES_SideType_ovn_opt_exec				12		///< =Ȩƽ
#define EES_SideType_opt_exec					13		///Ȩƽ֣
#define EES_SideType_abandon_today_opt_exec		14		///< =Ȩ
#define EES_SideType_abandon_ovn_opt_exec		15		///< =Ȩ
#define EES_SideType_abandon_opt_exec	  		16		///Ȩƽ֣
#define EES_sideType_opt_offset					17		///ȨԶԳ
#define EES_sideType_perform_offset				18		///ԼԳ
#define EES_SideType_close_short				21		///< =򵥣ƽ֣
#define EES_SideType_close_long					22		///< =ƽ֣


typedef unsigned char EES_ExchangeID;					///< ID
#define EES_ExchangeID_sh_cs                    100		///< =Ͻ
#define EES_ExchangeID_sz_cs                    101		///< =
#define EES_ExchangeID_cffex                    102		///< =н
#define EES_ExchangeID_shfe                     103		///< =
#define EES_ExchangeID_dce                      104		///< =
#define EES_ExchangeID_zcze                     105		///< =֣
#define EES_ExchangeID_ine						106		///< =Դ
#define EES_ExchangeID_sge						107		///< =Ϻ
#define EES_ExchangeID_gfex						108     ////<=
#define EES_ExchangeID_done_away                255		///< =Done-away 


typedef unsigned char EES_SecType;						///< Ʒ 
#define EES_SecType_cs                          1		///< =Ʊ
#define EES_SecType_options                     2		///< =Ȩ
#define EES_SecType_fut                         3		///< =ڻ


typedef unsigned char EES_ForceCloseType;				///< ǿƽԭ 
#define EES_ForceCloseType_not_force_close      0		///< =ǿƽ  
#define EES_ForceCloseType_not_enough_bp        1		///< =ʽ  
#define EES_ForceCloseType_not_enough_position  2		///< =ͻ  
#define EES_ForceCloseType_not_enough_position2 3		///< =Ա  
#define EES_ForceCloseType_not_round_lot        4		///< =ֲַ  
#define EES_ForceCloseType_invalid              5		///< =Υ
#define EES_ForceCloseType_other                6		///< =

typedef unsigned char EES_OptExecFlag;
#define EES_OptExecFlag_normal					0		///< =Ȩ
#define EES_OptExecFlag_dont_auto_exec			1		///< =벻Զִ
#define EES_OptExecFlag_fut_hedge				2		///< =ڻλԶԳ

typedef unsigned char EES_ForceCloseReason;
#define EES_FORCE_CLOSE_REASON_NO_FORCE					0
#define EES_FORCE_CLOSE_REASON_LACK_OF_FUND				1
#define EES_FORCE_CLOSE_REASON_CLIENT_OVERFLOW_POS		2
#define EES_FORCE_CLOSE_REASON_MEMBER_OVERFLOW_POS		3
#define EES_FORCE_CLOSE_REASON_POS_ERROR				4
#define EES_FORCE_CLOSE_REASON_VIOLATION				5
#define EES_FORCE_CLOSE_REASON_OTHGER					6

typedef unsigned char EES_OrderState;					///< ״̬
#define EES_OrderState_order_live               1		///< =ӻ
#define EES_OrderState_order_dead               2		///< =

typedef int           EES_Previlege;					///< ĿǰӲݲ֧֣Ҳ˵ȫȨ 99ȫ  1ֻ 2ֻƽ
#define EES_Previlege_open_and_close            99		///< =Ȩ
#define EES_Previlege_readonly                  1		///< =ֻ
#define EES_Previlege_close_only                2		///< =ֻƽ


typedef int     EES_PosiDirection;						///< շ 1ͷ 5ͷ
#define EES_PosiDirection_long					1		///< =ͷ
#define EES_PosiDirection_short					5		///< =ͷ


typedef unsigned char EES_RejectedMan;					///< ˭ܾʢϵͳĽ 1=ʢ
#define EES_RejectedMan_by_shengli				1		///< =ʢܾ

typedef unsigned char EES_ReasonCode;					///< ӱܾɡűӡ±

typedef unsigned char EES_CxlReasonCode;				///< ɹԭ
#define EES_CxlReasonCode_by_account			1		///< =û
#define EES_CxlReasonCode_timeout				2		///< =ϵͳtimeout, ӵڱϵͳȡ
#define EES_CxlReasonCode_supervisory			3		///< =Supervisory, ʢϵͳȡ
#define EES_CxlReasonCode_by_market				4		///< =гܾ
#define EES_CxlReasonCode_another				255		///< =

typedef unsigned char EES_OrderStatus;					///< նŶ״̬
#define EES_OrderStatus_shengli_accept			0x80	///< bit7=1EESϵͳѽ
#define EES_OrderStatus_mkt_accept				0x40	///< bit6=1гѽֹܻԤ
#define EES_OrderStatus_executed				0x20	///< bit5=1ѳɽ򲿷ֳɽ
#define EES_OrderStatus_cancelled				0x10 	///< bit4=1ѳ, ǲֳɽ
#define EES_OrderStatus_cxl_requested			0x08	///< bit3=1ͻ
#define EES_OrderStatus_reserved1				0x04	///< bit2־λ
#define EES_OrderStatus_reserved2				0x02	///< bit1ֹӯֹ־λ
#define EES_OrderStatus_closed					0x01	///< bit0=1ѹر, (ܾ/ȫɽ/ѳ)

typedef unsigned int EES_OrderTif;						///< ɽ
#define EES_OrderTif_IOC						0		///< ҪFAK/FOKʱҪTIFΪ0
#define EES_OrderTif_Day						99998	///< ڱ

typedef unsigned long long int EES_CustomFieldType;		///< ûɴԶ8λֵ	

typedef unsigned char EES_HedgeFlag;					///< Ͷ־
#define EES_HedgeFlag_Arbitrage				1			///< 
#define EES_HedgeFlag_Speculation			2			///< Ͷ
#define EES_HedgeFlag_Hedge					3			///< ױ

typedef int EES_LogonResult;
#define EES_LOGON_OK							0		///< ɹ
#define EES_LOGON_AUTHENTICATION_FAILED			1		///< û/벻
#define EES_LOGON_ACCOUNT_NOT_BOUND				2		///< ûδκʽ˻
#define EES_LOGON_ALREADY_LOGON					3		///< ϵͳΪظ¼ʱû¼ôͻֵ᷵Ŀǰһ㲻ôãӦòյ
#define EES_LOGON_ANOTHER_LOGON					4		///< Ѿ¼ɹٴε¼
#define EES_LOGON_MISSING_EXTRA_INFO			5		///< ȱٿͻ˱ʶmacַ
#define EES_LOGON_INTERNAL_ERROR				6		///< ϵͳڲ
#define EES_LOGON_NOT_USING_QUERY_PORT			7		///< ʹ°汾APIٻᷢ
#define EES_LOGON_CONNECT_QUERY_PORT_FAILED		8		///< Ӳѯͨʧ
#define EES_LOGON_RPTR_INVALID_INFO				11		///< ЧɼϢ
#define EES_LOGON_RPTR_IP_ERROR					12		///< ɼϱͽ׶˵ԶIPͬ
#define EES_LOGON_RPTR_APPID_AUTH_CODE_ERROR	13		///< УAPPIDȨ
#define EES_LOGON_SYSTEM_ENV_CRITICAL			99		///< Ŀǰӣڴ桢Ӳ̵ȿռ䲻㣬е¼ֹ

typedef int EES_ChangePasswordResult;
#define EES_ChangePasswordResult_Success		0		///< ɹ
#define EES_ChangePasswordResult_OldPwdNotMatch	1		///< 벻
#define EES_ChangePasswordResult_NewPwdInvalid	2		///< Ƿհ׵
#define	EES_ChangePasswordResult_NotLogIn		3		///< δ¼
#define	EES_ChangePasswordResult_InternalError	99		///< ϵͳ̨

typedef unsigned char EES_OrderType;
#define EES_Order_Type_Limt						1		///< ޼
#define EES_Order_Type_Market					2		///< мۣδ֧
#define EES_Order_Type_Stop_Profit_Limit		3		///< ޼ֹӯ
#define EES_Order_Type_Stop_Loss_Limit			4		///< ޼ֹ
#define EES_Order_Type_Stop_Profit_Market		5		///< мֹӯδ֧
#define EES_Order_Type_Stop_Loss_Market			6		///< мֹδ֧

typedef unsigned char EES_OrderExchangeStatus;
#define EES_Order_Exchange_Status_Accept			0		///< г
#define EES_Order_Exchange_Status_Triggered			1		///< ֹӯֹ𵥴
#define EES_Order_Exchange_Status_Suspended			2		///< 
#define EES_Order_Exchange_Status_Activated			3		///< 

#pragma pack(push, 1)


/// ¼صϢ
struct EES_LogonResponse
{
	EES_LogonResult		m_Result;							///< μĵEES_LogonResult
	EES_UserID			m_UserId;							///< ¼ӦûID
	unsigned int		m_TradingDate;						///< գʽΪyyyyMMddintֵ
	EES_ClientToken		m_MaxToken;							///< ǰ token 
	unsigned int		m_OrderFCCount;						///< µزλʱµƵĴ
	unsigned int		m_OrderFCInterval;					///< µزλʱµƵλʱ䣬΢ֵ
	unsigned int		m_CancelFCCount;					///< زλʱڳƵĴ
	unsigned int		m_CancelFCInterval;					///< زλʱڳƵλʱ䣬΢ֵ
};


/// µϢ
struct EES_EnterOrderField
{ 
	EES_Account         m_Account;						///< û
	EES_SideType        m_Side;							///<  11 =Ȩƽ12=Ȩƽ14=Ȩ15=Ȩ
	EES_ExchangeID      m_Exchange;						///< 
	EES_Symbol          m_Symbol;						///< Լ
	EES_SecType         m_SecType;						///< Ʒ
	double              m_Price;						///< ۸
	unsigned int        m_Qty;							///< 
	EES_ForceCloseReason m_ForceCloseReason;			///<ǿƽԭ  0=ǿƽ, 1=ʽ,2=ͻ,3=Ա,4=ֲַ,5=Υ棬6=
	EES_ClientToken		m_ClientOrderToken;				///< ͣ뱣֤αϴεֵ󣬲һҪ֤
	EES_OrderTif		m_Tif;							///< ҪFAK/FOKʱҪΪEES_OrderTif_IOC
	unsigned int		m_MinQty;						///< ҪFAK/FOKʱֵ=0ӳ佻FAK-
														///< ҪFAK/FOKʱֵ>0<m_Qtyӳ佻FAK-ССֵ
														///< ҪFAK/FOKʱֵ=m_Qtyӳ佻FOK
														///< ڱΪ0.ֵ>m_QtyREMϵͳܾ
	
	EES_CustomFieldType m_CustomField;					///< ûԶֶΣ8ֽڡûµʱֵָOnOrderAcceptOnQueryTradeOrder¼з
	EES_MarketSessionId m_MarketSessionId;				///< ϯλ룬OnResponseQueryMarketSessionIdȡϷֵ0ǷֵREMϵͳо͵ϯλ	m_ForceMarketSessionIdΪtrue
	EES_HedgeFlag		m_HedgeFlag;					///< Ͷ־
	unsigned char		m_ForceMarketSessionId;			///< Ϊtrueͻָϯλ룬Ǹϯλû߷ǷʱָʾҪо͵ϯλǾܾµ
	unsigned char		m_DoNotAdjustCoverSide;			///< Ĭ£н/ġƽ/ƽ򡱶APIԶ֮תΪƽֵ֡Ϊtrue򲻽дתһڲԳ
	EES_OrderType	    m_OrderType;					///< Ŀǰ֧֣1=޼; 3=޼ֹӯ; 4=޼ֹ; 3֣ҽԴЧ
	double				m_StopPrice;					///< m_OrderTypeΪ 3/4/5/6 ʱ0
	unsigned char		m_IsOffset;						///< ȨǷԳ壨1ǣ0
	EES_EnterOrderField()
	{
		memset(this, 0, sizeof(*this));
		m_Tif = EES_OrderTif_Day;
		m_MinQty = 0;
		m_MarketSessionId = 0;
		m_HedgeFlag = EES_HedgeFlag_Speculation;
		m_SecType = EES_SecType_fut;
		m_ForceMarketSessionId = 0;
		m_DoNotAdjustCoverSide = 0;
		m_OrderType = EES_Order_Type_Limt;
	}

};

/// µ̨ϵͳϢ
struct EES_OrderAcceptField
{ 
	EES_ClientToken     m_ClientOrderToken;				///< µʱ򣬷ظtoken
	EES_MarketToken     m_MarketOrderToken;				///< гҵtoken
	EES_OrderState      m_OrderState;					///< ״̬ʱ1Ҳп2.    1=order liveӻţ    2=order deadˣ
	EES_UserID          m_UserID;						///<  user id 
	EES_Nanosecond      m_AcceptTime;					///< 1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_Account         m_Account;						///< û
	EES_SideType        m_Side;							///< 
	EES_ExchangeID      m_Exchange;						///< 
	EES_Symbol          m_Symbol;						///< Լ
	EES_SecType         m_SecType;						///< Ʒ
	double              m_Price;						///< ۸
	unsigned int        m_Qty;							///< 
	EES_ForceCloseReason m_ForceCloseReason;			///<ǿƽԭ  0=ǿƽ, 1=ʽ,2=ͻ,3=Ա,4=ֲַ,5=Υ棬6=
	EES_OrderTif		m_Tif;							///< ûµʱֵָ
	unsigned int		m_MinQty;						///< ûµʱֵָ
	EES_CustomFieldType m_CustomField;					///< ûµʱֵָ
	EES_MarketSessionId m_MarketSessionId;				///< ϯλ룬пܺµʱָĲͬͬԭУǰϯλδӺãָϯλŷǷȣָ0REMо
	EES_HedgeFlag		m_HedgeFlag;					///< Ͷ־
};

/// µгϢ
struct EES_OrderMarketAcceptField
{
	EES_Account       m_Account;          ///< û
	EES_MarketToken   m_MarketOrderToken; ///< ʢϵͳĵӺţʢʱøúš
	EES_MarketOrderId m_MarketOrderId;    ///< г
	EES_Nanosecond    m_MarketTime;       ///< гʱϢ
	EES_UserID        m_UserID;			  ///<  user id 
	EES_ClientToken   m_ClientOrderToken; ///< ClientToken
	EES_OrderExchangeStatus	m_ExchangeStatus;	///< οEES_OrderExchangeStatus壬0=ͨ; 1=ֹӯֹ𵥴; 2=; 3= 
};

/// µ̨ϵͳܾ
struct EES_OrderRejectField
{
	EES_UserID				m_Userid;			///< ԭӵûӦLoginID
	EES_Nanosecond			m_Timestamp;		///< 1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_ClientToken			m_ClientOrderToken;	///< ԭӵtoken
	EES_RejectedMan			m_RejectedMan;		///< ˭ܾʢϵͳĽ 1=ʢ
	EES_ReasonCode			m_ReasonCode;		///< ӱܾɡűӡ±
	EES_GrammerResult		m_GrammerResult;	///< ﷨Ľ飬ÿַӳһּԭ򣬼ļĩβĸ¼
	EES_RiskResult			m_RiskResult;		///< ؼĽ飬ÿַӳһּԭ򣬼ļĩβĸ¼
	EES_GrammerResultText	m_GrammerText;		///< ﷨Ľ
	EES_RiskResultText		m_RiskText;			///< ؼĽ			
};

/// µгܾ
struct EES_OrderMarketRejectField
{
	EES_Account     m_Account;           ///< û
	EES_MarketToken m_MarketOrderToken;	 ///< ʢϵͳĵӺţʢʱøúš
	EES_Nanosecond  m_MarketTimestamp;   ///< гʱϢ, 1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_ReasonText2  m_ReasonText;		 ///< صĴַGB2312
	EES_ExchangeID  m_ExchangeId;		 ///< Ľ
	int				m_ExchangeErrorId;	 ///< apiĴ
	EES_UserID      m_UserID;			 ///<  user id 
	EES_ClientToken m_ClientOrderToken;  ///< ClientToken
};

/// ɽϢ
struct EES_OrderExecutionField
{
	EES_UserID        m_Userid;							///< ԭӵûӦLoginID
	EES_Nanosecond    m_Timestamp;						///< ɽʱ䣬1970110ʱ00뿪ʼʱ
	EES_ClientToken   m_ClientOrderToken;				///< ԭӵtoken
	EES_MarketToken   m_MarketOrderToken;				///< ʢϵͳĵӺţʢʱøúš
	unsigned int      m_Quantity;						///< ӳɽ
	double            m_Price;							///< ӳɽ
	EES_MarketToken   m_ExecutionID;					///< ӳɽ(TAG 1017)
	EES_MarketExecId  m_MarketExecID;					///< ɽ
};

/// µָ
struct EES_CancelOrder
{
	EES_MarketToken m_MarketOrderToken;					///< ʢϵͳĵӺţʢʱøúš
	unsigned int    m_Quantity;							///< ǸõӱȡϣʣµΪ0ĵΪȫȡйĿǰ0ֵ0
	EES_Account     m_Account;							///< ʻID
	EES_MarketSessionId m_MarketSessionId;				///< ϯλ룬OnResponseQueryMarketSessionIdȡϷֵ0ǷֵREMϵͳо͵ϯλ	m_ForceMarketSessionIdΪtrue	
	unsigned char	m_ForceMarketSessionId;				///< Ϊ1ͻָϯλ룬Ǹϯλû߷ǷʱָʾҪо͵ϯλǾܾµ
	unsigned char   m_ActionFlag;                       ///< 0=, 1=, 2=עںԴּ֧
	unsigned char   m_orderIdType;                      ///< 0 ϵͳų  1 صųҪдصm_ClientOrderToken
	EES_ClientToken  m_ClientOrderToken;				///< ԭص
	unsigned int    m_origOrderUserId;                  ///Ϊָuser_Id ҲΪ0 0ѵ¼user_idԶ

	EES_CancelOrder()
	{
		memset(this, 0, sizeof(*this));
	}
};

/// 
struct EES_OrderCxled
{ 
	EES_UserID        m_Userid;							///< ԭӵûӦLoginID
	EES_Nanosecond    m_Timestamp;						///< ʱ䣬1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_ClientToken   m_ClientOrderToken;				///< ԭӵtoken
	EES_MarketToken   m_MarketOrderToken;				///< ʢϵͳĵӺţʢʱøúš
	unsigned int      m_Decrement;						///< Ϣȡĵ
	EES_CxlReasonCode m_Reason;							///< ԭ򣬼±
};

/// ѯĽṹ
struct EES_QueryAccountOrder
{
	EES_UserID			m_Userid;						///< ԭӵûӦLoginID
	EES_Nanosecond		m_Timestamp;					///< ʱ䣬1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_ClientToken		m_ClientOrderToken;				///< ԭӵtoken 
	EES_SideType		m_SideType;						///< 1 = 򵥣 2 = ƽ  3= 򵥣ƽ 4 =   5= 򵥣ƽ 6= ƽ 21ƽƽƽģʽ 22ƽƽƽģʽ 
	unsigned int		m_Quantity;						///< ƱΪڻΪ
	EES_SecType			m_InstrumentType;				///< 1Equity Ʊ 2Options Ȩ 3Futures ڻ
	EES_Symbol			m_symbol;						///< Ʊ룬ڻȨ룬й׼ (Ŀǰ6λͿ)
	double				m_Price;						///< ۸
	EES_Account			m_account;						///< 61 16  Alpha ͻʺ.  ǴĿͻʺš֤󣬱ֵҲӵȱʡֵ
	EES_ExchangeID		m_ExchengeID;					///< 100Ͻ  101=  102=н  103=  104=  105=֣  255= done-away  See appendix 
	EES_ForceCloseReason m_ForceCloseReason;			///<ǿƽԭ  0=ǿƽ, 1=ʽ,2=ͻ,3=Ա,4=ֲַ,5=Υ棬6=
	EES_MarketToken		m_MarketOrderToken;				///< ʢϵͳĵӺţʢʱøúš 
	EES_OrderStatus		m_OrderStatus;					///< οEES_OrderStatusĶ
	EES_Nanosecond		m_CloseTime;					///< ر¼1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	int					m_FilledQty;					///< 0  4 Int4  ɽ
	EES_OrderTif		m_Tif;							///< ûµʱֵָ
	unsigned int		m_MinQty;						///< ûµʱֵָ
	EES_CustomFieldType m_CustomField;					///< ûµʱֵָ
	EES_MarketOrderId	m_MarketOrderId;				///< 
	EES_HedgeFlag		m_HedgeFlag;					///< Ͷ־
};
/// ѯɽĽṹ
struct EES_QueryOrderExecution
{
	EES_UserID			m_Userid;						///< ԭӵûӦLoginID
	EES_Nanosecond		m_Timestamp;					///< ɽʱ䣬1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_ClientToken		m_ClientOrderToken;				///< ԭӵtoken
	EES_MarketToken		m_MarketOrderToken;				///< ʢϵͳĵӺţʢʱøúš
	unsigned int		m_ExecutedQuantity;				///< ӳɽ
	double				m_ExecutionPrice;				///< ӳɽ
	EES_MarketToken		m_ExecutionID;					///< ӳɽ(TAG 1017)
	EES_MarketExecId	m_MarketExecID;					///< ɽ
};

/// һ˻жͳɽعɺϢ
struct EES_QueryAccountTradeFinish
{
	EES_Account			m_account;						///< ˻ID
};

/// ʻϢϢ
struct EES_AccountInfo
{
	EES_Account			m_Account;						///< ʻID 
	EES_Previlege		m_Previlege;					///< ȨޣĿǰӲݲ֧֣Ҳ˵ȫȨ 99ȫ  1ֻ 2ֻƽ
	double				m_InitialBp;					///< ʼȨ
	double				m_AvailableBp;					///< ܿʽ
	double				m_Margin;						///< вλռõı֤
	double				m_FrozenMargin;					///< йҵı֤
	double				m_CommissionFee;				///< ѿ۳ܽ
	double				m_FrozenCommission;				///< ҵѽ
};

/// ʻĲλϢ
struct EES_AccountPosition
{
	EES_Account			m_actId;						///< Value  Notes
	EES_Symbol			m_Symbol;						///< Լ/Ʊ
	EES_PosiDirection	m_PosiDirection;				///< շ 1ͷ 5ͷ
	unsigned int		m_InitOvnQty;					///< ҹֳʼֵ仯ͨHelpDeskֹ޸
	unsigned int		m_OvnQty;						///< ǰҹΪ0
	unsigned int		m_FrozenOvnQty;					///< 
	unsigned int		m_TodayQty;						///< ǰΪ0
	unsigned int		m_FrozenTodayQty;				///< Ľ
	double				m_OvnMargin;					///< ҹռñ֤
	double				m_TodayMargin;					///< ռõı֤
	double				m_PositionCost;
	EES_HedgeFlag		m_HedgeFlag;					///< λӦͶ־
};

struct EES_AccountOptionPosition
{
	EES_Account			m_actId;						///< Value  Notes û
	EES_Symbol			m_Symbol;						///< Լ/Ʊ
	EES_PosiDirection	m_PosiDirection;				///< շ 1ͷ 5ͷ
	EES_Symbol			m_UnderlyingSymbol;				///< ȨڻԼ
	char				m_CallPut;                      ///< ȨϹϹ
	double				m_StrikePrice;                  ///< ȨԼִм
	unsigned int		m_ExpireDate;                   ///< 
	unsigned int		m_InitOvnQty;					///< ҹֳʼֵ仯ͨHelpDeskֹ޸		
	unsigned int		m_CurOvnQty;                    /// ǰ
	unsigned int		m_CurTodayQty;                  /// ʣ
	unsigned int		m_CoverOvnLockedQty;            /// ƽƽģʽ²ʾ
	unsigned int		m_CoverTodayLockedQty;          /// ƽƽģʽ²ʾ
	unsigned int		m_ExecPendingQty;               ///< Ȩշȥûгɽرʱֵ0κȨ
	unsigned int		m_ExecAppliedQty;               ///< ȨѾյر
	unsigned int		m_CxlExecPendingQty;            ///  Ȩ;
	double				m_LiquidPl;                      ///<ƽӯ
	double				m_AvgPrice;	                     ///<
	double				m_TotalCommissionFee;            ///<
	EES_HedgeFlag		m_HedgeFlag;					///< λӦͶ־
};

/// ʻʽϢ
struct EES_AccountBP
{
	EES_Account			m_account;						///< Value  Notes
	double				m_InitialBp;					///< ʼȨ
	double				m_AvailableBp;					///< ܿʽ
	double				m_Margin;						///< вλռõı֤
	double				m_FrozenMargin;					///< йҵı֤
	double				m_CommissionFee;				///< ѿ۳ܽ
	double				m_FrozenCommission;				///< ҵѽ
	double				m_OvnInitMargin;				///< ʼֱ֤
	double				m_TotalLiquidPL;				///< ƽӯ
	double				m_TotalMarketPL;				///< ֲܳӯ
};

/// Լб
struct EES_SymbolField
{
	EES_SecType			m_SecType;						///< 3=FutureĿǰ֧ڻ
	EES_Symbol			m_symbol;						///< Լ/Ʊ
	EES_SymbolName		m_symbolName;					///< Լ
	EES_ExchangeID		m_ExchangeID;					///< 102=н   103=    104=    105=֣
	EES_ProductID		m_ProdID;						///< Ʒ
	unsigned int		m_DeliveryYear;					///< 
	unsigned int		m_DeliveryMonth;				///< 
	unsigned int		m_MaxMarketOrderVolume;			///< м۵µ
	unsigned int		m_MinMarketOrderVolume;			///< м۵Сµ
	unsigned int		m_MaxLimitOrderVolume;			///< ޼۵µ
	unsigned int		m_MinLimitOrderVolume;			///< ޼۵Сµ
	unsigned int		m_VolumeMultiple;				///< Լ
	double				m_PriceTick;					///< С䶯λ 
	unsigned int		m_CreateDate;					///< 
	unsigned int		m_OpenDate;						///< 
	unsigned int		m_ExpireDate;					///< , ȨҲøֵ
	unsigned int		m_StartDelivDate;				///< ʼ
	unsigned int		m_EndDelivDate;					///< 
	unsigned int		m_InstLifePhase;				///< Լ״̬   0=δ    1=    2=ͣ    3=
	unsigned int		m_IsTrading;					///< ǰǷ   0=δ    1=
	double				m_StrikePrice;					///< ȨԼִм, ڻֵΪ0
	char				m_CallPut;						///< ȨϹϹ
	EES_Symbol			m_UnderlyingSymbol;				///< ȨڻԼ
};

/// ѯʻı֤
struct EES_AccountMargin
{
	EES_HedgeFlag		m_HedgeFlag;					///< Ͷ־
	EES_Symbol			m_symbol;						///< Լ/Ʊ
	EES_ExchangeID		m_ExchangeID;					///< 102=н   103=    104=    105=֣
	EES_ProductID		m_ProdID;						///< 4  Alpha Ʒ
	double				m_LongMarginRatio;				///< ֱ֤
	double				m_ShortMarginRatio;				///< ղֱ֤ʣĿǰò
};

/// ʻԼʲѯ
struct EES_AccountFee
{
	EES_HedgeFlag		m_HedgeFlag;					///< Ͷ־
	EES_Symbol			m_symbol;						///<  Լ/Ʊ
	EES_ExchangeID		m_ExchangeID;					///<  102=н    103=    104=    105=֣
	EES_ProductID		m_ProdID;						///<  Ʒ
	double				m_OpenRatioByMoney;				///<  ʣս
	double				m_OpenRatioByVolume;			///<  ʣ
	double				m_CloseYesterdayRatioByMoney;	///<  ƽʣս
	double				m_CloseYesterdayRatioByVolume;	///<  ƽʣ
	double				m_CloseTodayRatioByMoney;		///<  ƽʣս
	double				m_CloseTodayRatioByVolume;		///<  ƽʣ
	EES_PosiDirection	m_PositionDir;					///<  1: ͷ2: ͷ
};

/// ܾϢ
struct EES_CxlOrderRej
{
	EES_Account			m_account;						///< ͻʺ. 
	EES_MarketToken		m_MarketOrderToken;				///< ʢڲõorderID
	unsigned int		m_ReasonCode;					///< 룬ÿַӳһּԭ򣬼ļĩβĸ¼öλʾһԭ
	EES_ReasonText		m_ReasonText;					///< ַδʹ
	EES_UserID			m_UserID;						///< Ҫ user idΪҲԭΪ0
	EES_ClientToken		m_ClientOrderToken;				///< ҪClientTokenΪҲԭΪ0
	EES_ExchangeID		m_ExchangeID;					///< ܾԴ0=ֱ̨Ӿܾ102/103/104ֵʾĳܾ
	unsigned char		m_ActionFlag;                   ///< 0=, 1=, 2=עںԴּ֧
};

/// 
struct EES_PostOrder
{
	EES_UserID			m_Userid;						///< ԭӵûӦLoginID
	EES_Nanosecond		m_Timestamp;					///< ʱ䣬1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_MarketToken		m_MarketOrderToken;				///< ʢϵͳĵӺţʢʱøúš
	EES_ClientToken		m_ClientOrderToken;				///< ãΪ
	EES_SideType		m_SideType;						///< Buy/Sell Indicator 27  1 Int1  1 = 򵥣    2 = ƽ    3= 򵥣ƽ   4=    5= 򵥣ƽ   6= ƽ  21ƽƽƽģʽ 22ƽƽƽģʽ
	unsigned int		m_Quantity;						///< ƱΪڻΪ
	EES_SecType			m_SecType;						///< 1Equity Ʊ   2Options Ȩ   3Futures ڻ
	EES_Symbol			m_Symbol;						///< Ʊ룬ڻȨ룬й׼ (Ŀǰ6λͿ)
	double				m_price;						///< ۸ 
	EES_Account			m_account;						///< ͻʺ.  ǴĿͻʺš֤󣬱ֵҲӵȱʡֵ
	EES_ExchangeID		m_ExchangeID;					///< 255=Done-away
	EES_ForceCloseReason m_ForceCloseReason;			///<ǿƽԭ  0=ǿƽ, 1=ʽ,2=ͻ,3=Ա,4=ֲַ,5=Υ棬6=
	EES_OrderState		m_OrderState;					///< ״̬ʱ1Ҳп2.    1=order liveӻţ    2=order deadˣ
	EES_MarketOrderId	m_ExchangeOrderID;				///< ţ˹ֵΪհ
	EES_HedgeFlag		m_HedgeFlag;					///< Ͷ־
};

/// ɽ
struct EES_PostOrderExecution
{
	EES_UserID			m_Userid;						///< ԭӵûӦLoginID
	EES_Nanosecond		m_Timestamp;					///< ɽʱ䣬1970110ʱ00뿪ʼʱ䣬ʹConvertFromTimestampӿתΪɶʱ
	EES_MarketToken		m_MarketOrderToken;				///< ʢϵͳĵӺţʢʱøúš
	unsigned int		m_ExecutedQuantity;				///< ӳɽ
	double				m_ExecutionPrice;				///< ӳɽ
	EES_MarketToken		m_ExecutionNumber;				///< ӳɽ
	EES_MarketExecId	m_MarketExecID;					///< ɽ
};


struct EES_ExchangeMarketSession
{	
	EES_ExchangeID			m_ExchangeID;					///< 102=н    103=    104=    105=֣	
	unsigned char			m_SessionCount;					///ýҲΪm_SessionIdǰλЧ255
	EES_MarketSessionId		m_SessionId[255];				///ϷĽӴ
};

struct EES_SymbolStatus
{	
	EES_ExchangeID	m_ExchangeID;		///< 102=н    103=    104=    105=֣	
	EES_Symbol		m_Symbol;			///< Լ
	unsigned char	m_InstrumentStatus;	///< ״̬ '0':ǰ; '1':ǽ; '2':; '3':Ͼ۱; '4'Ͼۼ۸ƽ; '5':Ͼ۴; '6': ;
	unsigned int	m_TradingSegmentSN;	///< ׽׶α
	char			m_EnterTime[9];		///< 뱾״̬ʱ
	unsigned char	m_EnterReason;		///< 뱾״̬ԭ: '1': Զл; '2': ֶл; '3': ۶; '4': ۶ֶ;
};

struct EES_MarketMBLData
{
	unsigned int		m_RequestId;					///< ʱid
	unsigned int		m_Result;						///< 0Ϊأ0Ϊִ
	EES_Symbol			m_symbol;						///< Լ/Ʊ	
	EES_ExchangeID		m_ExchangeID;					///< 102=н   103=    104=    105=֣
	double				m_Price;						///< ۸
	int					m_Volume;						///< 
	unsigned char		m_IsBid;						///< 1: 飬0:
};

struct EES_TradeSvrInfo
{
	char            m_remoteTradeIp[16];  /// IP
	unsigned short  m_remoteTradeTCPPort; /// TCP˿
	unsigned short  m_remoteTradeUDPPort; /// UDP˿

	char            m_remoteQueryIp[16];  /// ѯIP
	unsigned short  m_remoteQueryTCPPort; /// ѯTCP˿

	char            m_LocalTradeIp[16];   /// ؽIP
	unsigned short  m_LocalTradeUDPPort;  /// ؽUDP˿

	EES_TradeSvrInfo()
	{
		memset((void*)this, 0, sizeof(EES_TradeSvrInfo));
	}
};

struct EES_SessionID
{
	char				m_TradeNo[17];///ϯλ
	unsigned int		m_Result;///0:ɹ1:û󶨵˻ûͣȨޣ2:ǰϵͳ󶨲ڸýϯλĽϯλӦ
	int			        m_SessionID;///ϯλ
};

#pragma pack(pop)

// Ϊ EES_OrderRejectField::m_ReasonCodeȡֵ˵ίбܾ˵ܾԭ
//	0 - 22Ϊ﷨
//	
//	0	ͱʱִ
//	1	ǿƽԭǷĿǰֻ֧֡0-ǿƽ
//	2	Ƿ
//	3	ʹ
//	4	TIFںϷֵΧĿǰֻ֧֣EES_OrderTif_IOC(0)  EES_OrderTif_Day(99998)
//	5	ʹ
//	6	ίм۸>0
//	7	ʹ
//	8	ʹ
//	9	ƷֲϷĿǰֻ֧֡3-ڻ
//	10	ίϷ>0
//	11	ʹ
//	12	򲻺ϷĿǰֻ֧1-6 21 22
//	13	ʹ
//	14	ûȨ޵˻в
//	15	ίбظ
//	16	ڵ˻
//	17	ϷĺԼ
//	18	ίޣĿǰϵͳÿ850ί
//	19	ùע
//	20	ʽ˺δȷý
//	21	m_MinQtyֵm_Qty
//	22	нӶڶϿ״̬ʱܾ
//  23	ǰ˻ûȨȨ
//	24	¼ûsession
	
// 50- 116ɷؾܾɣϰзؾܾɾԭļ 2020/8/12
// 
//	51	ռ̱֤
//	65	ֹ
//	70	ܹҵУ
//	114	ʽ
//	115	ƽλ

//	ָľܾԭձ,öλʾһԭ,һλΪ1ʾλӦԭΪ
//  REMֱӾܾĴ룺
//  m_ExchangeID = 0 
//	5			-  Ҳ
//	33			-  ѳѳɽ
//	3			-  δг
//	129			-  ⲿܴӱϵͳ
//	513			-  ޿ڳϯλ
//	257			-  ͻŻߵ¼Ŵ
//	17			-  ͻŻߵ¼Ŵ
//	1025		-  ϯλ
//	2049		-  ϯλѶϿ
//  5957        -  ظ
//  5958        -  ظ
//	4097		-  ڲ1
//	8193		-  ڲ2
//	16385		-  ڲ3
//	32769		-  δ𿪹
//	65537		-  ڲ5
//	131073		-  ڲ6
//	262145		-  

//֪Ĵ룺 m_ExchangeID = 103
//	26 - غԼǽʱ
//	28 - Ѿȫɽ
//	29 - Ѿ
//	49 - ۸񳬳ͣ

//֪Ĵ룺 m_ExchangeID = 104
//	40039 - Ѿ
//	40040 - ȫɽ,ܳ!
//	40054 - ܳûĶ
//	72003 - ޴˳
#endif
