/*!****************************************************************************
 @note   Copyright (coffee), 2005-2014, Shengli Tech. Co., Ltd.
 @file   EESQuoteDemo.h
 @date   2014/4/27   12:31
 @author zhou.hu
 
 \brief  本类演示是EES行情API的使用示例。

 @note 
******************************************************************************/

#pragma once

#ifdef WIN32
/// add by zhou.hu review 2014/4/22 Windwos平台引用的头文件
#include <Windows.h>

typedef HMODULE		T_DLL_HANDLE;

#else
/// add by zhou.hu review 2014/4/22 linux平台引用的头文件
#include <stdlib.h>
#include <stdio.h>
#include <dlfcn.h>
#include <string.h>

typedef void*		T_DLL_HANDLE;

#endif

#include <string>
#include "../include/quote/C++/EESQuoteApi.h"

using std::string;

class QuoteDemo : public EESQuoteEvent
{
public:
	QuoteDemo(void);
	virtual ~QuoteDemo(void);
	
	/// \brief 测试入口函数
	void Run();

private:
	/// \brief 初始化
	bool Init();
	/// \brief 关闭
	void Close();

	/// \brief 暂停
	void Pause();

private:
	/// \brief 加载EES行情API的动态库
	bool LoadEESQuote();
	/// \brief 释放EES行情API的动态库
	void UnloadEESQuote();

	/// \brief Windows版加载行情API的动态库
	bool Windows_LoadEESQuote();
	/// \brief Windows版释放行情API的动态库
	void Windows_UnloadEESQuote();

	/// \brief Linux版本加载行情API的动态库
	bool Linux_LoadEESQuote();
	/// \brief Linux版本释放行情API的动态库
	void Linux_UnloadEESQuote();

	/// \brief 初始化参数调整方法
	void InputParam();

	/// \brief 登录
	void Logon();
	/// \brief 查询所有合约
	void QueryAllSymbol();
	/// \brief 显示行情信息
	void ShowQuote(EESMarketDepthQuoteData* pQuote);
	
private:

	/// \brief 当服务器连接成功，登录前调用, 如果是组播模式不会发生, 只需判断InitMulticast返回值即可
	virtual void OnEqsConnected();
	/// \brief 当服务器曾经连接成功，被断开时调用，组播模式不会发生该事件
	virtual void OnEqsDisconnected();
	/// \brief 当登录成功或者失败时调用，组播模式不会发生
	virtual void OnLoginResponse(const char* eqsId, bool bSuccess, const char* pReason);
	/// \brief 收到行情时调用,具体格式根据instrument_type不同而不同
	virtual void OnQuoteUpdated(EqsExchangeId exchangeId, EESMarketDepthQuoteData* pDepthQuoteData);
	/// \brief 日志接口，让使用者帮助写日志。
	virtual void OnWriteTextLog(EesEqsLogLevel nlevel, const char* pLogText, int nLogLen);
	/// \brief 注册symbol响应消息来时调用，组播模式不支持行情注册
	virtual void OnSymbolRegisterResponse(EqsExchangeId exchangeId, const char* pSymbol, bool bSuccess);
	/// \brief  注销symbol响应消息来时调用，组播模式不支持行情注册
	virtual void OnSymbolUnregisterResponse(EqsExchangeId exchangeId, const char* pSymbol, bool bSuccess);
	/// \brief 查询symbol列表响应消息来时调用，组播模式不支持合约列表查询
	virtual void OnSymbolListResponse(const char* eqsId, EqsExchangeId exchangeId, const char* pSymbol, bool bLast);
    /// \brief 查询交易所对应的合约信息
    virtual void OnQuerySymbolQuoteResponse(EqsExchangeId exchangeId, const char *pSymbol, EESMarketDepthQuoteData *pDepthQuoteData);


private:
	EESQuoteApi*				m_eesApi;				///< EES行情API接口
	T_DLL_HANDLE				m_handle;				///< EES行情API句柄
	funcDestroyEESQuoteApi		m_distoryFun;			///< EES行情API对象销毁函数

	string						m_quoteServerIp;		///< 行情服务器IP
	int							m_quotePort;			///< 行情服务器端口
	vector<EqsTcpInfo>			m_vec_ServerInfo;		///< 需要连接的行情服务信息
	string						m_logonId;				///< 登录编号
	string						m_logonPwd;				///< 登录密码


	int                         m_regSymCount;
	char						m_c_need_quote_type;	///< 需要连接行情类型

	bool 						m_b_logoned;			///< 是否已经登陆
};

