/*! \file  EesTraderDefine.h
 *  \brief EES׿ͻAPIʹõϢ嶨塣
 *
 *  ļϸEES׿ͻAPIʹõݽṹԼϢ塣 
*/
#pragma  once 


#ifndef _EES_TRADE_API_STRUCT_DEFINE_H_
#define _EES_TRADE_API_STRUCT_DEFINE_H_

#define SL_EES_API_VERSION    "0.0.1.0"   ///<  api Э汾

typedef int RESULT ;      ///< 巵ֵ 
typedef int ERR_NO ;      ///< ֵ 

typedef int           EES_ClientToken ; ///< API˶ĿͻID
typedef int           EES_UserID ;      ///< ʻID
typedef long long int EES_MarketToken ; ///< г ID
typedef int           EES_TradingDate ; ///< 
typedef long long int EES_Nanosecond ;  ///< ʱ

typedef char    EES_Account[17] ;      ///< ʻ
typedef char    EES_ProductID[5] ;     ///< ڻĲƷ

typedef char    EES_ReasonText[64];    ///< 

typedef char    EES_GrammerResult[32]; ///< µ﷨
typedef char    EES_RiskResult[96];    ///< µؼ
                              
typedef char    EES_Symbol[9] ;        ///< ׺Լ
typedef char    EES_SymbolName[21] ;   ///< ׺Լ

typedef unsigned char EES_SideType ;            ///< 
#define EES_SideType_open_long                  1   ///< =򵥣
#define EES_SideType_close_today_long           2   ///< =ƽ
#define EES_SideType_close_today_short          3   ///< =򵥣ƽ
#define EES_SideType_open_short                 4   ///< =
#define EES_SideType_close_ovn_short            5   ///< =򵥣ƽ
#define EES_SideType_close_ovn_long             6   ///< =ƽ
#define EES_SideType_force_close_ovn_short      7   ///< = ǿƽ
#define EES_SideType_force_close_ovn_long       8   ///< = ǿƽ
#define EES_SideType_force_close_today_short    9   ///< = ǿƽ
#define EES_SideType_force_close_today_long     10  ///< = ǿƽ

typedef unsigned char EES_ExchangeID ;          ///< ID
#define EES_ExchangeID_sh_cs                    100   ///< =Ͻ
#define EES_ExchangeID_sz_cs                    101   ///< =
#define EES_ExchangeID_cffex                    102   ///< =н
#define EES_ExchangeID_shfe                     103   ///< =
#define EES_ExchangeID_dce                      104   ///< =
#define EES_ExchangeID_zcze                     105   ///< =֣
#define EES_ExchangeID_done_away                255   ///< =Done-away 


typedef unsigned char EES_SecType ;             ///< Ʒ 
#define EES_SecType_cs                          1   ///< =Ʊ
#define EES_SecType_options                     2   ///< =Ȩ
#define EES_SecType_fut                         3   ///< =ڻ


typedef unsigned char EES_ForceCloseType ;      ///< ǿƽԭ 
#define EES_ForceCloseType_not_force_close      0   ///< =ǿƽ  
#define EES_ForceCloseType_not_enough_bp        1   ///< =ʽ  
#define EES_ForceCloseType_not_enough_position  2   ///< =ͻ  
#define EES_ForceCloseType_not_enough_position2 3   ///< =Ա  
#define EES_ForceCloseType_not_round_lot        4   ///< =ֲַ  
#define EES_ForceCloseType_invalid              5   ///< =Υ
#define EES_ForceCloseType_other                6   ///< =

typedef unsigned char EES_OrderState ;          ///< ״̬
#define EES_OrderState_order_live               1   ///< =ӻ
#define EES_OrderState_order_dead               2   ///< =

typedef int           EES_Previlege ;           ///< ĿǰӲݲ֧֣Ҳ˵ȫȨ 99ȫ  1ֻ 2ֻƽ
#define EES_Previlege_open_and_close            99    ///< =Ȩ
#define EES_Previlege_readonly                  1     ///< =ֻ
#define EES_Previlege_close_only                2     ///< =ֻƽ


typedef int     EES_PosiDirection;      ///< շ 1ͷ 5ͷ
#define EES_PosiDirection_long          1   ///< =ͷ
#define EES_PosiDirection_short         5   ///< =ͷ


typedef unsigned char EES_RejectedMan;  ///< ˭ܾʢϵͳĽ 1=ʢ
#define EES_RejectedMan_by_shengli      1     ///< =ʢܾ

typedef unsigned char EES_ReasonCode;         ///< ӱܾɡűӡ±

typedef unsigned char EES_CxlReasonCode ; ///< ɹԭ
#define EES_CxlReasonCode_by_account      1   ///< =û
#define EES_CxlReasonCode_timeout         2   ///< =ϵͳtimeout, ӵڱϵͳȡ
#define EES_CxlReasonCode_supervisory     3   ///< =Supervisory, ʢϵͳȡ
#define EES_CxlReasonCode_by_market       4   ///< =гܾ
#define EES_CxlReasonCode_another       255   ///< =

typedef unsigned char EES_OrderStatus;    ///< ö廹ԺҪ
#define EES_OrderStatus_                  0   ///< =ҵȫɽ  
#define EES_OrderStatus_cxled             1   ///< =Ѿ  
#define EES_OrderStatus_reject            2   ///< =ܾ  
#define EES_OrderStatus_expiration        3   ///< =ѹڣѾ


#pragma pack(push, 1)


/// ¼صϢ
struct EES_LogonResponse
{
  int               m_Result;           ///< 0ʾ¼ɹ0ʾ¼ʧܣʧʱ᷵UserId   0-  ¼ɹ    1-  û/   2-  û⣬˻бΪյ
  EES_UserID        m_UserId;           ///< ¼ӦûID
  unsigned int      m_TradingDate;      ///< գʽΪyyyyMMddintֵ
  EES_ClientToken   m_MaxToken;         ///< ǰ token 
};


/// µϢ
struct EES_EnterOrderField
{ 
  EES_Account         m_Account;          ///< û
  EES_SideType        m_Side ;            ///< 
  EES_ExchangeID      m_Exchange;         ///< 
  EES_Symbol          m_Symbol;           ///< Լ
  EES_SecType         m_SecType ;         ///< Ʒ
  double              m_Price ;           ///< ۸
  unsigned int        m_Qty ;             ///< 
  EES_ForceCloseType  m_ForceCloseReason ;///< ǿƽԭ
};

/// µгϢ
struct EES_OrderAcceptField
{ 
  EES_ClientToken     m_ClientOrderToken ;      ///< µʱ򣬷ظtoken
  EES_MarketToken     m_MarketOrderToken;       ///< гҵtoken
  EES_OrderState      m_OrderState ;            ///< ״̬
  EES_UserID          m_UserID ;                ///<  user id 
  EES_Nanosecond      m_AcceptTime ;            ///< 賿ʼ0ʱ
  EES_Account         m_Account;                ///< û
  EES_SideType        m_Side ;                  ///< 
  EES_ExchangeID      m_Exchange;               ///< 
  EES_Symbol          m_Symbol;                 ///< Լ
  EES_SecType         m_SecType ;               ///< Ʒ
  double              m_Price ;                 ///< ۸
  unsigned int        m_Qty ;                   ///< 
  EES_ForceCloseType  m_ForceCloseReason ;      ///< ǿƽԭ
};


/// µгܾ
struct EES_OrderRejectField
{
  EES_UserID        m_Userid ;            ///< ԭӵûӦLoginID
  EES_Nanosecond    m_Timestamp ;         ///< ʱ䣬ʱ
  EES_ClientToken   m_ClientOrderToken ;  ///< ԭӵtoken
  EES_RejectedMan   m_RejectedMan ;       ///< ˭ܾʢϵͳĽ 1=ʢ
  EES_ReasonCode    m_ReasonCode  ;       ///< ӱܾɡűӡ±
  EES_GrammerResult m_Grammer_result ;    ///< ﷨Ľ飬ÿַӳһּԭ򣬼ļĩβĸ¼
  EES_RiskResult    m_RriskResult ;       ///< ؼĽ飬ÿַӳһּԭ򣬼ļĩβĸ¼
};

/// ɽϢ
struct EES_OrderExecutionField
{
  EES_UserID        m_Userid ;            ///< ԭӵûӦLoginID
  EES_Nanosecond    m_Timestamp ;         ///< ʱ䣬ʱ
  EES_ClientToken   m_ClientOrderToken ;  ///< ԭӵtoken
  EES_MarketToken   m_MarketOrderToken ;  ///< ʢϵͳĵӺţʢʱøúš
  unsigned int      m_Quantity;           ///< ӳɽ
  double            m_Price;              ///< ӳɽ
  EES_MarketToken   m_ExecutionID ;       ///< ӳɽ(TAG 1017)
};

/// µָ
struct EES_CancelOrder
{
  EES_MarketToken m_MarketOrderToken;   ///< ʢϵͳĵӺţʢʱøúš
  unsigned int    m_Quantity ;          ///< ǸõӱȡϣʣµΪ0ĵΪȫȡйĿǰ0ֵ0
  EES_Account     m_Account;            ///< ʻID
};

/// 
struct EES_OrderCxled
{ 
  EES_UserID        m_Userid ;            ///< ԭӵûӦLoginID
  EES_Nanosecond    m_Timestamp ;         ///< ʱ䣬ʱ
  EES_ClientToken   m_ClientOrderToken ;  ///< ԭӵtoken
  EES_MarketToken   m_MarketOrderToken ;  ///< ʢϵͳĵӺţʢʱøúš
  unsigned int      m_Decrement ;         ///< Ϣȡĵ
  EES_CxlReasonCode m_Reason ;            ///< ԭ򣬼±
};

/// ѯĽṹ
struct EES_QueryAccountOrder
{
  EES_UserID        m_Userid ;            ///< ԭӵûӦLoginID
  EES_Nanosecond    m_Timestamp ;         ///< 6  8 Int8  ʱ䣬ʱ
  EES_ClientToken   m_ClientOrderToken ;  ///< ԭӵtoken 
  EES_SideType      m_SideType ;          ///< 1 = 򵥣 2 = ƽ  3= 򵥣ƽ 4 =   5= 򵥣ƽ 6= ƽ 7=򵥣ǿƽ  8=ǿƽ  9=򵥣ǿƽ  10=򵥣ǿƽ
  unsigned int      m_Quantity ;          ///< ƱΪڻΪ
  EES_SecType       m_InstrumentType ;    ///< 1Equity Ʊ 2Options Ȩ 3Futures ڻ
  EES_Symbol        m_symbol ;            ///< Ʊ룬ڻȨ룬й׼ (Ŀǰ6λͿ)
  double            m_Price;              ///< ۸
  EES_Account       m_account;            ///< 61 16  Alpha ͻʺ.  ǴĿͻʺš֤󣬱ֵҲӵȱʡֵ
  EES_ExchangeID    m_ExchengeID ;           ///< 100Ͻ  101=  102=н  103=  104=  105=֣  255= done-away  See appendix 
  EES_ForceCloseType  m_ForceCloseReason ;   ///< ǿƽԭ - 0=ǿƽ  - 1=ʽ  - 2=ͻ  - 3=Ա  - 4=ֲַ  - 5=Υ  - 6=
  EES_MarketToken   m_OrderReferenceNumber ; ///< ʢϵͳĵӺţʢʱøúš 
  EES_OrderStatus   m_OrderStatus ;          ///< 0ҵȫɽ  1Ѿ 2ܾ 3ѹڣѾ
  EES_Nanosecond    m_CloseTime ;            ///< 0  8 Int8  Ѿȫɽ߳߾ֵܾЧ
  int               m_FilledQty ;            ///< 0  4 Int4  ɽ
};
/// ѯɽĽṹ
struct EES_QueryOrderExecution
{
  EES_UserID        m_Userid ;            ///< ԭӵûӦLoginID
  EES_Nanosecond    m_Timestamp ;         ///< ʱ䣬ʱ
  EES_ClientToken   m_ClientOrderToken ;  ///< ԭӵtoken
  EES_MarketToken   m_MarketOrderToken ;  ///< ʢϵͳĵӺţʢʱøúš
  unsigned int      m_ExecutedQuantity ;  ///< ӳɽ
  double            m_ExecutionPrice  ;   ///< ӳɽ
  EES_MarketToken   m_ExecutionID ;       ///< ӳɽ(TAG 1017)
};

/// һ˻жͳɽعɺϢ
struct EES_QueryAccountTradeFinish
{
  EES_Account     m_account ;  ///< ˻ID
};

/// ʻϢϢ
struct EES_AccountInfo
{
  EES_Account     m_Account ;         ///< ʻID 
  EES_Previlege   m_Previlege ;       ///< ȨޣĿǰӲݲ֧֣Ҳ˵ȫȨ 99ȫ  1ֻ 2ֻƽ
  double          m_InitialBp ;       ///< ʼȨ
  double          m_AvailableBp ;     ///< ܿʽ
  double          m_Margin ;          ///< вλռõı֤
  double          m_FrozenMargin ;    ///< йҵı֤
  double          m_CommissionFee  ;  ///< ѿ۳ܽ
  double          m_FrozenCommission ;///< ҵѽ
};

/// ʻĲλϢ
struct EES_AccountPosition
{
  EES_Account     m_actId;            ///< Value  Notes
  EES_Symbol      m_Symbol ;          ///< Լ/Ʊ
  EES_PosiDirection m_PosiDirection;  ///< շ 2ͷ 3ͷ
  unsigned int    m_InitOvnQty;       ///< ҹֳʼֵ仯ͨHelpDeskֹ޸
  unsigned int    m_OvnQty;           ///< ǰҹΪ0
  unsigned int    m_FrozenOvnQty;     ///< 
  unsigned int    m_TodayQty;         ///< ǰΪ0
  unsigned int    m_FrozenTodayQty;   ///< Ľ
  double          m_OvnMargin  ;      ///< ҹռñ֤
  double          m_TodayMargin ;     ///< ռõı֤
};

/// ʻĲλϢ
struct EES_AccountBP
{
  EES_Account   m_account;            ///< Value  Notes
  double        m_InitialBp ;         ///< ʼȨ
  double        m_AvailableBp ;       ///< ܿʽ
  double        m_Margin ;            ///< вλռõı֤
  double        m_FrozenMargin ;      ///< йҵı֤
  double        m_CommissionFee  ;    ///< ѿ۳ܽ
  double        m_FrozenCommission ;  ///< ҵѽ
  double        m_OvnInitMargin;      ///< ʼֱ֤
  double        m_TotalLiquidPL;      ///< ƽӯ
  double        m_TotalMarketPL;      ///< ֲܳӯ
};

/// Լб
struct EES_SymbolField
{
  EES_SecType     m_SecType ;               ///< 3=FutureĿǰֻ
  EES_Symbol      m_symbol  ;               ///< Լ/Ʊ
  EES_SymbolName  m_symbolName ;            ///< Լ
  EES_ExchangeID  m_ExchangeID ;            ///< 102=н   103=    104=    105=֣
  EES_ProductID   m_ProdID ;                ///< Ʒ
  unsigned int    m_DeliveryYear ;          ///< 
  unsigned int    m_DeliveryMonth ;         ///< 
  unsigned int    m_MaxMarketOrderVolume ;  ///< м۵µ
  unsigned int    m_MinMarketOrderVolume ;  ///< м۵Сµ
  unsigned int    m_MaxLimitOrderVolume ;   ///< ޼۵µ
  unsigned int    m_MinLimitOrderVolume ;   ///< ޼۵Сµ
  unsigned int    m_VolumeMultiple;         ///< Լ
  double          m_PriceTick;              ///< С䶯λ 
  unsigned int    m_CreateDate;             ///< 
  unsigned int    m_OpenDate ;              ///< 
  unsigned int    m_ExpireDate ;            ///< 
  unsigned int    m_StartDelivDate ;        ///< ʼ
  unsigned int    m_EndDelivDate;           ///< 
  unsigned int    m_InstLifePhase ;         ///< Լ״̬   0=δ    1=    2=ͣ    3=
  unsigned int    m_IsTrading;              ///< ǰǷ   0=δ    1=
} ;

/// ѯʻı֤
struct EES_AccountMargin
{
  EES_SecType     m_SecType ;           ///< 3=FutureĿǰֻ
  EES_Symbol      m_symbol ;            ///< Լ/Ʊ
  EES_ExchangeID  m_ExchangeID ;        ///< 102=н   103=    104=    105=֣
  EES_ProductID   m_ProdID;             ///< 4  Alpha Ʒ
  double          m_LongMarginRatio ;   ///< ֱ֤
  double          m_ShortMarginRatio ;  ///< ղֱ֤ʣĿǰò
};

/// ʻԼʲѯ
struct EES_AccountFee
{
  EES_SecType     m_SecType ;                    ///<  3=FutureĿǰֻ
  EES_Symbol      m_symbol ;                     ///<  Լ/Ʊ
  EES_ExchangeID  m_ExchangeID  ;                ///<  102=н    103=    104=    105=֣
  EES_ProductID   m_ProdID ;                     ///<  Ʒ
  double          m_OpenRatioByMoney ;           ///<  ʣս
  double          m_OpenRatioByVolume ;          ///<  ʣ
  double          m_CloseYesterdayRatioByMoney;  ///<  ƽʣս
  double          m_CloseYesterdayRatioByVolume; ///<  ƽʣ
  double          m_CloseTodayRatioByMoney;      ///<  ƽʣս
  double          m_CloseTodayRatioByVolume ;    ///<  ƽʣ
} ;

/// ܾϢ
struct EES_CxlOrderRej
{
  EES_Account       m_account  ;            ///< ͻʺ. 
  EES_MarketToken   m_MarketOrderToken;     ///< ʢڲõorderID
  unsigned int      m_ReasonCode ;          ///< 룬ÿַӳһּԭ򣬼ļĩβĸ¼
  EES_ReasonText    m_ReasonText ;          ///< ַδʹ
};

/// 
struct EES_PostOrder
{
  EES_UserID        m_Userid  ;           ///< ԭӵûӦLoginID
  EES_Nanosecond    m_Timestamp ;         ///< ʱ䣬ʱ
  EES_MarketToken   m_MarketOrderToken ;  ///< ʢϵͳĵӺţʢʱøúš
  EES_ClientToken   m_ClientOrderToken ;  ///< ãΪ
  EES_SideType      m_SideType ;          ///< Buy/Sell Indicator 27  1 Int1  1 = 򵥣    2 = ƽ    3= 򵥣ƽ   4=    5= 򵥣ƽ   6= ƽ   7=  ǿƽ    8=  ǿƽ    9=  ǿƽ    10= ǿƽ
  unsigned int      m_Quantity ;          ///< ƱΪڻΪ
  EES_SecType       m_SecType ;           ///< 1Equity Ʊ   2Options Ȩ   3Futures ڻ
  EES_Symbol        m_Symbol;             ///< Ʊ룬ڻȨ룬й׼ (Ŀǰ6λͿ)
  double            m_price ;             ///< ۸ 
  EES_Account       m_account;            ///< ͻʺ.  ǴĿͻʺš֤󣬱ֵҲӵȱʡֵ
  EES_ExchangeID    m_ExchangeID ;        ///< 255=Done-away
  EES_ForceCloseType  m_ForceCloseReason ;   ///< ã   ǿƽԭ    - 0=ǿƽ    - 1=ʽ    - 2=ͻ    - 3=Ա    - 4=ֲַ    - 5=Υ    - 6=
  EES_OrderState    m_OrderState ;        ///< ״̬ʱ1Ҳп2.    1=order liveӻţ    2=order deadˣ
};

/// ɽ
struct EES_PostOrderExecution
{
  EES_UserID      m_Userid ;            ///< ԭӵûӦLoginID
  EES_Nanosecond  m_Timestamp ;         ///< ʱ䣬ʱ
  EES_MarketToken m_MarketOrderToken;   ///< ʢϵͳĵӺţʢʱøúš
  unsigned int    m_ExecutedQuantity;   ///< ӳɽ
  double          m_ExecutionPrice;     ///< ӳɽ
  EES_MarketToken  m_ExecutionNumber;   ///< ӳɽ
};

#pragma pack(pop)

//	ίָľܾԭ﷨ձ
//	0	κԭɾܾλΪ1
//	1	ǿƽԭǷĿǰֻ֧֡0-ǿƽ
//	2	ǷĿǰֻ֧֡102-н
//	3	ʹ
//	4	ʹ
//	5	ʹ
//	6	ίм۸>0
//	7	ʹ
//	8	ʹ
//	9	ƷֲϷĿǰֻ֧֡3-ڻ
//	10	ίϷ>0
//	11	ʹ
//	12	򲻺ϷĿǰֻ֧1-6
//	13	ʹ
//	14	ûȨ޵˻в
//	15	ίбظ
//	16	ڵ˻
//	17	ϷĺԼ
//	18	ίޣĿǰϵͳÿ850ί

//	ָľܾԭձ
//	0	У 
//	1	ίδ
//	2	ҪίҲ
//	3	ûίеûһ
//	4	˻ίе˻һ
//	5	ίѾرգѾ/ɽ
//	6	ظ
//	7	ܱ
//	

// ίָľܾԭ򣬷ؼձ
//	0	
//	1	ռ̱֤
//	2	ޣ̿ڼ
//	3	: ɽ
//	4	۰ٷֱȳ:̿ڼ
//	5	۰ٷֱȳ:ɽ
//	6	ޣ
//	7	۰ٷֱȳޣ
//	8	޼ίж
//	9	мίж
//	10	ۼ¶
//	11	ۼ¶
//	12	ۼ¶
//	13	ָʱ1յ
//	14	ָʱ2յ
//	15	ֹ
//	16	ۼƿֶ
//	17	ۼƽֶ
//	18	У鲻ͨ
//	19	ͻȨ˲
//	20	ܹҵУ
//	21	󳷵
//	22	ĳԼ󳷵
//	23	ָʱ1ڳ
//	24	ָʱ2ڳ
//	25	
//	26	ۼƳֲ
//	27	ۼƳֲռñ֤ܺ
//	28	ۼƳɽ
//	29	ɽܺ
//	30	¶гܾ
//	31	µ̨ϵͳܾ
//	32	гܾ
//	33	ָʱ1¶гܾ
//	34	ָʱ2¶гܾ
//	35	ָʱ1ڳгܾ
//	36	ָʱ2ڳгܾ
//	37	ӯ
//	38	ӯ
//	39	ӯ
//	40	ֶ
//	41	ֿղ
//	42	ֶռñ֤
//	43	ֿղռñ֤
//	44	ĳԼֶ
//	45	ĳԼֿղ
//	46	ĳԼֶռñ֤
//	47	ĳԼֿղռñ֤
//	48	ĳԼֲ
//	49	ĳԼֲռ֤ܶ
//	50	ĳԼ
//	51	ĳԼӯ
//	52	ĳԼ
//	53	ۼƿֳɽ
//	54	ۼƿֳɽܺ
//	55	ۼƿֳɽ
//	56	ۼƿղֳɽ
//	57	ۼƿֳɽܺ
//	58	ۼƿղֳɽܺ
//	59	̷ն
//	60	ն
//	61	ָʱ1µ̨ϵͳܾ
//	62	ָʱ2µ̨ϵͳܾ
//	63	ʹ
//	64	ʽ
//	65	ƽλ
//	66	ίм۸񳬹ǵͣΧ




#endif
