﻿using System;
using System.Runtime.InteropServices;

namespace SlEesQuote.MsgDefine
{

    /// <summary>
    /// EES行情结构
    /// </summary>
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct EESMarketDepthQuoteData
    {
        /// <summary>
        /// 交易日
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] TradingDay;
        /// <summary>
        /// 合约代码
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 31)]
        public byte[] InstrumentID;
        /// <summary>
        /// 交易所代码
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] ExchangeID;

        /// <summary>
        /// 合约在交易所的代码
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 31)]
        public byte[] ExchangeInstID;


        /// <summary>
        /// 最新价
        /// </summary>
        public double LastPrice;

        /// <summary>
        /// 上次结算价
        /// </summary>
        public double PreSettlementPrice;


        /// <summary>
        /// 昨收盘价格
        /// </summary>
        public double PreClosePrice;


        /// <summary>
        /// 昨持仓量
        /// </summary>
        public double PreOpenInterest;


        /// <summary>
        /// 今开盘价
        /// </summary>
        public double OpenPrice;

        /// <summary>
        /// 最高价
        /// </summary>
        public double HighestPrice;


        /// <summary>
        /// 最低价
        /// </summary>
        public double LowestPrice;


        /// <summary>
        /// 数量
        /// </summary>
        public Int64 Volume;

        /// <summary>
        /// 成交金额
        /// </summary>
        public double Turnover;


        /// <summary>
        /// 持仓量
        /// </summary>
        public double OpenInterest;


        /// <summary>
        /// 今收盘
        /// </summary>
        public double ClosePrice;


        /// <summary>
        /// 本次结算价
        /// </summary>
        public double SettlementPrice;


        /// <summary>
        /// 涨停板价
        /// </summary>
        public double UpperLimitPrice;


        /// <summary>
        /// 跌停板价
        /// </summary>
        public double LowerLimitPrice;


        /// <summary>
        /// 昨虚实度
        /// </summary>
        public double PreDelta;


        /// <summary>
        /// 今虚实度
        /// </summary>
        public double CurrDelta;

        /// <summary>
        /// 最后修改时间
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] UpdateTime;


        /// <summary>
        /// 最后修改毫秒
        /// </summary>
        public int UpdateMillisec;


        /// <summary>
        /// 申买价一
        /// </summary>
        public double BidPrice1;

        /// <summary>
        /// 申买量一
        /// </summary>
        public Int64 BidVolume1;


        /// <summary>
        /// 申卖价一
        /// </summary>
        public double AskPrice1;


        /// <summary>
        /// 申卖量一
        /// </summary>
        public Int64 AskVolume1;



        /// <summary>
        /// 申买价二
        /// </summary>
        public double BidPrice2;

        /// <summary>
        /// 申买量二
        /// </summary>
        public Int64 BidVolume2;


        /// <summary>
        /// 申卖价二
        /// </summary>
        public double AskPrice2;


        /// <summary>
        /// 申卖量二
        /// </summary>
        public Int64 AskVolume2;


        /// <summary>
        /// 申买价三
        /// </summary>
        public double BidPrice3;

        /// <summary>
        /// 申买量三
        /// </summary>
        public Int64 BidVolume3;


        /// <summary>
        /// 申卖价三
        /// </summary>
        public double AskPrice3;


        /// <summary>
        /// 申卖量三
        /// </summary>
        public Int64 AskVolume3;

        /// <summary>
        /// 申买价四
        /// </summary>
        public double BidPrice4;

        /// <summary>
        /// 申买量四
        /// </summary>
        public Int64 BidVolume4;


        /// <summary>
        /// 申卖价四
        /// </summary>
        public double AskPrice4;


        /// <summary>
        /// 申卖量四
        /// </summary>
        public Int64 AskVolume4;

        /// <summary>
        /// 申买价五
        /// </summary>
        public double BidPrice5;

        /// <summary>
        /// 申买量五
        /// </summary>
        public Int64 BidVolume5;

        /// <summary>
        /// 申卖价五
        /// </summary>
        public double AskPrice5;


        /// <summary>
        /// 申卖量五
        /// </summary>
        public Int64 AskVolume5;


        /// <summary>
        /// 当日均价
        /// </summary>
        public double AveragePrice;

        /// <summary>
        /// 虚实值
        /// </summary>
        public int MoneyInOrOut;
        /// <summary>
        /// 状态
        /// </summary>
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 8)]
        public string TradingPhaseCode;
        /// <summary>
        /// 发送时间
        /// </summary>
        public int SendingTime;

    }
}
