﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

namespace SlEesQuote.MsgDefine
{
    ///EES行情服务器配置信息
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct EqsTcpInfo
    {

        ///IP
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        private byte[] EqsIdByte;
        ///IP
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        private byte[] EqsIpByte;
        ///Port
        public UInt16 EqsPort;



        public string EqsId
        {
            get
            {
                if(EqsIdByte is null)
                {
                    EqsIdByte = new byte[16];
                }
                return Encoding.Default.GetString(EqsIdByte);

            }
            set
            {
                if (EqsIdByte is null)
                {
                    EqsIdByte = new byte[16];
                }
                var msg = Encoding.Default.GetBytes(value);
                for (int i = 0; i < 16 && i< msg.Count(); ++i )
                {
                    EqsIdByte[i] = msg[i];
                }
            }
        }

        public string EqsIp
        {
            get
            {
                if (EqsIpByte is null)
                {
                    EqsIpByte = new byte[16];
                }
                return Encoding.Default.GetString(EqsIpByte);

            }
            set
            {
                if (EqsIpByte is null)
                {
                    EqsIpByte = new byte[16];
                }
                var msg = Encoding.Default.GetBytes(value);
                for (int i = 0; i < 16 && i < msg.Count(); ++i )
                {
                    EqsIpByte[i] = msg[i];
                }
            }
        }

    }
}
