﻿using SlEesQuote.MsgDefine;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

namespace SlEesQuote
{
    public class SlEesQuoteDll
    {
        #region C dll export functions mapping
        [DllImport("RemStockQuoteApi.dll", EntryPoint = "SLEES_OptQuote_CreateQuote", CallingConvention = CallingConvention.Cdecl)]
        protected static extern IntPtr SLEES_OptQuote_CreateQuote(IntPtr userParam);

        [DllImport("RemStockQuoteApi.dll", EntryPoint = "SLEES_OptQuote_DestroyQuote", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptQuote_DestroyQuote(IntPtr handle);

        [DllImport("RemStockQuoteApi.dll", EntryPoint = "SLEES_OptQuote_ConnEqsServer", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptQuote_ConnEqsServer(IntPtr handle, EqsTcpInfo[] eqsInfo, int num);



        [DllImport("RemStockQuoteApi.dll", EntryPoint = "SLEES_OptQuote_SetEqsConnectionEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptQuote_SetEqsConnectionEvent(IntPtr handle,  SLEES_OptQuote_EqsConnectionEventPtr pFun);

        [DllImport("RemStockQuoteApi.dll", EntryPoint = "SLEES_OptQuote_DisConnEqsServer", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptQuote_DisConnEqsServer(IntPtr handle);


        [DllImport("RemStockQuoteApi.dll", EntryPoint = "SLEES_OptQuote_SetEqsDisConnectionEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptQuote_SetEqsDisConnectionEvent(IntPtr handle, SLEES_OptQuote_EqsDisConnectionEventPtr pFun);


        [DllImport("RemStockQuoteApi.dll", EntryPoint = "SLEES_OptQuote_EqsUserLogon", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptQuote_EqsUserLogon(IntPtr handle, string userId, string userPwd);


        [DllImport("RemStockQuoteApi.dll", EntryPoint = "SLEES_OptQuote_SetEqsLoginResponseEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptQuote_SetEqsLoginResponseEvent(IntPtr handle, SLEES_OptQuote_EqsLoginResponseEventPtr pFun);

        [DllImport("RemStockQuoteApi.dll", EntryPoint = "SLEES_OptQuote_SetEqsQuoteUpdatedEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptQuote_SetEqsQuoteUpdatedEvent(IntPtr handle, SLEES_OptQuote_EqsQuoteUpdatedEventPtr pFun);

        [DllImport("RemStockQuoteApi.dll", EntryPoint = "SLEES_OptQuote_EqsRegisterSymbol", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptQuote_EqsRegisterSymbol(IntPtr handle, EESExchange exchangeId, string pSymbol);

        [DllImport("RemStockQuoteApi.dll", EntryPoint = "SLEES_OptQuote_SetEqsSymbolRegisterResponseEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptQuote_SetEqsSymbolRegisterResponseEvent(IntPtr handle, SLEES_OptQuote_EqsSymbolRegisterResponseEventPtr pFun);


        [DllImport("RemStockQuoteApi.dll", EntryPoint = "SLEES_OptQuote_EqsUnregisterSymbol", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptQuote_EqsUnregisterSymbol(IntPtr handle, EESExchange exchangeId, string pSymbol);


        [DllImport("RemStockQuoteApi.dll", EntryPoint = "SLEES_OptQuote_SetEqsSymbolUnregisterResponseEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptQuote_SetEqsSymbolUnregisterResponseEvent(IntPtr handle, SLEES_OptQuote_EqsSymbolUnregisterResponseEventPtr pFun);


        [DllImport("RemStockQuoteApi.dll", EntryPoint = "SLEES_OptQuote_EqsQuerySymbolQuote", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptQuote_EqsQuerySymbolQuote(IntPtr handle, EESExchange exchangeId, string pSymbol);

        [DllImport("RemStockQuoteApi.dll", EntryPoint = "SLEES_OptQuote_SetEqsQuerySymbolQuoteResponseEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptQuote_SetEqsQuerySymbolQuoteResponseEvent(IntPtr handle, SLEES_OptQuote_EqsQuerySymbolQuoteResponseEventPtr pFun);


        [DllImport("RemStockQuoteApi.dll", EntryPoint = "SLEES_OptQuote_EqsQuerySymbolList", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptQuote_EqsQuerySymbolList(IntPtr handle);

        [DllImport("RemStockQuoteApi.dll", EntryPoint = "SLEES_OptQuote_SetEqsSymbolListResponseEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptQuote_SetEqsSymbolListResponseEvent(IntPtr handle, SLEES_OptQuote_EqsSymbolListResponseEventPtr pFun);

        [DllImport("RemStockQuoteApi.dll", EntryPoint = "SLEES_OptQuote_SetEqsWriteTextLogEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptQuote_SetEqsWriteTextLogEvent(IntPtr handle, SLEES_OptQuote_SetEqsWriteTextLogEventPtr pFun);


        #endregion

        #region Event
        ///连接消息的回调
        public delegate void QuoteClientConnectionEvent();
        public event QuoteClientConnectionEvent quoteClientConnectionEvent;
        public delegate void QuoteClientDisConnectionEvent();
        public event QuoteClientDisConnectionEvent quoteClientDisConnectionEvent;
        public delegate void QuoteClientLoginResponseEvent(bool bSuccess, string pReason);
        public event QuoteClientLoginResponseEvent quoteClientLoginResponseEvent;

        public delegate void QuoteClientQuoteUpdatedEvent(EESExchange exchangeId,EESMarketDepthQuoteData pDepthQuoteData);
        public event QuoteClientQuoteUpdatedEvent quoteClientQuoteUpdatedEvent;


        public delegate void QuoteClientSymbolRegisterResponseEvent(EESExchange exchangeId, string pSymbol, bool bSuccess);
        public event QuoteClientSymbolRegisterResponseEvent quoteClientSymbolRegisterResponseEvent;

        public delegate void QuoteClientSymbolUnregisterResponseEvent(EESExchange exchangeId, string pSymbol, bool bSuccess);
        public event QuoteClientSymbolUnregisterResponseEvent quoteClientSymbolUnregisterResponseEvent;

        public delegate void QuoteClientSymbolListResponseEvent(EESExchange exchangeId, string pSymbol, bool bLast);
        public event QuoteClientSymbolListResponseEvent quoteClientSymbolListResponseEvent;

        public delegate void QuoteClientQuerySymbolQuoteResponseEvent(EESExchange exchangeId, string pSymbol, EESMarketDepthQuoteData pDepthQuoteData);
        public event QuoteClientQuerySymbolQuoteResponseEvent quoteClientQuerySymbolQuoteResponseEvent;

        public delegate void QuoteClientWriteTextLogEvent(EesEqsLogLevel nlevel, string pLogText, int nLogLen);
        public event QuoteClientWriteTextLogEvent quoteClientWriteTextLogEvent;

        #endregion

        SLEES_OptQuote_EqsConnectionEventPtr connectionEventPtr;
        SLEES_OptQuote_EqsDisConnectionEventPtr disconnectionEventPtr;
        SLEES_OptQuote_EqsLoginResponseEventPtr loginResponseEventPtr;
        SLEES_OptQuote_EqsQuoteUpdatedEventPtr quoteUpdatedEventPtr;

        SLEES_OptQuote_EqsSymbolRegisterResponseEventPtr symbolRegisterResponseEventPtr;

        SLEES_OptQuote_EqsSymbolUnregisterResponseEventPtr symbolUnregisterResponseEventPtr;

        SLEES_OptQuote_EqsQuerySymbolQuoteResponseEventPtr querySymbolQuoteResponseEventPtr;
        SLEES_OptQuote_EqsSymbolListResponseEventPtr symbolListResponseEventPtr;

        SLEES_OptQuote_SetEqsWriteTextLogEventPtr writeTextLogEventPtr;
        private IntPtr quoteHandle = IntPtr.Zero;
        public SlEesQuoteDll()
        {
            quoteHandle = SLEES_OptQuote_CreateQuote(IntPtr.Zero);

            connectionEventPtr = new SLEES_OptQuote_EqsConnectionEventPtr(ConnectionEvent);;
            disconnectionEventPtr = new SLEES_OptQuote_EqsDisConnectionEventPtr(DisConnectionEvent);;
            loginResponseEventPtr = new SLEES_OptQuote_EqsLoginResponseEventPtr(LoginResponseEvent);
            quoteUpdatedEventPtr = new SLEES_OptQuote_EqsQuoteUpdatedEventPtr(QuoteUpdatedEvent);
            symbolRegisterResponseEventPtr = new SLEES_OptQuote_EqsSymbolRegisterResponseEventPtr(SymbolRegisterResponseEvent);
            symbolUnregisterResponseEventPtr = new SLEES_OptQuote_EqsSymbolUnregisterResponseEventPtr(SymbolUnregisterResponseEvent);
            querySymbolQuoteResponseEventPtr = new SLEES_OptQuote_EqsQuerySymbolQuoteResponseEventPtr(QuerySymbolQuoteResponseEvent);
            symbolListResponseEventPtr = new SLEES_OptQuote_EqsSymbolListResponseEventPtr(SymbolListResponseEvent);
            writeTextLogEventPtr = new SLEES_OptQuote_SetEqsWriteTextLogEventPtr(WriteTextLogEvent);
            try
            {
                SLEES_OptQuote_SetEqsConnectionEvent(quoteHandle, connectionEventPtr);
                SLEES_OptQuote_SetEqsDisConnectionEvent(quoteHandle, disconnectionEventPtr);
                SLEES_OptQuote_SetEqsLoginResponseEvent(quoteHandle, loginResponseEventPtr);
                SLEES_OptQuote_SetEqsQuoteUpdatedEvent(quoteHandle, quoteUpdatedEventPtr);
                SLEES_OptQuote_SetEqsSymbolRegisterResponseEvent(quoteHandle, symbolRegisterResponseEventPtr);
                SLEES_OptQuote_SetEqsSymbolUnregisterResponseEvent(quoteHandle, symbolUnregisterResponseEventPtr);
                SLEES_OptQuote_SetEqsQuerySymbolQuoteResponseEvent(quoteHandle, querySymbolQuoteResponseEventPtr);
                SLEES_OptQuote_SetEqsSymbolListResponseEvent(quoteHandle, symbolListResponseEventPtr);
                SLEES_OptQuote_SetEqsWriteTextLogEvent(quoteHandle, writeTextLogEventPtr);
            }
            catch (Exception e)
            {

            }

        }



        private static class TradeFactory
        {
            public static SlEesQuoteDll trade = new SlEesQuoteDll();
        }

        public static SlEesQuoteDll GetInstance()
        {
            return TradeFactory.trade;
        }

        /// 主动函数



        public int ConnServer(List<EqsTcpInfo> eqsTcpInfos)
        {
            return SLEES_OptQuote_ConnEqsServer(quoteHandle, eqsTcpInfos.ToArray(), eqsTcpInfos.Count());
        }

        public int DisConnServer()
        {
            return SLEES_OptQuote_DisConnEqsServer(quoteHandle);
        }

        public int UserLogon(string userId, string userPwd)
        {
            return SLEES_OptQuote_EqsUserLogon(quoteHandle, userId, userPwd);
        }

        public int RegisterSymbol(EESExchange exchangeId, string pSymbol)
        {
            return SLEES_OptQuote_EqsRegisterSymbol(quoteHandle, exchangeId, pSymbol);
        }

        public int UnregisterSymbol(EESExchange exchangeId, string pSymbol)
        {
            return SLEES_OptQuote_EqsUnregisterSymbol(quoteHandle, exchangeId, pSymbol);
        }

        public int QuerySymbolQuote(EESExchange exchangeId, string pSymbol)
        {
            return SLEES_OptQuote_EqsQuerySymbolQuote(quoteHandle, exchangeId, pSymbol);
        }

        public int QuerySymbolList()
        {
            return SLEES_OptQuote_EqsQuerySymbolList(quoteHandle);
        }

        protected delegate void SLEES_OptQuote_EqsConnectionEventPtr(IntPtr handle);
        protected delegate void SLEES_OptQuote_EqsDisConnectionEventPtr(IntPtr handle);
        protected delegate void SLEES_OptQuote_EqsLoginResponseEventPtr(IntPtr handle, bool bSuccess, string pReason);
        protected delegate void SLEES_OptQuote_EqsQuoteUpdatedEventPtr(IntPtr handle, EESExchange exchangeId,ref EESMarketDepthQuoteData pDepthQuoteData);
        protected delegate void SLEES_OptQuote_EqsSymbolRegisterResponseEventPtr(IntPtr handle, EESExchange exchangeId, string pSymbol, bool bSuccess);
        protected delegate void SLEES_OptQuote_EqsSymbolUnregisterResponseEventPtr(IntPtr handle, EESExchange exchangeId, string pSymbol, bool bSuccess);
        protected delegate void SLEES_OptQuote_EqsQuerySymbolQuoteResponseEventPtr(IntPtr handle, EESExchange exchangeId, string pSymbol, ref EESMarketDepthQuoteData pDepthQuoteData);
        protected delegate void SLEES_OptQuote_EqsSymbolListResponseEventPtr(IntPtr handle, EESExchange exchangeId, string pSymbol, bool bLast);
        protected delegate void SLEES_OptQuote_SetEqsWriteTextLogEventPtr(IntPtr handle, EesEqsLogLevel nlevel, string pLogText, int nLogLen);



        #region  事件函数
        private void ConnectionEvent(IntPtr handle)
        {
            quoteClientConnectionEvent?.Invoke();
           // Console.WriteLine("ConnectionEvent");
        }
        private void DisConnectionEvent(IntPtr handle)
        {
            quoteClientDisConnectionEvent?.Invoke();
          //  Console.WriteLine("DisConnectionEvent");
        }

        private void LoginResponseEvent(IntPtr handle, bool bSuccess, string pReason)
        {
            quoteClientLoginResponseEvent?.Invoke(bSuccess,pReason);
          //  Console.WriteLine("LoginResponseEvent");
        }

        private void QuoteUpdatedEvent(IntPtr handle, EESExchange exchangeId, ref EESMarketDepthQuoteData pDepthQuoteData)
        {
            quoteClientQuoteUpdatedEvent?.Invoke(exchangeId, pDepthQuoteData);
//Console.WriteLine("QuoteUpdatedEvent");
        }

        private void SymbolRegisterResponseEvent(IntPtr handle, EESExchange exchangeId, string pSymbol, bool bSuccess)
        {
            quoteClientSymbolRegisterResponseEvent?.Invoke( exchangeId,pSymbol,bSuccess);
         //   Console.WriteLine("SymbolRegisterResponseEvent");
        }
        private void SymbolUnregisterResponseEvent(IntPtr handle, EESExchange exchangeId, string pSymbol, bool bSuccess)
        {
            quoteClientSymbolUnregisterResponseEvent?.Invoke(exchangeId, pSymbol, bSuccess);
         //   Console.WriteLine("SymbolUnregisterResponseEvent");
        }

        private void QuerySymbolQuoteResponseEvent(IntPtr handle, EESExchange exchangeId, string pSymbol, ref EESMarketDepthQuoteData pDepthQuoteData)
        {
            quoteClientQuerySymbolQuoteResponseEvent?.Invoke(exchangeId, pSymbol, pDepthQuoteData);
          //  Console.WriteLine("QuerySymbolQuoteResponseEvent");
        }

        private void SymbolListResponseEvent(IntPtr handle, EESExchange exchangeId, string pSymbol, bool bLast)
        {
            quoteClientSymbolListResponseEvent?.Invoke(exchangeId, pSymbol,bLast);
         //   Console.WriteLine("SymbolListResponseEvent");
        }

        private void WriteTextLogEvent(IntPtr handle, EesEqsLogLevel nlevel, string pLogText, int nLogLen)
        {
            quoteClientWriteTextLogEvent?.Invoke(nlevel, pLogText, nLogLen);
        //    Console.WriteLine("WriteTextLogEvent");
        }

        #endregion
    }
}
