﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Reflection;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace SlEesTrade
{
    public partial class SlEesTradeDll
    {  
        #region Delegate

        //担保品列表查询的返回事件
        public delegate void SetQueryCreditGuarantyListEvent(SlEesTradeDll traderDll, ref CShengliCreditGuarantyListField guarantyList, int nRequestID, byte bIsLast);
        public event SetQueryCreditGuarantyListEvent setQueryCreditGuarantyListEvent;

        //可融资标的头寸查询的返回事件
        public delegate void SetQueryCreditFinanceCashEvent(SlEesTradeDll traderDll, ref CShengliCreditFinanceCashField financeCash, int nRequestID, byte bIsLast);
        public event SetQueryCreditFinanceCashEvent setQueryCreditFinanceCashEvent;

        //可融券标的头寸查询的返回事件
        public delegate void SetQueryCreditSellshortCashEvent(SlEesTradeDll traderDll, ref CShengliCreditSellshortCashField sellShortCash, int nRequestID, byte bIsLast);
        public event SetQueryCreditSellshortCashEvent setQueryCreditSellshortCashEvent;

        //合约展期查询的返回事件
        public delegate void SetQueryCreditContractExtensionEvent(SlEesTradeDll traderDll, ref CShengliCreditContractExtensionField contractExtension, int nRequestID, byte bIsLast);
        public event SetQueryCreditContractExtensionEvent setQueryCreditContractExtensionEvent;

        //两融账户资金查询的返回事件
        public delegate void SetQueryCreditAccountEvent(SlEesTradeDll traderDll, ref CShengliCreditAccountField creditAccount, int nRequestID, byte bIsLast);
        public event SetQueryCreditAccountEvent setQueryCreditAccountEvent;

        //担保品持仓查询的返回事件
        public delegate void SetQueryCreditGuaranryPositionEvent(SlEesTradeDll traderDll, ref CShengliCreditGuarantyPositionField guarantyPosition, int nRequestID, byte bIsLast);
        public event SetQueryCreditGuaranryPositionEvent setQueryCreditGuaranryPositionEvent;

        //融资负债查询的返回事件
        public delegate void SetQueryCreditFinancePositionEvent(SlEesTradeDll traderDll, ref CShengliCreditFinancePositionField financePosition, int nRequestID, byte bIsLast);
        public event SetQueryCreditFinancePositionEvent setQueryCreditFinancePositionEvent;

        //融券负债查询的返回事件
        public delegate void SetQueryCreditSellshortPositionEvent(SlEesTradeDll traderDll, ref CShengliCreditSellshortPositionField sellShortPosition, int nRequestID, byte bIsLast);
        public event SetQueryCreditSellshortPositionEvent setQueryCreditSellshortPositionEvent;

        //融资负债明细查询的返回事件
        public delegate void SetQueryCreditFinanceDebtEvent(SlEesTradeDll traderDll, ref CShengliCreditFinanceDebtField financeDebt, int nRequestID, byte bIsLast);
        public event SetQueryCreditFinanceDebtEvent setQueryCreditFinanceDebtEvent;

        //融券负债明细查询的返回事件
        public delegate void SetQueryCreditSellshortDebtEvent(SlEesTradeDll traderDll, ref CShengliCreditSellshortDebtField sellShortDebt, int nRequestID, byte bIsLast);
        public event SetQueryCreditSellshortDebtEvent setQueryCreditSellshortDebtEvent;
        #endregion

        #region C Callback mapping
        protected delegate void SLEES_OptTrade_SetQueryCreditGuarantyListEventPtr(IntPtr handle, ref CShengliCreditGuarantyListField guarantyList, int nRequestID, byte bIsLast);
        protected delegate void SLEES_OptTrade_SetQueryCreditFinanceCashEventPtr(IntPtr handle, ref CShengliCreditFinanceCashField financeCash, int nRequestID, byte bIsLast);
        protected delegate void SLEES_OptTrade_SetQueryCreditSellshortCashEventPtr(IntPtr handle, ref CShengliCreditSellshortCashField sellShortCash, int nRequestID, byte bIsLast);
        protected delegate void SLEES_OptTrade_SetQueryCreditContractExtensionEventPtr(IntPtr handle, ref CShengliCreditContractExtensionField contractExtension, int nRequestID, byte bIsLast);
        protected delegate void SLEES_OptTrade_SetQueryCreditAccountEventPtr(IntPtr handle, ref CShengliCreditAccountField creditAccount, int nRequestID, byte bIsLast);
        protected delegate void SLEES_OptTrade_SetQueryCreditGuaranryPositionEventPtr(IntPtr handle, ref CShengliCreditGuarantyPositionField guarantyPosition, int nRequestID, byte bIsLast);
        protected delegate void SLEES_OptTrade_SetQueryCreditFinancePositionEventPtr(IntPtr handle, ref CShengliCreditFinancePositionField financePosition, int nRequestID, byte bIsLast);
        protected delegate void SLEES_OptTrade_SetQueryCreditSellshortPositionEventPtr(IntPtr handle, ref CShengliCreditSellshortPositionField sellShortPosition, int nRequestID, byte bIsLast);
        protected delegate void SLEES_OptTrade_SetQueryCreditFinanceDebtEventPtr(IntPtr handle, ref CShengliCreditFinanceDebtField financeDebt, int nRequestID, byte bIsLast);
        protected delegate void SLEES_OptTrade_SetQueryCreditSellshortDebtEventPtr(IntPtr handle, ref CShengliCreditSellshortDebtField sellShortDebt, int nRequestID, byte bIsLast);

        #endregion

        #region C dll export functions mapping  

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryCreditGuarantyList", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryCreditGuarantyList(IntPtr handle, ref CShengliCreditGuarantyListQueryField info, int nRequestID);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryCreditGuarantyListEvent", CallingConvention = CallingConvention.Cdecl)]
        [SetEvent(nameof(QueryCreditGuarantyListEvent))]
        protected static extern int SLEES_OptTrade_SetQueryCreditGuarantyListEvent(IntPtr handle, SLEES_OptTrade_SetQueryCreditGuarantyListEventPtr p_fun);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryCreditFinanceCash", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryCreditFinanceCash(IntPtr handle, ref CShengliCreditFinanceCashQueryField info, int nRequestID);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryCreditFinanceCashEvent", CallingConvention = CallingConvention.Cdecl)]
        [SetEvent(nameof(QueryCreditFinanceCashEvent))]
        protected static extern int SLEES_OptTrade_SetQueryCreditFinanceCashEvent(IntPtr handle, SLEES_OptTrade_SetQueryCreditFinanceCashEventPtr p_fun);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryCreditSellshortCash", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryCreditSellshortCash(IntPtr handle, ref CShengliCreditSellshortCashQueryField info, int nRequestID);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryCreditSellshortCashEvent", CallingConvention = CallingConvention.Cdecl)]
        [SetEvent(nameof(QueryCreditSellShortCashEvent))]
        protected static extern int SLEES_OptTrade_SetQueryCreditSellshortCashEvent(IntPtr handle, SLEES_OptTrade_SetQueryCreditSellshortCashEventPtr p_fun);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryCreditContractExtension", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryCreditContractExtension(IntPtr handle, ref CShengliCreditContractExtensionQueryField info, int nRequestID);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryCreditContractExtensionEvent", CallingConvention = CallingConvention.Cdecl)]
        [SetEvent(nameof(QueryCreditContractExtensionEvent))]
        protected static extern int SLEES_OptTrade_SetQueryCreditContractExtensionEvent(IntPtr handle, SLEES_OptTrade_SetQueryCreditContractExtensionEventPtr p_fun);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryCreditAccount", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryCreditAccount(IntPtr handle, ref CShengliCreditAccountQueryField info, int nRequestID);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryCreditAccountEvent", CallingConvention = CallingConvention.Cdecl)]
        [SetEvent(nameof(QueryCreditAccountEvent))]
        protected static extern int SLEES_OptTrade_SetQueryCreditAccountEvent(IntPtr handle, SLEES_OptTrade_SetQueryCreditAccountEventPtr p_fun);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryCreditGuaranryPosition", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryCreditGuaranryPosition(IntPtr handle, ref CShengliCreditGuarnatyPositionQueryField info, int nRequestID);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryCreditGuaranryPositionEvent", CallingConvention = CallingConvention.Cdecl)]
        [SetEvent(nameof(QueryCreditGuarantyPositionEvent))]
        protected static extern int SLEES_OptTrade_SetQueryCreditGuaranryPositionEvent(IntPtr handle, SLEES_OptTrade_SetQueryCreditGuaranryPositionEventPtr p_fun);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryCreditFinancePosition", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryCreditFinancePosition(IntPtr handle, ref CShengliCreditFinancePositionQueryField info, int nRequestID);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryCreditFinancePositionEvent", CallingConvention = CallingConvention.Cdecl)]
        [SetEvent(nameof(QueryCreditFinancePostionEvent))]
        protected static extern int SLEES_OptTrade_SetQueryCreditFinancePositionEvent(IntPtr handle, SLEES_OptTrade_SetQueryCreditFinancePositionEventPtr p_fun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryCreditSellshortPosition", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryCreditSellshortPosition(IntPtr handle, ref CShengliCreditSellshortPositionQueryField info, int nRequestID);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryCreditSellshortPositionEvent", CallingConvention = CallingConvention.Cdecl)]
        [SetEvent(nameof(QueryCreditSellShortPositionEvent))]
        protected static extern int SLEES_OptTrade_SetQueryCreditSellshortPositionEvent(IntPtr handle, SLEES_OptTrade_SetQueryCreditSellshortPositionEventPtr p_fun);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryCreditFinanceDebt", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryCreditFinanceDebt(IntPtr handle, ref CShengliCreditFinanceDebtQueryField info, int nRequestID);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryCreditFinanceDebtEvent", CallingConvention = CallingConvention.Cdecl)]
        [SetEvent(nameof(QueryCreditFinanceDebtEvent))]
        protected static extern int SLEES_OptTrade_SetQueryCreditFinanceDebtEvent(IntPtr handle, SLEES_OptTrade_SetQueryCreditFinanceDebtEventPtr p_fun);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryCreditSellshortDebt", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryCreditSellshortDebt(IntPtr handle, ref CShengliCreditSellshortDebtQueryField info, int nRequestID);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryCreditSellshortDebtEvent", CallingConvention = CallingConvention.Cdecl)]
        [SetEvent(nameof(QueryCreditSellShortDebtEvent))]
        protected static extern int SLEES_OptTrade_SetQueryCreditSellshortDebtEvent(IntPtr handle, SLEES_OptTrade_SetQueryCreditSellshortDebtEventPtr p_fun);

        #endregion

        #region Api  
        public int QueryCreditGuarantyList(CShengliCreditGuarantyListQueryField info, int requestId)
        {
            int ret = SLEES_OptTrade_QueryCreditGuarantyList(tradeHandle, ref info, requestId);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QueryCreditGuarantyList(tradeHandle, ref info, requestId);
            }
            return ret;
        }

        public int QueryCreditFinanceCash(CShengliCreditFinanceCashQueryField info, int requestId)
        {
            int ret = SLEES_OptTrade_QueryCreditFinanceCash(tradeHandle, ref info, requestId);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QueryCreditFinanceCash(tradeHandle, ref info, requestId);
            }
            return ret;
        } 

        public int QueryCreditSellShortCash(CShengliCreditSellshortCashQueryField info, int requestId)
        {
            int ret = SLEES_OptTrade_QueryCreditSellshortCash(tradeHandle, ref info, requestId);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QueryCreditSellshortCash(tradeHandle, ref info, requestId);
            }
            return ret;
        }


        public int QueryCreditContractExtension(CShengliCreditContractExtensionQueryField info, int requestId)
        {
            int ret = SLEES_OptTrade_QueryCreditContractExtension(tradeHandle, ref info, requestId);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QueryCreditContractExtension(tradeHandle, ref info, requestId);
            }
            return ret;
        }


        public int QueryCreditAccount(CShengliCreditAccountQueryField info, int requestId)
        {
            int ret = SLEES_OptTrade_QueryCreditAccount(tradeHandle, ref info, requestId);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QueryCreditAccount(tradeHandle, ref info, requestId);
            }
            return ret;
        }

     
        public int QueryCreditGuaranryPosition(CShengliCreditGuarnatyPositionQueryField info, int requestId)
        {
            int ret = SLEES_OptTrade_QueryCreditGuaranryPosition(tradeHandle, ref info, requestId);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QueryCreditGuaranryPosition(tradeHandle, ref info, requestId);
            }
            return ret;
        }

        public int QueryCreditFinancePosition(CShengliCreditFinancePositionQueryField info, int requestId)
        {
            int ret = SLEES_OptTrade_QueryCreditFinancePosition(tradeHandle, ref info, requestId);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QueryCreditFinancePosition(tradeHandle, ref info, requestId);
            }
            return ret;
        }

    
        public int QueryCreditSellshortPosition(CShengliCreditSellshortPositionQueryField info, int requestId)
        {
            int ret = SLEES_OptTrade_QueryCreditSellshortPosition(tradeHandle, ref info, requestId);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QueryCreditSellshortPosition(tradeHandle, ref info, requestId);
            }
            return ret;
        }

  
        public int QueryCreditFinanceDebt(CShengliCreditFinanceDebtQueryField info, int requestId)
        {
            int ret = SLEES_OptTrade_QueryCreditFinanceDebt(tradeHandle, ref info, requestId);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QueryCreditFinanceDebt(tradeHandle, ref info, requestId);
            }
            return ret;
        }

   
        public int QueryCreditSellshortDebt(CShengliCreditSellshortDebtQueryField info, int requestId)
        {
            int ret = SLEES_OptTrade_QueryCreditSellshortDebt(tradeHandle, ref info, requestId);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QueryCreditSellshortDebt(tradeHandle, ref info, requestId);
            }
            return ret;
        }


        #endregion

        #region Event 
        private void QueryCreditGuarantyListEvent(IntPtr handle, ref CShengliCreditGuarantyListField guarantyList, int nRequestID, byte bIsLast)
        {
            setQueryCreditGuarantyListEvent?.Invoke(this, ref guarantyList, nRequestID, bIsLast);
        }

        private void QueryCreditFinanceCashEvent(IntPtr handle, ref CShengliCreditFinanceCashField financeCash, int nRequestID, byte bIsLast)
        {
            setQueryCreditFinanceCashEvent?.Invoke(this, ref financeCash, nRequestID, bIsLast);
        }

        private void QueryCreditSellShortCashEvent(IntPtr handle, ref CShengliCreditSellshortCashField sellShortCash, int nRequestID, byte bIsLast)
        {
            setQueryCreditSellshortCashEvent?.Invoke(this, ref sellShortCash, nRequestID, bIsLast);
        }

        private void QueryCreditContractExtensionEvent(IntPtr handle, ref CShengliCreditContractExtensionField contractExtension, int nRequestID, byte bIsLast)
        {
            setQueryCreditContractExtensionEvent?.Invoke(this, ref contractExtension, nRequestID, bIsLast);
        }

        private void QueryCreditAccountEvent(IntPtr handle, ref CShengliCreditAccountField creditAccount, int nRequestID, byte bIsLast)
        {
            setQueryCreditAccountEvent?.Invoke(this, ref creditAccount, nRequestID, bIsLast);
        }

        private void QueryCreditGuarantyPositionEvent(IntPtr handle, ref CShengliCreditGuarantyPositionField guarantyPosition, int nRequestID, byte bIsLast)
        {
            setQueryCreditGuaranryPositionEvent?.Invoke(this, ref guarantyPosition, nRequestID, bIsLast);
        }

        private void QueryCreditFinancePostionEvent(IntPtr handle, ref CShengliCreditFinancePositionField financePosition, int nRequestID, byte bIsLast)
        {
            setQueryCreditFinancePositionEvent?.Invoke(this, ref financePosition, nRequestID, bIsLast);
        }

        private void QueryCreditSellShortPositionEvent(IntPtr handle, ref CShengliCreditSellshortPositionField sellShortPosition, int nRequestID, byte bIsLast)
        {
            setQueryCreditSellshortPositionEvent?.Invoke(this, ref sellShortPosition, nRequestID, bIsLast);
        }

        private void QueryCreditFinanceDebtEvent(IntPtr handle, ref CShengliCreditFinanceDebtField financeDebt, int nRequestID, byte bIsLast)
        {
            setQueryCreditFinanceDebtEvent?.Invoke(this, ref financeDebt, nRequestID, bIsLast);
        }

        private void QueryCreditSellShortDebtEvent(IntPtr handle, ref CShengliCreditSellshortDebtField sellShortDebt, int nRequestID, byte bIsLast)
        {
            setQueryCreditSellshortDebtEvent?.Invoke(this, ref sellShortDebt, nRequestID, bIsLast);
        }
        #endregion
    }
}
