﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace SlEesTrade
{
    #region struct mapping

    ///REM期权做市订单接受
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQuoteOrderAcceptedField
    {
        ///消息index
        public UInt32 MsgIndex;
        ///用户ID
        public UInt32 UserID;
        ///客户端编号
        public UInt32 ClOrdToken;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///申报类型 1报价 2撤单
        public byte ReqType;
        ///交易所
        public byte ExchID;
        ///代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///证券类型
        public byte SecurityType;
        ///证券子类型
        public byte SecuritySubType;
        ///盘后定价交易标志
        public byte PfpFlag;
        ///REM系统单cluster唯一编号
        public UInt64 OrderID;
        ///价格
        public Int64 AskPrice;
        ///数量
        public UInt32 AskQty;
        ///方向
        public char AskSide;
        ///订单状态
        public byte AskOrderState;
        ///价格
        public Int64 BidPrice;
        ///数量
        public UInt32 BidQty;
        ///方向
        public char BidSide;
        ///订单状态
        public byte BidOrderState;
        ///REM内核(硬件)处理完毕接受的时间戳，和开始发往交易所的时间戳相同
        public UInt64 AcceptTimestamp;
        ///交易所接受时，交易所给出的时间戳
        public UInt64 ExchangeTransTimestamp;
        ///REM系统收到交易所接受的时间戳
        public UInt64 ExchangeAcceptTimestamp;
        ///被动单/外部单标志
        public byte PassiveOrderFlag;
        ///交易所接受标志
        public byte ExchangeAcceptFlag;
        /// 8011
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] ExchangeOrderToken;
        /// opstation
        public UInt64 OpStation;
        ///UserInfo
        public UInt64 UserInfo;
        ///ExchangeUserinfo
        public UInt64 ExchangeUserinfo;
        ///委托方式
        public byte Delegatetype;
    };





    ///REM期权做市订单交易所接受
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQuoteOrderExchAcceptedField
    {
        ///消息index
        public UInt32 MsgIndex;
        ///用户ID
        public UInt32 UserID;
        ///客户端编号
        public UInt32 ClOrdToken;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///申报类型 1报价 2撤单 3乱序
        public byte ReqType;
        ///交易所
        public byte ExchID;
        ///代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///证券类型
        public byte SecurityType;
        ///证券子类型
        public byte SecuritySubType;
        ///盘后定价交易标志
        public byte PfpFlag;
        ///REM系统单cluster唯一编号
        public UInt64 OrderID;
        ///交易所单号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        public byte[] ExchangeOrderID;
        ///价格
        public Int64 AskPrice;
        ///数量
        public UInt32 AskQty;
        ///方向
        public char AskSide;
        ///订单状态
        public byte AskOrderState;
        ///价格
        public Int64 BidPrice;
        ///数量
        public UInt32 BidQty;
        ///方向
        public char BidSide;
        ///订单状态
        public byte BidOrderState;
        ///原订单的撤单状态
        public byte CxlReqStatus;
        ///被撤卖单的orderid
        public UInt64 AskOriOrderID;
        ///被撤卖单的userid
        public UInt32 AskOriUserID;
        ///被撤卖单的原始客户订单编号
        public UInt32 AskOriClOrdToken;
        ///数量
        public UInt32 AskLeavesQty;
        ///被撤买单的orderid
        public UInt64 BidOriOrderID;
        ///被撤买单的userid
        public UInt32 BidOriUserID;
        ///被撤买单的原始客户订单编号
        public UInt32 BidOriClOrdToken;
        ///数量
        public UInt32 BidLeavesQty;
        ///REM内核(硬件)处理完毕接受的时间戳，和开始发往交易所的时间戳相同
        public UInt64 AcceptTimestamp;
        ///交易所接受时，交易所给出的时间戳
        public UInt64 ExchangeTransTimestamp;
        ///REM系统收到交易所接受的时间戳
        public UInt64 ExchangeAcceptTimestamp;
        ///被动单/外部单标志
        public byte PassiveOrderFlag;
        ///交易所接受标志
        public byte ExchangeAcceptFlag;
        /// 8011
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] ExchangeOrderToken;
        ///UserInfo
        public UInt64 UserInfo;
        ///ExchangeUserinfo
        public UInt64 ExchangeUserinfo;
    };




    ///REM期权做市订单拒绝
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQuoteOrderRejectedField
    {
        ///消息index
        public UInt32 MsgIndex;
        ///用户ID
        public UInt32 UserID;
        ///客户端编号
        public UInt32 ClOrdToken;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///申报类型
        public byte ReqType;
        ///交易所
        public byte ExchID;
        ///代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///证券类型
        public byte SecurityType;
        ///证券子类型
        public byte SecuritySubType;
        ///盘后定价交易标志
        public byte PfpFlag;
        ///REM系统单cluster唯一编号
        public UInt64 OrderID;
        ///价格
        public Int64 AskPrice;
        ///数量
        public UInt32 AskQty;
        ///方向
        public char AskSide;
        ///订单状态
        public byte AskOrderState;
        ///价格
        public Int64 BidPrice;
        ///数量
        public UInt32 BidQty;
        ///方向
        public char BidSide;
        ///订单状态
        public byte BidOrderState;
        ///REM内核(硬件)处理完毕接受的时间戳，和开始发往交易所的时间戳相同
        public UInt64 AcceptTimestamp;
        ///交易所接受时，交易所给出的时间戳
        public UInt64 ExchangeTransTimestamp;
        ///REM系统收到交易所接受的时间戳
        public UInt64 ExchangeAcceptTimestamp;
        ///被动单/外部单标志
        public byte PassiveOrderFlag;
        ///系统拒绝
        public byte RejectedBy;
        ///拒绝原因
        public UInt16 RejectReason;
        ///错误原因文字
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
        public byte[] RejectText;
        ///语法检查结果
        public UInt32 GrammarResult;
        ///语法检查结果
        public UInt32 GrammarSubResult;
        ///风控检查结果
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] RiskResult;
        /// 8011
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] ExchangeOrderToken;
        /// opstation
        public UInt64 OpStation;
        ///UserInfo
        public UInt64 UserInfo;
        ///ExchangeUserinfo
        public UInt64 ExchangeUserinfo;
    };

    ///REM期权做市订单成交
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQuoteOrderExecedField
    {
        ///消息index
        public UInt32 MsgIndex;
        ///用户ID
        public UInt32 UserID;
        ///客户端编号
        public UInt32 ClOrdToken;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///申报类型
        public byte ReqType;
        ///交易所
        public byte ExchID;
        ///代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///证券类型
        public byte SecurityType;
        ///证券子类型
        public byte SecuritySubType;
        ///盘后定价交易标志
        public byte PfpFlag;
        ///REM系统单cluster唯一编号
        public UInt64 OrderID;
        ///交易所单号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        public byte[] ExchangeOrderID;
        ///交易所成交ID
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        public byte[] ExchangeExecID;
        ///本次成交价
        public Int64 LastPrice;
        ///本次成交量
        public UInt32 LastQty;
        ///剩余数量
        public UInt32 LeavesQty;
        ///开平标记 O：开仓 C：平仓
        public byte PositionSide;
        ///买卖标记
        public byte AskOrBid;
        ///订单状态
        public byte OrderState;
        ///被动单/外部单标志 0=普通单 1=被动单 2=外部单
        public byte PassiveOrderFlag;
        ///REM接受请求并发往交易所的时间戳
        public UInt64 AcceptTimestamp;
        ///交易所提供成交的时间戳
        public UInt64 ExchangeTransTimestamp;
        ///REM系统收到交易所接受的时间戳
        public UInt64 ExchangeAcceptTimestamp;
        /// 8011
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] ExchangeOrderToken;
        ///UserInfo
        public UInt64 UserInfo;
        ///ExchangeUserinfo
        public UInt64 ExchangeUserinfo;
        ///REM系统cluster唯一成交编号
        public UInt32 ExecID;
    };

    ///REM期权做市订单撤单成功
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQuoteOrderCxledField
    {
        ///消息index
        public UInt32 MsgIndex;
        ///用户ID
        public UInt32 UserID;
        ///客户端编号
        public UInt32 ClOrdToken;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///申报类型
        public byte ReqType;
        ///交易所
        public byte ExchID;
        ///代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///证券类型
        public byte SecurityType;
        ///证券子类型
        public byte SecuritySubType;
        ///盘后定价交易标志
        public byte PfpFlag;
        ///REM系统单cluster唯一编号
        public UInt64 OrderID;
        ///被撤卖单的交易所单号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        public byte[] AskExchangeOrderID;
        ///被撤卖单的userid
        public UInt32 AskOriUserID;
        ///被撤卖单的orderid
        public UInt64 AskOriOrderID;
        ///被撤卖单的原始客户订单编号
        public UInt32 AskOriClOrdToken;
        ///数量
        public UInt32 AskLeavesQty;
        ///被撤买单的交易所单号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        public byte[] BidExchangeOrderID;
        ///被撤买单的userid
        public UInt32 BidOriUserID;
        ///被撤买单的orderid
        public UInt64 BidOriOrderID;
        ///被撤买单的原始客户订单编号
        public UInt32 BidOriClOrdToken;
        ///数量
        public UInt32 BidLeavesQty;
        ///REM内核(硬件)处理完毕接受的时间戳，和开始发往交易所的时间戳相同
        public UInt64 AcceptTimestamp;
        ///交易所接受时，交易所给出的时间戳
        public UInt64 ExchangeTransTimestamp;
        ///REM系统收到交易所接受的时间戳
        public UInt64 ExchangeAcceptTimestamp;
        ///被动撤单的操作员id
        public UInt32 PassiveOptr;
        ///撤单状态
        public Int32 CxlReqStatus;
        ///UserInfo
        public UInt64 UserInfo;
        ///ExchangeUserinfo
        public UInt64 ExchangeUserinfo;
    };

    ///REM期权做市订单撤单拒绝
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQuoteOrderCxlRejectedField
    {
        ///消息index
        public UInt32 MsgIndex;
        ///用户ID
        public UInt32 UserID;
        ///客户端编号
        public UInt32 ClOrdToken;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///申报类型
        public byte ReqType;
        ///交易所
        public byte ExchID;
        ///代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///证券类型
        public byte SecurityType;
        ///证券子类型
        public byte SecuritySubType;
        ///盘后定价交易标志
        public byte PfpFlag;
        ///REM系统单cluster唯一编号
        public UInt64 OrderID;
        ///REM内核(硬件)处理完毕接受的时间戳，和开始发往交易所的时间戳相同
        public UInt64 AcceptTimestamp;
        ///交易所接受时，交易所给出的时间戳
        public UInt64 ExchangeTransTimestamp;
        ///REM系统收到交易所接受的时间戳
        public UInt64 ExchangeAcceptTimestamp;
        ///被动撤单的操作员id
        public UInt32 PassiveOptr;
        ///撤单状态
        public Int32 CxlReqStatus;
        ///系统拒绝
        public byte RejectedBy;
        ///拒绝原因
        public UInt16 RejectReason;
        ///错误原因文字
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
        public byte[] RejectText;
        ///UserInfo
        public UInt64 UserInfo;
        ///ExchangeUserinfo
        public UInt64 ExchangeUserinfo;
    };

    ///报价单回滚请求
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQuoteRewindReqField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///消息index
        public UInt32 MsgIndex;
    };

    ///报价单回滚完成
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQuoteOrderRewindFinishField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///错误码
        public UInt32 ErrCode;
    };

    #endregion
    public partial class SlEesTradeDll
    {

        #region Delegate
        public delegate void SetQuoteOrderAcceptedEvent(SlEesTradeDll traderDll, ref CShengliStockQuoteOrderAcceptedField accept);
        public event SetQuoteOrderAcceptedEvent setQuoteOrderAcceptedEvent;

        public delegate void SetQuoteOrderExchAcceptedEvent(SlEesTradeDll traderDll, ref CShengliStockQuoteOrderExchAcceptedField exchAccepted);
        public event SetQuoteOrderExchAcceptedEvent setQuoteOrderExchAcceptedEvent;

        public delegate void SetQuoteOrderRejectedEvent(SlEesTradeDll traderDll, ref CShengliStockQuoteOrderRejectedField reject);
        public event SetQuoteOrderRejectedEvent setQuoteOrderRejectedEvent;

        public delegate void SetQuoteOrderExecedEvent(SlEesTradeDll traderDll, ref CShengliStockQuoteOrderExecedField execed);
        public event SetQuoteOrderExecedEvent setQuoteOrderExecedEvent;

        public delegate void SetQuoteOrderCxledEvent(SlEesTradeDll traderDll, ref CShengliStockQuoteOrderCxledField cxled);
        public event SetQuoteOrderCxledEvent setQuoteOrderCxledEvent;

        public delegate void SetQuoteOrderCxlRejectedEvent(SlEesTradeDll traderDll, ref CShengliStockQuoteOrderCxlRejectedField cxlRejected);
        public event SetQuoteOrderCxlRejectedEvent setQuoteOrderCxlRejectedEvent;

        public delegate void SetQuoteOrderRewindFinishEvent(SlEesTradeDll traderDll, ref CShengliStockQuoteOrderRewindFinishField rewind);
        public event SetQuoteOrderRewindFinishEvent setQuoteOrderRewindFinishEvent;
        #endregion

        #region C Callback mapping
        protected delegate void SLEES_OptTrade_SetQuoteOrderAcceptedEventPtr(IntPtr handle, ref CShengliStockQuoteOrderAcceptedField accept);
        protected delegate void SLEES_OptTrade_SetQuoteOrderExchAcceptedEventPtr(IntPtr handle, ref CShengliStockQuoteOrderExchAcceptedField exchAccept);
        protected delegate void SLEES_OptTrade_SetQuoteOrderRejectedEventPtr(IntPtr handle, ref CShengliStockQuoteOrderRejectedField reject);
        protected delegate void SLEES_OptTrade_SetQuoteOrderExecedEventPtr(IntPtr handle, ref CShengliStockQuoteOrderExecedField execed);
        protected delegate void SLEES_OptTrade_SetQuoteOrderCxledEventPtr(IntPtr handle, ref CShengliStockQuoteOrderCxledField cxled);
        protected delegate void SLEES_OptTrade_SetQuoteOrderCxlRejectedEventPtr(IntPtr handle, ref CShengliStockQuoteOrderCxlRejectedField cxlRejected);
        protected delegate void SLEES_OptTrade_SetQuoteOrderRewindFinishEventPtr(IntPtr handle, ref CShengliStockQuoteOrderRewindFinishField rewind);

        SLEES_OptTrade_SetQuoteOrderAcceptedEventPtr setQuoteOrderAcceptedEventPtr;
        SLEES_OptTrade_SetQuoteOrderExchAcceptedEventPtr setQuoteOrderExchAcceptedEventPtr;
        SLEES_OptTrade_SetQuoteOrderRejectedEventPtr setQuoteOrderRejectedEventPtr;
        SLEES_OptTrade_SetQuoteOrderExecedEventPtr setQuoteOrderExecedEventPtr;
        SLEES_OptTrade_SetQuoteOrderCxledEventPtr setQuoteOrderCxledEventPtr;
        SLEES_OptTrade_SetQuoteOrderCxlRejectedEventPtr setQuoteOrderCxlRejectedEventPtr;
        SLEES_OptTrade_SetQuoteOrderRewindFinishEventPtr setQuoteOrderRewindFinishEventPtr;
        #endregion

        #region C dll export functions mapping
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQuoteOrderAcceptedEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQuoteOrderAcceptedEvent(IntPtr handle, SLEES_OptTrade_SetQuoteOrderAcceptedEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQuoteOrderExchAcceptedEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQuoteOrderExchAcceptedEvent(IntPtr handle, SLEES_OptTrade_SetQuoteOrderExchAcceptedEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQuoteOrderRejectedEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQuoteOrderRejectedEvent(IntPtr handle, SLEES_OptTrade_SetQuoteOrderRejectedEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQuoteOrderExecedEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQuoteOrderExecedEvent(IntPtr handle, SLEES_OptTrade_SetQuoteOrderExecedEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQuoteOrderCxledEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQuoteOrderCxledEvent(IntPtr handle, SLEES_OptTrade_SetQuoteOrderCxledEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQuoteOrderCxlRejectedEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQuoteOrderCxlRejectedEvent(IntPtr handle, SLEES_OptTrade_SetQuoteOrderCxlRejectedEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_RewindQuoteOrder", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_RewindQuoteOrder(IntPtr handle,ref CShengliStockQuoteRewindReqField rewindReq);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQuoteOrderRewindFinishEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQuoteOrderRewindFinishEvent(IntPtr handle, SLEES_OptTrade_SetQuoteOrderRewindFinishEventPtr pFun);

        #endregion

        #region api 快照回滚
        public int RewindQuoteOrderReq(ref CShengliStockQuoteRewindReqField rewindReq)
        {
            int ret = SLEES_OptTrade_RewindQuoteOrder(tradeHandle, ref rewindReq);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_RewindQuoteOrder(tradeHandle, ref rewindReq);
            }
            return ret;
        }
        public int SLEES_QueryEntrustList(ref CShengliStockReqQueryEntrustField rewindReq)
        {
            int ret = SLEES_QueryEntrustList(tradeHandle, ref rewindReq);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_QueryEntrustList(tradeHandle, ref rewindReq);
            }
            return ret;
        }
        public int SLEES_QueryEntrustExecutionList(ref CShengliStockReqQueryEntrustExecutionField rewindReq)
        {
            int ret = SLEES_QueryEntrustExecutionList(tradeHandle, ref rewindReq);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_QueryEntrustExecutionList(tradeHandle, ref rewindReq);
            }
            return ret;
        }
        #endregion

        #region 1788 查询通道列表
        public int SLEES_OptTrade_QueryChannelList(uint nRequestID)
        {
            int ret = SLEES_OptTrade_QueryChannelList(tradeHandle, nRequestID);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_QueryChannelList(tradeHandle, nRequestID);
            }
            return ret;
        }
        #endregion

        #region Event
        private void RecvQueryEntrustListEvent(IntPtr handle, ref CShengliStockRespQueryEntrustField pquery, bool isLast)
        {
            queryEntrustListEvent?.Invoke(this, ref pquery, isLast);
        }
        private void RecvQueryEntrustExecutionEven(IntPtr handle, ref CShengliStockRespQueryEntrustExecutionField pquery, bool isLast)
        {
            queryEntrustExecutionEvent?.Invoke(this, ref pquery, isLast);
        }
        private void RecvQuoteOrderRewindFinishEvent(IntPtr handle, ref CShengliStockQuoteOrderRewindFinishField rewind)
        {
            setQuoteOrderRewindFinishEvent?.Invoke(this,ref rewind);
        }
        private void RecvQuoteOrderAcceptedEvent(IntPtr handle, ref CShengliStockQuoteOrderAcceptedField accept)
        {
            setQuoteOrderAcceptedEvent?.Invoke(this,ref accept);
        }

        private void RecvQuoteOrderExchAcceptedEvent(IntPtr handle, ref CShengliStockQuoteOrderExchAcceptedField exchAccept)
        {
            setQuoteOrderExchAcceptedEvent?.Invoke(this,ref exchAccept);
        }

        private void RecvQuoteOrderRejectedEvent(IntPtr handle, ref CShengliStockQuoteOrderRejectedField reject)
        {
            setQuoteOrderRejectedEvent?.Invoke(this,ref reject);
        }

        private void RecvQuoteOrderExecedEvent(IntPtr handle, ref CShengliStockQuoteOrderExecedField execed)
        {
            setQuoteOrderExecedEvent?.Invoke(this,ref execed);
        }

        private void RecvQuoteOrderCxledEvent(IntPtr handle, ref CShengliStockQuoteOrderCxledField cxled)
        {
            setQuoteOrderCxledEvent?.Invoke(this, ref cxled);
        }

        private void RecvQuoteOrderCxlRejectedEvent(IntPtr handle, ref CShengliStockQuoteOrderCxlRejectedField cxlReject)
        {
            setQuoteOrderCxlRejectedEvent?.Invoke(this,ref cxlReject);
        }

        #endregion

    }
}
