﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;
using System.Threading;
using System.Threading.Tasks;
using System.Reflection;

namespace SlEesTrade
{
 
    public partial class SlEesTradeDll
	{
		// CShengliStockTraderSpi

		///连接消息的回调
		public delegate void TradeClientConnectionEvent(SlEesTradeDll tradeDll, int errNo, string errStr);
		public event TradeClientConnectionEvent tradeClientConnectionEvent;

		///连接断开消息的回调
		public delegate void TradeClientDisconnectionEvent(SlEesTradeDll tradeDll, int errNo, string errStr);
		public event TradeClientDisconnectionEvent tradeClientDisConnectionEvent;

		///登录消息的回调
		public delegate void TradeClientUserLogonEvent(SlEesTradeDll tradeDll, ref CShengliStockRespUserLoginField logon, int nRequestID);
		public event TradeClientUserLogonEvent tradeClientUserLogonEvent;

		///修改密码响应回调
		public delegate void TradeClientChangePasswordEvent(SlEesTradeDll tradeDll, ref CShengliStockRespChangePwdField changePwd, int nRequestID);
		public event TradeClientChangePasswordEvent tradeClientChangePasswordEvent;

		///查询客户号列表的返回事件
		public delegate void TradeClientQueryClientIdEvent(SlEesTradeDll tradeDll, ref CShengliStockClientIDListField clientInfo, int nRequestID, byte bIsLast);
		public event TradeClientQueryClientIdEvent tradeClientQueryClientIdEvent;

		///查询资金账户列表的返回事件
		public delegate void TradeClientQueryAccountEvent(SlEesTradeDll tradeDll, ref CShengliStockAccountListField accountInfo, int nRequestID, byte bIsLast);
		public event TradeClientQueryAccountEvent tradeClientQueryAccountEvent;
        ///查询股东账户列表的返回事件
        public delegate void TradeClientQueryTradeAccountEvent(SlEesTradeDll tradeDll, ref CShengliStockTradeAccountListField accountInfo, int nRequestID, byte bIsLast);
		public event TradeClientQueryTradeAccountEvent tradeClientQueryTradeAccountEvent;

		///查询合约列表的返回事件
		public delegate void TradeClientQuerySymbolEvent(SlEesTradeDll tradeDll, ref CShengliStockNormalSecurityCodeField symbolInfo, int nRequestID, byte bIsLast);
		public event TradeClientQuerySymbolEvent tradeClientQuerySymbolEvent;

        ///查询参考汇率返回事件
        public delegate void TradeClientQueryReferenceExchangeRateEvent(SlEesTradeDll tradeDll, ref CShengliStockReferenceExchangeRateField fieldRate, int nRequestID, byte bIsLast);
        public event TradeClientQueryReferenceExchangeRateEvent tradeClientQueryReferenceExchangeRateEvent;

        ///查询ETF列表的返回事件
        public delegate void TradeClientQueryETFListEvent(SlEesTradeDll tradeDll, ref CShengliStockETFInfoField etfInfo, int nRequestID, byte bIsLast);
        public event TradeClientQueryETFListEvent tradeClientQueryETFListEvent;

        ///查询委托明细的返回事件
        public delegate void TradeClientQueryEntrustDetailsEvent(SlEesTradeDll tradeDll, ref CShengliStockETFRemAcceptInfoField entrustDetails, int nRequestID, byte bIsLast);
        public event TradeClientQueryEntrustDetailsEvent tradeClientQueryEntrustDetailsEvent;

        ///查询PCF列表的返回事件
        public delegate void TradeClientQureyPCFComponentInfoListEvent(SlEesTradeDll tradeDll, ref CShengliStockPCFCompoonentInfoField etfInfo, int nRequestID, byte bIsLast);
        public event TradeClientQureyPCFComponentInfoListEvent tradeClientQureyPCFComponentInfoListEvent;

        ///查询ETF市场接受的返回事件
        public delegate void TradeClientQureyETFMarketAcceptCompoonentInfoListEvent(SlEesTradeDll tradeDll, ref CShengliStockETFMarketAcceptCompoonentInfoField etfInfo, int nRequestID, byte bIsLast);
        public event TradeClientQureyETFMarketAcceptCompoonentInfoListEvent tradeClientQureyETFMarketAcceptCompoonentInfoListEvent;

        ///查询ETF成份股查询的返回事件
        public delegate void TradeClientQueryETFMemberEvent(SlEesTradeDll tradeDll, ref CShengliStockEtfMemberField member, int nRequestID, byte bIsGlobalLast);
        public event TradeClientQueryETFMemberEvent tradeClientQueryETFMemberEvent;

		///查询期权细节的返回事件
		public delegate void TradeClientQueryOptionDetailEvent(SlEesTradeDll tradeDll, ref CShengliStockOptionSecurityCodeField option, int nRequestID, byte bIsLast);
		public event TradeClientQueryOptionDetailEvent tradeClientQueryOptionDetailEvent;

		/// TODO
		///查询帐户交易费用的返回事件 
		public delegate void TradeClientQueryAccountTradeFeeEvent(SlEesTradeDll tradeDll );
		public event TradeClientQueryAccountTradeFeeEvent tradeClientQueryAccountTradeFeeEvent;

		/// 查询仓位列表的返回事件
		public delegate void TradeClientQueryNormalPositionEvent(SlEesTradeDll tradeDll, ref CShengliStockNormalPositionField pos, int nRequestID, byte bIsLast);
		public event TradeClientQueryNormalPositionEvent tradeClientQueryNormalPositionEvent;
		public delegate void TradeClientQueryOptionPositionEvent(SlEesTradeDll tradeDll, ref CShengliStockOptionPositionField pos, int nRequestID, byte bIsLast);
		public event TradeClientQueryOptionPositionEvent tradeClientQueryOptionPositionEvent;
        /// 查询组合策略持仓列表的返回事件
        public delegate void TradeClientQueryOptionCombStrategyPositionEvent(SlEesTradeDll tradeDll, ref CShengliStockOptionCombStrategyPositionField pos, int nRequestID, byte bIsLast);
        public event TradeClientQueryOptionCombStrategyPositionEvent tradeClientQueryOptionCombStrategyPositionEvent;


        ///订单rewind的返回事件
        public delegate void TradeClientOrderRewindEvent(SlEesTradeDll tradeDll, ref CShengliStockOrderAcceptedField order, int nRequestID);
		public event TradeClientOrderRewindEvent tradeClientOrderRewindEvent;

		///成交rewind的返回事件
		public delegate void TradeClientExecRewindEvent(SlEesTradeDll tradeDll, ref CShengliStockOrderExecedField exec, int nRequestID);
		public event TradeClientExecRewindEvent tradeClientExecRewindEvent;

		///撤单请求rewind响应
		public delegate void TradeClientCxlReqRewindEvent(SlEesTradeDll tradeDll, ref CShengliStockOrderCxledField cxlReq, int nRequestID);
		public event TradeClientCxlReqRewindEvent tradeClientCxlReqRewindEvent;

		///客户号订单rewind完成的返回事件
		public delegate void TradeClientOrderRewindFinishEvent(SlEesTradeDll tradeDll, ref CShengliStockOrderRewindFinishField orderFinish, int nRequestID);
		public event TradeClientOrderRewindFinishEvent tradeClientOrderRewindFinishEvent;

		///成交rewind完成的返回事件
		public delegate void TradeClientExecRewindFinishEvent(SlEesTradeDll tradeDll, ref CShengliStockExecRewindFinishField execFinish, int nRequestID);
		public event TradeClientExecRewindFinishEvent tradeClientExecRewindFinishEvent;

		///撤销请求rewind完成的返回事件
		public delegate void TradeClientCxlReqRewindFinishEvent(SlEesTradeDll tradeDll, ref CShengliStockCxlReqRewindFinishField cxlReqFinish, int nRequestID);
		public event TradeClientCxlReqRewindFinishEvent tradeClientCxlReqRewindFinishEvent;

		///客户号资金状态查询的返回事件
		public delegate void TradeClientQueryClientBpStatusEvent(SlEesTradeDll tradeDll, ref CShengliStockBpStatusField bpInfo, int nRequestID, byte bIsLast);
		public event TradeClientQueryClientBpStatusEvent tradeClientQueryClientBpStatusEvent;

		///交易所连接查询的返回事件
		public delegate void TradeClientQueryMarketSessionEvent(SlEesTradeDll tradeDll, ref CShengliStockExchangeConnectField session, int nRequestID, byte bIsLast);
		public event TradeClientQueryMarketSessionEvent tradeClientQueryMarketSessionEvent;

        ///交易所状态变化通知事件
        public delegate void TradeClientMarketStatusChangeReportEvent(SlEesTradeDll tradeDll, ref CShengliStockExchangeStatusReportField report);
		public event TradeClientMarketStatusChangeReportEvent tradeClientMarketStatusChangeReportEvent;

		///订单接受的返回事件
		public delegate void TradeClientOrderAcceptedEvent(SlEesTradeDll tradeDll, ref CShengliStockOrderAcceptedField accept);
		public event TradeClientOrderAcceptedEvent tradeClientOrderAcceptedEvent;

        ///订单拒绝的返回事件
        public delegate void TradeClientOrderRejectedEvent(SlEesTradeDll tradeDll, ref CShengliStockOrderRejectedField reject);
		public event TradeClientOrderRejectedEvent tradeClientOrderRejectedEvent;

		///成交回报的返回事件
		public delegate void TradeClientOrderExecutedEvent(SlEesTradeDll tradeDll, ref CShengliStockOrderExecedField exec);
		public event TradeClientOrderExecutedEvent tradeClientOrderExecutedEvent;

		///撤单成功的返回事件
		public delegate void TradeClientOrderCxledEvent(SlEesTradeDll tradeDll, ref CShengliStockOrderCxledField cxled);
		public event TradeClientOrderCxledEvent tradeClientOrderCxledEvent;

		///撤单拒绝的返回事件
		public delegate void TradeClientOrderCxlRejectedEvent(SlEesTradeDll tradeDll, ref CShengliStockOrderCxlRejectedField cxlRejected);
		public event TradeClientOrderCxlRejectedEvent tradeClientOrderCxlRejectedEvent;

		///ETF申购赎回成交的返回事件
		public delegate void TradeClientETFExecutedEvent(SlEesTradeDll tradeDll, ref CShengliStockOrderExecedField head, ref CShengliStockEtfExecBodyField[] arrBody, int arrCount);
		public event TradeClientETFExecutedEvent tradeClientETFExecutedEvent;

		///风控累计值返回，2个
		public delegate void TradeClientAccountRiskDataEvent(SlEesTradeDll tradeDll, ref CShengliStockAccountRiskDataRspField accRsp);
		public event TradeClientAccountRiskDataEvent tradeClientAccountRiskDataEvent;

		public delegate void TradeClientSymbolRiskDataEvent(SlEesTradeDll tradeDll, ref CShengliStockSymbolRiskDataRspField symRsp);
		public event TradeClientSymbolRiskDataEvent tradeClientSymbolRiskDataEvent;

        ///向其他节点转资金
        public delegate void OutFundAccountAmountNodeEvent(SlEesTradeDll tradeDll, ref CShengliStockTrasnBpField symRsp);
		public event OutFundAccountAmountNodeEvent outFundAccountAmountNodeEvent;

        public delegate void SetQueryOutFundAccountAmountNodeDetailEvent(SlEesTradeDll tradeDll,ref CShengliStockTrasnQueryBpDetailField bpDetail,int nRequestID);
        public event SetQueryOutFundAccountAmountNodeDetailEvent setQueryOutFundAccountAmountNodeDetailEvent;

        public delegate void SendOpStationReportEvent(SlEesTradeDll tradeDll,ref CShengliOpStationReportResp opStation);
        public event SendOpStationReportEvent sendOpStationReportEvent;

        public delegate void SetRecvPushCashInOutEvent(SlEesTradeDll tradeDll, ref CShengliStockRespCashInOutField record);
        public event SetRecvPushCashInOutEvent setRecvPushCashInOutEvent;

        public delegate void SetSubscribeMktCltOrdIDEvent(SlEesTradeDll tradeDll, ref CShengliStockRespSubscribeField subscribe, int requestId);
        public event SetSubscribeMktCltOrdIDEvent setSubscribeMktCltOrdIDEvent;

        public delegate void SetRecvPushSubscribeMktCltOrdIDEvent(SlEesTradeDll tradeDll, ref CShengliStockRespMktCltOrdIDField mktCltOrdID);
        public event SetRecvPushSubscribeMktCltOrdIDEvent setRecvPushSubscribeMktCltOrdIDEvent;

        public delegate void FundAcctPwdCheckEvent(SlEesTradeDll tradeDll, ref CShengliFundAccountPwdCheckResp rsp);
        public event FundAcctPwdCheckEvent fundAcctPwdCheckEvent;

        public delegate void QueryAcctMarginEvent(SlEesTradeDll tradeDll, ref CShengliStockQuerySymbolMarginInfoRespField margin);
        public event QueryAcctMarginEvent queryAcctMarginEvent;

        public delegate void QueryAcctFeeEvent(SlEesTradeDll tradeDll, ref CShengliStockQuerySymbolFeeInfoRespField fee);
        public event QueryAcctFeeEvent queryAcctFeeEvent;

        //同主席划转资金的返回事件
        public delegate void ChairmanCustAcctFundInOutEvent(SlEesTradeDll tradeDll, ref CShengliStockInOutFundAccountAmountField inOut, int nRequestID);
        public event ChairmanCustAcctFundInOutEvent chairmanCustAcctFundInOutEvent;

        //同主席划转标的券的返回事件
        public delegate void ChairmanTransferUnderlyingQtyEvent(SlEesTradeDll tradeDll, ref CShengliStockFrzUnderlyingSymbolQtyField underlyingQty, int nRequestID);
        public event ChairmanTransferUnderlyingQtyEvent chairmanTransferUnderlyingQtyEvent;

        //普通单撤单请求事件
        public delegate void CxlOrderReqEventHandler(CShengliStockCxlOrderField ord,int ret);
        public event CxlOrderReqEventHandler CxlOrderReqEvent;

        //报价单撤单请求事件
        public delegate void CxlQuoteOrderEventHandler(CShengliQuoteEnterOrderField ord);
        public event CxlQuoteOrderEventHandler CxlOneSideQuoteOrderEvent;
        public event CxlQuoteOrderEventHandler CxlQuoteOrderEvent;

        //查询风控门限值的返回事件
        public delegate void RiskRuleThresholdsEvent(SlEesTradeDll tradeDll, ref CShengliStockReqQueryRiskThresholdValueRespField riskThreshold, int nRequestID, byte bIsLast);
        public event RiskRuleThresholdsEvent riskRuleThresholdsEvent;
        //查询风控累计值的返回事件
        public delegate void RiskRuleAccumulateValEvent(SlEesTradeDll tradeDll, ref CShengliStockReqQueryRiskValueRespField riskThreshold, int nRequestID, byte bIsLast);
        public event RiskRuleAccumulateValEvent riskRuleAccumulateValEvent;
        //查询旁路风控的返回事件
        public delegate void AcctMonitorValueEvent(SlEesTradeDll tradeDll, ref CShengliStockReqQueryAcctMonitorValueRespField pResp, int nReqID, byte bIsLast);
        public event AcctMonitorValueEvent acctMonitorValueEvent;

        //查询签约银行的返回事件
        public delegate void QuerySigningBankListEvent(SlEesTradeDll tradeDll, CShengliStockQuerySigningBankInfoRespField pResp, int nReqID, byte bIsLast);
        public event QuerySigningBankListEvent querySigningBankListEvent;

        //查询银行余额的返回事件
        public delegate void QueryBankBalanceInfoEvent(SlEesTradeDll tradeDll, CShengliStockQueryBankBalanceInfoRespField pResp, int nReqID);
        public event QueryBankBalanceInfoEvent queryBankBalanceInfoEvent;

        //一步式入金的请求事件
        public delegate void OneStepTransferInCashReqEvent(SlEesTradeDll tradeDll, CShengliStockOneStepTransferInCashReqField req);
        public event OneStepTransferInCashReqEvent oneStepTransferInCashReqEvent;

        //一步式入金的返回事件
        public delegate void OneStepTransferInCashRespEvent(SlEesTradeDll tradeDll, CShengliStockOneStepTransferInCashRespField pResp, int nReqID);
        public event OneStepTransferInCashRespEvent oneStepTransferInCashRespEvent;

        //一步式出金的请求事件
        public delegate void OneStepTransferOutCashReqEvent(SlEesTradeDll tradeDll, CShengliStockOneStepTransferOutCashReqField req);
        public event OneStepTransferOutCashReqEvent oneStepTransferOutCashReqEvent;

        //一步式出金的返回事件
        public delegate void OneStepTransferOutCashRespEvent(SlEesTradeDll tradeDll, CShengliStockOneStepTransferOutCashRespField pResp, int nReqID);
        public event OneStepTransferOutCashRespEvent oneStepTransferOutCashRespEvent;

        //查询委托方式的返回事件
        public delegate void QueryDelegateTypeEvent(SlEesTradeDll tradeDll, CShengliStockQueryDeletageTypeRespField pResp, int nReqID, byte bIsLast);
        public event QueryDelegateTypeEvent queryDelegateTypeEvent;

        //断开连接的返回事件
        public delegate void DisConnEvent(SlEesTradeDll tradeDll, CShengliStockCommonMsgField pResp);
        public event DisConnEvent disConnEvent;


        #region 1224资金划拨

        public delegate void SLEES_OptTrade_QueryFundStrategyCfgEventPtr(IntPtr handle, ref CShengliStockQueryFundStrategyCfgResp pResp, int nRequestID);
        public event SLEES_OptTrade_QueryFundStrategyCfgEventPtr queryFundStrategyCfgEvent;
        public delegate void SLEES_OptTrade_SetFundStrategyCfgEventPtr(IntPtr handle, ref CShengliStockSetFundStrategyCfgResp pResp, int nRequestID);
        public event SLEES_OptTrade_SetFundStrategyCfgEventPtr setFundStrategyCfgEvent;

        public delegate void SLEES_OptTrade_QueryFundStrategySwitchStatusEventPtr(IntPtr handle, ref CShengliStockQueryFundStrategySwitchStatusResp pResp, int nReqID);
        public event SLEES_OptTrade_QueryFundStrategySwitchStatusEventPtr queryFundStrategySwitchStatusEvent;
        public delegate void SLEES_OptTrade_SetFundStrategySwitchStatusEventPtr(IntPtr handle, ref CShengliStockSetFundStrategySwitchStatusResp pResp, int nReqID);
        public event SLEES_OptTrade_SetFundStrategySwitchStatusEventPtr setFundStrategySwitchStatusEvent;

        #endregion


        #region 快照回滚
        public delegate void SetQueryEntrustListEvent(SlEesTradeDll traderDll, ref CShengliStockRespQueryEntrustField rewind, bool isLast);
        public event SetQueryEntrustListEvent queryEntrustListEvent;

        public delegate void SetQueryEntrustExecutionEvent(SlEesTradeDll traderDll, ref CShengliStockRespQueryEntrustExecutionField rewind, bool isLast);
        public event SetQueryEntrustExecutionEvent queryEntrustExecutionEvent;
        #endregion

        #region 1178 查询通道列表 
        public delegate void SetQueryChannelEvent(SlEesTradeDll traderDll, ref CShengliStockChannelField pChannelInfo, uint nReqID, bool bIsLast);
        public event SetQueryChannelEvent queryChannelEvent;
        #endregion

        // 查询仓位划转流水的返回事件
        public delegate void QueryTransferPositionListEvent(SlEesTradeDll tradeDll, CShengliStockRespTransferPositionField pResp, int nReqID, byte bIsLast);
        public event QueryTransferPositionListEvent queryTransPosListEvent;

        // 仓位划转流水推送事件
        public delegate void RecvTransferPositionListEvent(SlEesTradeDll tradeDll, CShengliStockRespTransferPositionField pResp);
        public event RecvTransferPositionListEvent recvTransferPositionListEvent;

        // 查询仓位数量的返回事件
        public delegate void QueryUnderlyingSymbolQtyExEvent(SlEesTradeDll tradeDll, CShengliStockUnderlyingSymbolQtyField pResp, int nReqID);
        public event QueryUnderlyingSymbolQtyExEvent queryUnderlyingSymbolQtyExEvent;

        // 主席划拨标的券事件
        public delegate void TransferUnderlyingQtyExEvent(SlEesTradeDll tradeDll, CShengliStockFrzUnderlyingSymbolQtyReqField info, CShengliStockConnMasterField pMasterInfo,int ret);
        public event TransferUnderlyingQtyExEvent transferUnderlyingQtyExEvent;
     
       
        // SL EES TRADE EVENT
        #region C Callback mapping
        protected delegate void SLEES_OptTrade_ConnectionEventPtr(IntPtr handle, int errNo, string errStr);
		protected delegate void SLEES_OptTrade_DisconnectionEventPtr(IntPtr handle, int errNo, string errStr);
        protected delegate void SLEES_OptTrade_SetDisQueryConnectionEventPtr(IntPtr handle, int errNo, string errStr);
        protected delegate void SLEES_OptTrade_UserLogonEventPtr(IntPtr handle, ref CShengliStockRespUserLoginField logon, int nRequestID);
		protected delegate void SLEES_OptTrade_ChangePasswordEventPtr(IntPtr handle, ref CShengliStockRespChangePwdField changePwd, int nRequestID);
		protected delegate void SLEES_OptTrade_QueryClientIdEventPtr(IntPtr handle, ref CShengliStockClientIDListField clientInfo, int nRequestID, byte bIsLast);
		protected delegate void SLEES_OptTrade_QueryFundAccountEventPtr(IntPtr handle, ref CShengliStockAccountListField accountInfo, int nRequestID, byte bIsLast);
		protected delegate void SLEES_OptTrade_QueryTradeAccountEventPtr(IntPtr handle, ref CShengliStockTradeAccountListField accountInfo, int nRequestID, byte bIsLast);
		protected delegate void SLEES_OptTrade_QuerySecurityCodeEventPtr(IntPtr handle, ref CShengliStockNormalSecurityCodeField symbolInfo, int nRequestID, byte bIsLast);
        protected delegate void SLEES_OptTrade_QueryReferenceExchangeRateEventPtr(IntPtr handle, ref CShengliStockReferenceExchangeRateField fieldRate, int nRequestID, byte bIsLast);
        protected delegate void SLEES_OptTrade_QueryETFMemberEventPtr(IntPtr handle, ref CShengliStockEtfMemberField member, int nRequestID, byte bIsGlobalLast);
        protected delegate void SLEES_OptTrade_QueryETFListEventPtr(IntPtr handle, ref CShengliStockETFInfoField etfInfo, int nRequestID, byte bIsLast);
        protected delegate void SLEES_OptTrade_QueryETFRemAcceptEventPtr(IntPtr handle, ref CShengliStockETFRemAcceptInfoField symbolInfo, int nRequestID, byte bIsLast);
        protected delegate void SLEES_OptTrade_QureyETFComponentListEventPtr(IntPtr handle, ref CShengliStockETFRemAcceptInfoField symbolInfo, int nRequestID, byte bIsLast);
        protected delegate void SLEES_OptTrade_QureyPCFComponentInfoListEventPtr(IntPtr handle, ref CShengliStockPCFCompoonentInfoField symbolInfo, int nRequestID, byte bIsLast);
        protected delegate void SLEES_OptTrade_QureyETFMarketAcceptComponentListEventPtr(IntPtr handle, ref CShengliStockETFMarketAcceptCompoonentInfoField symbolInfo, int nRequestID, byte bIsLast);

        protected delegate void SLEES_OptTrade_QueryOptionDetailEventPtr(IntPtr handle, ref CShengliStockOptionSecurityCodeField option, int nRequestID, byte bIsLast);
        protected delegate void SLEES_OptTrade_QueryAccountTradeFeeEventPtr(IntPtr handle);
        protected delegate void SLEES_OptTrade_QueryNormalPositionEventPtr(IntPtr handle, ref CShengliStockNormalPositionField pos, int nRequestID, byte bIsLast);
        protected delegate void SLEES_OptTrade_QueryOptionPositionEventPtr(IntPtr handle, ref CShengliStockOptionPositionField pos, int nRequestID, byte bIsLast);
        protected delegate void SLEES_OptTrade_QueryOptionCombStrategyPositionEventPtr(IntPtr handle, ref CShengliStockOptionCombStrategyPositionField pos, int nRequestID, byte bIsLast);
        protected delegate void SLEES_OptTrade_OrderRewindEventPtr(IntPtr handle, ref CShengliStockOrderAcceptedField order, int nRequestID);
		protected delegate void SLEES_OptTrade_ExecRewindEventPtr(IntPtr handle, ref CShengliStockOrderExecedField exec, int nRequestID);
		protected delegate void SLEES_OptTrade_CxlReqRewindEventPtr(IntPtr handle, ref CShengliStockOrderCxledField cxlReq, int nRequestID);
		protected delegate void SLEES_OptTrade_OrderRewindFinishEventPtr(IntPtr handle, ref CShengliStockOrderRewindFinishField orderFinish, int nRequestID);
		protected delegate void SLEES_OptTrade_ExecRewindFinishEventPtr(IntPtr handle, ref CShengliStockExecRewindFinishField execFinish, int nRequestID);
		protected delegate void SLEES_OptTrade_CxlReqRewindFinishEventPtr(IntPtr handle, ref CShengliStockCxlReqRewindFinishField cxlReqFinish, int nRequestID);
		protected delegate void SLEES_OptTrade_QueryClientBpStatusEventPtr(IntPtr handle, ref CShengliStockBpStatusField bpInfo, int nRequestID, byte bIsLast);
		protected delegate void SLEES_OptTrade_QueryMarketSessionEventPtr(IntPtr handle, ref CShengliStockExchangeConnectField session, int nRequestID, byte bIsLast);
		protected delegate void SLEES_OptTrade_MarketStatusChangeReportEventPtr(IntPtr handle, ref CShengliStockExchangeStatusReportField report);
		protected delegate void SLEES_OptTrade_OrderAcceptedEventPtr(IntPtr handle, ref CShengliStockOrderAcceptedField accept);
		protected delegate void SLEES_OptTrade_OrderRejectedEventPtr(IntPtr handle, ref CShengliStockOrderRejectedField reject);
		protected delegate void SLEES_OptTrade_OrderExecedEventPtr(IntPtr handle, ref CShengliStockOrderExecedField exec);
		protected delegate void SLEES_OptTrade_OrderCxledEventPtr(IntPtr handle, ref CShengliStockOrderCxledField cxled);
		protected delegate void SLEES_OptTrade_OrderCxlRejectedEventPtr(IntPtr handle, ref CShengliStockOrderCxlRejectedField cxlRejected);
		protected delegate void SLEES_OptTrade_ETFExecutedEventPtr(IntPtr handle, ref CShengliStockOrderExecedField head, ref CShengliStockEtfExecBodyField[] arrBody, int arrCount);
		protected delegate void SLEES_OptTrade_AccountRiskDataEventPtr(IntPtr handle, ref CShengliStockAccountRiskDataRspField accRsp);
		protected delegate void SLEES_OptTrade_SymbolRiskDataEventPtr(IntPtr handle, ref CShengliStockSymbolRiskDataRspField symRsp);
		protected delegate void SLEES_OptTrade_OutFundAccountAmountNodeEventPtr(IntPtr handle, ref CShengliStockTrasnBpField symRsp, int nRequestID);
		protected delegate void SLEES_OptTrade_SetQueryOutFundAccountAmountNodeDetailEventPtr(IntPtr handle, ref CShengliStockTrasnQueryBpDetailField bpDetail, int nRequestID,byte bIsLast);
        protected delegate void SLEES_OptTrade_SendOpStationReportEventPtr(IntPtr handle,ref CShengliOpStationReportResp opStation);
        protected delegate void SLEES_OptTrade_ReqQueryRiskRuleThresholdsEventPtr(IntPtr handel,ref CShengliStockReqQueryRiskThresholdValueRespField riskThreshold, int nRequestID, byte bIsLast);
        protected delegate void SLEES_OptTrade_ReqQueryRiskRuleAccumulateValEventPtr(IntPtr handel,ref CShengliStockReqQueryRiskValueRespField pResp, int nReqID, byte bIsLast);
        protected delegate void SLEES_OptTrade_ReqQueryAcctMonitorValueEventPtr(IntPtr handle, ref CShengliStockReqQueryAcctMonitorValueRespField pResp, int nReqID, byte bIsLast);
        protected delegate void SLEES_OptTrade_SetQueryCashInOutEventPtr(IntPtr handle,ref CShengliStockRespCashInOutField record,int nRequestID, byte bIsLast);
        protected delegate void SLEES_OptTrade_SetPushCashInOutReportEventPtr(IntPtr handle, ref CShengliStockRespCashInOutField record);
        protected delegate void SLEES_OptTrade_SetSubscribeEventPtr(IntPtr handle, ref CShengliStockRespSubscribeField subscribe, int nRequestID);
        protected delegate void SLEES_OptTrade_SetPushMktCltOrdIDEventPtr(IntPtr handle, ref CShengliStockRespMktCltOrdIDField mktCltOrdID);
		protected delegate void SLEES_OptTrade_FundAccountPwdCheckReportEventPtr(IntPtr handle, ref CShengliFundAccountPwdCheckResp checkResp);

        protected delegate void SLEES_OptTrade_SetInOutFundAccountAmountEventPtr(IntPtr handle, ref CShengliStockInOutFundAccountAmountField inOutFund,int nRequestID);
        protected delegate void SLEES_OptTrade_SetFrozenUnderlyingSymbolQtyEventPtr(IntPtr handle,ref CShengliStockFrzUnderlyingSymbolQtyField frzUnderlying,int nRequestID);
        protected delegate void SLEES_OptTrade_SetQueryUnderlyingSymbolQtyEventPtr(IntPtr handle,ref CShengliStockUnderlyingSymbolQtyField underlyingInfo,int nRequestID);
        protected delegate void SLEES_OptTrade_SetQueryChairmanAcctAvailBpEventPtr(IntPtr handle, ref CShengliStockQryChairmanAcctAvailBpRespFiled chairmanAcctAvailBp, int nRequestID);
        protected delegate void SLEES_OptTrade_SetCommonMsgEventPtr(IntPtr handle, ref CShengliStockCommonMsgField info);
        protected delegate void SLEES_OptTrade_SetQuerySymbolMarginInfoEventPtr(IntPtr handle, ref CShengliStockQuerySymbolMarginInfoRespField pResp, int nReqID, byte bIsLast);
        protected delegate void SLEES_OptTrade_SetQuerySymbolFeeInfoEventPtr(IntPtr handle, ref CShengliStockQuerySymbolFeeInfoRespField pResp, int nReqID, byte bIsLast);


        #region 1224资金划拨
        protected delegate void SLEES_OptTrade_SetQuerySigningBankInfoEventPtr(IntPtr handle, ref CShengliStockQuerySigningBankInfoRespField pResp, int nReqID, byte bIsLast);
        protected delegate void SLEES_OptTrade_SetQueryBankBalanceInfoEventPtr(IntPtr handle, ref CShengliStockQueryBankBalanceInfoRespField pResp, int nReqID);
        protected delegate void SLEES_OptTrade_SetBankToDeriveEventPtr(IntPtr handle, ref CShengliStockOneStepTransferInCashRespField pResp, int nReqID);
        protected delegate void SLEES_OptTrade_SetDeriveToBankEventPtr(IntPtr handle, ref CShengliStockOneStepTransferOutCashRespField pResp, int nReqID);
        protected delegate void SLEES_OptTrade_SetQueryDelegateTypeEventPtr(IntPtr handle, ref CShengliStockQueryDeletageTypeRespField pResp, int nReqID, byte bIsLast);

        protected delegate void SLEES_OptTrade_SetQueryTransferPositionEventPtr(IntPtr handle,ref CShengliStockRespTransferPositionField record,int nRequestID, byte bIsLast);
        protected delegate void SLEES_OptTrade_SetPushTransferPositionReportEventPtr(IntPtr handle, ref CShengliStockRespTransferPositionField record);
 
        #endregion

        #region 快照回滚
        protected delegate void SLEES_SetQueryEntrustListEventPtr(IntPtr handle, ref CShengliStockRespQueryEntrustField pQuery, bool isLast);
        protected delegate void SLEES_SetQueryEntrustExecutionEventPtr(IntPtr handle, ref CShengliStockRespQueryEntrustExecutionField pQuery, bool isLast);
        #endregion

        #region 1178 查询通道列表   
        protected delegate void SLEES_QueryChannelEventPtr(IntPtr handle, ref CShengliStockChannelField pChannelInfo, uint nRequestID, bool isLast);
        #endregion

        #endregion
        // Trade Client

        public UInt32 UserID { set; get; }

		SLEES_OptTrade_ConnectionEventPtr connectionEventPtr;
		SLEES_OptTrade_DisconnectionEventPtr disconnectionEventPtr;
        SLEES_OptTrade_SetDisQueryConnectionEventPtr disQueryConnEventPtr;
        SLEES_OptTrade_UserLogonEventPtr userLogonEventPtr;
		SLEES_OptTrade_ChangePasswordEventPtr changePasswordEventPtr;
		SLEES_OptTrade_QueryClientIdEventPtr queryClientIdEventPtr;
		SLEES_OptTrade_QueryFundAccountEventPtr queryFundAccountEventPtr;
		SLEES_OptTrade_QueryTradeAccountEventPtr queryTradeAccountEventPtr;
		SLEES_OptTrade_QuerySecurityCodeEventPtr querySecurityCodeEventPtr;
        SLEES_OptTrade_QueryReferenceExchangeRateEventPtr queryReferenceExchangeRateEventPtr;
        SLEES_OptTrade_QueryETFListEventPtr queryETFListEventPtr;
        SLEES_OptTrade_QueryETFRemAcceptEventPtr queryETFRemAcceptEventPtr;
        SLEES_OptTrade_QureyPCFComponentInfoListEventPtr qureyPCFComponentInfoListEventPtr;
        SLEES_OptTrade_QureyETFMarketAcceptComponentListEventPtr qureyETFMarketAcceptComponentListEventPtr;

        SLEES_OptTrade_QueryETFMemberEventPtr queryETFMemberEventPtr;

        SLEES_OptTrade_QueryOptionDetailEventPtr queryOptionDetailEventPtr;
        SLEES_OptTrade_QueryAccountTradeFeeEventPtr queryAccountTradeFeeEventPtr;
        SLEES_OptTrade_QueryNormalPositionEventPtr queryNormalPositionEventPtr;
        SLEES_OptTrade_QueryOptionPositionEventPtr queryOptionPositionEventPtr;
        SLEES_OptTrade_QueryOptionCombStrategyPositionEventPtr queryOptionCombStrategyPositionEventPtr;
        SLEES_OptTrade_OrderRewindEventPtr orderRewindEventPtr;
		SLEES_OptTrade_ExecRewindEventPtr execRewindEventPtr;
		SLEES_OptTrade_CxlReqRewindEventPtr cxlReqRewindEventPtr;
		SLEES_OptTrade_OrderRewindFinishEventPtr orderRewindFinishEventPtr;
		SLEES_OptTrade_ExecRewindFinishEventPtr execRewindFinishEventPtr;
		SLEES_OptTrade_CxlReqRewindFinishEventPtr cxlReqRewindFinishEventPtr;
		SLEES_OptTrade_QueryClientBpStatusEventPtr queryClientBpStatusEventPtr;
		SLEES_OptTrade_QueryMarketSessionEventPtr queryMarketSessionEventPtr;
		SLEES_OptTrade_MarketStatusChangeReportEventPtr marketStatusChangeReportEventPtr;
		SLEES_OptTrade_OrderAcceptedEventPtr orderAcceptedEventPtr;
		SLEES_OptTrade_OrderRejectedEventPtr orderRejectedEventPtr;
		SLEES_OptTrade_OrderExecedEventPtr orderExecedEventPtr;
		SLEES_OptTrade_OrderCxledEventPtr orderCxledEventPtr;
		SLEES_OptTrade_OrderCxlRejectedEventPtr orderCxlRejectedEventPtr;
		SLEES_OptTrade_ETFExecutedEventPtr eTFExecutedEventPtr;
		SLEES_OptTrade_AccountRiskDataEventPtr accountRiskDataEventPtr;
		SLEES_OptTrade_SymbolRiskDataEventPtr symbolRiskDataEventPtr;
        SLEES_OptTrade_OutFundAccountAmountNodeEventPtr outFundAccountAmountNodeEventPtr;
        SLEES_OptTrade_SetQueryOutFundAccountAmountNodeDetailEventPtr setQueryOutFundAccountAmountNodeDetailEventPtr;
        SLEES_OptTrade_SendOpStationReportEventPtr sendOpStationReportEventPtr;
        SLEES_OptTrade_ReqQueryRiskRuleThresholdsEventPtr queryRiskRuleThresholdsEventPtr;
        SLEES_OptTrade_ReqQueryRiskRuleAccumulateValEventPtr queryRiskRuleAccumulateValEventPtr;
        SLEES_OptTrade_ReqQueryAcctMonitorValueEventPtr queryAcctMonitorValueEventPtr;
        SLEES_OptTrade_SetQueryCashInOutEventPtr setQueryCashInOutEventPtr;
        SLEES_OptTrade_SetPushCashInOutReportEventPtr setPushCashInOutReportEventPtr;
        SLEES_OptTrade_SetSubscribeEventPtr setSubscribeEventPtr;
        SLEES_OptTrade_SetPushMktCltOrdIDEventPtr setPushMktCltOrdIDEventPtr;
        SLEES_OptTrade_SetInOutFundAccountAmountEventPtr inOutFundAccountAmountEventPtr;
        SLEES_OptTrade_SetFrozenUnderlyingSymbolQtyEventPtr frozenUnderlyingSymbolQtyEventPtr;
        SLEES_OptTrade_SetQueryUnderlyingSymbolQtyEventPtr queryUnderlyingSymbolQtyEventPtr;
        SLEES_OptTrade_SetQueryChairmanAcctAvailBpEventPtr queryChairmanAcctAvailBpEventPtr;
        SLEES_OptTrade_FundAccountPwdCheckReportEventPtr fundAcctPwdCheckRespEventPtr;
        SLEES_OptTrade_SetCommonMsgEventPtr commonMsgEventPtr;
        SLEES_OptTrade_SetQuerySymbolMarginInfoEventPtr querySymbolMarginInfoEventPtr;
        SLEES_OptTrade_SetQuerySymbolFeeInfoEventPtr querySymbolFeeInfoEventPtr;

        SLEES_OptTrade_SetQuerySigningBankInfoEventPtr querySigningBankInfoEventPtr;
        SLEES_OptTrade_SetQueryBankBalanceInfoEventPtr queryBankBalanceInfoEventPtr;
        SLEES_OptTrade_SetBankToDeriveEventPtr bankToDeriveEventPtr;
        SLEES_OptTrade_SetDeriveToBankEventPtr deriveToBankeventptr;
        SLEES_OptTrade_SetQueryDelegateTypeEventPtr queryDelegateTypeEventPtr;

        #region 1224资金划拨
        SLEES_OptTrade_QueryFundStrategyCfgEventPtr queryFundStrategyCfgEventPtr;
        SLEES_OptTrade_SetFundStrategyCfgEventPtr setFundStrategyCfgEventPtr;
        SLEES_OptTrade_QueryFundStrategySwitchStatusEventPtr queryFudStrategySwitchStatusEventPtr;
        SLEES_OptTrade_SetFundStrategySwitchStatusEventPtr setFudStrategySwitchStatusEventPtr;
        #endregion

        #region 快照回滚
        SLEES_SetQueryEntrustListEventPtr setQueryEntrustListEventPtr;
        SLEES_SetQueryEntrustExecutionEventPtr setQueryEntrustExecutionEventPtr;
        #endregion

        #region 1178 查询通道列表  
        SLEES_QueryChannelEventPtr setQueryChannelEventPtr;
        #endregion


        SLEES_OptTrade_SetQueryTransferPositionEventPtr setQueryTransferPositionEventPtr;
        SLEES_OptTrade_SetPushTransferPositionReportEventPtr setPushTransferPositionReportEventPtr;
        
        private IntPtr tradeHandle = IntPtr.Zero;

        public string Sign { get; private set; }

        Dictionary<string, object> _ptrDic { get; set; } = new Dictionary<string, object>();
        public SlEesTradeDll(string strLogDir,string sign)
		{
            Sign = sign;
            tradeHandle = SLEES_OptTrade_CreateTrade(IntPtr.Zero, strLogDir);

			connectionEventPtr = new SLEES_OptTrade_ConnectionEventPtr(ConnectionEvent);
			disconnectionEventPtr = new SLEES_OptTrade_DisconnectionEventPtr(DisConnectionEvent);
            disQueryConnEventPtr = new SLEES_OptTrade_SetDisQueryConnectionEventPtr(DisQueryConnectionEvent);
            userLogonEventPtr = new SLEES_OptTrade_UserLogonEventPtr(UserLogonEvent);
			changePasswordEventPtr = new SLEES_OptTrade_ChangePasswordEventPtr(ChangePasswordEvent);
			queryClientIdEventPtr = new SLEES_OptTrade_QueryClientIdEventPtr(QueryClientIdEvent);
			queryFundAccountEventPtr = new SLEES_OptTrade_QueryFundAccountEventPtr(QueryFundAccountEvent);
            queryTradeAccountEventPtr = new SLEES_OptTrade_QueryTradeAccountEventPtr(QueryTradeAccountEvent);
            querySecurityCodeEventPtr = new SLEES_OptTrade_QuerySecurityCodeEventPtr(QuerySecurityCodeEvent);
            queryReferenceExchangeRateEventPtr = new SLEES_OptTrade_QueryReferenceExchangeRateEventPtr(QueryReferenceExchangeRateEvent);
            queryETFListEventPtr = new SLEES_OptTrade_QueryETFListEventPtr(QueryETFListEvent);
            queryETFRemAcceptEventPtr = new SLEES_OptTrade_QueryETFRemAcceptEventPtr(QueryETFRemAcceptEvent);
            qureyPCFComponentInfoListEventPtr = new SLEES_OptTrade_QureyPCFComponentInfoListEventPtr(QureyPCFComponentInfoList);
            qureyETFMarketAcceptComponentListEventPtr = new SLEES_OptTrade_QureyETFMarketAcceptComponentListEventPtr(QureyETFMarketAcceptCompoonentInfoList);

            queryETFMemberEventPtr = new SLEES_OptTrade_QueryETFMemberEventPtr(QueryETFMemberEvent);

            queryOptionDetailEventPtr = new SLEES_OptTrade_QueryOptionDetailEventPtr(QueryOptionDetailEvent);
            queryAccountTradeFeeEventPtr = new SLEES_OptTrade_QueryAccountTradeFeeEventPtr(QueryAccountTradeFeeEvent);
            queryNormalPositionEventPtr = new SLEES_OptTrade_QueryNormalPositionEventPtr(QueryNormalPositionEvent);
            queryOptionPositionEventPtr = new SLEES_OptTrade_QueryOptionPositionEventPtr(QueryOptionPositionEvent);
            queryOptionCombStrategyPositionEventPtr = new SLEES_OptTrade_QueryOptionCombStrategyPositionEventPtr(QueryOptionCombStrategyPositionEvent);
            orderRewindEventPtr = new SLEES_OptTrade_OrderRewindEventPtr(OrderRewindEvent);
			execRewindEventPtr = new SLEES_OptTrade_ExecRewindEventPtr(ExecRewindEvent);
			cxlReqRewindEventPtr = new SLEES_OptTrade_CxlReqRewindEventPtr(CxlReqRewindEvent);
			orderRewindFinishEventPtr = new SLEES_OptTrade_OrderRewindFinishEventPtr(OrderRewindFinishEvent);
			execRewindFinishEventPtr = new SLEES_OptTrade_ExecRewindFinishEventPtr(ExecRewindFinishEvent);
			cxlReqRewindFinishEventPtr = new SLEES_OptTrade_CxlReqRewindFinishEventPtr(CxlReqRewindFinishEvent);
			queryClientBpStatusEventPtr = new SLEES_OptTrade_QueryClientBpStatusEventPtr(QueryClientBpStatusEvent);
			queryMarketSessionEventPtr = new SLEES_OptTrade_QueryMarketSessionEventPtr(QueryMarketSessionEvent);
			marketStatusChangeReportEventPtr = new SLEES_OptTrade_MarketStatusChangeReportEventPtr(MarketStatusChangeReportEvent);
			orderAcceptedEventPtr = new SLEES_OptTrade_OrderAcceptedEventPtr(OrderAcceptedEvent);
			orderRejectedEventPtr = new SLEES_OptTrade_OrderRejectedEventPtr(OrderRejectedEvent);
			orderExecedEventPtr = new SLEES_OptTrade_OrderExecedEventPtr(OrderExecedEvent);
			orderCxledEventPtr = new SLEES_OptTrade_OrderCxledEventPtr(OrderCxledEvent);
			orderCxlRejectedEventPtr = new SLEES_OptTrade_OrderCxlRejectedEventPtr(OrderCxlRejectedEvent);
			eTFExecutedEventPtr = new SLEES_OptTrade_ETFExecutedEventPtr(ETFExecutedEvent);
			accountRiskDataEventPtr = new SLEES_OptTrade_AccountRiskDataEventPtr(AccountRiskDataEvent);
			symbolRiskDataEventPtr = new SLEES_OptTrade_SymbolRiskDataEventPtr(SymbolRiskDataEvent);
			outFundAccountAmountNodeEventPtr = new SLEES_OptTrade_OutFundAccountAmountNodeEventPtr(FundAccountAmountNodeEvent);
            setQueryOutFundAccountAmountNodeDetailEventPtr = new SLEES_OptTrade_SetQueryOutFundAccountAmountNodeDetailEventPtr(QueryOutFundAccountAmountNodeDetailEvent);
            sendOpStationReportEventPtr = new SLEES_OptTrade_SendOpStationReportEventPtr(QuerySendOpStationReportEvent);
            queryRiskRuleThresholdsEventPtr = new SLEES_OptTrade_ReqQueryRiskRuleThresholdsEventPtr(QueryRiskRuleThresholdsEvent);
            queryRiskRuleAccumulateValEventPtr = new SLEES_OptTrade_ReqQueryRiskRuleAccumulateValEventPtr(QueryRiskRuleAccumulateValEvent);
            queryAcctMonitorValueEventPtr = new SLEES_OptTrade_ReqQueryAcctMonitorValueEventPtr(QueryAcctMonitorValueEvent);
            setQueryCashInOutEventPtr = new SLEES_OptTrade_SetQueryCashInOutEventPtr(QueryCashInOutRecordEvent);
            setPushCashInOutReportEventPtr = new SLEES_OptTrade_SetPushCashInOutReportEventPtr(RecvPushCashInOutRecordEvent);
            setSubscribeEventPtr = new SLEES_OptTrade_SetSubscribeEventPtr(RecvSubscibeMktCltOrdIDEvent);
            setPushMktCltOrdIDEventPtr = new SLEES_OptTrade_SetPushMktCltOrdIDEventPtr(RecvPushMktCltOrdIDEvent);
            inOutFundAccountAmountEventPtr = new SLEES_OptTrade_SetInOutFundAccountAmountEventPtr(RecvInOutFundAccountAmountEvent);
            frozenUnderlyingSymbolQtyEventPtr = new SLEES_OptTrade_SetFrozenUnderlyingSymbolQtyEventPtr(RecvFrozenUnderlyingSymbolQtyEvent);
            queryUnderlyingSymbolQtyEventPtr = new SLEES_OptTrade_SetQueryUnderlyingSymbolQtyEventPtr(RecvQueryUnderlyingSymbolQtyEvent);
            queryChairmanAcctAvailBpEventPtr = new SLEES_OptTrade_SetQueryChairmanAcctAvailBpEventPtr(RecvQueryChairmanAcctAvailBpEvent);
            fundAcctPwdCheckRespEventPtr = new SLEES_OptTrade_FundAccountPwdCheckReportEventPtr(FundAcctPwdCheckRespEvent);
            commonMsgEventPtr = new SLEES_OptTrade_SetCommonMsgEventPtr(CommonMsgEvent);
            querySymbolMarginInfoEventPtr = new SLEES_OptTrade_SetQuerySymbolMarginInfoEventPtr(QuerySymbolMarginInfoEvent);
            querySymbolFeeInfoEventPtr = new SLEES_OptTrade_SetQuerySymbolFeeInfoEventPtr(QuerySymbolFeeInfoEvent);

            setQuoteOrderAcceptedEventPtr = new SLEES_OptTrade_SetQuoteOrderAcceptedEventPtr(RecvQuoteOrderAcceptedEvent);
            setQuoteOrderExchAcceptedEventPtr = new SLEES_OptTrade_SetQuoteOrderExchAcceptedEventPtr(RecvQuoteOrderExchAcceptedEvent);
            setQuoteOrderRejectedEventPtr = new SLEES_OptTrade_SetQuoteOrderRejectedEventPtr(RecvQuoteOrderRejectedEvent);
            setQuoteOrderExecedEventPtr = new SLEES_OptTrade_SetQuoteOrderExecedEventPtr(RecvQuoteOrderExecedEvent);
            setQuoteOrderCxledEventPtr = new SLEES_OptTrade_SetQuoteOrderCxledEventPtr(RecvQuoteOrderCxledEvent);
            setQuoteOrderCxlRejectedEventPtr = new SLEES_OptTrade_SetQuoteOrderCxlRejectedEventPtr(RecvQuoteOrderCxlRejectedEvent);
            setQuoteOrderRewindFinishEventPtr = new SLEES_OptTrade_SetQuoteOrderRewindFinishEventPtr(RecvQuoteOrderRewindFinishEvent);

            querySigningBankInfoEventPtr = new SLEES_OptTrade_SetQuerySigningBankInfoEventPtr(RecvQuerySigningBankInfoEvent);
            queryBankBalanceInfoEventPtr = new SLEES_OptTrade_SetQueryBankBalanceInfoEventPtr(RecvQueryBankBalanceInfoEvent);
            bankToDeriveEventPtr = new SLEES_OptTrade_SetBankToDeriveEventPtr(RecvBankToDeriveEvent);
            deriveToBankeventptr = new SLEES_OptTrade_SetDeriveToBankEventPtr(RecvDeriveToBankEvent);
            queryDelegateTypeEventPtr = new SLEES_OptTrade_SetQueryDelegateTypeEventPtr(RecvDelegateTypeEvent);


            queryFundStrategyCfgEventPtr = new SLEES_OptTrade_QueryFundStrategyCfgEventPtr(QueryFundStrategyCfgEvent);
            setFundStrategyCfgEventPtr = new SLEES_OptTrade_SetFundStrategyCfgEventPtr(SetFundStrategyCfgEvent);
            queryFudStrategySwitchStatusEventPtr = new SLEES_OptTrade_QueryFundStrategySwitchStatusEventPtr(QueryFundStrategySwitchStatusEvent);
            setFudStrategySwitchStatusEventPtr = new SLEES_OptTrade_SetFundStrategySwitchStatusEventPtr(SetFundStrategySwitchStatusEvent);

            #region 快照回滚
            setQueryEntrustListEventPtr = new SLEES_SetQueryEntrustListEventPtr(RecvQueryEntrustListEvent);
            setQueryEntrustExecutionEventPtr = new SLEES_SetQueryEntrustExecutionEventPtr(RecvQueryEntrustExecutionEven);
            #endregion

            // 1178 查询通道列表
            setQueryChannelEventPtr = new SLEES_QueryChannelEventPtr(RecvQueryEntrustExecutionEvent);
            setQueryTransferPositionEventPtr = new SLEES_OptTrade_SetQueryTransferPositionEventPtr(RecvQueryTransferPositionRecordEvent);
            setPushTransferPositionReportEventPtr = new SLEES_OptTrade_SetPushTransferPositionReportEventPtr(RecvPushTransferPositionRecordEvent);        

            try
            {
				SLEES_OptTrade_SetConnectionEvent(tradeHandle, connectionEventPtr);
				SLEES_OptTrade_SetDisConnectionEvent(tradeHandle, disconnectionEventPtr);
                SLEES_OptTrade_SetDisQueryConnectionEvent(tradeHandle, disQueryConnEventPtr);
                SLEES_OptTrade_SetUserLogonEvent(tradeHandle, userLogonEventPtr);
				SLEES_OptTrade_SetChangePasswordEvent(tradeHandle, changePasswordEventPtr);
				SLEES_OptTrade_SetQueryClientIdListEvent(tradeHandle, queryClientIdEventPtr);
				SLEES_OptTrade_SetQueryAccountListEvent(tradeHandle, queryFundAccountEventPtr);
				SLEES_OptTrade_SetQueryTradeAccountListEvent(tradeHandle, queryTradeAccountEventPtr);
				SLEES_OptTrade_SetQureySymbolListEvent(tradeHandle, querySecurityCodeEventPtr);
          //      SLEES_OptTrade_SetQureyETFListEvent(tradeHandle, queryETFListEventPtr);
            //    SLEES_OptTrade_SetQureyETFRemAcceptComponentListEvent(tradeHandle, queryETFRemAcceptEventPtr);
             //   SLEES_OptTrade_SetQureyPCFComponentInfoListEvent(tradeHandle, qureyPCFComponentInfoListEventPtr);
               // SLEES_OptTrade_SetQureyETFMarketAcceptComponentListEvent(tradeHandle, qureyETFMarketAcceptComponentListEventPtr);

              //  SLEES_OptTrade_SetQueryETFMemberEvent(tradeHandle, queryETFMemberEventPtr);
                SLEES_OptTrade_SetQueryOptionDetailEvent(tradeHandle, queryOptionDetailEventPtr);
                SLEES_OptTrade_SetQueryAccoutTradeFeeEvent(tradeHandle, queryAccountTradeFeeEventPtr);
                SLEES_OptTrade_SetQueryNormalPositionEvent(tradeHandle, queryNormalPositionEventPtr);
                SLEES_OptTrade_SetQueryOptionPositionEvent(tradeHandle, queryOptionPositionEventPtr);
                SLEES_OptTrade_SetQueryOptionCombStrategyPositionEvent(tradeHandle, queryOptionCombStrategyPositionEventPtr);
                SLEES_OptTrade_SetOrderRewindEvent(tradeHandle, orderRewindEventPtr);
				SLEES_OptTrade_SetExecRewindEvent(tradeHandle, execRewindEventPtr);
				SLEES_OptTrade_SetCxlReqRewindEvent(tradeHandle, cxlReqRewindEventPtr);
				SLEES_OptTrade_SetOrderRewindFinishEvent(tradeHandle, orderRewindFinishEventPtr);
				SLEES_OptTrade_SetExecRewindFinishEvent(tradeHandle, execRewindFinishEventPtr);
				SLEES_OptTrade_SetCxlReqRewindFinishEvent(tradeHandle, cxlReqRewindFinishEventPtr);
				SLEES_OptTrade_SetQueryClientBpStatusEvent(tradeHandle, queryClientBpStatusEventPtr);
				SLEES_OptTrade_SetQueryMarketSessionEvent(tradeHandle, queryMarketSessionEventPtr);
				SLEES_OptTrade_SetMarketStatusChangeReportEvent(tradeHandle, marketStatusChangeReportEventPtr);
				SLEES_OptTrade_SetOrderAcceptedEvent(tradeHandle, orderAcceptedEventPtr);
				SLEES_OptTrade_SetOrderRejectedEvent(tradeHandle, orderRejectedEventPtr);
				SLEES_OptTrade_SetOrderExecedEvent(tradeHandle, orderExecedEventPtr);
				SLEES_OptTrade_SetOrderCxledEvent(tradeHandle, orderCxledEventPtr);
				SLEES_OptTrade_SetOrderCxlRejectedEvent(tradeHandle, orderCxlRejectedEventPtr);
				SLEES_OptTrade_SetETFExecutedEvent(tradeHandle, eTFExecutedEventPtr);
				SLEES_OptTrade_SetAccountRiskDataEvent(tradeHandle, accountRiskDataEventPtr);
				SLEES_OptTrade_SetSymbolRiskDataEvent(tradeHandle, symbolRiskDataEventPtr);
                SLEES_OptTrade_SetOutFundAccountAmountNodeEvent(tradeHandle, outFundAccountAmountNodeEventPtr);
                SLEES_OptTrade_SetQueryOutFundAccountAmountNodeDetailEvent(tradeHandle,setQueryOutFundAccountAmountNodeDetailEventPtr);
                SLEES_OptTrade_SendOpStationReportEvent(tradeHandle,sendOpStationReportEventPtr);
                SLEES_OptTrade_SetQueryRiskRuleThresholdsEvent(tradeHandle,queryRiskRuleThresholdsEventPtr);
                SLEES_OptTrade_SetQueryRiskRuleAccumulateValEvent(tradeHandle,queryRiskRuleAccumulateValEventPtr);
                SLEES_OptTrade_SetQueryAcctMonitorValueEvent(tradeHandle, queryAcctMonitorValueEventPtr);
                SLEES_OptTrade_SetQueryCashInOutEvent(tradeHandle, setQueryCashInOutEventPtr);
                SLEES_OptTrade_SetPushCashInOutReportEvent(tradeHandle, setPushCashInOutReportEventPtr);
                SLEES_OptTrade_SetSubscribeEvent(tradeHandle,setSubscribeEventPtr);
                SLEES_OptTrade_SetPushMktCltOrdIDEvent(tradeHandle,setPushMktCltOrdIDEventPtr);
                SLEES_OptTrade_SetInOutFundAccountAmountEvent(tradeHandle, inOutFundAccountAmountEventPtr);
                SLEES_OptTrade_SetFrozenUnderlyingSymbolQtyEvent(tradeHandle, frozenUnderlyingSymbolQtyEventPtr);
                SLEES_OptTrade_SetQueryUnderlyingSymbolQtyEvent(tradeHandle, queryUnderlyingSymbolQtyEventPtr);
                SLEES_OptTrade_SetQueryChairmanAcctAvailBpEvent(tradeHandle,queryChairmanAcctAvailBpEventPtr);
                SLEES_OptTrade_SetFundAccountPwdCheckReportEvent(tradeHandle, fundAcctPwdCheckRespEventPtr);
                SLEES_OptTrade_SetQuoteOrderAcceptedEvent(tradeHandle,setQuoteOrderAcceptedEventPtr);
                SLEES_OptTrade_SetQuoteOrderExchAcceptedEvent(tradeHandle,setQuoteOrderExchAcceptedEventPtr);
                SLEES_OptTrade_SetQuoteOrderRejectedEvent(tradeHandle,setQuoteOrderRejectedEventPtr);
                SLEES_OptTrade_SetQuoteOrderExecedEvent(tradeHandle,setQuoteOrderExecedEventPtr);
                SLEES_OptTrade_SetQuoteOrderCxledEvent(tradeHandle,setQuoteOrderCxledEventPtr);
                SLEES_OptTrade_SetQuoteOrderCxlRejectedEvent(tradeHandle,setQuoteOrderCxlRejectedEventPtr);
                SLEES_OptTrade_SetQuoteOrderRewindFinishEvent(tradeHandle, setQuoteOrderRewindFinishEventPtr);
                SLEES_OptTrade_SetCommonMsgEvent(tradeHandle, commonMsgEventPtr);
                SLEES_OptTrade_SetQuerySymbolMarginInfoEvent(tradeHandle, querySymbolMarginInfoEventPtr);
                SLEES_OptTrade_SetQuerySymbolFeeInfoEvent(tradeHandle, querySymbolFeeInfoEventPtr);

                SLEES_OptTrade_SetQuerySigningBankInfoEvent(tradeHandle, querySigningBankInfoEventPtr);
                SLEES_OptTrade_SetQueryBankBalanceInfoEvent(tradeHandle, queryBankBalanceInfoEventPtr);
                SLEES_OptTrade_SetBankToDeriveEvent(tradeHandle, bankToDeriveEventPtr);
                SLEES_OptTrade_SetDeriveToBankEvent(tradeHandle, deriveToBankeventptr);
                SLEES_OptTrade_SetQueryDelegateTypeEvent(tradeHandle, queryDelegateTypeEventPtr);


                SLEES_OptTrade_SetReqQueryFundStrategyCfgEvent(tradeHandle, queryFundStrategyCfgEventPtr);
                SLEES_OptTrade_SetReqSetFundStrategyCfgEvent(tradeHandle, setFundStrategyCfgEventPtr);
                SLEES_OptTrade_SetReqQueryFundStrategySwitchStatusEvent(tradeHandle, queryFudStrategySwitchStatusEventPtr);
                SLEES_OptTrade_SetReqSetFundStrategySwitchStatusEvent(tradeHandle, setFudStrategySwitchStatusEventPtr);

                #region 快照回滚
                SLEES_SetQueryEntrustList(tradeHandle, setQueryEntrustListEventPtr);
                SLEES_SetQueryEntrustExecutionList(tradeHandle, setQueryEntrustExecutionEventPtr);
                #endregion

                // 1178 查询通道列表 
                SLEES_OptTrade_SetQueryChannelListEvent(tradeHandle, setQueryChannelEventPtr);
                
                SLEES_OptTrade_SetQueryTransferPositionEvent(tradeHandle, setQueryTransferPositionEventPtr);
                SLEES_OptTrade_SetPushTransferPositionReportEvent(tradeHandle, setPushTransferPositionReportEventPtr);
            }
            catch (Exception e)
			{

			}


            var type = this.GetType();
            var methods = type.GetMethods(BindingFlags.NonPublic | BindingFlags.Static);
            foreach (var item in methods)
            {
                var attr = item.GetCustomAttribute<SetEventAttribute>();
                if (attr != null)
                {
                    var evt = type.GetMethod(attr.Name, BindingFlags.Instance | BindingFlags.NonPublic);
                    var pars = item.GetParameters();
                    if (pars.Length >= 2)
                    {
                        var target = pars[1];
                        var ptr = Delegate.CreateDelegate(target.ParameterType, this, evt);
                        _ptrDic.Add(attr.Name, ptr);
                        item.Invoke(this, new object[] { tradeHandle, ptr });
                    }
                }
            }

        }

        

        ~SlEesTradeDll()
		{
			if (tradeHandle != IntPtr.Zero)
			{
				SLEES_OptTrade_DestroyTrade(tradeHandle);
			}
		}



        private TaskCompletionSource<int> ConnServerResult;
        private TaskCompletionSource<CShengliStockRespChangePwdField> ChangePasswordResult;
        private TaskCompletionSource<CShengliStockRespUserLoginField> UserLogonResult;
        private TaskCompletionSource<List<CShengliStockClientIDListField>> QueryClientIdListResult;
        private TaskCompletionSource<List<CShengliStockAccountListField>> QueryAccountListResult;
        private TaskCompletionSource<List<CShengliStockTradeAccountListField>> QueryTradeAccountListResult;
        private TaskCompletionSource<List<CShengliStockNormalSecurityCodeField>> QueryStockSecuCodeListResult;
        private TaskCompletionSource<List<CShengliStockOptionSecurityCodeField>> QueryOptSecuCodeListResult;
        private TaskCompletionSource<List<CShengliStockBpStatusField>> QueryBpStatusListResult;
        private TaskCompletionSource<List<CShengliStockOptionPositionField>> QueryOptPositionListResult;
        private TaskCompletionSource<List<CShengliStockNormalPositionField>> QueryStockPositionListResult;
        private TaskCompletionSource<List<CShengliStockTrasnQueryBpDetailField>> QueryBpDetailListResult;
        private TaskCompletionSource<bool> OrderRewindFinishResult;
        private TaskCompletionSource<bool> ExecRewindFinishResult;
        private TaskCompletionSource<bool> CxlReqRewindFinishResult;
        private TaskCompletionSource<CShengliStockEtfMemberField> QueryETFSymbolListResult;
        private TaskCompletionSource<List<CShengliStockReqQueryRiskThresholdValueRespField>> QueryRiskThresholdListResult;
        private TaskCompletionSource<List<CShengliStockReqQueryRiskValueRespField>> QueryRiskRealValueListResult;
        private TaskCompletionSource<List<CShengliStockReqQueryAcctMonitorValueRespField>> QueryAcctMonitorValueListResult;
		private TaskCompletionSource<List<CShengliStockRespCashInOutField>> QueryCashInOutListResult;
		private TaskCompletionSource<List<CShengliStockRespTransferPositionField>> QueryPosInOutListResult;
        private TaskCompletionSource<CShengliOpStationReportResp> OpStationResult;
        private TaskCompletionSource<CShengliStockInOutFundAccountAmountField> InOutFundAmountResult;
        private TaskCompletionSource<CShengliStockFrzUnderlyingSymbolQtyField> FrzUnderlyingSymbolQtyResult;
        private TaskCompletionSource<CShengliStockFrzUnderlyingSymbolQtyField> FrzUnderlyingSymbolQtyExResult;
        private TaskCompletionSource<CShengliStockUnderlyingSymbolQtyField> QueryUnderlyingSymbolQtyResult;
        private TaskCompletionSource<CShengliStockUnderlyingSymbolQtyField> QueryUnderlyingSymbolQtyExResult;
        private TaskCompletionSource<CShengliStockQryChairmanAcctAvailBpRespFiled> QueryChairmanAcctAvailBpResult;
        private TaskCompletionSource<List<CShengliStockQuerySymbolMarginInfoRespField>> QuerySymblMarginInfoResult;
        private TaskCompletionSource<List<CShengliStockQuerySymbolFeeInfoRespField>> QuerySymbolFeeInfoResult;

        private TaskCompletionSource<List<CShengliStockQuerySigningBankInfoRespField>> QuerySigningBankInfoResult;
        private TaskCompletionSource<CShengliStockQueryBankBalanceInfoRespField> QueryBankBalanceInfoResult;
        private TaskCompletionSource<CShengliStockOneStepTransferInCashRespField> OneStepTransferInCashResult;
        private TaskCompletionSource<CShengliStockOneStepTransferOutCashRespField> OneStepTransferOutCashResult;

        private static class TradeFactory
		{
			//这个功能只有TradeClient在用，无需目录了
			public static SlEesTradeDll trade = new SlEesTradeDll("","Instance");
		}

		public static SlEesTradeDll GetInstance()
		{
			return TradeFactory.trade;
		}

		/// 主动函数

        public int ConnServer(string tradeAddr, int tradePort, string queryAddr, int queryPort)
		{
            CShengliStockConnConfigField connConfig = new CShengliStockConnConfigField();
            connConfig.TradeProcNum = -1;
            connConfig.TradeRecvNum = -1;
            connConfig.QueryProcNum = -1;
            connConfig.QueryRecvNum = -1;
            return SLEES_OptTrade_ConnServer(tradeHandle,  tradeAddr,  tradePort, queryAddr, queryPort, ref connConfig);
		}
        public async  Task<int> ConnServerAsync(string tradeAddr, int tradePort, string queryAddr, int queryPort)
        {
            CShengliStockConnConfigField connConfig = new CShengliStockConnConfigField();
            connConfig.TradeProcNum = -1;
            connConfig.TradeRecvNum = -1;
            connConfig.QueryProcNum = -1;
            connConfig.QueryRecvNum = -1;
            connConfig.TradeSyncMethod = 1;
            connConfig.QuerySyncMethod = 1;
            connConfig.TradeRecvSleepTime = 1000;
            connConfig.TradeProcSleepTime = 1000;
            connConfig.QueryRecvSleepTime = 1000;
            connConfig.QueryProcSleepTime = 1000;
            int ret = SLEES_OptTrade_ConnServer(tradeHandle, tradeAddr, tradePort, queryAddr, queryPort,ref connConfig);
            if(ret !=0 )
            {
                return -1;
            }
            ConnServerResult = new TaskCompletionSource<int>();


            await ConnServerResult.Task;

            return ConnServerResult.Task.Result;

        }

        public int Heartbeat()
        {
            return SLEES_OptTrade_Heartbeat(tradeHandle);
        }

        public int AddSideCheck(byte side,byte flag)
        {
            return SLEES_OptTrade_AddSideCheck(tradeHandle,side,flag);
        }

        public int DisConnServer()
		{
			return SLEES_OptTrade_DisConnServer(tradeHandle);
		}

		public int UserLogon(int version, string userId, string userPwd, string appID, string authCode, string prodInfo, string macAddr, byte logonType = 0,string op_station = "",byte delegateType = 0)
		{
			return SLEES_OptTrade_UserLogon(tradeHandle, version, userId, userPwd, appID, authCode, prodInfo, macAddr, logonType,op_station,delegateType);
		}

        public async Task<CShengliStockRespUserLoginField?> UserLogonAsync(int version, string userId, string userPwd, string appID, string authCode, string prodInfo, string macAddr, byte logonType,string op_station,byte delegateType = 0)
        {
            UserLogonResult = new TaskCompletionSource<CShengliStockRespUserLoginField>();
            int ret =  SLEES_OptTrade_UserLogon(tradeHandle, version, userId, userPwd,  appID, authCode, prodInfo, macAddr, logonType,op_station, delegateType);
            if(ret !=0 )
            {
                return null;
            }
          
            await UserLogonResult.Task;
            return UserLogonResult.Task.Result;
        }



        public int ChangePassword(string oldPwd, string newPwd)
		{
			return SLEES_OptTrade_ChangePassword(tradeHandle, oldPwd, newPwd);
		}

        public async Task<CShengliStockRespChangePwdField?> ChangePasswordAsync(string oldPwd, string newPwd)
        {
            ChangePasswordResult = new TaskCompletionSource<CShengliStockRespChangePwdField>();
            int ret = ChangePassword(oldPwd,newPwd);
            if(ret != 0)
            {
                return null;
            }
            await ChangePasswordResult.Task;
            return ChangePasswordResult.Task.Result;
        }

		public int QueryClientIdList()
		{
            int  ret = SLEES_OptTrade_QueryClientIdList(tradeHandle, 0);
            while( ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES )
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_QueryClientIdList(tradeHandle, 0);
            }
            return ret;
		}

        public async Task<List<CShengliStockClientIDListField>> QueryClientIdListAsync()
        {
            ClientIdList.Clear();
            QueryClientIdListResult = new TaskCompletionSource<List<CShengliStockClientIDListField>>();

            int ret = QueryClientIdList();

            if (ret != 0)
            {
                return null;
            }
            await QueryClientIdListResult.Task;
            return QueryClientIdListResult.Task.Result;
        }



		public int QueryAccountList(string clientId)
		{
            int ret = SLEES_OptTrade_QueryAccountList(tradeHandle, clientId, 0 );
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_QueryAccountList(tradeHandle, clientId, 0);
            }

            return ret ;
		}
        public int QueryTradeAccountList(string clientId)
		{
            int ret = SLEES_OptTrade_QueryTradeAccountList(tradeHandle, clientId, 0);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_QueryTradeAccountList(tradeHandle, clientId, 0);
            }
            return ret ;
		}

        public async Task<List<CShengliStockTradeAccountListField>> QueryTradeAccountListAsync(string clientId)
        {
            TradeAccountList.Clear();
            QueryTradeAccountListResult = new TaskCompletionSource<List<CShengliStockTradeAccountListField>>();
            int ret = QueryTradeAccountList(clientId);
            if (ret != 0)
            {
                return null;
            }
            await QueryTradeAccountListResult.Task;
            return QueryTradeAccountListResult.Task.Result;
        }

        public async Task<List<CShengliStockAccountListField>> QueryAccountListAsync(string clientId)
        {
            AccountList.Clear();
            QueryAccountListResult = new TaskCompletionSource<List<CShengliStockAccountListField>>();
            int ret = QueryAccountList(clientId);

            if (ret != 0)
            {
                return null;
            }
            await QueryAccountListResult.Task;
            return QueryAccountListResult.Task.Result;
        }


		public int QureySymbolList(UInt32 comboSesurityType)
		{
            int ret = SLEES_OptTrade_QureySymbolList(tradeHandle, comboSesurityType, 0);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QureySymbolList(tradeHandle, comboSesurityType, 0);
            }
            return ret;
		}

        public int QueryReferenceExchangeRate()
        {
            int ret = SLEES_OptTrade_QureyReferenceExchangeRate(tradeHandle);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QureyReferenceExchangeRate(tradeHandle);
            }
            return ret;
        }

        public async Task<List<CShengliStockNormalSecurityCodeField>> QureySymbolListAsync(UInt32 comboSesurityType)
        {
            StockSecuCodeList.Clear();
            QueryStockSecuCodeListResult = new TaskCompletionSource<List<CShengliStockNormalSecurityCodeField>>();
            int ret = QureySymbolList(comboSesurityType);
            if(ret != 0)
            {
                return null;
            }
            await QueryStockSecuCodeListResult.Task;
            return QueryStockSecuCodeListResult.Task.Result;
        }

        public int QureyETFList()
        {
            int ret = SLEES_OptTrade_QureyETFList(tradeHandle);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QureyETFList(tradeHandle);
            }
            return ret;
        }

        public int QureyETFRemAccept()
        {
            int ret = SLEES_OptTrade_QureyETFRemAcceptComponentList(tradeHandle);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QureyETFRemAcceptComponentList(tradeHandle);
            }
            return ret;
        }

        public int QureyPCFComponentInfo()
        {
            int ret = SLEES_OptTrade_QureyPCFComponentInfoList(tradeHandle);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QureyPCFComponentInfoList(tradeHandle);
            }
            return ret;
        }
        public int QureyETFMarketAccept()
        {
            int ret = SLEES_OptTrade_QureyETFMarketAcceptComponentList(tradeHandle);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QureyETFMarketAcceptComponentList(tradeHandle);
            }
            return ret;
        }


        public int QueryETFMember(string securityCode, UInt32 exchId)
		{
            int ret = SLEES_OptTrade_QueryETFMember(tradeHandle, securityCode, exchId, 0);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QueryETFMember(tradeHandle, securityCode, exchId, 0);
            }
            return ret;
		}

        public async Task<CShengliStockEtfMemberField?> QueryETFMemberListAsync(string securityCode, UInt32 exchId)
        {
            QueryETFSymbolListResult = new TaskCompletionSource<CShengliStockEtfMemberField>();
            int ret = QueryETFMember(securityCode,exchId);
            if (ret != 0)
            {
                return null;
            }
            await QueryETFSymbolListResult.Task;
            return QueryETFSymbolListResult.Task.Result;
        }


        public int QueryOptionDetail(string securityCode, UInt32 exchId)
		{
            int ret = SLEES_OptTrade_QueryOptionDetail(tradeHandle, securityCode, exchId, 0);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QueryOptionDetail(tradeHandle, securityCode, exchId, 0);
            }
            return ret;
		}

        public async Task<List<CShengliStockOptionSecurityCodeField>> QueryOptionDetailAsync(string securityCode, UInt32 exchId)
        {
            OptSecuCodeList.Clear();
            QueryOptSecuCodeListResult = new TaskCompletionSource<List<CShengliStockOptionSecurityCodeField>>();
            int ret = QueryOptionDetail(securityCode,exchId);
            if (ret != 0)
            {
                return null;
            }
            await QueryOptSecuCodeListResult.Task;
            return QueryOptSecuCodeListResult.Task.Result;
        }


        public int QueryAccoutTradeFee(string clientId)
		{
            int ret = SLEES_OptTrade_QueryAccoutTradeFee(tradeHandle, clientId, 0);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QueryAccoutTradeFee(tradeHandle, clientId, 0);
            }
            return ret;

		}

		public int QueryNormalPosition(string clientId)
		{
            int ret = SLEES_OptTrade_QueryNormalPosition(tradeHandle, clientId, 0);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_QueryNormalPosition(tradeHandle, clientId, 0);
            }
            return ret;
		}

        public async Task<List<CShengliStockNormalPositionField>> QueryNormalPositionAsync(string clientId)
        {
            StockPositionList.Clear();
            QueryStockPositionListResult = new TaskCompletionSource<List<CShengliStockNormalPositionField>>();
            int ret = QueryNormalPosition(clientId);
            if (ret != 0)
            {
                return null;
            }
            await QueryStockPositionListResult.Task;
            return QueryStockPositionListResult.Task.Result;
        }

        public int QueryOptionPosition(string clientId)
		{
            int ret = SLEES_OptTrade_QueryOptionPosition(tradeHandle, clientId, 0);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_QueryOptionPosition(tradeHandle, clientId, 0);
            }
            return ret;
		}
        
        public async Task<List<CShengliStockOptionPositionField>> QueryOptionPositionAsync(string clientId)
        {
            OptPositionList.Clear();
            QueryOptPositionListResult = new TaskCompletionSource<List<CShengliStockOptionPositionField>>();
            int ret = QueryOptionPosition(clientId);
            if (ret != 0)
            {
                return null;
            }
            await QueryOptPositionListResult.Task;
            return QueryOptPositionListResult.Task.Result;
        }


        public int RewindTradingInfoReq(string clientId)
		{
            int ret = SLEES_OptTrade_RewindTradingInfoReq(tradeHandle, clientId, 0);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_RewindTradingInfoReq(tradeHandle, clientId, 0);
            }
            return ret;
		}

        public async Task<bool> RewindTradingInfoReqAsync(string clientId)
        {
            OrderRewindFinishResult = new TaskCompletionSource<bool>();
            ExecRewindFinishResult = new TaskCompletionSource<bool>();
            CxlReqRewindFinishResult = new TaskCompletionSource<bool>();
            int ret = RewindTradingInfoReq(clientId);
            if(ret != 0)
            {
                return false;
            }
            await OrderRewindFinishResult.Task;
            await ExecRewindFinishResult.Task;
            await CxlReqRewindFinishResult.Task;
            return OrderRewindFinishResult.Task.Result && ExecRewindFinishResult.Task.Result && CxlReqRewindFinishResult.Task.Result;
        }


        public int QueryClientBpStatus(string clientId)
		{
            int ret = SLEES_OptTrade_QueryClientBpStatus(tradeHandle, clientId, 0);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_QueryClientBpStatus(tradeHandle, clientId, 0);
            }
            return ret;

		}

        public async Task<List<CShengliStockBpStatusField>> QueryClientBpStatusAsync(string clientId)
        {
            BpStatusList.Clear();
            QueryBpStatusListResult = new TaskCompletionSource<List<CShengliStockBpStatusField>>();
            int ret = QueryClientBpStatus(clientId);
            if (ret != 0)
            {
                return null;
            }
            await QueryBpStatusListResult.Task;
            return QueryBpStatusListResult.Task.Result;
        }


        public int QueryMarketSession()
        {
            int ret = SLEES_OptTrade_QueryMarketSession(tradeHandle);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QueryMarketSession(tradeHandle);
            }
            return ret;

		}

		public int QueryAccountRiskData(string clientId, int accountType, string fundAccount, int requestId)
		{
            int ret = SLEES_OptTrade_QueryAccountRiskData(tradeHandle, clientId, accountType, fundAccount, requestId);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QueryAccountRiskData(tradeHandle, clientId, accountType, fundAccount, requestId);
            }
            return ret;
		}

		public int QuerySymbolRiskData(string clientId, int accountType, string fundAccount,int exchange, string securityCode, int requestId)
		{
            int ret = SLEES_OptTrade_QuerySymbolRiskData(tradeHandle, clientId, accountType, fundAccount, exchange, securityCode, requestId);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QuerySymbolRiskData(tradeHandle, clientId, accountType, fundAccount, exchange, securityCode, requestId);
            }
            return ret;
		}


		public int EnterOrder(ref CShengliStockEnterOrderField order)
		{
			return SLEES_OptTrade_EnterOrder(tradeHandle, ref order);
		}
        public int EnterCombOrder(ref CShengliStockEnterOrderField order, ref CShengliStockExternCombOrder pExternCombOrder, CShengliStockCombLegField[] pCombLeg)
        {
            return SLEES_OptTrade_EnterCombOrder(tradeHandle, ref order, ref pExternCombOrder, pCombLeg);
        }
        public int EnterCombExercise(ref CShengliStockEnterOrderField order, int Nolegs, CShengliStockCombLegField[] pCombLeg)
        {
            return SLEES_OptTrade_EnterCombExercise(tradeHandle, ref order, Nolegs, pCombLeg);
        }

        //下报价单
        public int EnterQuoteOrder(ref CShengliQuoteEnterOrderField order)
        {
            return SLEES_OptTrade_EnterQuoteOrder(tradeHandle, ref order);
        }

        /// <summary>
        /// 撤销报价单 isCxlOneSide为true，撤销单边报价；isCxlOneSide为false，撤销双边报价
        /// </summary>
        /// <param name="order"></param>
        /// <param name="isCxlOneSide"></param>
        /// <returns></returns>
        public int CxlQuoteOrder(ref CShengliQuoteEnterOrderField order,bool isCxlOneSide)
        {
            int ret = SLEES_OptTrade_EnterQuoteOrder(tradeHandle, ref order);
            if(isCxlOneSide)
            {
                CxlOneSideQuoteOrderEvent?.Invoke(order);
            }
            else
            {
                CxlQuoteOrderEvent?.Invoke(order);
            }
            return ret;
        }

        public int CxlOrder(ref CShengliStockCxlOrderField order)
		{
            int ret = SLEES_OptTrade_CxlOrder(tradeHandle, ref order);
            CxlOrderReqEvent?.Invoke(order,ret);
            return ret;
		}

		public int GetMaxToken(out UInt32 token)
		{
			return SLEES_OptTrade_GetMaxToken(tradeHandle, out token);
		}

		public int SetLoggerSwitch(bool bOn)
		{
			return SLEES_OptTrade_SetLoggerSwitch(tradeHandle, bOn);
		}

        public int FundAccountPwdCheck(UInt32 userId, string fundAcct, string password)
        {
            return SLEES_OptTrade_FundAccountPwdCheck(tradeHandle, userId, fundAcct, password);
        }


        public int OutFundAccountAmountNode( CShengliStockTrasnBpReqField info)
        {
            int ret = SLEES_OptTrade_OutFundAccountAmountNode(tradeHandle, ref info, info.RequestID);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_OutFundAccountAmountNode(tradeHandle, ref info, info.RequestID);
        }
            return ret;
        }

        public int QueryOutFundAccountAmountNodeDetail(CShengliStockTrasnBpQueryField info)
        {
            int ret = SLEES_OptTrade_QueryOutFundAccountAmountNodeDetail(tradeHandle, ref info, 0);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_QueryOutFundAccountAmountNodeDetail(tradeHandle, ref info, 0);
            }
            return ret;
        }

        public async Task<List<CShengliStockTrasnQueryBpDetailField>> QueryOutFundAccountAmountNodeDetailAsync(CShengliStockTrasnBpQueryField info)
        {
            BpDetailList.Clear();
            QueryBpDetailListResult = new TaskCompletionSource<List<CShengliStockTrasnQueryBpDetailField>>();
            int ret = QueryOutFundAccountAmountNodeDetail(info);
            if (ret != 0)
            {
                return null;
            }
            await QueryBpDetailListResult.Task;
            return QueryBpDetailListResult.Task.Result;
        }


        public int SetAsyncReceiveMode()
		{
			return SLEES_OptTrade_SetAsyncReceiveMode(tradeHandle);
		}

        public int SendOpStationReport(CShengliOpStationReportReq opStation)
        {
            int ret = SLEES_OptTrade_SendOpStationReport(tradeHandle, Encoding.UTF8.GetString(opStation.CustomerKey), Encoding.UTF8.GetString(opStation.OpStationContent));
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_SendOpStationReport(tradeHandle, Encoding.UTF8.GetString(opStation.CustomerKey), Encoding.UTF8.GetString(opStation.OpStationContent));
            }
            return ret;
        }

        public async Task<CShengliOpStationReportResp> SendOpStationReportAsync(CShengliOpStationReportReq opStation)
        {
            OpStationResult = new TaskCompletionSource<CShengliOpStationReportResp>();
            int ret = SendOpStationReport(opStation);
            if(ret != 0)
            {
                return new CShengliOpStationReportResp();
            }
            await OpStationResult.Task;
            return OpStationResult.Task.Result;
        }

        public int QueryRiskRuleThresholds(CShengliStockReqQueryRiskThresholdValueField info)
        {
            int ret = SLEES_OptTrade_QueryRiskRuleThresholds(tradeHandle,ref info, 0);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_QueryRiskRuleThresholds(tradeHandle,ref info, 0);
            }
            return ret;
        }

        public async Task<List<CShengliStockReqQueryRiskThresholdValueRespField>> QueryRiskRuleThresholdsAsync(CShengliStockReqQueryRiskThresholdValueField info)
        {
            RiskThresholdList = new List<CShengliStockReqQueryRiskThresholdValueRespField>();
            QueryRiskThresholdListResult = new TaskCompletionSource<List<CShengliStockReqQueryRiskThresholdValueRespField>>();
            int ret = QueryRiskRuleThresholds(info);
            if (ret != 0)
            {
                return null;
            }
            await QueryRiskThresholdListResult.Task;
            return QueryRiskThresholdListResult.Task.Result;
        }

        public int QueryRiskRuleAccumulateVal(CShengliStockReqQueryHeaderField info, CShengliStockReqQueryRiskValueField[] pReqVal)
        {
            int ret = SLEES_OptTrade_QueryRiskRuleAccumulateVal(tradeHandle,ref info, pReqVal,0);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_QueryRiskRuleAccumulateVal(tradeHandle,ref info, pReqVal, 0);
            }
            return ret;
        }

        public async Task<List<CShengliStockReqQueryRiskValueRespField>> QueryRiskRuleAccumulateValAsync(CShengliStockReqQueryHeaderField info, CShengliStockReqQueryRiskValueField[] pReqVal)
        {
            RiskRealValueList = new List<CShengliStockReqQueryRiskValueRespField>();
            QueryRiskRealValueListResult = new TaskCompletionSource<List<CShengliStockReqQueryRiskValueRespField>>();
            int ret = QueryRiskRuleAccumulateVal(info,pReqVal);
            if (ret != 0)
            {
                return null;
            }
            await QueryRiskRealValueListResult.Task;
            return QueryRiskRealValueListResult.Task.Result;
        }

        public int QueryAcctMonitorValue(CShengliStockReqQueryAcctMonitorValueField info)
        {
            int ret = SLEES_OptTrade_QueryAcctMonitorValue(tradeHandle,ref info, 0);
            while(ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_QueryAcctMonitorValue(tradeHandle,ref info, 0);
            }
            return ret;
        }

        public async Task<List<CShengliStockReqQueryAcctMonitorValueRespField>> QueryAcctMonitorValueAsync(CShengliStockReqQueryAcctMonitorValueField info)
        {
            AcctMonitorValueList = new List<CShengliStockReqQueryAcctMonitorValueRespField>();
            QueryAcctMonitorValueListResult = new TaskCompletionSource<List<CShengliStockReqQueryAcctMonitorValueRespField>>();
            int ret = QueryAcctMonitorValue(info);
            if(ret != 0)
            {
                return new List<CShengliStockReqQueryAcctMonitorValueRespField>();
            }
            await QueryAcctMonitorValueListResult.Task;
            return QueryAcctMonitorValueListResult.Task.Result;
        }

        public int SLEES_OptTrade_QueryCashInOutList(CShengliStockQueryCashInOutField info)
        {
            int ret = SLEES_OptTrade_QueryCashInOutList(tradeHandle, ref info, 0);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_QueryCashInOutList(tradeHandle, ref info, 0);
            }
            return ret;
        }

        public async Task<List<CShengliStockRespCashInOutField>> QueryCashInOutListInfoAsync(CShengliStockQueryCashInOutField info)
        {
            CashInOutRecordList = new List<CShengliStockRespCashInOutField>();
            QueryCashInOutListResult = new TaskCompletionSource<List<CShengliStockRespCashInOutField>>();
            int ret = SLEES_OptTrade_QueryCashInOutList(info);
            if (ret != 0)
            {
                return null;
            }
            await QueryCashInOutListResult.Task;
            return QueryCashInOutListResult.Task.Result;
        }
        public int SubscribeMktCltOrdID(CShengliStockSubscribeField info)
        {
            int ret = SLEES_OptTrade_SubscribeMsg(tradeHandle, ref info, 0);
            while(ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_SubscribeMsg(tradeHandle, ref info, 0);
            }
            return ret;
        }

        public int InOutFundAccountAmount(CShengliStockInOutFundAccountAmountReqField info)
        {
            int ret = SLEES_OptTrade_InOutFundAccountAmount(tradeHandle, ref info, (int)info.RequestID);
            while(ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_InOutFundAccountAmount(tradeHandle, ref info, (int)info.RequestID);
        }
            return ret;
        }

        public async Task<CShengliStockInOutFundAccountAmountField> InOutFundAccountAmountAsync(CShengliStockInOutFundAccountAmountReqField info)
        {
            InOutFundAmountResult = new TaskCompletionSource<CShengliStockInOutFundAccountAmountField>();
            int ret = InOutFundAccountAmount(info);
            if(ret != 0)
            {
                return new CShengliStockInOutFundAccountAmountField();
            }
            await InOutFundAmountResult.Task;
            return InOutFundAmountResult.Task.Result;
        }

        public int FrzUnderlyingSymbolQty(CShengliStockFrzUnderlyingSymbolQtyReqField info)
        {
            int ret = SLEES_OptTrade_FrzUnderlyingSymbolQty(tradeHandle, ref info, (int)info.RequestID);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_FrzUnderlyingSymbolQty(tradeHandle, ref info, (int)info.RequestID);
            }
            return ret;
        }

        public async Task<CShengliStockFrzUnderlyingSymbolQtyField> FrzUnderlyingSymbolQtyAsync(CShengliStockFrzUnderlyingSymbolQtyReqField info)
        {
            FrzUnderlyingSymbolQtyResult = new TaskCompletionSource<CShengliStockFrzUnderlyingSymbolQtyField>();
            int ret = FrzUnderlyingSymbolQty(info);
            if (ret != 0)
            {
                return new CShengliStockFrzUnderlyingSymbolQtyField();
            }
            await FrzUnderlyingSymbolQtyResult.Task;
            return FrzUnderlyingSymbolQtyResult.Task.Result;
        }

        public int FrzUnderlyingSymbolQtyEx(CShengliStockFrzUnderlyingSymbolQtyReqField info, CShengliStockConnMasterField pMasterInfo)
        {
            int ret = SLEES_OptTrade_FrzUnderlyingSymbolQtyEx(tradeHandle, ref info, ref pMasterInfo, (int)info.RequestID);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_FrzUnderlyingSymbolQtyEx(tradeHandle, ref info, ref pMasterInfo, (int)info.RequestID);
            }
            return ret;
        }

        public async Task<CShengliStockFrzUnderlyingSymbolQtyField> FrzUnderlyingSymbolQtyExAsync(CShengliStockFrzUnderlyingSymbolQtyReqField info, CShengliStockConnMasterField pMasterInfo)
        {
            FrzUnderlyingSymbolQtyExResult = new TaskCompletionSource<CShengliStockFrzUnderlyingSymbolQtyField>();
            int ret = FrzUnderlyingSymbolQtyEx(info,pMasterInfo);
            transferUnderlyingQtyExEvent?.Invoke(this, info, pMasterInfo,ret);
            if (ret != 0)
            {
                return new CShengliStockFrzUnderlyingSymbolQtyField();
            }
            await FrzUnderlyingSymbolQtyExResult.Task;
            return FrzUnderlyingSymbolQtyExResult.Task.Result;
        }


        public int QueryUnderlyingSymbolQty(CShengliStockReqUnderlyingSymbolQtyField info)
        {
            int ret = SLEES_OptTrade_QueryUnderlyingSymbolQty(tradeHandle, ref info, (int)info.RequestID);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_QueryUnderlyingSymbolQty(tradeHandle, ref info, (int)info.RequestID);
            }
            return ret;
        }

        public async Task<CShengliStockUnderlyingSymbolQtyField> QueryUnderlyingSymbolQtyAsync(CShengliStockReqUnderlyingSymbolQtyField info)
        {
            QueryUnderlyingSymbolQtyResult = new TaskCompletionSource<CShengliStockUnderlyingSymbolQtyField>();
            int ret = QueryUnderlyingSymbolQty(info);
            if(ret != 0)
            {
                return new CShengliStockUnderlyingSymbolQtyField();
            }
            await QueryUnderlyingSymbolQtyResult.Task;
            return QueryUnderlyingSymbolQtyResult.Task.Result;
        }

        public int QueryUnderlyingSymbolQtyEx(CShengliStockReqUnderlyingSymbolQtyField info, CShengliStockConnMasterField pMasterInfo)
        {
            int ret = SLEES_OptTrade_QueryUnderlyingSymbolQtyEx(tradeHandle, ref info,ref pMasterInfo, (int)info.RequestID);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_QueryUnderlyingSymbolQtyEx(tradeHandle, ref info, ref pMasterInfo, (int)info.RequestID);
            }
            return ret;
        }

        public async Task<CShengliStockUnderlyingSymbolQtyField> QueryUnderlyingSymbolQtyExAsync(CShengliStockReqUnderlyingSymbolQtyField info, CShengliStockConnMasterField pMasterInfo)
        {
            QueryUnderlyingSymbolQtyExResult = new TaskCompletionSource<CShengliStockUnderlyingSymbolQtyField>();
            int ret = QueryUnderlyingSymbolQtyEx(info,pMasterInfo);
            if (ret != 0)
            {
                return new CShengliStockUnderlyingSymbolQtyField();
            }
            await QueryUnderlyingSymbolQtyExResult.Task;
            return QueryUnderlyingSymbolQtyExResult.Task.Result;
        }

        public int QueryChairmanAcctAvailBp(CShengliStockReqQryChairmanAcctAvailBpFiled info)
        {
            int ret = SLEES_OptTrade_QueryChairmanAcctAvailBp(tradeHandle,ref info,(int)info.RequestID);
            while(ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(200);
                ret = SLEES_OptTrade_QueryChairmanAcctAvailBp(tradeHandle, ref info,(int)info.RequestID);
            }
            return ret;
        }

        public async Task<CShengliStockQryChairmanAcctAvailBpRespFiled> QueryChairmanAcctAvailBpAsync(CShengliStockReqQryChairmanAcctAvailBpFiled info)
        {
            QueryChairmanAcctAvailBpResult = new TaskCompletionSource<CShengliStockQryChairmanAcctAvailBpRespFiled>();
            int ret = QueryChairmanAcctAvailBp(info);
            if(ret != 0)
            {
                return new CShengliStockQryChairmanAcctAvailBpRespFiled();
            }
            await QueryChairmanAcctAvailBpResult.Task;
            return QueryChairmanAcctAvailBpResult.Task.Result;
        }

        public int QuerySymbolMarginInfo(CShengliStockQuerySymbolMarginInfoReqField info)
        {
            int ret = SLEES_OptTrade_QuerySymbolMarginInfo(tradeHandle,ref info, 0);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_QuerySymbolMarginInfo(tradeHandle, ref info, 0);
            }
            return ret;
        }

        public async Task<List<CShengliStockQuerySymbolMarginInfoRespField>> QuerySymbolMarginInfoAsync(CShengliStockQuerySymbolMarginInfoReqField info)
        {
            SymbolMarginInfoList = new List<CShengliStockQuerySymbolMarginInfoRespField>();
            QuerySymblMarginInfoResult = new TaskCompletionSource<List<CShengliStockQuerySymbolMarginInfoRespField>>();
            int ret = QuerySymbolMarginInfo(info);
            if (ret != 0)
            {
                return new List<CShengliStockQuerySymbolMarginInfoRespField>();
            }
            await QuerySymblMarginInfoResult.Task;
            return QuerySymblMarginInfoResult.Task.Result;
        }

        public int QuerySymbolFeeInfo(CShengliStockQuerySymbolFeeInfoReqField info)
        {
            int ret = SLEES_OptTrade_QuerySymbolFeeInfo(tradeHandle, ref info, 0);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_QuerySymbolFeeInfo(tradeHandle, ref info, 0);
            }
            return ret;
        }

        public async Task<List<CShengliStockQuerySymbolFeeInfoRespField>> QuerySymbolFeeInfoAsync(CShengliStockQuerySymbolFeeInfoReqField info)
        {
            SymbolFeeInfoList = new List<CShengliStockQuerySymbolFeeInfoRespField>();
            QuerySymbolFeeInfoResult = new TaskCompletionSource<List<CShengliStockQuerySymbolFeeInfoRespField>>();
            int ret = QuerySymbolFeeInfo(info);
            if (ret != 0)
            {
                return new List<CShengliStockQuerySymbolFeeInfoRespField>();
            }
            await QuerySymbolFeeInfoResult.Task;
            return QuerySymbolFeeInfoResult.Task.Result;
        }


        //查询签约银行
        public int QuerySigningBankInfo(CShengliStockQuerySigningBankInfoReqField info,int reqId)
        {
            int ret = SLEES_OptTrade_ReqQuerySigningBankInfo(tradeHandle, info, reqId);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_ReqQuerySigningBankInfo(tradeHandle, info, reqId);
            }
            return ret;
        }

        public async Task<List<CShengliStockQuerySigningBankInfoRespField>> QuerySigningBankInfoAsync(CShengliStockQuerySigningBankInfoReqField info,int reqId)
        {
            SigningBankInfoList = new List<CShengliStockQuerySigningBankInfoRespField>();
            QuerySigningBankInfoResult = new TaskCompletionSource<List<CShengliStockQuerySigningBankInfoRespField>>();
            int ret = QuerySigningBankInfo(info,reqId);
            if (ret != 0)
            {
                return new List<CShengliStockQuerySigningBankInfoRespField>();
            }
            await QuerySigningBankInfoResult.Task;
            return QuerySigningBankInfoResult.Task.Result;
        }

        //查看银行余额
        public int QueryBankBalanceInfo(CShengliStockQueryBankBalanceInfoReqField info,int reqId)
        {
            int ret = SLEES_OptTrade_ReqQueryBankBalanceInfo(tradeHandle, info, reqId);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_ReqQueryBankBalanceInfo(tradeHandle, info, reqId);
            }
            return ret;
        }

        public async Task<CShengliStockQueryBankBalanceInfoRespField> QueryBankBalanceInfoAsync(CShengliStockQueryBankBalanceInfoReqField info,int reqId)
        {
            QueryBankBalanceInfoResult = new TaskCompletionSource<CShengliStockQueryBankBalanceInfoRespField>();
            int ret = QueryBankBalanceInfo(info,reqId);
            if (ret != 0)
            {
                return new CShengliStockQueryBankBalanceInfoRespField();
            }
            await QueryBankBalanceInfoResult.Task;
            return QueryBankBalanceInfoResult.Task.Result;
        }

        //一步式入金
        public int OneStepTransferInCash(CShengliStockOneStepTransferInCashReqField info,int reqId)
        {
            int ret = SLEES_OptTrade_ReqOneStepTransferInCash(tradeHandle, info, reqId);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_ReqOneStepTransferInCash(tradeHandle, info, reqId);
            }
            oneStepTransferInCashReqEvent?.Invoke(this, info);
            return ret;
        }

        public async Task<CShengliStockOneStepTransferInCashRespField> OneStepTransferInCashAsync(CShengliStockOneStepTransferInCashReqField info, int reqId)
        {
            OneStepTransferInCashResult = new TaskCompletionSource<CShengliStockOneStepTransferInCashRespField>();
            int ret = OneStepTransferInCash(info,reqId);
            if (ret != 0)
            {
                return new CShengliStockOneStepTransferInCashRespField();
            }
            await OneStepTransferInCashResult.Task;
            return OneStepTransferInCashResult.Task.Result;
        }

        //一步式出金
        public int OneStepTransderOutCash(CShengliStockOneStepTransferOutCashReqField info, int reqId)
        {
            int ret = SLEES_OptTrade_ReqOneStepTransferOutCash(tradeHandle, info, reqId);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_ReqOneStepTransferOutCash(tradeHandle, info, reqId);
            }
            oneStepTransferOutCashReqEvent?.Invoke(this, info);
            return ret;
        }

        public async Task<CShengliStockOneStepTransferOutCashRespField> OneStepTransderOutCashAsync(CShengliStockOneStepTransferOutCashReqField info, int reqId)
        {
            OneStepTransferOutCashResult = new TaskCompletionSource<CShengliStockOneStepTransferOutCashRespField>();
            int ret = OneStepTransderOutCash(info,reqId);
            if (ret != 0)
            {
                return new CShengliStockOneStepTransferOutCashRespField();
            }
            await OneStepTransferOutCashResult.Task;
            return OneStepTransferOutCashResult.Task.Result;
        }

        public int ReqClientTradeType(byte clientType)
        {
            int ret = SLEES_OptTrade_ReqClientTradeType(tradeHandle, clientType);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_ReqClientTradeType(tradeHandle, clientType);
            }
            return ret;
        }

        public int QueryDelegateTypeList(CShengliStockQueryDelegateTypeReqField info,int reqId)
        {
            int ret = SLEES_OptTrade_ReqDelegateTypeList(tradeHandle,ref info, reqId);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_ReqDelegateTypeList(tradeHandle,ref info, reqId);
            }
            return ret;
        }
     

        #region 1224资金划拨
        public delegate int SLEES_OptTrade_Req_Msg_Action<T>(IntPtr handle, ref T req, int nRequestID);
        public int SLEES_OptTrade_Req_Msg<T>(SLEES_OptTrade_Req_Msg_Action<T> action, ref T info, int requestId) where T : struct
        {
            int ret = action(tradeHandle, ref info, requestId);
            while (ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = action(tradeHandle, ref info, requestId);
            }
            return ret;
        }


        public int QueryFundStrategyCfg(ref CShengliStockQueryFundStrategyCfg info, int requestId)
        {
            return SLEES_OptTrade_Req_Msg(SLEES_OptTrade_ReqQueryFundStrategyCfg, ref info, requestId);
        }
        public int SetFundStrategyCfg(ref CShengliStockSetFundStrategyCfg info, int requestId)
        {
            return SLEES_OptTrade_Req_Msg(SLEES_OptTrade_ReqSetFundStrategyCfg, ref info, requestId);
        }
        public int QueryFundStrategySwitchStatus(ref CShengliStockQueryFundStrategySwitchStatus info, int requestId)
        {
            return SLEES_OptTrade_Req_Msg(SLEES_OptTrade_ReqQueryFundStrategySwitchStatus, ref info, requestId);
        }
        public int SetFundStrategySwitchStatus(ref CShengliStockSetFundStrategySwitchStatus info, int requestId)
        {
            return SLEES_OptTrade_Req_Msg(SLEES_OptTrade_ReqSetFundStrategySwitchStatus, ref info, requestId);
        }

        #endregion

        public int QueryTransferPositionList(CShengliStockQueryTransferPositionField req,int reqId)
        {
            int ret = SLEES_OptTrade_QueryTransferPositionList(tradeHandle, ref req, reqId);
            while(ret == SlEesTradeReason.CLIENT_TOO_MANY_QUERIES)
            {
                Thread.Sleep(20);
                ret = SLEES_OptTrade_QueryTransferPositionList(tradeHandle, ref req, reqId);
            }
            return ret;
        }

        public async Task<List<CShengliStockRespTransferPositionField>> QueryPosInOutListInfoAsync(CShengliStockQueryTransferPositionField req)
        {
            PosInOutRecordList = new List<CShengliStockRespTransferPositionField>();
            QueryPosInOutListResult = new TaskCompletionSource<List<CShengliStockRespTransferPositionField>>();
            int ret = QueryTransferPositionList(req,0);
            if (ret != 0)
            {
                return null;
            }
            await QueryPosInOutListResult.Task;
            return QueryPosInOutListResult.Task.Result;
        }

        /// Event 事件

        List<CShengliStockClientIDListField> ClientIdList = new List<CShengliStockClientIDListField>();
        List<CShengliStockAccountListField> AccountList = new List<CShengliStockAccountListField>();
        List<CShengliStockTradeAccountListField> TradeAccountList = new List<CShengliStockTradeAccountListField>();
        List<CShengliStockNormalSecurityCodeField> StockSecuCodeList = new List<CShengliStockNormalSecurityCodeField>();
        List<CShengliStockOptionSecurityCodeField> OptSecuCodeList = new List<CShengliStockOptionSecurityCodeField>();
        List<CShengliStockBpStatusField> BpStatusList = new List<CShengliStockBpStatusField>();
        List<CShengliStockOptionPositionField> OptPositionList = new List<CShengliStockOptionPositionField>();
        List<CShengliStockNormalPositionField> StockPositionList = new List<CShengliStockNormalPositionField>();
        List<CShengliStockTrasnQueryBpDetailField> BpDetailList = new List<CShengliStockTrasnQueryBpDetailField>();
        List<CShengliStockReqQueryRiskThresholdValueRespField> RiskThresholdList = new List<CShengliStockReqQueryRiskThresholdValueRespField>();
        List<CShengliStockReqQueryRiskValueRespField> RiskRealValueList = new List<CShengliStockReqQueryRiskValueRespField>();
        List<CShengliStockRespCashInOutField> CashInOutRecordList = new List<CShengliStockRespCashInOutField>();
        List<CShengliStockRespTransferPositionField> PosInOutRecordList = new List<CShengliStockRespTransferPositionField>();
        List<CShengliStockReqQueryAcctMonitorValueRespField> AcctMonitorValueList = new List<CShengliStockReqQueryAcctMonitorValueRespField>();
        List<CShengliStockQuerySymbolMarginInfoRespField> SymbolMarginInfoList = new List<CShengliStockQuerySymbolMarginInfoRespField>();
        List<CShengliStockQuerySymbolFeeInfoRespField> SymbolFeeInfoList = new List<CShengliStockQuerySymbolFeeInfoRespField>();
        List<CShengliStockQuerySigningBankInfoRespField> SigningBankInfoList = new List<CShengliStockQuerySigningBankInfoRespField>();

        public void ConnectionEvent(IntPtr handle, int errNo, string errStr)
		{
			if (tradeClientConnectionEvent != null)
			{
				tradeClientConnectionEvent(this,errNo, errStr);
			}
            if(ConnServerResult != null && !ConnServerResult.Task.IsCompleted)
            {
                ConnServerResult.SetResult(errNo );
            }

            //Console.WriteLine("ConnectionEvent");
		}

		public void DisConnectionEvent(IntPtr handle, int errNo, string errStr)
		{
			if (tradeClientDisConnectionEvent != null)
			{
				tradeClientDisConnectionEvent(this, errNo, errStr);
			}

            //Console.WriteLine("DisConnectionEvent");
		}

        public void DisQueryConnectionEvent(IntPtr handle, int errNo, string errStr)
        {

        }


        public void UserLogonEvent(IntPtr handle, ref CShengliStockRespUserLoginField logon, int nRequestID)
		{
			if (tradeClientUserLogonEvent != null)
			{
				tradeClientUserLogonEvent(this, ref logon, nRequestID);
			}

			UserID = logon.UserID;

            if (UserLogonResult != null && !UserLogonResult.Task.IsCompleted)
            {
                UserLogonResult.SetResult(logon);
            }

            //Console.WriteLine("UserLogonEvent");
		}

		public void ChangePasswordEvent(IntPtr handle, ref CShengliStockRespChangePwdField changePwd, int nRequestID)
		{
			if (tradeClientChangePasswordEvent != null)
			{
				tradeClientChangePasswordEvent(this, ref changePwd, nRequestID);
			}
            
            if ((ChangePasswordResult != null) && (!ChangePasswordResult.Task.IsCompleted))
            {
                ChangePasswordResult.SetResult(changePwd);
            }
            //Console.WriteLine("ChangePasswordEvent");
        }

		public void QueryClientIdEvent(IntPtr handle, ref CShengliStockClientIDListField clientInfo, int nRequestID, byte bIsLast)
		{
          //  //Console.WriteLine("QueryClientIdEvent" + bIsLast);
            if (tradeClientQueryClientIdEvent != null)
			{
				tradeClientQueryClientIdEvent(this, ref clientInfo, nRequestID, bIsLast);
			}
            
            if((QueryClientIdListResult != null) && (!QueryClientIdListResult.Task.IsCompleted))
            {
                if (bIsLast != 1)
                {
                    ClientIdList.Add(clientInfo);
                }
                else
                {
                    QueryClientIdListResult.SetResult(ClientIdList);
                }
            }

			//Console.WriteLine("QueryClientIdEvent");
		}

        public void QueryFundAccountEvent(IntPtr handle, ref CShengliStockAccountListField accountInfo, int nRequestID, byte bIsLast)
		{
			if (tradeClientQueryAccountEvent != null)
			{
				tradeClientQueryAccountEvent(this, ref accountInfo, nRequestID, bIsLast);
			}
            
            if ((QueryAccountListResult != null) && (!QueryAccountListResult.Task.IsCompleted))
            {
                if (bIsLast != 1)
                {
                    AccountList.Add(accountInfo);
                }
                else
                {
                    QueryAccountListResult.SetResult(AccountList);
                }
            }
            //Console.WriteLine("QueryFundAccountEvent");
		}

        public void QuerySecurityCodeEvent(IntPtr handle, ref CShengliStockNormalSecurityCodeField symbolInfo, int nRequestID, byte bIsLast)
        {
            if (tradeClientQuerySymbolEvent != null)
            {
                tradeClientQuerySymbolEvent(this, ref symbolInfo, nRequestID, bIsLast);
            }
            string secucode = "";
            try
            {
                secucode = System.Text.Encoding.Default.GetString(symbolInfo.SecurityCode);
            }
            catch
            {
            }
            if (secucode == "00880")
            {
                ;
            }
            if (bIsLast != 1)
            {
                StockSecuCodeList.Add(symbolInfo);
            }
            if ((QueryStockSecuCodeListResult != null) && (!QueryStockSecuCodeListResult.Task.IsCompleted) && (bIsLast == 1))
            {
                QueryStockSecuCodeListResult.SetResult(StockSecuCodeList);
            }
            //Console.WriteLine("QuerySecurityCodeEvent");
        }

        public void QueryReferenceExchangeRateEvent(IntPtr handle, ref CShengliStockReferenceExchangeRateField fieldRate, int nRequestID, byte bIsLast)
        {
            if (tradeClientQueryReferenceExchangeRateEvent != null)
            {
                tradeClientQueryReferenceExchangeRateEvent(this, ref fieldRate, nRequestID, bIsLast);
            }
        }

        public void QueryETFListEvent(IntPtr handle, ref CShengliStockETFInfoField etfInfo, int nRequestID, byte bIsLast)
        {
            if (tradeClientQueryETFListEvent != null)
            {
                tradeClientQueryETFListEvent(this, ref etfInfo, nRequestID, bIsLast);
            }

        }
        public void QueryETFRemAcceptEvent(IntPtr handle, ref CShengliStockETFRemAcceptInfoField etfCompoonent, int nRequestID, byte bIsLast)
        {
            if (tradeClientQueryEntrustDetailsEvent != null)
            {
                tradeClientQueryEntrustDetailsEvent(this, ref etfCompoonent, nRequestID, bIsLast);
            }

        }
        public void QureyPCFComponentInfoList(IntPtr handle, ref CShengliStockPCFCompoonentInfoField pcfCompoonent, int nRequestID, byte bIsLast)
        {
            if (tradeClientQureyPCFComponentInfoListEvent != null)
            {
                tradeClientQureyPCFComponentInfoListEvent(this, ref pcfCompoonent, nRequestID, bIsLast);
            }

        }
        public void QureyETFMarketAcceptCompoonentInfoList(IntPtr handle, ref CShengliStockETFMarketAcceptCompoonentInfoField etfMarketAccept, int nRequestID, byte bIsLast)
        {
            if (tradeClientQureyETFMarketAcceptCompoonentInfoListEvent != null)
            {
                tradeClientQureyETFMarketAcceptCompoonentInfoListEvent(this, ref etfMarketAccept, nRequestID, bIsLast);
            }

        }

		public void QueryETFMemberEvent(IntPtr handle, ref CShengliStockEtfMemberField member, int nRequestID, byte bIsLast)
		{
			if (tradeClientQueryETFMemberEvent != null)
			{
				tradeClientQueryETFMemberEvent(this, ref member, nRequestID, bIsLast);
			}
            if ((QueryETFSymbolListResult != null) && (!QueryETFSymbolListResult.Task.IsCompleted) && (bIsLast == 1))
            {
                QueryETFSymbolListResult.SetResult(member);
            }
            //Console.WriteLine("QueryETFMemberEvent");
        }


		public void QueryOptionDetailEvent(IntPtr handle, ref CShengliStockOptionSecurityCodeField option, int nRequestID, byte bIsLast)
		{
			if (tradeClientQueryOptionDetailEvent != null)
			{
				tradeClientQueryOptionDetailEvent(this, ref option, nRequestID, bIsLast);
			}
            
            if ((QueryOptSecuCodeListResult != null) && (!QueryOptSecuCodeListResult.Task.IsCompleted))
            {
                if (bIsLast != 1)
                {
                    OptSecuCodeList.Add(option);
                }
                else
                {
                    QueryOptSecuCodeListResult.SetResult(OptSecuCodeList);
                }
            }
            //Console.WriteLine("QueryOptionDetailEvent");
        }

		public void QueryAccountTradeFeeEvent(IntPtr handle)
		{
			if (tradeClientQueryAccountTradeFeeEvent != null)
			{
				tradeClientQueryAccountTradeFeeEvent(this);
			}

			//Console.WriteLine("QueryAccountTradeFeeEvent");
		}

		public void QueryNormalPositionEvent(IntPtr handle, ref CShengliStockNormalPositionField pos, int nRequestID, byte bIsLast)
		{
			if (tradeClientQueryNormalPositionEvent != null)
			{
				tradeClientQueryNormalPositionEvent(this,ref pos, nRequestID, bIsLast);
			}

            if ((QueryStockPositionListResult != null) && (!QueryStockPositionListResult.Task.IsCompleted))
            {
                if (bIsLast != 1)
                {
                    StockPositionList.Add(pos);
                }
                else
                {
                    QueryStockPositionListResult.SetResult(StockPositionList);
                }
            }
		}

		public void QueryOptionPositionEvent(IntPtr handle, ref CShengliStockOptionPositionField pos, int nRequestID, byte bIsLast)
		{
			if (tradeClientQueryOptionPositionEvent != null)
			{
				tradeClientQueryOptionPositionEvent(this, ref  pos, nRequestID, bIsLast);
			}

            if ((QueryOptPositionListResult != null) && (!QueryOptPositionListResult.Task.IsCompleted))
            {
                if(bIsLast != 1)
                {
                    OptPositionList.Add(pos);
                }
                else
                {
                    QueryOptPositionListResult.SetResult(OptPositionList);
                }
            }
		}


        public void QueryOptionCombStrategyPositionEvent(IntPtr handle, ref CShengliStockOptionCombStrategyPositionField pos, int nRequestID, byte bIsLast)
        {
            if (tradeClientQueryOptionCombStrategyPositionEvent != null)
            {
                tradeClientQueryOptionCombStrategyPositionEvent(this, ref pos, nRequestID, bIsLast);
            }
        }

        public void OrderRewindEvent(IntPtr handle, ref CShengliStockOrderAcceptedField order, int nRequestID)
		{
			if (tradeClientOrderRewindEvent != null)
			{
				tradeClientOrderRewindEvent(this, ref order, nRequestID);
			}
			//Console.WriteLine("OrderRewindEvent");
		}

		public void ExecRewindEvent(IntPtr handle, ref CShengliStockOrderExecedField exec, int nRequestID)
		{
			if (tradeClientExecRewindEvent != null)
			{
				tradeClientExecRewindEvent(this, ref exec, nRequestID);
			}
            //Console.WriteLine("ExecRewindEvent");
        }

		public void CxlReqRewindEvent(IntPtr handle, ref CShengliStockOrderCxledField cxlReq, int nRequestID)
		{
			if (tradeClientCxlReqRewindEvent != null)
			{
				tradeClientCxlReqRewindEvent(this, ref cxlReq, nRequestID);
			}

			//Console.WriteLine("CxlReqRewindEvent");
		}

		public void OrderRewindFinishEvent(IntPtr handle, ref CShengliStockOrderRewindFinishField orderFinish, int nRequestID)
		{
			if (tradeClientOrderRewindFinishEvent != null)
			{
				tradeClientOrderRewindFinishEvent(this, ref orderFinish, nRequestID);
			}
            if ((OrderRewindFinishResult != null) && (!OrderRewindFinishResult.Task.IsCompleted))
            {
                OrderRewindFinishResult.SetResult(true);
            }
            //Console.WriteLine("OrderRewindFinishEvent");
        }

		public void ExecRewindFinishEvent(IntPtr handle, ref CShengliStockExecRewindFinishField execFinish, int nRequestID)
		{
			if (tradeClientExecRewindFinishEvent != null)
			{
				tradeClientExecRewindFinishEvent(this, ref execFinish, nRequestID);
			}
            if ((ExecRewindFinishResult != null) && (!ExecRewindFinishResult.Task.IsCompleted))
            {
                ExecRewindFinishResult.SetResult(true);
            }
            //Console.WriteLine("ExecRewindFinishEvent");
        }

		public void CxlReqRewindFinishEvent(IntPtr handle, ref CShengliStockCxlReqRewindFinishField cxlReqFinish, int nRequestID)
		{
			if (tradeClientCxlReqRewindFinishEvent != null)
			{
				tradeClientCxlReqRewindFinishEvent(this, ref cxlReqFinish, nRequestID);
			}
            if ((CxlReqRewindFinishResult != null) && (!CxlReqRewindFinishResult.Task.IsCompleted))
            {
                CxlReqRewindFinishResult.SetResult(true);
            }
            //Console.WriteLine("CxlReqRewindFinishEvent");
        }

		public void QueryClientBpStatusEvent(IntPtr handle, ref CShengliStockBpStatusField bpInfo, int nRequestID, byte bIsLast)
		{
			if (tradeClientQueryClientBpStatusEvent != null)
			{
				tradeClientQueryClientBpStatusEvent(this, ref bpInfo, nRequestID, bIsLast);
			}

            if ((QueryBpStatusListResult != null) && (!QueryBpStatusListResult.Task.IsCompleted))
            {
                if (bIsLast != 1)
                {
                    BpStatusList.Add(bpInfo);
                }
                else
                {
                    QueryBpStatusListResult.SetResult(BpStatusList);
                }
            }
            
        }

		public void QueryMarketSessionEvent(IntPtr handle, ref CShengliStockExchangeConnectField session, int nRequestID, byte bIsLast)
		{
			if (tradeClientQueryMarketSessionEvent != null)
			{
				tradeClientQueryMarketSessionEvent(this, ref session, nRequestID, bIsLast);
			}

			//Console.WriteLine("QueryMarketSessionEvent");
		}

		public void MarketStatusChangeReportEvent(IntPtr handle, ref CShengliStockExchangeStatusReportField report)
		{
			if (tradeClientMarketStatusChangeReportEvent != null)
			{
				tradeClientMarketStatusChangeReportEvent(this ,ref report);
			}

			//Console.WriteLine("MarketStatusChangeReportEvent");
		}

		public void OrderAcceptedEvent(IntPtr handle, ref CShengliStockOrderAcceptedField accept)
		{
            tradeClientOrderAcceptedEvent?.Invoke(this, ref accept);
		}

		public void OrderRejectedEvent(IntPtr handle, ref CShengliStockOrderRejectedField reject)
		{
			if (tradeClientOrderRejectedEvent != null)
			{
				tradeClientOrderRejectedEvent(this, ref reject);
			}

			//Console.WriteLine("OrderRejectedEvent");
		}

		public void OrderExecedEvent(IntPtr handle, ref CShengliStockOrderExecedField exec)
		{
			if (tradeClientOrderExecutedEvent != null)
			{
				tradeClientOrderExecutedEvent(this, ref exec);
			}

			//Console.WriteLine("OrderExecedEvent");
		}

		public void OrderCxledEvent(IntPtr handle, ref CShengliStockOrderCxledField cxled)
		{
			if (tradeClientOrderCxledEvent != null)
			{
				tradeClientOrderCxledEvent(this, ref cxled);
			}

			//Console.WriteLine("OrderCxledEvent");
		}

		public void OrderCxlRejectedEvent(IntPtr handle, ref CShengliStockOrderCxlRejectedField cxlRejected)
		{
			if (tradeClientOrderCxlRejectedEvent != null)
			{
				tradeClientOrderCxlRejectedEvent(this, ref cxlRejected);
			}

			//Console.WriteLine("OrderCxlRejectedEvent");
		}

		public void ETFExecutedEvent(IntPtr handle, ref CShengliStockOrderExecedField head, ref CShengliStockEtfExecBodyField[] arrBody, int arrCount)
		{
			if (tradeClientETFExecutedEvent != null)
			{
				tradeClientETFExecutedEvent(this, ref head, ref arrBody, arrCount);
			}

			//Console.WriteLine("ETFExecutedEvent");
		}

		public void AccountRiskDataEvent(IntPtr handle, ref CShengliStockAccountRiskDataRspField accRsp)
		{
			if (tradeClientAccountRiskDataEvent != null)
			{
				tradeClientAccountRiskDataEvent(this, ref accRsp);
			}
			//Console.WriteLine("AccountRiskDataEvent");
		}

		public void SymbolRiskDataEvent(IntPtr handle, ref CShengliStockSymbolRiskDataRspField symRsp)
		{
			if (tradeClientSymbolRiskDataEvent != null)
			{
				tradeClientSymbolRiskDataEvent(this, ref symRsp);
			}
			//Console.WriteLine("SymbolRiskDataEvent");
		}
        public void FundAccountAmountNodeEvent(IntPtr handle, ref CShengliStockTrasnBpField symRsp,int nRequestID)
		{
			if (outFundAccountAmountNodeEvent != null)
			{
                outFundAccountAmountNodeEvent(this, ref symRsp);
			}
			//Console.WriteLine("SymbolRiskDataEvent");
		}
        public void QueryOutFundAccountAmountNodeDetailEvent(IntPtr handle, ref CShengliStockTrasnQueryBpDetailField symRsp,int nRequestID,byte bIsLast)
        {
            if (setQueryOutFundAccountAmountNodeDetailEvent != null)
            {
                setQueryOutFundAccountAmountNodeDetailEvent(this, ref symRsp,nRequestID);
            }
            
            if ((QueryBpDetailListResult != null) && (!QueryBpDetailListResult.Task.IsCompleted))
            {
                if (bIsLast != 1)
                {
                    BpDetailList.Add(symRsp);
                }
                else
                {
                    QueryBpDetailListResult.SetResult(BpDetailList);
                }
            }

            //Console.WriteLine("QueryOutFundAccountAmountNodeDetailEvent");
        }
        public void QuerySendOpStationReportEvent(IntPtr handle, ref CShengliOpStationReportResp opStation)
        {
            if(sendOpStationReportEvent != null)
            {
                sendOpStationReportEvent(this,ref opStation);
            }
            if(OpStationResult != null && !OpStationResult.Task.IsCompleted)
            {
                OpStationResult.SetResult(opStation);
            }
        }

        private void QueryRiskRuleThresholdsEvent(IntPtr handel, ref CShengliStockReqQueryRiskThresholdValueRespField riskThreshold, int nRequestID, byte bIsLast)
        {
            if(riskRuleThresholdsEvent != null)
            {
                riskRuleThresholdsEvent(this,ref riskThreshold, nRequestID, bIsLast);
            }
            if ((QueryRiskThresholdListResult != null) && (!QueryRiskThresholdListResult.Task.IsCompleted))
            {
                if (bIsLast != 1)
                {
                    RiskThresholdList.Add(riskThreshold);
                }
                else
                {
                    QueryRiskThresholdListResult.SetResult(RiskThresholdList);
                }
            }
        }

        private void QueryRiskRuleAccumulateValEvent(IntPtr handel, ref CShengliStockReqQueryRiskValueRespField pResp, int nReqID, byte bIsLast)
        {
            if(riskRuleAccumulateValEvent != null)
            {
                riskRuleAccumulateValEvent(this,ref pResp, nReqID, bIsLast);
            }
            if ((QueryRiskRealValueListResult != null) && (!QueryRiskRealValueListResult.Task.IsCompleted))
            {
                if (bIsLast != 1)
                {
                    RiskRealValueList.Add(pResp);
                }
                else
                {
                    QueryRiskRealValueListResult.SetResult(RiskRealValueList);
                }
            }			
        }

        private void QueryAcctMonitorValueEvent(IntPtr handle, ref CShengliStockReqQueryAcctMonitorValueRespField pResp, int nReqID, byte bIsLast)
        {
            if(acctMonitorValueEvent != null)
            {
                acctMonitorValueEvent(this,ref pResp, nReqID, bIsLast);
            }
            if((QueryAcctMonitorValueListResult != null) && (!QueryAcctMonitorValueListResult.Task.IsCompleted))
            {
                if (bIsLast != 1)
                {
                    AcctMonitorValueList.Add(pResp);
                }
                else
                {
                    QueryAcctMonitorValueListResult.SetResult(AcctMonitorValueList);
                }
            }
        }

        public void QueryCashInOutRecordEvent(IntPtr handle, ref CShengliStockRespCashInOutField record, int nRequestID, byte bIsLast)
        {
            if ((QueryCashInOutListResult != null) && (!QueryCashInOutListResult.Task.IsCompleted))
            {
                if (bIsLast != 1)
                {
                    CashInOutRecordList.Add(record);
                }
                else
                {
                    QueryCashInOutListResult.SetResult(CashInOutRecordList);
                }
            }
        }

        public void RecvPushCashInOutRecordEvent(IntPtr handle, ref CShengliStockRespCashInOutField record)
        {
            setRecvPushCashInOutEvent?.Invoke(this, ref record);
        }

        private void RecvSubscibeMktCltOrdIDEvent(IntPtr handle, ref CShengliStockRespSubscribeField subscribe, int requestId)
        {
            setSubscribeMktCltOrdIDEvent?.Invoke(this,ref subscribe,requestId);
        }

        private void RecvPushMktCltOrdIDEvent(IntPtr handle, ref CShengliStockRespMktCltOrdIDField mktCltOrdID)
        {
            setRecvPushSubscribeMktCltOrdIDEvent?.Invoke(this,ref mktCltOrdID);
        }

        public void FundAcctPwdCheckRespEvent(IntPtr handle, ref CShengliFundAccountPwdCheckResp checkRsp)
        {
            if (fundAcctPwdCheckEvent != null)
            {
                fundAcctPwdCheckEvent(this, ref checkRsp);
            }
        }

        private void QueryTradeAccountEvent(IntPtr handle, ref CShengliStockTradeAccountListField accountInfo, int nRequestID, byte bIsLast)
        {
            if (tradeClientQueryTradeAccountEvent != null)
            {
                tradeClientQueryTradeAccountEvent(this, ref accountInfo, nRequestID, bIsLast);
            }
            
            if ((QueryTradeAccountListResult != null) && (!QueryTradeAccountListResult.Task.IsCompleted))
            {
                if (bIsLast != 1)
                {
                    TradeAccountList.Add(accountInfo);
                }
                else
                {
                    QueryTradeAccountListResult.SetResult(TradeAccountList);
                }
            }
        }

        private void RecvQueryUnderlyingSymbolQtyEvent(IntPtr handle, ref CShengliStockUnderlyingSymbolQtyField underlyingInfo, int nRequestID)
        {
            if (QueryUnderlyingSymbolQtyResult != null && !QueryUnderlyingSymbolQtyResult.Task.IsCompleted)
            {
                QueryUnderlyingSymbolQtyResult.SetResult(underlyingInfo);
            }
            if(QueryUnderlyingSymbolQtyExResult != null && !QueryUnderlyingSymbolQtyExResult.Task.IsCompleted)
            {
                queryUnderlyingSymbolQtyExEvent?.Invoke(this, underlyingInfo, nRequestID);
                QueryUnderlyingSymbolQtyExResult.SetResult(underlyingInfo);
            }
        }

        private void RecvQueryChairmanAcctAvailBpEvent(IntPtr handle, ref CShengliStockQryChairmanAcctAvailBpRespFiled chairmanAcctAvailBp, int nRequestID)
        {
            if(QueryChairmanAcctAvailBpResult != null && !QueryChairmanAcctAvailBpResult.Task.IsCompleted)
            {
                QueryChairmanAcctAvailBpResult.SetResult(chairmanAcctAvailBp);
            }
        }

        private void RecvFrozenUnderlyingSymbolQtyEvent(IntPtr handle, ref CShengliStockFrzUnderlyingSymbolQtyField frzUnderlying, int nRequestID)
        {
            if(FrzUnderlyingSymbolQtyResult != null && !FrzUnderlyingSymbolQtyResult.Task.IsCompleted)
            {
                FrzUnderlyingSymbolQtyResult.SetResult(frzUnderlying);
            }
            if(FrzUnderlyingSymbolQtyExResult != null && !FrzUnderlyingSymbolQtyExResult.Task.IsCompleted)
            {
                FrzUnderlyingSymbolQtyExResult.SetResult(frzUnderlying);
            }
            chairmanTransferUnderlyingQtyEvent?.Invoke(this,ref frzUnderlying,nRequestID);
        }

        private void RecvInOutFundAccountAmountEvent(IntPtr handle, ref CShengliStockInOutFundAccountAmountField inOutFund, int nRequestID)
        {
            if(InOutFundAmountResult != null && !InOutFundAmountResult.Task.IsCompleted)
            {
                InOutFundAmountResult.SetResult(inOutFund);
            }
            chairmanCustAcctFundInOutEvent?.Invoke(this, ref inOutFund,nRequestID);
        }

        private void CommonMsgEvent(IntPtr handle, ref CShengliStockCommonMsgField info)
        {
            disConnEvent?.Invoke(this, info);
        }

        private void QuerySymbolMarginInfoEvent(IntPtr handle, ref CShengliStockQuerySymbolMarginInfoRespField pResp, int nReqID, byte bIsLast)
        {
            queryAcctMarginEvent?.Invoke(this, ref pResp);
            if ((QuerySymblMarginInfoResult != null) && (!QuerySymblMarginInfoResult.Task.IsCompleted))
            {
                if (bIsLast != 1)
                {
                    SymbolMarginInfoList.Add(pResp);
                }
                else
                {
                    QuerySymblMarginInfoResult.SetResult(SymbolMarginInfoList);
                }
            }
            
        }

        private void QuerySymbolFeeInfoEvent(IntPtr handle, ref CShengliStockQuerySymbolFeeInfoRespField pResp, int nReqID, byte bIsLast)
        {
            queryAcctFeeEvent?.Invoke(this, ref pResp);
            if ((QuerySymbolFeeInfoResult != null) && (!QuerySymbolFeeInfoResult.Task.IsCompleted))
            {
                if (bIsLast != 1)
                {
                    SymbolFeeInfoList.Add(pResp);
                }
                else
                {
                    QuerySymbolFeeInfoResult.SetResult(SymbolFeeInfoList);
                }
            }
        }


        private void RecvQuerySigningBankInfoEvent(IntPtr handle, ref CShengliStockQuerySigningBankInfoRespField pResp, int nReqID, byte bIsLast)
        {
            querySigningBankListEvent?.Invoke(this,pResp,nReqID,bIsLast);
            if ((QuerySigningBankInfoResult != null) && (!QuerySigningBankInfoResult.Task.IsCompleted))
            {
                if (bIsLast != 1)
                {
                    SigningBankInfoList.Add(pResp);
                }
                else
                {
                    QuerySigningBankInfoResult.SetResult(SigningBankInfoList);
                }
            }
        }

        private void RecvQueryBankBalanceInfoEvent(IntPtr handle, ref CShengliStockQueryBankBalanceInfoRespField pResp, int nReqID)
        {
            queryBankBalanceInfoEvent?.Invoke(this,pResp,nReqID);
            if ((QueryBankBalanceInfoResult != null) && (!QueryBankBalanceInfoResult.Task.IsCompleted))
            {
                QueryBankBalanceInfoResult.SetResult(pResp);
            }
        }

        private void RecvBankToDeriveEvent(IntPtr handle, ref CShengliStockOneStepTransferInCashRespField pResp, int nReqID)
        {
            oneStepTransferInCashRespEvent?.Invoke(this,pResp,nReqID);
            if ((OneStepTransferInCashResult != null) && (!OneStepTransferInCashResult.Task.IsCompleted))
            {
                OneStepTransferInCashResult.SetResult(pResp);
            }
        }

        private void RecvDeriveToBankEvent(IntPtr handle, ref CShengliStockOneStepTransferOutCashRespField pResp, int nReqID)
        {
            oneStepTransferOutCashRespEvent?.Invoke(this,pResp,nReqID);
            if ((OneStepTransferOutCashResult != null) && (!OneStepTransferOutCashResult.Task.IsCompleted))
            {
                OneStepTransferOutCashResult.SetResult(pResp);
            }
        }

        private void RecvDelegateTypeEvent(IntPtr handle, ref CShengliStockQueryDeletageTypeRespField pResp, int nReqID, byte bIsLast)
        {
            queryDelegateTypeEvent?.Invoke(this, pResp, nReqID, bIsLast);
        }

        #region 1224资金划拨
        private void QueryFudStrategySwitchStatusEvent(IntPtr handle, ref CShengliStockQueryFundStrategySwitchStatusResp pResp, int nReqID)
        {
            queryFundStrategySwitchStatusEvent?.Invoke(handle, ref pResp, nReqID);
        }
        private void QueryFundStrategyCfgEvent(IntPtr handle, ref CShengliStockQueryFundStrategyCfgResp pResp, int nRequestID)
        {
            queryFundStrategyCfgEvent?.Invoke(handle, ref pResp, nRequestID);
        }
        private void SetFundStrategyCfgEvent(IntPtr handle, ref CShengliStockSetFundStrategyCfgResp pResp, int nRequestID)
        {
            setFundStrategyCfgEvent?.Invoke(handle, ref pResp, nRequestID);
        }
        private void QueryFundStrategySwitchStatusEvent(IntPtr handle, ref CShengliStockQueryFundStrategySwitchStatusResp pResp, int nReqID)
        {
            queryFundStrategySwitchStatusEvent?.Invoke(handle, ref pResp, nReqID);
        }
        private void SetFundStrategySwitchStatusEvent(IntPtr handle, ref CShengliStockSetFundStrategySwitchStatusResp pResp, int nReqID)
        {
            setFundStrategySwitchStatusEvent?.Invoke(handle, ref pResp, nReqID);
        }
        #endregion

        #region  1178 查询通道列表 
        private void RecvQueryEntrustExecutionEvent(IntPtr handle, ref CShengliStockChannelField pChannelInfo, uint nRequestID, bool isLast)
        {
            queryChannelEvent?.Invoke(this, ref pChannelInfo, nRequestID, isLast);
        }
        //(IntPtr handle, ref CShengliStockCHannelField pChannelInfo, int nRequestID, bool isLast);
        #endregion

        private void RecvQueryTransferPositionRecordEvent(IntPtr handle, ref CShengliStockRespTransferPositionField record, int nRequestID, byte bIsLast)
        {
            if ((QueryPosInOutListResult != null) && (!QueryPosInOutListResult.Task.IsCompleted))
            {
                if (bIsLast != 1)
                {
                    PosInOutRecordList.Add(record);
                }
                else
                {
                    QueryPosInOutListResult.SetResult(PosInOutRecordList);
                }
            }
            queryTransPosListEvent?.Invoke(this, record, nRequestID, bIsLast);
        }

        private void RecvPushTransferPositionRecordEvent(IntPtr handle, ref CShengliStockRespTransferPositionField record)
        {
            recvTransferPositionListEvent?.Invoke(this, record);
        }

    }

}
