﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.InteropServices;
using System.Threading;
using System.Threading.Tasks;

namespace SlEesTrade
{
    public partial class SlEesTradeDll
    {
        // CShengliStockTraderSpi

        #region C dll export functions mapping
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_CreateTrade", CallingConvention = CallingConvention.Cdecl)]
        protected static extern IntPtr SLEES_OptTrade_CreateTrade(IntPtr userParam, string logDir);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_Heartbeat", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_Heartbeat(IntPtr handle);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_AddSideCheck", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_AddSideCheck(IntPtr handle, byte side, byte n_flag);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_DestroyTrade", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_DestroyTrade(IntPtr handle);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_GetUserParam", CallingConvention = CallingConvention.Cdecl)]
        protected static extern IntPtr SLEES_OptTrade_GetUserParam(IntPtr handle);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_ConnServer", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_ConnServer(IntPtr handle, string tradeAddr, int tradePort, string queryAddr, int queryPort, ref CShengliStockConnConfigField connConfig);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_DisConnServer", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_DisConnServer(IntPtr handle);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetConnectionEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetConnectionEvent(IntPtr handle, SLEES_OptTrade_ConnectionEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetDisConnectionEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetDisConnectionEvent(IntPtr handle, SLEES_OptTrade_DisconnectionEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetDisQueryConnectionEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetDisQueryConnectionEvent(IntPtr handle, SLEES_OptTrade_SetDisQueryConnectionEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_UserLogon", CallingConvention = CallingConvention.Cdecl)]

        protected static extern int SLEES_OptTrade_UserLogon(IntPtr handle, int version, string userId, string userPwd, string appID, string authCode, string prodInfo, string macAddr, byte logonType, string op_station,byte delegateType);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_ChangePassword", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_ChangePassword(IntPtr handle, string oldPwd, string newPwd);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetUserLogonEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetUserLogonEvent(IntPtr handle, SLEES_OptTrade_UserLogonEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetChangePasswordEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetChangePasswordEvent(IntPtr handle, SLEES_OptTrade_ChangePasswordEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryClientIdList", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryClientIdList(IntPtr handle, int nReqID);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryClientIdListEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQueryClientIdListEvent(IntPtr handle, SLEES_OptTrade_QueryClientIdEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryAccountList", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryAccountList(IntPtr handle, string clientId, int nReqID);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryAccountListEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQueryAccountListEvent(IntPtr handle, SLEES_OptTrade_QueryFundAccountEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryTradeAccountList", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryTradeAccountList(IntPtr handle, string clientId, int nReqID);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryTradeAccountListEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQueryTradeAccountListEvent(IntPtr handle, SLEES_OptTrade_QueryTradeAccountEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QureySymbolList", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QureySymbolList(IntPtr handle, UInt32 comboSesurityType, int nReqID);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQureySymbolListEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQureySymbolListEvent(IntPtr handle, SLEES_OptTrade_QuerySecurityCodeEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryETFMember", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryETFMember(IntPtr handle, string securityCode, UInt32 exchId, int nReqID);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryETFMemberEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQueryETFMemberEvent(IntPtr handle, SLEES_OptTrade_QueryETFMemberEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryOptionDetail", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryOptionDetail(IntPtr handle, string securityCode, UInt32 exchId, int nReqID);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryOptionDetailEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQueryOptionDetailEvent(IntPtr handle, SLEES_OptTrade_QueryOptionDetailEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryAccoutTradeFee", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryAccoutTradeFee(IntPtr handle, string clientId, int nReqID);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryAccoutTradeFeeEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQueryAccoutTradeFeeEvent(IntPtr handle, SLEES_OptTrade_QueryAccountTradeFeeEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryNormalPosition", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryNormalPosition(IntPtr handle, string clientId, int nReqID);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryOptionCombStrategyPositionEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQueryOptionCombStrategyPositionEvent(IntPtr handle, SLEES_OptTrade_QueryOptionCombStrategyPositionEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryOptionPosition", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryOptionPosition(IntPtr handle, string clientId, int nReqID);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryNormalPositionEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQueryNormalPositionEvent(IntPtr handle, SLEES_OptTrade_QueryNormalPositionEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryOptionPositionEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQueryOptionPositionEvent(IntPtr handle, SLEES_OptTrade_QueryOptionPositionEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_RewindTradingInfoReq", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_RewindTradingInfoReq(IntPtr handle, string clientId, int nReqID);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetOrderRewindEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetOrderRewindEvent(IntPtr handle, SLEES_OptTrade_OrderRewindEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetExecRewindEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetExecRewindEvent(IntPtr handle, SLEES_OptTrade_ExecRewindEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetCxlReqRewindEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetCxlReqRewindEvent(IntPtr handle, SLEES_OptTrade_CxlReqRewindEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetOrderRewindFinishEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetOrderRewindFinishEvent(IntPtr handle, SLEES_OptTrade_OrderRewindFinishEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetExecRewindFinishEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetExecRewindFinishEvent(IntPtr handle, SLEES_OptTrade_ExecRewindFinishEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetCxlReqRewindFinishEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetCxlReqRewindFinishEvent(IntPtr handle, SLEES_OptTrade_CxlReqRewindFinishEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryClientBpStatus", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryClientBpStatus(IntPtr handle, string clientId, int nReqID);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryClientBpStatusEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQueryClientBpStatusEvent(IntPtr handle, SLEES_OptTrade_QueryClientBpStatusEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryMarketSession", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryMarketSession(IntPtr handle);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryMarketSessionEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQueryMarketSessionEvent(IntPtr handle, SLEES_OptTrade_QueryMarketSessionEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetMarketStatusChangeReportEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetMarketStatusChangeReportEvent(IntPtr handle, SLEES_OptTrade_MarketStatusChangeReportEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_EnterOrder", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_EnterOrder(IntPtr handle, ref CShengliStockEnterOrderField order);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_FundAccountPwdCheck", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_FundAccountPwdCheck(IntPtr handle, UInt32 user_id, string fund_account, string password);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetFundAccountPwdCheckReportEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetFundAccountPwdCheckReportEvent(IntPtr handle, SLEES_OptTrade_FundAccountPwdCheckReportEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_EnterCombOrder", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_EnterCombOrder(IntPtr handle, ref CShengliStockEnterOrderField order, ref CShengliStockExternCombOrder pExternCombOrder, CShengliStockCombLegField[] pCombLeg);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_EnterCombExercise", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_EnterCombExercise(IntPtr handle, ref CShengliStockEnterOrderField order, int Nolegs, CShengliStockCombLegField[] pCombLeg);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_EnterQuoteOrder", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_EnterQuoteOrder(IntPtr handle, ref CShengliQuoteEnterOrderField order);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_CxlOrder", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_CxlOrder(IntPtr handle, ref CShengliStockCxlOrderField order);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetOrderAcceptedEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetOrderAcceptedEvent(IntPtr handle, SLEES_OptTrade_OrderAcceptedEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetOrderRejectedEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetOrderRejectedEvent(IntPtr handle, SLEES_OptTrade_OrderRejectedEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetOrderExecedEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetOrderExecedEvent(IntPtr handle, SLEES_OptTrade_OrderExecedEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetOrderCxledEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetOrderCxledEvent(IntPtr handle, SLEES_OptTrade_OrderCxledEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetOrderCxlRejectedEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetOrderCxlRejectedEvent(IntPtr handle, SLEES_OptTrade_OrderCxlRejectedEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetETFExecutedEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetETFExecutedEvent(IntPtr handle, SLEES_OptTrade_ETFExecutedEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_GetMaxToken", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_GetMaxToken(IntPtr handle, out UInt32 token);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetLoggerSwitch", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetLoggerSwitch(IntPtr handle, bool bOn);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_LoggerFlush", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_LoggerFlush(IntPtr handle);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetAsyncReceiveMode", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetAsyncReceiveMode(IntPtr handle);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryAccountRiskData", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryAccountRiskData(IntPtr handle, string clientId, int accountType, string fundAccount, int requestId);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QuerySymbolRiskData", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QuerySymbolRiskData(IntPtr handle, string clientId, int accountType, string fundAccount, int exchange, string securityCode, int requestId);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetAccountRiskDataEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetAccountRiskDataEvent(IntPtr handle, SLEES_OptTrade_AccountRiskDataEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetSymbolRiskDataEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetSymbolRiskDataEvent(IntPtr handle, SLEES_OptTrade_SymbolRiskDataEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_OutFundAccountAmountNode", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_OutFundAccountAmountNode(IntPtr handle, ref CShengliStockTrasnBpReqField info, uint requestId);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetOutFundAccountAmountNodeEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetOutFundAccountAmountNodeEvent(IntPtr handle, SLEES_OptTrade_OutFundAccountAmountNodeEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryOutFundAccountAmountNodeDetail", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryOutFundAccountAmountNodeDetail(IntPtr handle, ref CShengliStockTrasnBpQueryField info, int requestId);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryOutFundAccountAmountNodeDetailEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQueryOutFundAccountAmountNodeDetailEvent(IntPtr handle, SLEES_OptTrade_SetQueryOutFundAccountAmountNodeDetailEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SendOpStationReport", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SendOpStationReport(IntPtr handle, string p_CustomerKey, string p_OpStationContent);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SendOpStationReportEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SendOpStationReportEvent(IntPtr handle, SLEES_OptTrade_SendOpStationReportEventPtr p_fun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryRiskRuleThresholds", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryRiskRuleThresholds(IntPtr handle, ref CShengliStockReqQueryRiskThresholdValueField info, int requestId);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryRiskRuleThresholdsEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQueryRiskRuleThresholdsEvent(IntPtr handel, SLEES_OptTrade_ReqQueryRiskRuleThresholdsEventPtr p_fun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryRiskRuleAccumulateVal", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryRiskRuleAccumulateVal(IntPtr handle, ref CShengliStockReqQueryHeaderField info, CShengliStockReqQueryRiskValueField[] pReqVal, int nRequestID);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryRiskRuleAccumulateValEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQueryRiskRuleAccumulateValEvent(IntPtr handle, SLEES_OptTrade_ReqQueryRiskRuleAccumulateValEventPtr p_fun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryAcctMonitorValue", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryAcctMonitorValue(IntPtr handle, ref CShengliStockReqQueryAcctMonitorValueField info, int nRequestID);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryAcctMonitorValueEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQueryAcctMonitorValueEvent(IntPtr handle, SLEES_OptTrade_ReqQueryAcctMonitorValueEventPtr p_fun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryCashInOutList", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryCashInOutList(IntPtr handle, ref CShengliStockQueryCashInOutField info, int nRequestID);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryCashInOutEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQueryCashInOutEvent(IntPtr handle, SLEES_OptTrade_SetQueryCashInOutEventPtr p_fun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetPushCashInOutReportEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetPushCashInOutReportEvent(IntPtr handle, SLEES_OptTrade_SetPushCashInOutReportEventPtr p_fun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SubscribeMsg", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SubscribeMsg(IntPtr handle, ref CShengliStockSubscribeField info, int nRequestID);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetSubscribeEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetSubscribeEvent(IntPtr handle, SLEES_OptTrade_SetSubscribeEventPtr p_fun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetPushMktCltOrdIDEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetPushMktCltOrdIDEvent(IntPtr handle, SLEES_OptTrade_SetPushMktCltOrdIDEventPtr p_fun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_InOutFundAccountAmount", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_InOutFundAccountAmount(IntPtr handel, ref CShengliStockInOutFundAccountAmountReqField info, int requestId);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetInOutFundAccountAmountEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetInOutFundAccountAmountEvent(IntPtr handel, SLEES_OptTrade_SetInOutFundAccountAmountEventPtr p_fun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_FrzUnderlyingSymbolQty", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_FrzUnderlyingSymbolQty(IntPtr handel, ref CShengliStockFrzUnderlyingSymbolQtyReqField info, int requestId);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_FrzUnderlyingSymbolQtyEx", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_FrzUnderlyingSymbolQtyEx(IntPtr handel, ref CShengliStockFrzUnderlyingSymbolQtyReqField info, ref CShengliStockConnMasterField pMasterInfo,  int requestId);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetFrozenUnderlyingSymbolQtyEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetFrozenUnderlyingSymbolQtyEvent(IntPtr handel, SLEES_OptTrade_SetFrozenUnderlyingSymbolQtyEventPtr p_fun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryUnderlyingSymbolQty", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryUnderlyingSymbolQty(IntPtr handel, ref CShengliStockReqUnderlyingSymbolQtyField info, int requestId);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryUnderlyingSymbolQtyEx", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryUnderlyingSymbolQtyEx(IntPtr handel, ref CShengliStockReqUnderlyingSymbolQtyField info, ref CShengliStockConnMasterField pMasterInfo, int requestId);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryUnderlyingSymbolQtyEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQueryUnderlyingSymbolQtyEvent(IntPtr handel, SLEES_OptTrade_SetQueryUnderlyingSymbolQtyEventPtr p_fun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryChairmanAcctAvailBp", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryChairmanAcctAvailBp(IntPtr handel, ref CShengliStockReqQryChairmanAcctAvailBpFiled info, int requestId);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryChairmanAcctAvailBpEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQueryChairmanAcctAvailBpEvent(IntPtr handel, SLEES_OptTrade_SetQueryChairmanAcctAvailBpEventPtr p_fun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetCommonMsgEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetCommonMsgEvent(IntPtr handel, SLEES_OptTrade_SetCommonMsgEventPtr p_fun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QuerySymbolMarginInfo", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QuerySymbolMarginInfo(IntPtr handel, ref CShengliStockQuerySymbolMarginInfoReqField info, int requestId);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQuerySymbolMarginInfoEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQuerySymbolMarginInfoEvent(IntPtr handel, SLEES_OptTrade_SetQuerySymbolMarginInfoEventPtr info);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QuerySymbolFeeInfo", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QuerySymbolFeeInfo(IntPtr handel, ref CShengliStockQuerySymbolFeeInfoReqField info, int requestId);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQuerySymbolFeeInfoEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQuerySymbolFeeInfoEvent(IntPtr handel, SLEES_OptTrade_SetQuerySymbolFeeInfoEventPtr info);


        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_ReqQuerySigningBankInfo", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_ReqQuerySigningBankInfo(IntPtr handle, CShengliStockQuerySigningBankInfoReqField info, int nRequestID);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQuerySigningBankInfoEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQuerySigningBankInfoEvent(IntPtr handle, SLEES_OptTrade_SetQuerySigningBankInfoEventPtr info);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_ReqQueryBankBalanceInfo", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_ReqQueryBankBalanceInfo(IntPtr handle, CShengliStockQueryBankBalanceInfoReqField info, int nRequestID);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryBankBalanceInfoEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQueryBankBalanceInfoEvent(IntPtr handle, SLEES_OptTrade_SetQueryBankBalanceInfoEventPtr info);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_ReqOneStepTransferInCash", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_ReqOneStepTransferInCash(IntPtr handle, CShengliStockOneStepTransferInCashReqField info, int nRequestID);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetBankToDeriveEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetBankToDeriveEvent(IntPtr handle, SLEES_OptTrade_SetBankToDeriveEventPtr info);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_ReqOneStepTransferOutCash", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_ReqOneStepTransferOutCash(IntPtr handle, CShengliStockOneStepTransferOutCashReqField info, int nRequestID);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetDeriveToBankEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetDeriveToBankEvent(IntPtr handle, SLEES_OptTrade_SetDeriveToBankEventPtr info);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_ReqClientTradeType", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_ReqClientTradeType(IntPtr handle, byte clientType);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_ReqDelegateTypeList", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_ReqDelegateTypeList(IntPtr handle, ref CShengliStockQueryDelegateTypeReqField info, int nRequestID);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryDelegateTypeEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQueryDelegateTypeEvent(IntPtr handle, SLEES_OptTrade_SetQueryDelegateTypeEventPtr info);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QureyETFList", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QureyETFList(IntPtr handle);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQureyETFListEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQureyETFListEvent(IntPtr handle, SLEES_OptTrade_QueryETFListEventPtr pFun);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QureyETFRemAcceptComponentList", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QureyETFRemAcceptComponentList(IntPtr handle);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQureyETFRemAcceptComponentListEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQureyETFRemAcceptComponentListEvent(IntPtr handle, SLEES_OptTrade_QueryETFRemAcceptEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QureyPCFComponentInfoList", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QureyPCFComponentInfoList(IntPtr handle);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQureyPCFComponentInfoListEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQureyPCFComponentInfoListEvent(IntPtr handle, SLEES_OptTrade_QureyPCFComponentInfoListEventPtr pFun);


        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QureyETFMarketAcceptComponentList", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QureyETFMarketAcceptComponentList(IntPtr handle);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQureyETFMarketAcceptComponentListEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQureyETFMarketAcceptComponentListEvent(IntPtr handle, SLEES_OptTrade_QureyETFMarketAcceptComponentListEventPtr pFun);


        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QureyReferenceExchangeRate", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QureyReferenceExchangeRate(IntPtr handle);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQureyReferenceExchangeRateEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQureyReferenceExchangeRateEvent(IntPtr handle, SLEES_OptTrade_QueryReferenceExchangeRateEventPtr pFun);

        #region 1224资金划拨
        /// <summary>
        /// 查询自动划拨资金配置
        /// </summary>
        /// <param name="handle"></param>
        /// <returns></returns>
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_ReqQueryFundStrategyCfg", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_ReqQueryFundStrategyCfg(IntPtr handle, ref CShengliStockQueryFundStrategyCfg req, int nRequestID);
        /// <summary>
        /// 查询自动划拨资金配置回调
        /// </summary>
        /// <param name="handle"></param>
        /// <returns></returns>
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetReqQueryFundStrategyCfgEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetReqQueryFundStrategyCfgEvent(IntPtr handle, SLEES_OptTrade_QueryFundStrategyCfgEventPtr req);

        /// <summary>
        /// 设置自动划拨资金配置
        /// </summary>
        /// <param name="handle"></param>
        /// <returns></returns>
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_ReqSetFundStrategyCfg", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_ReqSetFundStrategyCfg(IntPtr handle, ref  CShengliStockSetFundStrategyCfg req,int nRequestID);
        /// <summary>
        /// 设置自动划拨资金配置
        /// </summary>
        /// <param name="handle"></param>
        /// <returns></returns>
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetReqSetFundStrategyCfgEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetReqSetFundStrategyCfgEvent(IntPtr handle, SLEES_OptTrade_SetFundStrategyCfgEventPtr req);
        /// <summary>
        /// 查询自动划拨策略状态
        /// </summary>
        /// <param name="handle"></param>
        /// <returns></returns>
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_ReqQueryFundStrategySwitchStatus", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_ReqQueryFundStrategySwitchStatus(IntPtr handle, ref CShengliStockQueryFundStrategySwitchStatus req, int nRequestID);
        /// <summary>
        /// 查询自动划拨策略状态
        /// </summary>
        /// <param name="handle"></param>
        /// <returns></returns>
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetReqQueryFundStrategySwitchStatusEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetReqQueryFundStrategySwitchStatusEvent(IntPtr handle, SLEES_OptTrade_QueryFundStrategySwitchStatusEventPtr req);
        /// <summary>
        ///  开启和关闭 自动划拨策略
        /// </summary>
        /// <param name="handle"></param>
        /// <returns></returns>
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_ReqSetFundStrategySwitchStatus", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_ReqSetFundStrategySwitchStatus(IntPtr handle, ref CShengliStockSetFundStrategySwitchStatus req, int nRequestID);

        /// <summary>
        ///  开启和关闭 自动划拨策略
        /// </summary>
        /// <param name="handle"></param>
        /// <returns></returns>
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetReqSetFundStrategySwitchStatusEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetReqSetFundStrategySwitchStatusEvent(IntPtr handle, SLEES_OptTrade_SetFundStrategySwitchStatusEventPtr req);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryTransferPositionList", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryTransferPositionList(IntPtr handle, ref CShengliStockQueryTransferPositionField info, int nRequestID);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryTransferPositionEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQueryTransferPositionEvent(IntPtr handle, SLEES_OptTrade_SetQueryTransferPositionEventPtr p_fun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetPushTransferPositionReportEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetPushTransferPositionReportEvent(IntPtr handle, SLEES_OptTrade_SetPushTransferPositionReportEventPtr p_fun);

        #endregion


        #region 快照回滚

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryEntrustList", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_QueryEntrustList(IntPtr handle, ref CShengliStockReqQueryEntrustField rewindReq);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryEntrustList", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_SetQueryEntrustList(IntPtr handle, SLEES_SetQueryEntrustListEventPtr pFun);

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryEntrustExecutionList", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_QueryEntrustExecutionList(IntPtr handle, ref CShengliStockReqQueryEntrustExecutionField pQuery);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryEntrustExecutionList", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_SetQueryEntrustExecutionList(IntPtr handle, SLEES_SetQueryEntrustExecutionEventPtr pFun);
        #endregion

        #region  1178 查询通道列表

        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_QueryChannelList", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_QueryChannelList(IntPtr handle, uint nRequestID);
        [DllImport(DLLNAME, EntryPoint = "SLEES_OptTrade_SetQueryChannelListEvent", CallingConvention = CallingConvention.Cdecl)]
        protected static extern int SLEES_OptTrade_SetQueryChannelListEvent(IntPtr handle, SLEES_QueryChannelEventPtr pFun);
        #endregion

        #endregion

    }

}
