﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

namespace SlEesTrade
{
    #region C structions mapping

    ///协议版本号校验
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockProtoVersionCheckField
    {
        public UInt32 ProtoVersion;
    };

    //连接配置
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockConnConfigField
    {
        ///交易接收绑核（填写小于0的数为不绑核-1,默认绑核cpu2）
        public int TradeRecvNum;
        ///交易处理绑核（填写小于0的数为不绑核-1，默认不绑核）
        public int TradeProcNum;
        ///查询接收绑核（填写小于0的数为不绑核-1，默认绑核cpu4）
        public int QueryRecvNum;
        ///查询处理绑核（填写小于0的数为不绑核-1，默认不绑核）
        public int QueryProcNum;
        ///交易处理模式（同步为SOCKET_THREAD_SYNC，异步为SOCKET_THREAD_ASYNC，默认为同步）
        public byte TradeSyncMethod;
        ///查询处理模式（同步为SOCKET_THREAD_SYNC，异步为SOCKET_THREAD_ASYNC，默认为同步）
        public byte QuerySyncMethod;
        ///交易接收睡眠时间（填写时间大于等于0，单位为us，默认为0）
        public UInt64 TradeRecvSleepTime;
        ///交易处理异步睡眠时间（填写时间大于等于0，单位为us，默认为0）
        public UInt64 TradeProcSleepTime;
        ///查询接收睡眠时间（填写时间大于等于0，单位为us，默认为0）
        public UInt64 QueryRecvSleepTime;
        ///查询处理异步睡眠时间（填写时间大于等于0，单位为us，默认为0）
        public UInt64 QueryProcSleepTime;
        ///是否开启自动重连（不自动重连为NOT_AUTO_RECONN，自动重连为AUTO_RECONN，，默认为不自动重连）
        public byte IsReconn;
        ///自动重连时间间隔（填写时间大于等于1，单位为s，默认为1s）
        public UInt64 ReconnTime;
        ///使用tcp_direct模式(只支持linux,windows无效，关闭为SWITCH_CLOSE， 开启为SWITCH_OPEN，默认为关闭)
        public byte UseTcpDirect;
        ///tcp_direct指定网卡名(tcpdirect开启时有效)
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        public byte[] EthName;
        // 服务端udp端口(用于udp报单)
        public UInt16 RemoteTradeUDPPort;
    }

    ///登录请求
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqUserLoginField
    {
        ///客户端协议版本号
        public UInt32 ProtoVersion;
        ///登录名
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 33)]
        public byte[] LogonID;
        ///MD5加密后的密码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 33)]
        public byte[] Password;
        ///客户端mac地址
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 18)]
        public byte[] ClientMac;
        ///客户端类型名称
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
        public byte[] ClientProdInfo;
    };

    ///修改密码请求
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqChangePwdField
    {
        ///用户ID
        public UInt32 UserID;
        ///老密码的md5加密串
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 33)]
        public byte[] OldMd5Pwd;
        ///新密码的md5加密串
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 33)]
        public byte[] NewMd5Pwd;
    };

    ///客户号列表查询
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqQueryClientIDListField
    {
        ///用户ID
        public UInt32 UserID;
    };

    ///资金账号列表查询
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqQueryAccountListField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
    };

    ///股东账号列表查询
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqQueryTradeAccountListField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
    };

    ///证券代码列表查询
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqQuerySecurityCodeField
    {
        ///用户ID
        public UInt32 UserID;
        ///要查询的证券类型
        public UInt32 ComboSecurityType;
    };

    ///ETF成份股查询
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqQueryEtfMemberField
    {
        ///用户ID
        public UInt32 UserID;
        ///ETF证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///交易所
        public UInt32 ExchID;
    };

    ///期权细节查询
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqQueryOptionDetailField
    {
        ///用户ID
        public UInt32 UserID;
        ///标的代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///交易所
        public UInt32 ExchID;
    };

    ///账户费率查询
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqQueryAccountTradeFeeField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
    };

    ///仓位查询
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqQueryPositionField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
    };

    ///交易信息rewind请求
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqTradeInfoRewindField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
    };

    ///客户号资金状态查询请求
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqQueryBpStatusField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
    };

    ///交易所席位连接查询请求
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqQueryExchSessionField
    {
        ///用户ID
        public UInt32 UserID;
    };
    /// 查询风控阈值  请求结构体
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqQueryRiskThresholdValueField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        /// 风控ID号
        public UInt32 RiskRuleID;
        ///证券类型  填空
        public byte SecurityType;
        ///证券子类型  填空
        public byte SecuritySubType;
        ///交易所  填空
        public byte ExchID;
        ///代码  填空
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
    };

    /// 查询风控统计值 头部消息
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqQueryHeaderField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        /// 查询个数  指向 CShengliStockReqQueryRiskValueField 的个数 
        public UInt32 QryRiskCount;
    };

    /// 查询 风控统计值 结构体
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqQueryRiskValueField
    {
        /// 风控ID号
        public UInt32 RiskRuleID;
        ///证券类型  填空
        public byte SecurityType;
        ///证券子类型  填空
        public byte SecuritySubType;
        ///交易所  填空
        public byte ExchID;
        ///代码  填空
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
    };

    ///查询账户旁路风控当前值
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqQueryAcctMonitorValueField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
    };

    ///下单
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockEnterOrderField
    {
        ///用户ID 填登录的时候，返回的用户ID.
        public UInt32 UserID;
        ///客户端编号，登录成功以后，服务端会发送当前最大的 ClOrerToken ，之后，API每次的请求都要在这个上面连续的加1.
        public UInt32 ClOrdToken;
        ///客户号 
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] CustID;
        ///证券类型 根据选择的证券，合约指定值。可以默认为0 
        public byte SecurityType;
        ///证券子类型 根据选择的证券，合约指定值。可以默认为0 
        public byte SecuritySubType;
        ///资金账号 
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///交易所  交易证券，合约的交易所ID， 必须正确填写 。
        public byte ExchID;
        ///方向   交易方向
        public byte Side;
        ///数量 
        public UInt32 OrderQty;
        ///最小成交数量  
        public UInt32 MinQty;
        ///订单类型
        public byte PriceType;
        ///市价单时有效,最多成交价位数,0表示不限
        public UInt16 MaxPriceLevels;
        ///单子的存活时间
        public byte TIF;
        ///价格
        public Int64 Price;
        ///止损价
        public Int64 StopPrice;
        ///代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///交易类型
        public byte CashMarginFlag;
        ///会话ID,不关心时填0即可
        public byte SessionID;
        ///会话模式 填写 0 
        public byte SessionSelMode;
        ///客户使用,回报时将回传
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 4)]
        public byte[] UserInfo;
        /// RecordID
        public int RecordID;
        /// 强平标记 填 0
        /**
            0:正常交易，非强平
            1~254: 强平单，同时代表强平的原因ID
        */
        public byte ForceCoverFlag;
        //被硬件忽略的消息1
        public byte ToBypass1;
        //软件数据库落库
        public byte DelegateType;
        ///业务类别
        public int BussType;
        //被硬件忽略的消息2
        //public byte ToBypass2;
        //被硬件忽略的消息3
        public byte ToBypass3;
        //被硬件忽略的消息4
        public UInt32 ToBypass4;
        // 组合单边平仓里面的组合ID
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        public byte[] SecondaryOrderID;
        ///盘后定价交易标识
        public byte PfpFlag;
        //被硬件忽略的消息1
        public byte LotSizeType;
        ///是否按合同号还款
        public byte ReturnType;
        ///合同号
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 33)]
        public byte[] ContractNumber;
        ///还款金额
        public double ReturnAmount;
        ///还款数量
        public UInt32 ReturnQty;
    };

    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockCombTotalLegField
    {
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 4, ArraySubType = UnmanagedType.Struct)]
        public CShengliStockCombLegField[] legs;
    }

    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockCombLegField
    {
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] LegSecurityID;      ///<	成份合约代码（期权code）
        public byte Exchange;               ///<	交易所
        public byte LegPosDir;            ///<	持仓方向
        public UInt32 LegOrderQty;           ////<	成份合约数量
    };


    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    /// 期权组合，折分持仓订单扩展
    public struct CShengliStockExternCombOrder
    {
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        public byte[] SecondaryOrderID; ///<	组合策略流水号， 16位有效	构建组合申报时填全 0 ，解除组合申报时填写拟解除组合对应的组合流水号（构建组合申报时返回的执行报告中的OrderID）
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] StrategyID;     ///<	组合策略编码
        public byte Nolegs;           ///<	成分合约个数（最多支持4，目前市场最多是2）
    };

    ///下报价单
	[StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliQuoteEnterOrderField
    {
        ///用户ID 填登录的时候，返回的用户ID.
        public UInt32 UserID;
        ///客户端编号，登录成功以后，服务端会发送当前最大的 ClOrerToken ，之后，API每次的请求都要在这个上面连续的加1.
        public UInt32 ClOrdToken;
        ///客户号 
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] CustID;
        ///证券类型 根据选择的证券，合约指定值。可以默认为0 
        public byte SecurityType;
        ///证券子类型 根据选择的证券，合约指定值。可以默认为0 
        public byte SecuritySubType;
        ///资金账号 
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///交易所  交易证券，合约的交易所ID， 必须正确填写 。
        public byte ExchID;
        ///方向   交易方向
        public byte Side;
        ///代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///申报类型 1新订单 2撤单
        public byte ReqType;
        ///报价类型 1可交易的报价
        public byte QuoteType;
        ///买价
        public Int64 BidPx;
        ///买数量
        public UInt32 BidQty;
        ///买方向
        public char BidSide;
        ///卖价
        public Int64 AskPx;
        ///卖数量
        public UInt32 AskQty;
        ///卖方向
        public char AskSide;
        ///询价请求编号(回应报价的时候，要填,其它填空串)
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 11)]
        public byte[] QuoteReqID;
        ///供客户使用，柜台回报时将回传
        public UInt64 UserInfo;
        ///供客户使用，深交所交易所回报时将回传
        public UInt64 ExchangeUserInfo;
        /// 委托方式
        public byte DelegateType;
        /// RecordID
        public int RecordID;
        ///会话ID,不关心时填0即可
        public byte SessionID;
        ///会话模式 填写 0 
        public byte SessionSelMode;
    };


    ///撤单
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockCxlOrderField
    {
        //OrigUserId
        public UInt32 OrigUserId;
        ///用户ID
        public UInt32 UserID;
        ///客户端编号
        public UInt32 ClOrdToken;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///盛立系统产生的单子号
        public UInt64 OrigOrderID;
        ///要撤订单的ClOrdToken
        public UInt32 OrigClOrdToken;
        ///单子被取消后所希望剩下的数量
        public UInt32 LeavesQty;
        /// 客户使用,回报时将回传
        public int UserInfo1;

        //委托方式
        public byte DelegateType;
        //保留字段
        public UInt16 ToBypass1;
        //保留字段
        public byte ToBypass2;
        public byte ToBypass3;
        public byte ToBypass4;

    };

    ///协议版本号校验回报
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockRespProtoVersionCheckField
    {
        ///客户端协议版本号
        public UInt32 ProtoVersion;
    };

    ///登录请求回应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockRespUserLoginField
    {
        ///客户端协议版本号
		public UInt32 ProtoVersion;
        ///登录是否错误
        public Int32 Result;
        ///SessionId
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 33)]
        public byte[] SessionID;
        ///用户ID
        public UInt32 UserID;
        ///交易日
        public UInt32 TradingDate;
        ///该用户下单目前最大的编号
        public UInt32 MaxCltOrderToken;
        ///默认的客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] DefClientID;
		///计算实虛值标记		
        public byte MoneyInOrOutFlag;
        ///与主席同步，remTrader 里面的类型   0：原始 1:国信  5:南华CTP	
        public byte ChairmanSyncTradeFlag;   
        ///备用字段
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 3)]
        public byte[] Reserved;
        ///SessionId
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 33)]
        public byte[] LogonID;
        ///行权是否验证仓位
        public byte ExerciseCheckPos;
        ///备用字段
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 6)]
        public byte[] Reserved1;
        ///错误原因
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
        public byte[] MsgText;
    };

    ///修改密码响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockRespChangePwdField
    {
        ///用户ID
        public UInt32 UserID;
        ///修改密码是否成功
        public Int32 Result;
    };

    ///客户号列表查询响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockClientIDListField
    {


        public uint RequestID;
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///客户名称
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 64)]
        public byte[] ClientName;
        ///营业部
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] BranchID;
        ///客户号相关权限
        public Int32 Previlege;
    };

    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct TShengliStockBizPrevilegeBody
    {
        ///二级市场交易权限
        public byte Lev2MarketPer;
        ///债券撮合业务权限
        public byte BondMatchPer;
        ///债券质押式回购权限
        public byte BondPledgeBuybackPer;
        ///单市场ETF申赎权限
        public byte SigMarketEtfPer;
        ///跨市场ETF申赎权限
        public byte CrossMaketEtfPer;
        ///跨境ETF申赎权限
        public byte CrossBorderEtfPer;
        ///港股通权限
        public byte HkStockSharePer;
    };

    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct TShengliStockVarietyPrevilegeBody
    {
        ///A股权限
        public byte AStockPer;
        ///国债权限
        public byte NationalDebtPer;
        ///地方债权限
        public byte LocalDebtPer;
        ///企业债权限
        public byte EnterpriseDebtPer;
        ///公司债权限
        public byte CompDebtPer;
        ///金融债权限
        public byte FinancialDebtPer;
        ///可转换债权限
        public byte ConvertibleBondPer;
        ///可交换公司债权限
        public byte ExchCompDebtPer;
        ///可交换私募债权限
        public byte ExchPriDebtPer;
        ///私募债权限
        public byte PriDebtPer;
        ///次级债权限
        public byte SecondaryDebtPer;
        ///资产支持证券权限
        public byte AbSecurityPer;
        ///证券公司短期债权限
        public byte SecuCompShortDebtPer;
        ///LOF基金权限
        public byte LofFundPer;
        ///封闭式基金权限
        public byte ClosedFundPer;
        ///单市场ETF权限
        public byte SigMarketEtfVarPer;
        ///跨市场ETF权限
        public byte CrossMarketEtfVarPer;
        ///跨境ETF权限
        public byte CrossBorderEtfVarPer;
        ///实物债券ETF权限
        public byte EntityBondEtfPer;
        ///现金债券ETF权限
        public byte CashBondEtfPer;
        ///货币ETF权限
        public byte CurrencyEtfPer;
        ///黄金ETF权限
        public byte GoldEtfPer;
        ///跨境LOF权限
        public byte CrossBorderLofPer;
    };

    ///资金账户列表查询响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockAccountListField
    {
        public uint RequestID;
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金帐户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///资金账户名称
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 64)]
        public byte[] FundAccountName;
        ///资金帐户类型
        public byte FundAccountType;
        ///是否支持融资行权
        public int AccountFinanchingExercise;
        ///客户号相关业务行为权限
        ///业务行为权限结构体
        public TShengliStockBizPrevilegeBody BizPrevilegeBody;
        ///品种权限结构体
        public TShengliStockVarietyPrevilegeBody VarietyPrevilegeBody;
        /////委托方式结果
        //[MarshalAs(UnmanagedType.ByValArray, SizeConst = 1024)]
        //public byte[] DelegateValue;
        ///资金账户列表查询响应结果
        public UInt32 Result;
        ///查询结果内容
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
        public byte[] MsgText;
        // 认沽行权是否验仓 
        public byte OptPutExercise;
    };

    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockInvestorPrevilegeBody
    {
        ///市价委托权限
        public byte MarketPricePer;
        ///买入风险警示股票权限
        public byte BuyStStockPer;
        ///买入退市股票权限
        public byte BuyOutStockPer;
        ///创业板权限
        public byte StartBoardPer;
        ///科创板权限
        public byte KechuangBoardPer;
        ///分级基金权限
        public byte StructuredFundPer;
        ///债券市场投资者权限
        public byte BondMarketInvestorPer;
        ///债券市场合格投资者权限
        public byte BondMarketQualifiedPer;
        ///债券质押式回购权限
        public byte BondPledgeBuybackPer;
        ///港股通权限
        public byte HkStockSharePer;
        ///期权不合格投资者
        public byte OptUQIPer;
        ///期权一级权限
        public byte OptLevel1Per;
        ///期权二级权限
        public byte OptLevel2Per;
        ///期权三级权限
        public byte OptLevel3Per;
    };

    ///股东账户列表查询响应
	[StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockTradeAccountListField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金帐户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;

        public byte FundAccountType;
        ///股东帐户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 24)]
        public byte[] TradeAccount;

        //交易所
        public byte ExchangeId;

        //代表是否为当前绑定的股东账户
        public byte BindCurrentFlag;

        ///请求ID
        public uint RequestID;

        ///适当性权限结构体
        public CShengliStockInvestorPrevilegeBody InvestorPrevilegeBody;

        ///交易节点
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        public byte[] TradeNodeID;
    };

    ///证券代码列表查询响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockNormalSecurityCodeField
    {


        public uint RequestID;
        ///用户ID
        public UInt32 UserID;
        ///交易所
        public byte ExchID;
        ///证券类型
        public byte SecurityType;
        ///证券子类型
        public byte SecuritySubType;

        ///证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 88)]
        public byte[] SecurityName;

        /// <summary>
        /// 是否可平今
        /// </summary>
        public int CoverTodayFlag;

        ///货币品种
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 4)]
        public byte[] Currency;

        /// <summary>
        /// 面值
        /// </summary>
        public Int64 ParValue;

        /// <summary>
        /// 买最小数量
        /// </summary>
        public uint BuyMinQty;

        /// <summary>
        /// 卖最小数量
        /// </summary>
        public uint SellMinQty;

        /// <summary>
        /// 单个订单最小委托数量
        /// </summary>
        public uint MinOrderQty;

        /// <summary>
        /// 单个订单最大委托数量
        /// </summary>
        public uint MaxOrderQty;

        /// <summary>
        ///  昨收价格
        /// </summary>
        public Int64 PreClosePrice;

        /// <summary>
        /// 最小价格变动
        /// </summary>
        public Int64 MinTickPrice;

        /// <summary>
        /// 涨停价
        /// </summary>
        public Int64 UpLimitPrice;

        /// <summary>
        /// 跌停价
        /// </summary>
        public Int64 LowLimitPrice;

        /// <summary>
        /// 是否可融资
        /// </summary>
        public char IsFinancing;

        /// <summary>
        /// 是否可融券
        /// </summary>
        public char IsLending;

        ///是否有买权限
        public char BuyFlag;

        ///LotSize单位数量
        public uint LotSize;

    };

    ///期权代码列表查询响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockOptionSecurityCodeField
    {
        public uint RequestID;
        ///用户ID
        public UInt32 UserID;
        ///交易所
        public byte ExchID;
        ///证券类型
        public byte SecurityType;
        ///证券子类型
        public byte SecuritySubType;

        ///证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 88)]
        public byte[] SecurityName;

        /// <summary>
        /// 期权合约过期日
        /// </summary>
        public int ExpireDate;

        ///期权标的证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] UnderlyingSecurityCode;
        ///期权标的证券名称
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 88)]
        public byte[] UnderlyingSecurityName;


        ///期权标的证券类型
        public byte UnderlyingSecurityType;
        ///期权标的证券子类型
        public byte UnderlyingSecuritySubType;

        /// <summary>
        /// 期权类型
        /// </summary>
        public byte OptionType;

        /// <summary>
        /// 合约单位
        /// </summary>
        public uint VolMultipler;

        /// <summary>
        /// 期权首个交易日
        /// </summary>
        public int StartDate;



        /// <summary>
        /// 期权最后交易日
        /// </summary>
        public int EndDate;

        /// <summary>
        /// 期权交割日期
        /// </summary>
        public int DeliveryDate;

        /// <summary>
        /// 期权行权日期
        /// </summary>
        public int ExerciseDate;

        /// <summary>
        /// 更新版本号
        /// </summary>
        public byte UpdateVersion;

        /// <summary>
        /// 当前合约未平仓数量
        /// </summary>
        public int TotalLongPosition;

        /// <summary>
        /// 昨日收盘价格
        /// </summary>
        public Int64 SecurityClosePx;

        /// <summary>
        /// 昨日结算价格
        /// </summary>
        public Int64 SettlePrice;

        /// <summary>
        /// 标的昨日收盘价格
        /// </summary>
        public Int64 UnderlyingClosePx;

        /// <summary>
        /// 涨幅上限价格
        /// </summary>
        public Int64 DailyPriceUpLimit;


        /// <summary>
        /// 跌幅下限价格
        /// </summary>
        public Int64 DailyPriceDownLimit;


        /// <summary>
        /// 限价单个订单最小委托数量
        /// </summary>
        public uint LmtMinOrderQty;


        /// <summary>
        /// 限价单个订单最大委托数量
        /// </summary>
        public uint LmtMaxOrderQty;

        /// <summary>
        /// 市价单个订单最小委托数量
        /// </summary>
        public uint MktMinOrderQty;

        /// <summary>
        /// 市价单个订单最大委托数量
        /// </summary>
        public uint MktMaxOrderQty;

        /// <summary>
        /// 最小价格标动
        /// </summary>
        public Int64 MinTickPrice;

        ///期权合约账户代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 7)]
        public byte[] ContractAccountCode;

        ///期权合约代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 21)]
        public byte[] ContractID;

        ///标的所属交易所
        public byte UnderlyingExchID;

        /// <summary>
        /// 期权看涨看跌
        /// </summary>
        public byte CallOrPut;

        /// <summary>
        /// 期权行权价格
        /// </summary>
        public Int64 StrikePrice;

        public uint LmtBuyOrdMaxFloor; 		///< 限价买最大委托数量	
        public uint LmtSellOrdMaxFloor; 	///< 限价卖最大委托数量	
        public uint MktBuyOrdMaxFloor; 		///< 市价买最大委托数量	
        public uint MktSellOrdMaxFloor; 	///< 市价卖最大委托数量	

    };

    ///参考汇率查询响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReferenceExchangeRateField
    {
        public uint RequestID;
        ///用户ID
        public UInt32 UserID;
        //REM系统内源货币编号
        public uint SrcCurrencyType;
        //REM系统内目标货币编号
        public uint DstCurrencyType;
        //参考买入价
        public double BuyingPrice;
        //参考卖出价
        public double SellingPrice;
        //参考中间价
        public double MiddlePrice;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] DateOfApplication;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 21)]
        public byte[] Remark;
    }


    ///ETF列表查询响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockETFInfoField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
        public byte ExchID;
        ///证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///证券名称
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 88)]
        public byte[] SecurityName;
        ///ETF二级市场代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] ETFCode;
        //预估现金差额
        public double EstimateCashComponent;
        //最大现金替代比例
        public double MaxCashRatio;
        //T-1日现金差额
        public double CashComponent;
        //净值
        public double NavPerCu;
        //最小申赎单位
        public UInt32 CreationRedemptionUnit;
        //成分股个数
        public UInt32 ComponentRecordNum;
    }

    ///ETF申赎确认成分股明细响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockETFRemAcceptInfoField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
        public byte ExchID;
        ///资金帐户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///客户端编号
        public UInt32 ClOrdToken;
        ///委托方向
        public byte Side;
        ///ETF二级市场代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] ETFCode;
        ///REM系统单cluster唯一编号
        public UInt64 OrderID;
        ///证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///证券名称
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 88)]
        public byte[] SecurityName;
        ///成分股交易所
        public byte Exchange_underlying_secu_code;
        //本订单ETF份额所对应的当前成分股的总数量
        public UInt64 ComponentShare;
        //实际使用数量
        public UInt64 QtySubstitute;
        //替代数量
        public UInt64 CashSubstituteQty;
        //替代金额
        public double CashComponent;
        ///委托时间
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
        public byte[] UpdateDateTime;

    }

    //PCF成分股明细响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockPCFCompoonentInfoField
    {
        ///用户ID
        public UInt32 UserID;
        ///ETF交易所
        public byte ExchID;
        ///证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] ETFCode;
        ///成分股交易所
        public byte ExchIDUnderlyingSecuCode;
        ///成分股代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] UnderlyingSecurityCode;
        ///证券名称
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 88)]
        public byte[] UnderlyingSecurityName;
        //成分股的数量
        public UInt64 ComponentShare;
        //替代标志
        public byte SubstituteFlag;
        //溢价比例（%）
        public double PermiumRatio;
        //折价比例
        public double DiscountRatio;
        //申购现金替代金额
        public double CreationCashSubstitute;
        //赎回。
        public double RedemptionCashSubstitute;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
        public byte[] UpdateDateTime;

    }

    ///申赎市场接受
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockETFMarketAcceptCompoonentInfoField
    {

        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
        public byte ExchID;
        ///资金帐户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///客户端编号
        public UInt32 ClOrdToken;
        ///委托方向
        public byte Side;
        ///ETF二级市场代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] ETFCode;
        ///REM系统单cluster唯一编号
        public UInt64 OrderID;
        ///证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 88)]
        public byte[] SecurityName;
        ///成分股交易所
        public byte Exchange_underlying_secu_code;
        //本订单ETF份额所对应的当前成分股的总数量
        public UInt64 ComponentShare;
        //实际使用数量
        public UInt64 QtySubstitute;
        //替代数量
        public UInt64 CashSubstituteQty;
        //替代金额
        public double CashComponent;
        //委托时间
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
        public byte[] UpdateDateTime;

    }

    ///ETF成份股查询响应

    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockEtfMemberField
    {
        public uint RequestID;
        ///用户ID
        public UInt32 UserID;
        ///交易所
        public byte ExchID;
        ///ETF证券代码
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 9)]
        public string SecurityCode;
        ///交易所
        public byte MemberExchID;
        ///成份股证券代码
        [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 9)]
        public string MemberSecurityCode;
        ///成份股数量
        public uint Share;
        ///现金替代标志
        public byte SubstCashFlag;
        // 溢价比例
        public double PermiumRatio;
        // 折价比例
        public double DiscountRatio;
        // 申购替代金额
        public Int64 CreationCashSubstitute;
        // 赎回替代金额 
        public Int64 RedemptionCashSubstitute;
    };

    ///期权细节查询响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockOptionDetailField
    {

        ///用户ID
        public UInt32 UserID;
        ///ETF证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///交易所
        public byte ExchID;
        ///期权合约过期日
        public Int32 ExpireDate;
        ///期权标的证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] UnderlyingSecurityCode;
        ///期权合约账户代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 7)]
        public byte[] ContractAccountCode;
        ///期权合约代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 21)]
        public byte[] ContractID;
        ///标的所属交易所
        public byte UnderlyingExchID;
        ///期权看涨看跌
        public byte CallOrPut;
        ///期权行权价
        public double StrikePrice;
    };

    ///账户费率查询的响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockAccountTradeFeeField
    {

        public uint RequestID;
        ///用户ID
        public byte UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金帐户类型
        public byte AccountType;
        ///资金帐户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///交易所
        public byte ExchID;
        ///交易分类
        public byte TradeType;
        ///仓位方向（暂时不用）
        public byte PosDir;
        ///费率组合
        public byte FeeIdx;
        ///按照金额比例收取的费率
        public Int64 FeeAmount;
        ///按照成交量每股收取的费率
        public Int64 FeeQty;
        ///支持每笔最小收费
        public Int64 FeeMin;
    };

    ///普通仓位查询的响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockNormalPositionField
    {
        public uint RequestID;
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金帐户类型
        public byte AccountType;
        ///资金帐户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///交易所
        public byte ExchID;
        ///证券类型
        public byte SecurityType;
        ///证券类型
        public byte SecuritySubType;
        ///证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;

        ///初始隔夜仓数量
        public UInt32 InitOvnPosQty;
        ///剩余昨仓, 所持量
        public UInt32 CurOvnQty;
        ///总仓位，包括今仓, 所持量
        public UInt32 CurQty;
        ///总可平仓数量
        public UInt32 AvailQty;
        ///备兑锁定量中昨仓部分
        public UInt32 OvnCoveredLockedQty;
        ///总备兑锁定量
        public UInt32 CoveredLockedQty;
        ///备兑锁定挂单量中，影响昨仓的部分。
        public UInt32 OvnCoveredLockPendingQty;
        ///总备兑锁定挂单量
        public UInt32 CoveredLockPendingQty;
        ///备兑担保量, 即已用于期权备兑仓担保的量
        public UInt32 CoveredPledgedQty;
        // 备兑不足的量
        public UInt32 CoveredNotEnoughQty;
        ///总备兑解锁挂单量
        public UInt32 CoveredUnlockPendingQty;
        ///总平仓挂单量
        public UInt32 ClosePosPendingQty;
        /// 持仓均价
        public Int64 AvgPx;
        /// 行权锁定的数量
        public UInt32 ExecriseLockedQty;        
        /// 行权收付数量
        public Int32 ExerciseAcceptPayQty;
		/// 今天开仓数量
        public Int32 TodayOpenQty;

    };









    ///期权仓位查询的响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockOptionPositionField
    {

        public uint RequestID;
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金帐户类型
        public byte AccountType;
        ///资金帐户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///交易所
        public byte ExchID;
        ///证券类型
        public byte SecurityType;
        ///证券类型
        public byte SecuritySubType;
        ///证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;

        ///仓位方向，期权分多头、空头、备兑3种
        public byte PositionDirection;
        ///初始昨仓
        public UInt32 InitOvnQty;
        ///当前仓位
        public UInt32 CurQty;
        ///当前可平仓位
        public UInt32 AvailQty;


        /// 当前占用的保证金
        public Int64 CurMargin;

        /// 当前占用的交易所保证金
        public Int64 CurExchangeMargin;
        /// 持仓均价
        public Int64 AvgPx;


        /// <summary>
        /// 合约买入成本
        /// </summary>
        public Int64 Bcost;

        /// <summary>
        /// 仓位市值
        /// </summary>
        public Int64 Mktval;


        /// <summary>
        /// 权利金
        /// </summary>
        public Int64 Premium;
        /// <summary>
        /// 在途的开仓数量
        /// </summary>
        public uint OpeningQty;
        /// <summary>
        /// 在途的平仓数量
        /// </summary>
        public uint CoveringQty;
        /// <summary>
        /// 在途冻结资金
        /// </summary>
        public Int64 OpeningFrozenBp;
        ///在途冻结权利金
        public Int64 OpeningPremium;
        /// 最新价计算的保证金，包括上浮
        public Int64 LastPriceFloatMargin;
        /// 最新价计算的保证金，不包括上浮
        public Int64 LastPriceMargin;
		/// 行权数量 
        public uint ExerciseQty;
        ///组合占用数量
        public UInt32 CombQty;
        ///组合在途冻结数量
        public UInt32 PendingCombQty;
    };



    ///期权组合策略仓位查询的响应
	[StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockOptionCombStrategyPositionField
    {
        ///用户ID
        public UInt32 m_UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] m_ClientID;
        ///资金帐户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] m_FundAccount;
        ///交易所
        public byte m_exchange_id;
        ///股东帐户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 24)]
        public byte[] m_trade_acct;
        ///組合id
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        public byte[] m_comb_id;
        /// 今昨
        public byte m_day_type;
        ///組合策略编码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] m_comb_strategy_id;
        ///标的
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] m_underlying_secu_code;
        ///数量
        public UInt32 m_share;
        ///冻结数量
        public UInt32 m_frz_share;
        ///金额
        public Int64 m_margin;
        ///腿数
        public UInt32 m_leg_count;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 4, ArraySubType = UnmanagedType.Struct)]
        public CShengliStockOptionCombStrategyLegField[] m_leg;
        /// 初始组合持仓数量
        public UInt32 m_init_share;
    }


    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockOptionCombStrategyLegField
    {
        ///合约
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] m_secu_code;
        ///持仓方向
        public byte m_pos_dir;
        /// 分腿初始持仓
        public UInt32 m_init_share;
        ///份数
        public UInt32 m_share;
        ///每一腿的保证金
        public Int64 m_margin;
    }


    ///客户号订单rewind完成消息
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockOrderRewindFinishField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
    };


    ///客户号订单成交完成消息
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockExecRewindFinishField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
    };

    ///客户号订单撤销请求完成消息
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockCxlReqRewindFinishField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
    };

    ///交易所连接查询响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockExchangeConnectField
    {
        ///用户ID
        public UInt32 UserID;
        ///交易所
        public byte ExchID;
        ///交易所连接个数，0-255
        public byte SessionCount;
        ///交易所连接代号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 255)]
        public byte[] SessionID;
    };

    //交易所状态变化报告
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockExchangeStatusReportField
    {
        ///交易所代码
        public byte ExchID;
        ///交易所连接代号
        public byte SessionID;
        ///交易所状态
        public byte SessionStatus;
    };

    ///客户号资金状态查询响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockBpStatusField
    {
        ///用户ID
        public UInt32 UserID;
        ////客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///初始可用资金
        public Int64 InitialBp;
        ///当前可用资金
        public Int64 AvailableBp;

        ///开仓冻结保证金
        public Int64 FrozenMargin;
        ///开仓冻结权利金
        public Int64 FrozenPremium;
        ///冻结费用
        public Int64 FrozenFee;
        ///收权利金
        public Int64 IncomePremium;
        ///支出权利金
        public Int64 OutcomePremium;
        ///持仓占用保证金
        public Int64 MarginInclRlt;
        ///交易所可用资金
        public Int64 ExchangeAvailBp;
        ///总费用
        public Int64 TotalFee;
        ///总权益
        public Int64 TotalFundBln;
        ///请求ID
        public uint RequestID;
        ///市值权益
        public Int64 MarketEquity;
        ///日初权益
        public Int64 InitEquity;
        ///日初保证金
        public Int64 InitMargin;
        ///可取金额
        public Int64 AcceptableAmount;
        // 出入金判断类型
        public byte OutCashConditionFLag;
        ///资金帐户类型
        public byte FundAccountType;
        ///客户号资金状态查询响应结果
        /// </summary>
        public UInt32 Result;
        ///查询结果内容
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
        public byte[] MsgText;
        ///行权收付资金
        public Int64 ExerciseAcceptPayAmount;
        /// 行权冻结资金
        public Int64 InitFrzBp;
        /// 券商预留冻结资金
        public Int64 FrozenReserved;
        /// <summary>
        /// 交易所
        /// </summary>
        public byte ExchangeId;
        /// <summary>
        /// 自动划拨资金策略风险敞口
        /// </summary>
        public Int64 AutoTransfBpRiskExposure;
        /// <summary>
        /// 自动划拨资金策略可划出资金
        /// </summary>
        public Int64 CanTransfBp;
    };

    /// 查询风控阈值  返回结构体
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqQueryRiskThresholdValueRespField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        /// 风控ID号
        public UInt32 RiskRuleID;
        /// 风控类型
        public byte RiskRuleType;
        ///证券类型
        public byte SecurityType;
        ///证券子类型 
        public byte SecuritySubType;
        ///交易所
        public byte ExchID;
        ///代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        /// 参数个数	最大为3 
        public UInt32 ParamCount;
        /// 门限值 
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 3)]
        public Int64[] RiskThreholdValue;
        ///查询结果
        public byte Result;
        ///开关
        public byte Switch;
    };

    /// 查询风控统计值   返回结构体
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqQueryRiskValueRespField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        /// 风控ID号
        public UInt32 RiskRuleID;
        /// 风控类型
        public byte RiskRuleType;
        ///证券类型
        public byte SecurityType;
        ///证券子类型 
        public byte SecuritySubType;
        ///交易所
        public byte ExchID;
        ///代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        /// 门限值 
        public Int64 RiskValue;
        ///查询结果
        public byte Result;
        /// 更新时间
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 24)]
        public byte[] UpdTime;
        ///开关
        public byte Switch;
    };

    ///查询账户旁路风控 返回结构体
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqQueryAcctMonitorValueRespField
    {
        /// 用户ID
        public UInt32 UserID;
        /// 客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        /// 资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        /// 账户监控ID号
        public UInt32 AcctMoniotrID;
        /// 交易所
        public byte ExchID;
        /// 监控条目
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 64)]
        public byte[] MonitorEntryDisp;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
        public byte[] Memo;
        /// 实时值 
        public Int64 CurrentValue;
        /// 预警线1
        public Int64 Precaution1;
        /// 查询结果
        public byte Result;
        /// 更新时间
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 24)]
        public byte[] UpdTime;
        ///标的
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] Symbol;
    };

    ///REM订单接受, 订单rewind响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockOrderAcceptedField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户端编号
        public UInt32 ClOrdToken;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///证券类型
        public byte SecurityType;
        ///证券子类型
        public byte SecuritySubType;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///交易所
        public byte ExchID;
        ///方向
        public byte Side;
        ///数量
        public UInt32 OrderQty;
        ///最小成交数量
        public UInt32 MinQty;
        ///订单类型
        public byte PriceType;
        ///市价单时有效,最多成交价位数,0表示不限
        public UInt16 MaxPriceLevels;
        ///单子的存活时间
        public byte TIF;
        ///价格
        public Int64 Price;
        ///止损价
        public Int64 StopPrice;
        ///代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///交易类型
        public byte CashMarginFlag;
        ///会话ID,不关心时填0即可
        public byte SessionID;
        ///会话模式
        public byte SessionSelMode;
        ///REM系统单cluster唯一编号
		public UInt32 UserInfo1;
        ///客户使用,回报时将回传
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 4)]
        public byte[] UserInfo2;

        ///REM系统单cluster唯一编号
        public UInt64 OrderID;
        ///交易所单号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        public byte[] ExchangeOrderID;
        ///交易所接受标志
        public byte ExchangeAcceptFlag;
        ///订单状态
        public byte OrderState;
        ///被动单/外部单标志
        public byte PassiveOrderFlag;
        ///收到订单的时间，单位为纳秒
        public UInt64 RecvTimestamp;
        ///REM内核(硬件)处理完毕接受的时间戳，和开始发往交易所的时间戳相同
        public UInt64 AcceptTimestamp;
        ///REM系统收到交易所接受的时间戳
        public UInt64 ExchangeAcceptTimestamp;
        ///交易所接受时，交易所给出的时间戳
        public UInt64 ExchangeTransTimestamp;
        ///如果订单已经关闭，订单关闭的时间戳
        public UInt64 ClosedTimestamp;
        ///总成交量
        public UInt32 FilledQty;
        ///--期权扩展字段--///
        ///期权合约过期日
        public Int32 ExpireDate;
        ///期权标的证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] UnderlyingSecurityCode;
        ///期权合约账户代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 7)]
        public byte[] ContractAccountCode;
        ///期权合约代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 21)]
        public byte[] ContractID;
        ///交易所
        public byte UnderlyingExchID;
        ///期权看涨看跌
        public byte CallOrPut;
        ///期权行权价
        public Int64 StrikePrice;

        /// 只要不为0，就是强平的原因。
        public byte ForceCoverFlag;

        // 多腿信息	
        public CShengliStockExternCombOrder Extern;
        public CShengliStockCombLegField Leg1;
        public CShengliStockCombLegField Leg2;
        public CShengliStockCombLegField Leg3;
        public CShengliStockCombLegField Leg4;

        public byte DelegateType;

        // 组合单边平仓里面的组合ID
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        public byte[] SecondaryOrderID;
        ///盘后定价交易标志
        public byte PfpFlag;
    };

    ///成交回报, 成交rewind响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockOrderExecedField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户端编号
        public UInt32 ClOrdToken;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///REM系统单cluster唯一编号
        public UInt64 OrderID;
        ///REM系统cluster唯一成交编号
        public UInt64 ExecID;
        ///本次成交价
        public Int64 LastPrice;
        ///本次成交量
        public UInt32 LastQty;
        ///被动成交标志
        public byte PassiveFlag;
        ///交易所单号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        public byte[] ExchangeOrderID;
        ///交易所成交编号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        public byte[] ExchangeExecID;
        ///交易所成交时间戳
        public UInt64 ExchangeTimestamp;
        ///收到订单的时间
        public UInt64 ExecTimestamp;
        // 多腿信息	
        public CShengliStockExternCombOrder Extern;

        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 4, ArraySubType = UnmanagedType.Struct)]
        public CShengliStockCombLegField[] legs;
        ///买卖方向
        public byte Side;
        ///合约代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecuCode;

        // 组合单边平仓里面的组合ID
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        public byte[] SecondaryOrderID;
    };


    ///订单拒绝
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockOrderRejectedField
    {
        ///用户ID
        public UInt32 UserID;
        //下单时指定的ClOrdToken
        public UInt32 ClOrdToken;
        ///REM拒绝时该值为0. 交易所拒绝时为REM系统单号
        public UInt64 OrderID;
        ///拒绝的时间戳
        public UInt64 RejectTimeStamp;
        ///系统拒绝
        public byte RejectedBy;
        ///拒绝原因
        public UInt16 RejectReason;
        ///语法检查结果
        public UInt32 GrammarResult;
        ///被动标志，只有交易所拒绝的情况有可能
        public Int32 PassiveFlag;
        ///风控检查结果
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] RiskResult;
        ///错误原因文字
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 88)]
        public byte[] ReasonText;
    };

    ///撤单成功,撤单请求
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockOrderCxledField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户端编号
        public UInt32 ClOrdToken;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///盛立系统产生的单子号
        public UInt64 OrigOrderID;
        ///要撤订单的ClOrdToken
        public UInt32 OrigClOrdToken;
        ///撤单成功的数量
        public UInt32 LeavesQty;

        ///REM接受撤单请求并发往交易所的时间戳
        public UInt64 AcceptTimestamp;
        ///REM处理撤单成功的时间戳
        public UInt64 CxledTimestamp;
        ///交易所提供的撤单时间戳
        public UInt64 ExchangeTransTimestamp;
        ///交易所单号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        public byte[] ExchangeOrderID;
        ///撤单请求发送的UserID,如果是市场方向主动发起的撤单，该值填0。
        public UInt32 OrigUserID;
        ///撤单时该订单已成交数量
        //public UInt32 FilledQty;
        ///交易所
        public byte ExchID;
        ///被动撤单标志
        public int PassiveFlag;
        ///撤单状态标志
        public int CxlReqStatus;
        /// 做市买卖方向
        public byte QuoteSide;

    };


    ///撤单拒绝
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockOrderCxlRejectedField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户端编号
        public UInt32 ClOrdToken;
        ///单号
        public UInt64 OrderID;
        ///REM系统拒绝的时间戳，或者如果是交易所拒绝，REM处理交易所拒绝的时间戳
        public UInt64 RejectTimeStamp;
        ///如果是交易所撤单拒绝，交易所消息中提供的时间戳。
        public UInt64 ExchangeTransTimestamp;
        ///系统拒绝
        public byte RejectedBy;
        ///拒绝原因
        public UInt16 RejectReason;
        ///语法检查
        public UInt32 GrammarResult;
        ///被动撤单标志
        public int PassiveFlag;
        ///风控检查结果
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] RiskResult;
        ///错误原因文字
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 80)]
        public byte[] ReasonText;

        public UInt32 OrigUserID;
        public UInt32 OrigCliOrdToken;
    };

    ///ETF申购赎回成交回报
    ///Head
    //typedef CShengliStockOrderExecedField CShengliStockEtfExecHeadField;
    ///Body
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockEtfExecBodyField
    {
        ///成份股证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] UnderlyingSecurityCode;
        ///股份交付数量
        public UInt32 DeliveryQty;
        ///交易所
        public byte UnderlyingExchID;
        ///现金替代比例
        public double SubstCashRate;
    };

    /// <summary>
    /// 账户级风控累加值回报
    /// </summary>
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockAccountRiskDataRspField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金帐户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///资金帐户类型
        public byte FundAccountType;
        ///请求号
        public UInt32 RequestID;
        ///错误码
        public UInt16 ReasonCode;
        ///各个rule的值
        public Int64 Rule1Value;
        public Int64 Rule34Value;
        public Int64 Rule35Value;
        public UInt64 Rule37Value;
        public UInt64 Rule38Value;
        public UInt64 Rule40Value;
        public UInt64 Rule41Value;
        public Int64 Rule48Value;
        public Int64 Rule49Value;
        public Int64 Equities;

    }

    // <summary>
    /// symbol级风控累加值回报
    /// </summary>
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockSymbolRiskDataRspField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金帐户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///资金帐户类型
        public byte FundAccountType;
        ///证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///请求号
        public UInt32 RequestID;
        ///错误码
        public UInt16 ReasonCode;

        public UInt64 Rule36Value;
        public UInt64 Rule39Value;
        public UInt64 Rule44Value;
        public UInt64 Rule45Value;
        public UInt64 Rule50Value;
        public UInt64 Rule51Value;

    }


    // <summary>
    /// 向其他节点划出资金请求
    /// </summary>
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockTrasnBpReqField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金帐户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///资金帐户类型
        public byte FundAccountType;

        ///股东帐户
        public byte ExchangeId;

        ///请求号
        public UInt32 RequestID;
        ///划转资金
        public Int64 Amount;
    }
    /// <summary>
    /// 查询向其它节点划出资金的列表
    /// </summary>
    public struct CShengliStockTrasnBpQueryField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金帐户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
    }
    ///向其他节点划出资金请求回应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockTrasnBpField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金帐户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///资金帐户类型
        public byte FundAccountType;

        public byte ExchangeId;
        ///请求号
        public UInt32 RequestID;
        ///划转资金
        public Int64 Amount;
        ///划转资金结果
        public UInt32 Result;
        ///划转资金结果
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
        public byte[] MsgText;
    };
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockTrasnQueryBpDetailField
    {
        public UInt64 mID;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] mTradingDate;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] mClientID;
        ///资金帐户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] mFundAccount;

        public byte mExchange;
        ///划转资金
        public Int64 mOutAmount;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
        public byte[] mUpDt;

        ///查询响应结果
        public UInt32 Result;
        ///查询结果内容
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
        public byte[] MsgText;
    }

    /// OpStation上报请求
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliOpStationReportReq
    {
        /// 用户key
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 64)]
        public byte[] CustomerKey;
        /// 上报内容
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
        public byte[] OpStationContent;
    }
    ///OpStation上报请求回应 
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliOpStationReportResp
    {
        /// 用户key
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 64)]
        public byte[] CustomerKey;
        /// 上报结果
        public UInt32 Result;
        /// OpStationID
        public UInt32 OpStationID;
        /// UserID
        public UInt32 UserID;
    }

    /// <summary>
    /// 资金账户校验请求回复
    /// </summary>
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliFundAccountPwdCheckResp
    {
        /// 用户ID
        public UInt32 UserID;

        /// 资金帐户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;

        ///Rem错误原因
        public byte RemResultCode;

        ///错误原因
        public short ResultCode;

        ///错误详情 
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
        public byte[] ErrorText;
    }

    ///查询出入金
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQueryCashInOutField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金帐户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
    };

    ///查询出入金的返回
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockRespCashInOutField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金帐户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        /// 账户类型
        public byte FundAccountType;
        /// 出入金类型 
        public byte InOutSource;
        /// 出入金标记
        public byte CashInOutFlag;
        /// 出入金金额 放大1万倍
        public UInt64 ModifyBp;
        /// 更新时间
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 24)]
        public byte[] UpDt;
        //SeqID
        public Int64 SeqID;
        ///查询响应结果
        public UInt32 Result;
        ///查询结果内容
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
        public byte[] MsgText;
    };
    /// 订阅交易所订单单号
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockSubscribeField
    {
        ///用户ID
        public UInt32 UserID;
    }

    /// 订阅交易所订单单号的返回
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockRespSubscribeField
    {
        ///用户ID
        public UInt32 UserID;
        ///错误代码
        public Int32 ErrCode;
        /// 错误原因
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 36)]
        public byte[] ErrText;
    }

    /// 推送交易所订单单号
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockRespMktCltOrdIDField
    {
        ///订阅用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金帐户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        /// 订单类型 1下单委托 2撤单委托
        public byte OrderType;
        /// 客户端编号
        public UInt32 CltOrderToken;
        /// 下单用户的，用户ID，不一定是订阅用户的ID；
        public UInt32 OperUserID;
        ///订单号，新订单填写，撤单不填写
        public UInt64 OrderID;
        ///原始下单用户，撤单时填写
        public UInt32 OrigUserID;
        ///原始客户单号，撤单时填写
        public UInt32 OrigCltOrderToken;
        ///原始订单单号，撤单时填写
        public UInt64 OrigOrderID;
        ///市场客户单号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 11)]
        public byte[] MarketCltOrderID;
    }

    ///同主席划入划出资金请求
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockInOutFundAccountAmountReqField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///请求ID
        public UInt32 RequestID;
        ///交易所ID
        public byte ExchangeID;
        ///划入划出标志
        public char InOutFlag;
        ///金额
        public Int64 Amount;
        ///评定
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
        public byte[] Remark;
        ///交易密码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 64)]
        public byte[] Password;
    };

    ///同主席划入划出资金请求响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockInOutFundAccountAmountField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///请求ID
        public UInt32 RequestID;
        ///划入划出标志
        public char RrzFlag;
        ///金额
        public Int64 Amount;
        ///结果标号
        public UInt32 Result;
        ///消息内容
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
        public byte[] MsgText;
    };

    ///向主席锁定/解锁标的券数量请求
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockFrzUnderlyingSymbolQtyReqField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///请求ID
        public UInt32 RequestID;
        ///交易所ID
        public byte ExchangeID;
        ///市场代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///锁定解锁标志
        public char FrzFlag;
        ///数量
        public UInt32 Quantity;
        ///评定
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
        public byte[] Remark;
	    ///划转类型
	    public byte	InOutSource;
        ///流水号
	    public UInt64 SeqNo;
        ///交易密码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 64)]
        public byte[] Password;
    };

    ///向主席锁定/解锁标的券数量请求响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockFrzUnderlyingSymbolQtyField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///交易所ID
        public byte ExchangeID;
        ///请求ID
        public UInt32 RequestID;
        ///市场编码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///锁定解锁标志
        public char FrzFlag;
        ///数量
        public UInt32 Quantity;
        ///结果标号
        public UInt32 Result;
        ///结果内容
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
        public byte[] MsgText;
    };

    
    /// 连接主席的连接信息
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockConnMasterField
    {
        // 扩展字段版本
        public int 	ExVersion ;
        ///经纪公司代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] 	BrokerID;
        ///用户代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] 	UserID;
        ///密码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 48)]
        public byte[] 	Password;
        ///用户端产品信息
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] 	UserProductInfo;
        ///接口端产品信息
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] 	InterfaceProductInfo;
        ///协议信息
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] 	ProtocolInfo;
        ///AuthCode
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
        public byte[] AuthCode;
        ///AppID
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 48)]
        public byte[] AppId;	        
        ///投资者代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
        public byte[] 	InvestorID;        
        ///投资单元代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 24)]
        public byte[] 	InvestUnitID;
        ///保留字段
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
        public byte[] 	reserve1;
    } ;

    ///查询标的券数请求
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqUnderlyingSymbolQtyField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///交易所
        public byte ExchangeID;
        ///代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///请求ID
        public UInt32 RequestID;
        ///交易密码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 64)]
        public byte[] Password;
    };

    ///查询标的券数请求响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockUnderlyingSymbolQtyField
    {
        /// 用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///请求ID
        public UInt32 RequestID;
        ///交易所
        public byte ExchangeID;
        ///代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///数量
        public UInt32 Quantity;
        ///结果标号
        public UInt32 Result;
        ///结果内容
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
        public byte[] MsgText;
    };

    ///查询主席账户可用资金
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqQryChairmanAcctAvailBpFiled
    {
        /// 用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///货币类型
        public byte CurrencyType;
        ///请求ID
        public UInt32 RequestID;
        ///交易密码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 64)]
        public byte[] Password;
    };

    ///查询主席账户可用资金请求响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQryChairmanAcctAvailBpRespFiled
    {
        /// 用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///货币类型
        public byte CurrencyType;
        ///可用资金
        public Int64 AvaibleBp;
        ///请求ID
        public UInt32 RequestID;
        ///结果标号
        public UInt32 Result;
        ///结果内容
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
        public byte[] MsgText;
    };

    ///通用消息
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockCommonMsgField
    {
        public byte ErrCode;
        public byte DisconnFlag;
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 1)]
        public byte[] Reason;
    };

    ///查询合约保证金信息
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQuerySymbolMarginInfoReqField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
        public byte ExchID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
    };

    ///查询合约保证金回复信息
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQuerySymbolMarginInfoRespField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
        public byte ExchID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///开仓保证金
        public Int64 OpenMarin;
        ///交易所保证金
        public Int64 ExchangeMarin;
        ///风险保证金
        public Int64 RiskMargin;
        ///结果标号
        public byte Result;
    };

    ///查询合约费用信息
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQuerySymbolFeeInfoReqField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
        public byte ExchID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
    };

    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct TShengFeeConfigInfo
    {
        ///按金额收取比例
        public Int64 m_FeeAmount;
        ///每手收取的金额
        public UInt64 m_FeeQty;
        ///费用最小值
        public UInt64 m_FeeMin;
        ///费用最大值 ，只有交易所有效    
        public UInt64 m_FeeMax;
        ///  费用类别
        public byte   m_FeeType;
    };

    ///查询合约费用回复信息
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQuerySymbolFeeInfoRespField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
        public byte ExchID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///合约类型
        public byte SecurityType;
        ///合约子类型
        public byte SecuritySubType;
        ///side
        public byte Side;
        ///配置个数
        public UInt32 ValidCount;
        ///结果标号
        public UInt32 Result;
        ///手续费配置信息
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8, ArraySubType = UnmanagedType.Struct)]
        public TShengFeeConfigInfo[] FeeConfig;
    };


    ///查询签约银行信息
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQuerySigningBankInfoReqField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
        public byte ExchID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///币种
        public byte Currency;
        ///渠道(非必填)
        public byte Channel;
        ///银行业务标识 11银转衍 12衍转银
        public byte CubsbTrdId;
    };

    ///查询签约银行信息回复信息
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQuerySigningBankInfoRespField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
        public byte ExchID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///币种
        public byte Currency;
        ///银行代码
        public UInt32 ExtOrg;
        ///银行名称
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
        public byte[] ExtOrgName;
        ///结果标号
        public UInt32 Result;
        ///消息
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
        public byte[] MsgText;
        ///是否校验资金密码 0不校验1校验
        public byte CheckFundPasswd;
        ///是否校验银行密码 0不校验1校验
        public byte CheckBankPasswd;
    };
    ///查询银行余额
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQueryBankBalanceInfoReqField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
        public byte ExchID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///币种
        public byte Currency;
        ///银行代码
        public UInt32 ExtOrg;
        ///渠道(非必填)
        public byte Channel;
        ///资金密码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 33)]
        public byte[] AcctPwd;
        ///银行密码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 33)]
        public byte[] BankPwd;
    };

    ///查询银行余额回复信息
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQueryBankBalanceInfoRespField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
        public byte ExchID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///币种
        public byte Currency;
        ///银行代码
        public UInt32 ExtOrg;
        ///机构代码
        public UInt32 OrgCode;
        ///资金余额
        public UInt64 FundBln;
        ///结果标号
        public UInt32 Result;
        ///消息
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
        public byte[] MsgText;
    };

    ///一步式入金
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockOneStepTransferInCashReqField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
        public byte ExchID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///币种
        public byte Currency;
        ///银行代码
        public UInt32 ExtOrg;
        ///转账金额
        public Int64 TransAmt;
        ///渠道(非必填)
        public byte Channel;
        ///资金密码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 33)]
        public byte[] AcctPwd;
        ///银行密码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 33)]
        public byte[] BankPwd;
    };

    ///一步式入金返回结果
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockOneStepTransferInCashRespField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
        public byte ExchID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///币种
        public byte Currency;
        ///银行代码
        public UInt32 ExtOrg;
        ///转账金额
        public Int64 TransAmt;
        ///结果标号
        public UInt32 Result;
        ///消息
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
        public byte[] MsgText;
    };

    ///一步式出金
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockOneStepTransferOutCashReqField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
        public byte ExchID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///币种
        public byte Currency;
        ///银行代码
        public UInt32 ExtOrg;
        ///转账金额
        public Int64 TransAmt;
        ///渠道(非必填)
        public byte Channel;
        ///资金密码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 33)]
        public byte[] AcctPwd;
        ///银行密码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 33)]
        public byte[] BankPwd;
    };

    ///一步式出金回复信息
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockOneStepTransferOutCashRespField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
        public byte ExchID;
        ///资金账号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///币种
        public byte Currency;
        ///银行代码
        public UInt32 ExtOrg;
        ///转账金额
        public Int64 TransAmt;
        ///结果标号
        public UInt32 Result;
        ///消息
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
        public byte[] MsgText;
    };

    // 客户端 类型
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockTradeClientTypeReqField
    {
        ///用户ID
        public UInt32 UserID;
        ///< 产品类型
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 32)]
        public byte[] ProcInfo;
    };

    // 查询 支持的委托方式
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQueryDelegateTypeReqField
    {
        ///用户ID
        public UInt32 UserID;
    };

    // 查询 支持的委托方式返回消息
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQueryDeletageTypeRespField
    {
        ///用户ID
        public UInt32 UserID;
        ///< 委托方式
        public byte DelegateType;
        ///< 委托方描述	
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
        public byte[] DelegateDesc;
        ///< 委托类型
        public byte DelegateVer;
    };


    #region 1224资金划拨

    /// <summary>
    /// 查询资金账户划拨策略
    /// </summary>
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQueryFundStrategyCfg
    {
        /// <summary>
        /// 用户ID
        /// </summary>
        public UInt32 UserID;
        /// <summary>
        /// 客户号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        /// <summary>
        /// 资金账号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
    };

    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct TShengliStockQueryFundStrategyCfgItem
    { 
        /// <summary>
        /// 营业部
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] BranchID;
        /// <summary>
        /// 交易所
        /// </summary> 
        public byte ExchangeID;
        /// <summary>
        /// 预警线类型
        /// </summary> 
        public TShengliStockFundTypeEnum CordonType;
        /// <summary>
        /// 预警线
        /// </summary>
        public Int64 CordonValue;
        /// <summary>
        /// 维护线类型
        /// </summary>
        public TShengliStockFundTypeEnum MaintainType;
        /// <summary>
        /// 维持线
        /// </summary>
        public Int64 MaintainValue;
        /// <summary>
        /// 持续时间
        /// </summary>
        public uint DurationTime;
        /// <summary>
        /// 熔断时间
        /// </summary>
        public uint FusingTime;



        /// <summary>
        /// 预警线类型
        /// </summary>
        public TShengliStockFundTypeEnum T_CordonType;
        /// <summary>
        /// 预警线
        /// </summary>
        public Int64 T_CordonValue;
        /// <summary>
        /// 维护线类型
        /// </summary>
        public TShengliStockFundTypeEnum T_MaintainType;
        /// <summary>
        /// 维持线
        /// </summary>
        public Int64 T_MaintainValue;
        /// <summary>
        /// 持续时间
        /// </summary>
        public uint T_DurationTime;
        /// <summary>
        /// 熔断时间
        /// </summary>
        public uint T_FusingTime;
    };


    /// <summary>
    /// 自动划拨返回结果
    /// </summary>
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQueryFundStrategyCfgResp
    {
        /// <summary>
        /// 用户ID
        /// </summary>
        public UInt32 UserID;
        /// <summary>
        /// 客户号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        /// <summary>
        /// 股东账户
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 24)]
        public byte[] TradeAccount;
        /// <summary>
        ///资金账号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;

        public TShengliStockQueryFundStrategyCfgItem TransfStrategyCfgItem1;
        public TShengliStockQueryFundStrategyCfgItem TransfStrategyCfgItem2;
        /// <summary>
        /// 结果标号
        /// </summary>
        public TShengliStockTransfStrategyCfgResultTypeEnum Result;
    };

    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct TShengliStockSetFundStrategyCfgItem
    {
        /// <summary>
        /// 交易所
        /// </summary> 
        public byte ExchangeID;

        /// <summary>
        /// 预警线类型
        /// </summary> 
        public TShengliStockFundTypeEnum CordonType;
        /// <summary>
        /// 预警线
        /// </summary>
        public Int64 CordonValue;
        /// <summary>
        /// 维护线类型
        /// </summary>
        public TShengliStockFundTypeEnum MaintainType;
        /// <summary>
        /// 维持线
        /// </summary>
        public Int64 MaintainValue;
        /// <summary>
        /// 持续时间
        /// </summary>
        public uint DurationTime;
        /// <summary>
        /// 熔断时间
        /// </summary>
        public uint FusingTime;
    }

    /// <summary>
    /// 设置自动划拨策略的值
    /// </summary>
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockSetFundStrategyCfg
    {
        /// <summary>
        /// 用户ID
        /// </summary>
        public UInt32 UserID;
        /// <summary>
        /// 客户号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        /// <summary>
        /// 资金账号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        public TShengliTransfStrategyTypeEnum TransfStrategyType;

        public TShengliStockSetFundStrategyCfgItem ShTransfStrategyCfgItem;
        public TShengliStockSetFundStrategyCfgItem SzTransfStrategyCfgItem;
    };


    /// <summary>
    /// 设置自动划拨策略的值
    /// </summary>
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockSetFundStrategyCfgResp
    {
        /// <summary>
        /// 用户ID
        /// </summary>
        public UInt32 UserID;
        /// <summary>
        /// 客户号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        /// <summary>
        /// 资金账号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;

        public TShengliTransfStrategyTypeEnum TransfStrategyType;

        public TShengliStockSetFundStrategyCfgItem TransfStrategyCfgItem1;
        public TShengliStockSetFundStrategyCfgItem TransfStrategyCfgItem2;
        /// <summary>
        /// 结果标号
        /// </summary>
        public TShengliStockTransfStrategyCfgResultTypeEnum Result;
    };


    /// <summary>
    /// 查询自动划拨策略状态
    /// </summary>
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQueryFundStrategySwitchStatus
    {
        /// <summary>
        /// 用户ID
        /// </summary>
        public UInt32 UserID;
        /// <summary>
        /// 客户号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        /// <summary>
        /// 资金账号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
    };
    /// <summary>
    /// 查询自动划拨策略状态回复
    /// </summary>
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQueryFundStrategySwitchStatusResp
    {
        /// <summary>
        /// 用户ID
        /// </summary>
        public UInt32 UserID;
        /// <summary>
        /// 客户号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        /// <summary>
        /// 资金账号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        /// <summary>
        /// 结果标号
        /// </summary>
        public uint Result;
        /// <summary>
        /// 设置策略开关状态
        /// </summary>
        public TShengliStockTransfStrategySwitchStatusEnum SwitchStatus;
    };
    /// <summary>
    /// 设置自动划拨策略状态
    /// </summary>
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockSetFundStrategySwitchStatus
    {
        /// <summary>
        /// 用户ID
        /// </summary>
        public UInt32 UserID;
        /// <summary>
        /// 客户号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        /// <summary>
        /// 资金账号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        /// <summary>
        /// 设置策略开关状态
        /// </summary>
        public TShengliStockTransfStrategySwitchStatusEnum SwitchStatus;
    };
    /// <summary>
    /// 查询自动划拨策略状态回复
    /// </summary>
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockSetFundStrategySwitchStatusResp
    {
        /// <summary>
        /// 用户ID
        /// </summary>
        public UInt32 UserID;
        /// <summary>
        /// 客户号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        /// <summary>
        /// 资金账号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        /// <summary>
        /// 设置策略开关状态
        /// </summary>
        public TShengliStockTransfStrategySwitchStatusEnum SwitchStatus;
        /// <summary>
        /// 结果标号
        /// </summary>
        public TShengliStockTransfStrategyCfgResultTypeEnum Result;
    };

    /// 仓位划转查询请求
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockQueryTransferPositionField
    {
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金帐户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
    };

    /// 仓位划转查询结果，仓位划转推送
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockRespTransferPositionField
    {
        //SeqID
        public Int64        SeqID;
        ///用户ID
        public UInt32       UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[]       ClientID;
        ///资金帐户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[]       FundAccount;
        /// 账户类型
        public byte         FundAccountType;
        /// 出入金类型 
        public byte         InOutSource;
        /// 出入金标记
        public byte         CashInOutFlag;
        ///交易所
        public byte         ExchID;
    	///代码  填空
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[]       SecurityCode;
        /// 股东账户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[]		TradeAccount;		
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
        public byte[]		ReportPbu;        
        // 今仓，昨仓标记
        public byte 		OvnOrToday ;
        // 数量
        public UInt32       DetailQty;
        /// 更新时间
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 24)]
        public byte[]       UpDt;
        /// 状态
        public byte         State;
        /// 备注
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 256)]
        public byte[]       Remark;
    };
    #endregion
    #region 快照回滚

    /// <summary>
    /// 查询委托请求
    /// </summary>
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqQueryEntrustField
    {
        /// <summary>
        /// 请求序号
        /// </summary>
        public UInt32 RequestID;
        /// <summary>
        /// 用户ID
        /// </summary>
        public UInt32 UserID;
        /// <summary>
        /// 客户号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        /// <summary>
        /// 资金账号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        /// <summary>
        /// 查询源
        /// </summary>
        public byte QryFlag;
        /// <summary>
        /// 委托编码ID
        /// </summary>
        public UInt64 OrderID;
        /// <summary>
        /// 客户端编号
        /// </summary>
        public UInt32 ClOrdToken;
        /// <summary>
        /// 市场
        /// </summary>
        public byte ExchID;
        /// <summary>
        /// 证券代码
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        /// <summary>
        /// 委托方向
        /// </summary>
        public byte Side;
        /// <summary>
        /// 订单状态数量
        /// </summary>
        public UInt32 StateNum;
        /// <summary>
        /// 订单状态
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] OrderState;
        /// <summary>
        /// 起始序号
        /// </summary>
        public UInt64 StartIdx;
        /// <summary>
        /// 本次查询最大返回数量
        /// </summary>
        public UInt32 RequestNum;
    };

    /// 查询委托响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockRespQueryEntrustField
    {
        /// <summary>
        /// 请求序号
        /// </summary>
        public UInt32 RequestID;
        /// <summary>
        /// 用户ID
        /// </summary>
        public UInt32 UserID;
        /// <summary>
        /// 当前序号
        /// </summary>
        public UInt32 CurIdx;
        /// <summary>
        /// 当前记录在服务器中游标
        /// </summary>
        public UInt64 CurCursorMark;
        /// <summary>
        /// 委托用户ID
        /// </summary>
        public UInt32 Entrust_UserID;
        /// <summary>
        /// 客户号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        /// <summary>
        /// 资金账号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        /// <summary>
        /// 客户端编号
        /// </summary>
        public uint ClOrdToken;
        /// <summary>
        /// REM系统单cluster唯一编号，撤单标识原始订单号OrigOrderID
        /// </summary>
        public UInt64 OrderID;
        /// <summary>
        /// 交易所单号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        public byte[] ExchangeOrderID;
        /// <summary>
        /// 面向交易所的ordertoken
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] ExchangeOrderToken;
        /// <summary>
        /// 市场
        /// </summary>
        public byte ExchID;
        /// <summary>
        /// 代码
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        /// <summary>
        /// 证券类型
        /// </summary>
        public byte SecurityType;
        /// <summary>
        /// 证券子类型
        /// </summary>
        public byte SecuritySubType;
        /// <summary>
        /// 方向
        /// </summary>
        public byte Side;
        /// <summary>
        /// 订单类型
        /// </summary>
        public byte PriceType;
        /// <summary>
        /// 数量
        /// </summary>
        public UInt32 OrderQty;
        /// <summary>
        /// 最小成交数量
        /// </summary>
        public UInt32 MinQty;
        /// <summary>
        /// 市价单时有效,最多成交价位数,0表示不限
        /// </summary>
        public UInt16 MaxPriceLevels;
        /// <summary>
        /// 单子的存活时间
        /// </summary>
        public byte TIF;
        /// <summary>
        /// 会话ID
        /// </summary>
        public byte SessionID;
        /// <summary>
        /// 价格
        /// </summary>
        public UInt64 Price;
        /// <summary>
        /// 止损价
        /// </summary>
        public UInt64 StopPrice;
        /// <summary>
        /// 交易类型
        /// </summary>
        public byte CashMarginFlag;
        /// <summary>
        /// 会话模式
        /// </summary>
        public byte SessionSelMode;
        /// <summary>
        /// 交易所接受标志
        /// </summary>
        public byte ExchangeAcceptFlag;
        /// <summary>
        /// 总成交量
        /// </summary>
        public UInt32 FilledQty;
        /// <summary>
        /// 订单状态
        /// </summary>
        public byte OrderState;
        /// <summary>
        /// 被动单/外部单标志
        /// </summary>
        public byte PassiveOrderFlag;
        /// <summary>
        /// 只要不为0，就是强平的原因
        /// </summary>
        public byte ForceCoverFlag;
        /// <summary>
        /// 收到订单的时间，单位为纳秒
        /// </summary>
        public UInt64 RecvTimestamp;
        /// <summary>
        /// REM内核(硬件)处理完毕接受的时间戳，和开始发往交易所的时间戳相同&REM接受撤单请求并发往交易所的时间戳
        /// </summary>
        public UInt64 AcceptTimestamp;
        /// <summary>
        /// REM系统收到交易所接受的时间戳
        /// </summary>
        public UInt64 ExchangeAcceptTimestamp;
        /// <summary>
        /// 交易所提供的撤单时间戳，交易所接受时，交易所给出的时间戳
        /// </summary>
        public UInt64 ExchangeTransTimestamp;
        /// <summary>
        /// 交易所营业部
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] BranchID;
        /// <summary>
        /// 下单时候的UserInfo，UserInfo1为opstationID，UserInfo2为用户的自定义数据
        /// </summary>
        public UInt32 UserInfo1;

        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 4)]
        public byte[] UserInfo2;
        /// <summary>
        /// 委托方式
        /// </summary>
        public byte DelegateType;
        public byte CxlReqStatus;
        ///订单特有
        ///--期权扩展字段--///
        ///期权合约过期日
        public int ExpireDate;
        /// <summary>
        /// 交易所
        /// </summary>
        public byte UnderlyingExchID;
        /// <summary>
        /// 期权标的证券代码
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] UnderlyingSecurityCode;
        /// <summary>
        /// 期权合约账户代码
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 7)]
        public byte[] ContractAccountCode;
        /// <summary>
        /// 期权合约代码
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 21)]
        public byte[] ContractID;
        /// <summary>
        /// 期权看涨看跌
        /// </summary> 
        public char CallOrPut;
        /// <summary>
        /// 期权行权价
        /// </summary>
        public Int64 StrikePrice;
        ///报价单特有
        ///申报类型
        public byte QuoteReqType;
        /// <summary>
        /// 卖边价格	
        /// </summary>
        public Int64 AskPrice;
        /// <summary>
        /// 卖边数量	
        /// </summary>
        public UInt32 AskQty;
        /// <summary>
        /// 卖边方向	
        /// </summary>
        public char AskSide;
        /// <summary>
        /// 卖边订单状态	
        /// </summary>
        public byte AskOrderState;
        /// <summary>
        /// 卖边总成交量
        /// </summary>
        public UInt32 AskFilledQty;
        /// <summary>
        /// 买边价格	
        /// </summary>
        public Int64 BidPrice;
        /// <summary>
        /// 买边数量	
        /// </summary>
        public UInt32 BidQty;
        /// <summary>
        /// 买边方向	
        /// </summary>
        public char BidSide;
        /// <summary>
        /// 买边订单状态	
        /// </summary>
        public byte BidOrderState;
        /// <summary>
        /// 买边总成交量
        /// </summary>
        public UInt32 BidFilledQty;
        /// <summary>
        /// UserInfo
        /// </summary>
        public UInt64 UserInfo3;
        /// <summary>
        /// ExchangeUserinfo
        /// </summary>
        public UInt64 ExchangeUserinfo;

        /// <summary>
        /// 多腿信息
        /// </summary>        
        public CShengliStockExternCombOrder Extern;
        public CShengliStockCombLegField Leg1;
        public CShengliStockCombLegField Leg2;
        public CShengliStockCombLegField Leg3;
        public CShengliStockCombLegField Leg4;
    };

    /// 查询委托成交请求
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockReqQueryEntrustExecutionField
    {
        /// <summary>
        /// 请求序号
        /// </summary>
        public UInt32 RequestID;
        /// <summary>
        /// 用户ID
        /// </summary>
        public UInt32 UserID;
        /// <summary>
        /// 客户号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        /// <summary>
        /// 资金账号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        /// <summary>
        /// 查询源
        /// </summary>
        public byte QryFlag;
        /// <summary>
        /// REM系统cluster唯一成交编号	
        /// </summary>
        public UInt32 ExecID;
        /// <summary>
        /// 委托编码ID
        /// </summary>
        public UInt64 OrderID;
        /// <summary>
        /// 客户端编号
        /// </summary>
        public UInt32 ClOrdToken;
        /// <summary>
        /// 市场
        /// </summary>
        public byte ExchID;
        /// <summary>
        /// 证券代码
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        /// <summary>
        /// 委托方向
        /// </summary>
        public byte Side;
        /// <summary>
        /// 起始序号
        /// </summary>
        public UInt64 StartIdx;
        /// <summary>
        /// 本次查询最大返回数量
        /// </summary>
        public UInt32 RequestNum;
    };

    /// 查询委托成交响应
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockRespQueryEntrustExecutionField
    {
        /// <summary>
        /// 请求序号
        /// </summary>
        public UInt32 RequestID;
        /// <summary>
        /// 用户ID
        /// </summary>
        public UInt32 UserID;
        /// <summary>
        /// 当前序号
        /// </summary>
        public UInt32 CurIdx;
        /// <summary>
        /// 当前记录在服务器中游标
        /// </summary>
        public UInt64 CurCursorMark;
        /// <summary>
        /// 委托用户ID
        /// </summary>
        public UInt32 Entrust_UserID;
        /// <summary>
        /// 客户号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        /// <summary>
        /// 资金账号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        /// <summary>
        /// 客户端编号
        /// </summary>
        public uint ClOrdToken;
        /// <summary>
        /// REM系统单cluster唯一编号，撤单标识原始订单号OrigOrderID
        /// </summary>
        public UInt64 OrderID;
        /// <summary>
        /// 交易所单号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        public byte[] ExchangeOrderID;
        /// <summary>
        /// 面向交易所的ordertoken
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] ExchangeOrderToken;
        /// <summary>
        /// 市场
        /// </summary>
        public byte ExchID;
        /// <summary>
        /// 代码
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        /// <summary>
        /// 证券类型
        /// </summary>
        public byte SecurityType;
        /// <summary>
        /// 证券子类型
        /// </summary>
        public byte SecuritySubType;
        /// <summary>
        /// 方向
        /// </summary>
        public byte Side;
        /// <summary>
        /// 被动单/外部单标志
        /// </summary>
        public byte PassiveOrderFlag;
        /// <summary>
        /// 本次成交价
        /// </summary>
        public UInt64 LastPrice;
        /// <summary>
        /// 本次成交量
        /// </summary>        
        public UInt32 LastQty;
        /// <summary>
        /// 剩余数量
        /// </summary>        
        public UInt32 LeavesQty;
        /// <summary>
        /// 开平标记
        /// </summary>        
        public byte PositionSide;
        ///买卖标记	
        public byte AskOrBid;
        /// <summary>
        /// 订单状态
        /// </summary>        
        public byte OrderState;
        /// <summary>
        /// REM系统cluster唯一成交编号
        /// </summary>        
        public UInt32 ExecID;
        /// <summary>
        /// 交易所成交ID	
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 20)]
        public byte[] ExchangeExecID;
        /// <summary>
        /// 交易所提供的撤单时间戳，交易所接受时，交易所给出的时间戳
        /// </summary>
        public UInt64 ExchangeTransTimestamp;
        /// <summary>
        /// UserInfo
        /// </summary>
        public UInt64 UserInfo3;
        /// <summary>
        /// ExchangeUserinfo
        /// </summary>
        public UInt64 ExchangeUserinfo;
    };

    #endregion

    #region 1178 查询通道列表
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliStockChannelField
    {
        /// <summary>
        /// 请求序号
        /// </summary>
        public UInt32 RequestID;
        /// <summary>
        /// 用户ID
        /// </summary>
        public UInt32 UserID;
        /// <summary>
        /// 客户号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        /// <summary>
        /// 资金账号
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        /// <summary>
        /// 会话ID
        /// </summary>
        public byte SessionId;
        /// <summary>
        /// 交易所
        /// </summary>
        public byte ExchID;

        /// <summary>
        /// 平台类型
        /// </summary>
        public uint PlatformType;
        /// <summary>
        /// 申报类型
        /// </summary>
        public uint OfferType;
        /// <summary>
        ///  平台状态
        /// </summary>
        public byte PlatformState;
        /// <summary>
        /// 业务pbu个数
        /// </summary>
        public uint BussPbuCount;
        /// <summary>
        /// 业务pbu
        /// </summary>
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
        public byte[] BussPbu;
    }
    #endregion
    #endregion

}
