﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

namespace SlEesTrade
{

    ///担保品列表查询请求 
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliCreditGuarantyListQueryField
    {
        ///用户ID
		public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
		public byte ExchangeID;
        ///证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] Symbol;
    }

    ///可融资标的头寸查询
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliCreditFinanceCashQueryField
    {
        ///用户ID
		public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
		public byte ExchangeID;
        ///证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] Symbol;
        ///业务类别
        public Int32 BusinessType;
    };

    ///可融券标的头寸查询
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliCreditSellshortCashQueryField
    {
        ///用户ID
		public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
		public byte ExchangeID;
        ///证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] Symbol;
        ///业务类别
        public Int32 BusinessType;
    };

    ///合约展期查询
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliCreditContractExtensionQueryField
    {
        ///用户ID
		public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///合同编号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 33)]
        public byte[] ContractNumber;
        ///交易所
		public byte ExchangeID;
        ///证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] Symbol;
        ///买卖类别
        public byte Side;
        public UInt64 begin_time;
        public UInt64 end_time;
    };

    ///账户资金查询
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliCreditAccountQueryField
    {
        ///用户ID
		public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///业务类别
        public Int32 BusinessType;
    };

    ///担保品持仓查询
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliCreditGuarnatyPositionQueryField
    {
        ///用户ID
		public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
		public byte ExchangeID;
        ///证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] Symbol;
    };

    ///融资负债查询
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliCreditFinancePositionQueryField
    {
        ///用户ID
		public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
		public byte ExchangeID;
        ///证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] Symbol;
        /// 业务类别
        public int BussType;
    };

    ///融券负债查询
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliCreditSellshortPositionQueryField
    {
        ///用户ID
		public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
		public byte ExchangeID;
        ///证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] Symbol;
        /// 业务类别
        public int BussType;
    };

    ///融资负债明细查询
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliCreditFinanceDebtQueryField
    {
        ///用户ID
		public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
		public byte ExchangeID;
        ///证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] Symbol;
        ///合同编号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 33)]
        public byte[] ContractNumber;
        /// 业务类别 
        public int BussType;
        /// 页码
        public int PageNum;
        /// 每页数量
        public int PageSize;
    };

    ///融券负债明细查询
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliCreditSellshortDebtQueryField
    {
        ///用户ID
		public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///交易所
		public byte ExchangeID;
        ///证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] Symbol;
        ///合同编号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 33)]
        public byte[] ContractNumber;
        /// 业务类别 
        public int BussType;
        /// 页码
        public int PageNum;
        /// 每页数量
        public int PageSize;
    };



    /// 担保品列表查询返回
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliCreditGuarantyListField
    {
        /// 交易市场
        public byte ExchangeID;
        /// 证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] Symbol;
        /// 证券名称
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 88)]
        public byte[] SecurityName;
        ///证券类型	
        public byte SecurityType;
        ///证券子类型
        public byte SecuritySubType;

        /// 折算率
        public double ConversionRate;
        /// 公允价格
        public double Price;
        ///公允标记
        public byte FairFlag;
        /// 有效截止日期
        public Int32 EndDate;
    };

    /// 可融资标的头寸查询 返回
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliCreditFinanceCashField
    {
        public UInt32 RequestID;
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        /// 交易市场
        public byte ExchangeID;
        /// 证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] Symbol;
        /// 证券名称
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 88)]
        public byte[] SecurityName;
        ///证券类型	
        public byte SecurityType;
        ///证券子类型
        public byte SecuritySubType;
        ///业务类别
        public Int32 BusinessType;
        ///融资保证金比例
        public double MarginRatio;
        /// 有效截止日期
        public Int32 EndDate;
    };

    /// 可融券标的头寸查询 返回
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliCreditSellshortCashField
    {
        public UInt32 RequestID;
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        /// 交易市场
        public byte ExchangeID;
        /// 证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] Symbol;
        /// 证券名称
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 88)]
        public byte[] SecurityName;
        ///证券类型	
        public byte SecurityType;
        ///证券子类型
        public byte SecuritySubType;
        ///业务类别
        public Int32 BusinessType;
        ///融券保证金比例
        public double MarginRatio;
        ///可融数量
        public UInt32 AvailQty;
        /// 有效截止日期
        public Int32 EndDate;
    };

    /// 合约展期查询返回 （放后面）
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliCreditContractExtensionField
    {
        public UInt32 RequestID;
        ///用户ID
        public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///日期
        public Int32 Date;
        ///合同编号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 33)]
        public byte[] ContractNumber;
        ///股东账户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] TradeAccount;
        ///货币单位
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 4)]
        public byte[] MonetaryUnit;
        /// 交易市场
        public byte ExchangeID;
        /// 证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] Symbol;
        /// 证券名称
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 88)]
        public byte[] SecurityName;
        ///委托价格
        public double EntrustPrice;
        ///委托数量
        public UInt32 EntrustQty;
        ///成交数量
        public UInt32 ExecQty;
        ///成交均价
        public double ExecPrice;
        ///成交金额
        public double ExecAmount;
        ///买卖类别
        public byte Side;
        ///展期状态
        public Int32 ExtensionStatus;
        ///保证金比例
        public double MarginRatio;
        ///期初合约数量
        public UInt32 BeginQty;
        ///期初合约金额
        public double BeginAmount;
        ///已还合约数量
        public UInt32 RepayQty;
        ///已还合约金额
        public double RepayAmount;
        ///负债利息
        public double DebtInterest;
        ///已还利息
        public double RepayInterest;
        ///开始日期
        public Int32 BeginDate;
        ///结束日期
        public Int32 EndDate;
    };

    /// 账户资金查询返回
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliCreditAccountField
    {
        ///请求ID
        public UInt32 RequestID;
        ///用户ID
		public UInt32 UserID;
        ///交易所
        public byte ExchangeID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///股东账户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] TradeAccount;
        ///业务类别
        public int BussType;
        ///融资额度
        public double FinanceLimit;
        ///融券额度
        public double SellshortLimit;
        ///融资总负债
        public double FinanceDebt;
        ///融券总负债
        public double SellshortDebt;
        ///维持担保比例
        public double MarginGuarantyRatio;
        ///可用保证金
        public double AvailMargin;
        ///可用金额
        public double AvailAmount;
        ///融资市值
        public double FinanceMktValue;
        ///融券市值
        public double SellshortMktValue;
        ///担保品市值
        public double GuarantyMktValue;
        ///信用账户总资产
        public double TotalAssets;
        ///担保品冻结金额
        public double GuarantyFrozenAmount;
        ///融资冻结负债
        public double FinanceFrozenAmount;
        ///融券冻结负债
        public double SellshortFrozenAmount;

    };
    /// 担保品持仓查询返回 
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliCreditGuarantyPositionField
    {
        ///请求ID
        public UInt32 RequestID;
        ///用户ID
		public UInt32 UserID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金帐户类型
        public byte AccountType;
        ///资金账户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///交易所
        public byte ExchID;
        ///证券类型	
        public byte SecurityType;
        ///证券子类型
        public byte SecuritySubType;
        ///证券代码	
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] SecurityCode;
        ///初始隔夜仓数量	
        public UInt32 InitOvnPosQty;
        ///剩余昨仓, 所持量, 不考虑备兑锁定, 平仓锁定等	
        public UInt32 CurOvnQty;
        ///总仓位，包括今仓, 所持量, 不考虑备兑锁定, 平仓锁定等	
        public UInt32 CurQty;
        ///总可平仓数量, 考虑所有锁定数量	
        public UInt32 AvailQty;
        ///总平仓挂单量
        public UInt32 ClosePosPendingQty;
        /// 持仓均价
        public double AvgPx;
    };
    /// 融资负债查询返回
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliCreditFinancePositionField
    {
        public UInt32 RequestID;
        ///用户ID
        public UInt32 UserID;
        ///交易所
        public byte ExchangeID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;


        ///股东账户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] TradeAccount;
        /// 证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] Symbol;
        /// 证券名称
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 88)]
        public byte[] SecurityName;
        ///负债类别
        public Int32 DebtType;
        ///业务类别
        public Int32 BussType;
        ///期初负债金额
        public double BeginDebtAmount;
        ///期初负债数量
        public UInt32 BeginDebtQty;
        ///当前负债金额
        public double CurrentDebtAmount;
        ///当前负债数量
        public UInt32 CurrentDebtQty;
        ///当前负债市值
        public double CurrentDebtMktValue;
        ///融资盈亏
        public double FinancePL;
    };
    /// 融券负债查询返回 
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliCreditSellshortPositionField
    {
        public UInt32 RequestID;
        ///用户ID
        public UInt32 UserID;
        ///交易所
        public byte ExchangeID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///股东账户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] TradeAccount;
        /// 证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] Symbol;
        /// 证券名称
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 88)]
        public byte[] SecurityName;
        ///负债类别
        public Int32 DebtType;
        ///业务类别
        public Int32 BussType;
        ///期初负债金额
        public double BeginDebtAmount;
        ///期初负债数量
        public UInt32 BeginDebtQty;
        ///当前负债金额
        public double CurrentDebtAmount;
        ///当前负债数量
        public UInt32 CurrentDebtQty;
        ///当前负债市值
        public double CurrentDebtMktValue;
        ///融券盈亏
        public double SellshortPL;
    };
    /// 融资负债明细返回
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliCreditFinanceDebtField
    {
        public UInt32 RequestID;
        ///用户ID
        public UInt32 UserID;
        ///交易所
        public byte ExchangeID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///股东账户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] TradeAccount;
        /// 证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] Symbol;
        /// 证券名称
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 88)]
        public byte[] SecurityName;
        ///负债金额
        public double DebtAmount;
        ///合同编号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 33)]
        public byte[] ContractNumber;
        ///开仓日期
        public Int32 OpenDate;

        ///负债类别
        public Int32 DebtType;
        ///业务类别
        public int BussType;
        ///开仓金额
        public double OpenAmount;
        ///开仓数量
        public UInt32 OpenQty;
        ///当前负债金额
        public double CurrentDebtAmount;
        ///当前负债数量
        public UInt32 CurrentDebtQty;
        ///已还金额
        public double RepayAmount;
        ///归还截止日期
        public Int32 EndDate;
        ///融资盈利
        public double FinancePL;
        /// 数量
        public int TotalNum;
    };
    /// 融券负债明细返回
    [StructLayout(LayoutKind.Sequential, Pack = 1)]
    public struct CShengliCreditSellshortDebtField
    {
        public UInt32 RequestID;
        ///用户ID
        public UInt32 UserID;
        ///交易所
        public byte ExchangeID;
        ///客户号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] ClientID;
        ///资金账户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 17)]
        public byte[] FundAccount;
        ///股东账户
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
        public byte[] TradeAccount;
        /// 证券代码
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 9)]
        public byte[] Symbol;
        /// 证券名称
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 88)]
        public byte[] SecurityName;
        ///负债金额
        public double DebtAmount;
        ///合同编号
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 33)]
        public byte[] ContractNumber;
        ///开仓日期
        public Int32 OpenDate;
        ///负债类别
        public Int32 DebtType;
        ///业务类别
        public int BussType;
        ///开仓金额
        public double OpenAmount;
        ///开仓数量
        public UInt32 OpenQty;
        ///当前负债金额
        public double CurrentDebtAmount;
        ///当前负债数量
        public UInt32 CurrentDebtQty;
        ///已还数量
        public UInt32 RepayQty;
        ///归还截止日期
        public Int32 EndDate;
        ///融券盈利
        public double SellshortPL;
        ///数量
        public int TotalNum;
    };


}
