﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace SlEesTrade
{
   public class Test
    {
       public string clientID;
        public static byte[] ToBytes(string s, int length)
        {
            if (s == null)
            {
                return new byte[length];
            }
            byte[] sArrs = new byte[length];

            for (int i = 0; i < length; ++i )
            {
                if (i >= s.Length)
                {
                    sArrs[i] = 0;
                }
                else
                {
                    sArrs[i] = Convert.ToByte(s[i]);
                }
            }
            return sArrs;
        }
        static void Main(string[] args)
        {
            Test test = new Test();
            SlEesTradeDll slEesTrade = new SlEesTradeDll("", "Instance");
            slEesTrade.tradeClientConnectionEvent += test.ConnectionEvent;
            slEesTrade.tradeClientUserLogonEvent += test.UerLogonEvent;
            slEesTrade.tradeClientQueryClientIdEvent += test.QueryClientIdEvent;
            slEesTrade.tradeClientQueryAccountEvent += test.QueryAccountEvent;
            slEesTrade.tradeClientQueryNormalPositionEvent += test.QueryNormalPositionEvent;
            slEesTrade.tradeClientQueryOptionPositionEvent += test.QueryOptionPositionEvent;
            slEesTrade.tradeClientQueryClientBpStatusEvent += test.QueryClientBpStatusEvent;
            slEesTrade.outFundAccountAmountNodeEvent += SlEesTrade_outFundAccountAmountNodeEvent;
            string str;
            int start;
            
            Console.WriteLine("1.ConnServer ");
            Console.WriteLine("2.UserLogon ");
            Console.WriteLine("3.QueryClientIdList ");
            Console.WriteLine("4.QueryAccountList ");
            Console.WriteLine("5.QueryNormalPosition ");
            Console.WriteLine("6.QueryOptionPosition ");
            Console.WriteLine("7.QueryClientBpStatus "); 
            Console.WriteLine("8.QueryOptionDetail ");
            slEesTrade.ConnServer("10.1.59.23", 20000, "10.1.59.22", 20001);

            while (true)
            {
                Thread.Sleep(300);
                Console.Write("请输入:");
                str = Console.ReadLine();
                if (str.Equals(""))
                {
                    str = "0";
                }
                start = int.Parse(str);
                switch (start)
                {
                    case 1:
                        {
                            test.ConnServer(slEesTrade);
                            break;
                        }
                    case 2:
                        {
                            test.UserLogon(slEesTrade);
                            break;
                        }
                    case 3:
                        {
                            test.QueryClientIdList(slEesTrade);
                            break;
                        }
                    case 4:
                        {
                            test.QueryAccountList(slEesTrade);
                            break;
                        }
                    case 5:
                        {
                            test.QueryPosition(slEesTrade);
                            break;
                        }
                    case 6:
                        {
                            test.QueryPosition(slEesTrade);
                            break;
                        }
                    case 7:
                        {
                            test.QueryClientBpStatus(slEesTrade);
                            break;
                        }case 8:
                        {
                            test.QueryOptionDetailEvent(slEesTrade);
                            break;
                        }
                }
            }

           
        }

        private static void SlEesTrade_outFundAccountAmountNodeEvent(SlEesTradeDll tradeDll, ref CShengliStockTrasnBpField symRsp)
        {
            throw new NotImplementedException();
        }

        private void QueryNormalPositionEvent(SlEesTradeDll tradeDll, ref CShengliStockNormalPositionField pos, int nRequestID, byte bIsLast)
        {
            Console.WriteLine("资金账户:" + Encoding.ASCII.GetString(pos.FundAccount) + " 证券代码:" + Encoding.ASCII.GetString(pos.SecurityCode) +
                " 证券类型:"+pos.SecurityType + "  总仓位:" + pos.CurQty + " 持仓均价:" + pos.AvgPx + " 交易所:"+pos.ExchID +
                 " 备兑锁定:" + pos.CoveredLockedQty + "  证券类型:" + pos.SecuritySubType);
        }

        private void ConnectionEvent(SlEesTradeDll tradeDll, int errNo, string errStr)
        {
            Console.WriteLine("连接结果:"+errNo);
            tradeDll.UserLogon(1, "82002030", "1", "", "", "123", "00-00-00-00-00-00-00-E0", 0);
        }

        private void UerLogonEvent(SlEesTradeDll tradeDll, ref CShengliStockRespUserLoginField logon, int nRequestID)
        {
            Console.WriteLine("登录名:"+ Encoding.ASCII.GetString(logon.LogonID)+"  用户ID:"+logon.UserID + "  登录结果:"+logon.Result);

            while(true)
            {
                tradeDll.QueryClientIdList();
            }

        }

        private void QueryOptionPositionEvent(SlEesTradeDll tradeDll, ref CShengliStockOptionPositionField pos, int nRequestID, byte bIsLast)
        {
            
            Console.WriteLine("资金账户:" + Encoding.ASCII.GetString(pos.FundAccount) + " 证券代码:" + Encoding.ASCII.GetString(pos.SecurityCode) 
                +"交易所:"+pos.ExchID + "  证券类型:" + pos.SecurityType + " 仓位方向:" + pos.PositionDirection + " 初始昨仓:"+ pos.InitOvnQty 
                + "  当前仓位:" + pos.CurQty +"  当前可平仓位:"+pos.AvailQty+"  持仓均价:"+pos.AvgPx);
        }

        private void QueryClientBpStatusEvent(SlEesTradeDll tradeDll, ref CShengliStockBpStatusField bpInfo, int nRequestID, byte bIsLast)
        {
            Console.WriteLine("资金账户:"+ Encoding.ASCII.GetString(bpInfo.FundAccount) + "  初始可用资金:" + bpInfo.InitialBp+ "  当前可用资金:"
                + bpInfo.AvailableBp+"  是否为最后一个:"+ bIsLast);
        }

       

        private void QueryAccountEvent(SlEesTradeDll tradeDll, ref CShengliStockAccountListField accountInfo, int nRequestID, byte bIsLast)
        {
            Console.WriteLine("用户ID:" + accountInfo.UserID+ "  资金帐户:" + Encoding.ASCII.GetString(accountInfo.FundAccount)+ "  资金帐户类型:" + accountInfo.FundAccountType.ToString());

        }

        private void QueryClientIdEvent(SlEesTradeDll tradeDll, ref CShengliStockClientIDListField clientInfo, int nRequestID, byte bIsLast)
        {
            clientID = Encoding.ASCII.GetString(clientInfo.ClientID);
            Console.WriteLine("客户号:" + Encoding.ASCII.GetString(clientInfo.ClientID)+"是否最后一个:"+bIsLast);
        }

        public void ConnServer(SlEesTradeDll slEesTrade)
        {
            int ret;
            string tradeAddr;
            int tradePort;
            string queryAddr;
            int queryPort;
            Console.Write("tradeAddr:");
            tradeAddr = Console.ReadLine();
            Console.Write("tradePort:");
            tradePort = int.Parse(Console.ReadLine());
            Console.Write("queryAddr:");
            queryAddr = Console.ReadLine();
            Console.Write("queryPort:");
            queryPort = int.Parse(Console.ReadLine());
            ret = slEesTrade.ConnServer(tradeAddr, tradePort, queryAddr, queryPort);
           // ret = slEesTrade.ConnServer("10.1.51.235", 20000, "10.1.51.211", 20001);
            Console.WriteLine(ret);
        }
        public void UserLogon(SlEesTradeDll slEesTrade)
        {
            int ret;
            //int version;
            string userId;
            string userPwd;
            //string prodInfo;
            //string macAddr;
            //Console.Write("version:");
            //version = int.Parse(Console.ReadLine());          
            Console.Write("userId:");
            userId = Console.ReadLine();
            Console.Write("userPwd:");
            userPwd = Console.ReadLine();
            //Console.Write("prodInfo:");
            //prodInfo = Console.ReadLine();
            //Console.Write("macAddr:");
            //macAddr = Console.ReadLine();
            ret = slEesTrade.UserLogon(1, userId, userPwd, "123", "", "", "00-00-00-00-00-00-00-E0", 0);
            Console.WriteLine(ret);
        }
        public void QueryClientIdList(SlEesTradeDll slEesTrade)
        {
            slEesTrade.QueryClientIdList();
        }
        public void QueryAccountList(SlEesTradeDll slEesTrade)
        {
            string clientId;
            Console.Write("clientId:");
            clientId = Console.ReadLine();
            slEesTrade.QueryAccountList(clientId);
        }
        public void QueryPosition(SlEesTradeDll slEesTrade)
        {
            string clientId;
            Console.Write("clientId:");
            clientId = Console.ReadLine();
            slEesTrade.QueryOptionPosition(clientId);
        }
        
        public void QueryClientBpStatus(SlEesTradeDll slEesTrade)
        {
            string clientId;
            Console.Write("clientId:");
            clientId = Console.ReadLine();
            slEesTrade.QueryClientBpStatus(clientId);
        }


        public void QueryOptionDetailEvent(SlEesTradeDll slEesTrade)
        {
            slEesTrade.QueryOptionDetail("",0);
        }

    }
}
