/*!
* \file  ShengliStockUserApiCreditStruct.h
* \brief 交易和查询客户端信用账户融资融券的头文件
*
* 此文件描述了使用交易和查询客户端的公共结构体类型
*
* \author  SHENGLI
* \version 1.0
* \date    2014-04-18
*/

#ifndef SECURITY_CREDITSTRUCT_H
#define SECURITY_CREDITSTRUCT_H

#if _MSC_VER > 1000
#pragma once
#endif 

#include "ShengliStockUserApiDataType.h"

#pragma pack(push, 1)

/// 两融通用查询请求
struct CShengliCreditCommonQueryField
{
	///用户ID
	TShengliStockUserIDType    UserID;
	///客户号
	TShengliStockClientIdType  ClientID;
};

///担保品列表查询
struct CShengliCreditGuarantyListQueryField
{
	///用户ID
	TShengliStockUserIDType			UserID;
	///客户号
	TShengliStockClientIdType		ClientID;
	/// 交易市场
	TShengliStockExchangeIDType		ExchangeID;
	/// 证券代码
	TShengliStockSymbolType			Symbol;
};

///可融资标的头寸查询
struct CShengliCreditFinanceCashQueryField
{
	///用户ID
	TShengliStockUserIDType			UserID;
	///客户号
	TShengliStockClientIdType		ClientID;
	/// 交易市场
	TShengliStockExchangeIDType		ExchangeID;
	/// 证券代码
	TShengliStockSymbolType			Symbol;
	///业务类别
	TShengliStockBusinessType		BusinessType;
};

///可融券标的头寸查询
struct CShengliCreditSellshortCashQueryField
{
	///用户ID
	TShengliStockUserIDType			UserID;
	///客户号
	TShengliStockClientIdType		ClientID;
	/// 交易市场
	TShengliStockExchangeIDType		ExchangeID;
	/// 证券代码
	TShengliStockSymbolType			Symbol;
	///业务类别
	TShengliStockBusinessType		BusinessType;
};

///合约展期查询
struct CShengliCreditContractExtensionQueryField
{
	///用户ID
	TShengliStockUserIDType			UserID;
	///客户号
	TShengliStockClientIdType		ClientID;
	///合同编号
	TShengliContractNumber			ContractNumber;
	/// 交易市场
	TShengliStockExchangeIDType		ExchangeID;
	/// 证券代码
	TShengliStockSymbolType			Symbol;
	///买卖类别
	TShengliStockSideType			Side;
	TShengliStockTimeStampType		begin_time;
	TShengliStockTimeStampType		end_time;
};

///账户资金查询
struct CShengliCreditAccountQueryField
{
	///用户ID
	TShengliStockUserIDType			UserID;
	///客户号
	TShengliStockClientIdType		ClientID;
	///业务类别
	TShengliStockBusinessType		BusinessType;
};

///担保品持仓查询
struct CShengliCreditGuarnatyPositionQueryField
{
	///用户ID
	TShengliStockUserIDType			UserID;
	///客户号
	TShengliStockClientIdType		ClientID;
	/// 交易市场
	TShengliStockExchangeIDType		ExchangeID;
	/// 证券代码
	TShengliStockSymbolType			Symbol;
};

///融资负债查询
struct CShengliCreditFinancePositionQueryField
{
	///用户ID
	TShengliStockUserIDType			UserID;
	///客户号
	TShengliStockClientIdType		ClientID;
	/// 交易市场
	TShengliStockExchangeIDType		ExchangeID;
	/// 证券代码
	TShengliStockSymbolType			Symbol;
	/// 业务类别
	TShengliStockBusinessType		BussType;
};

///融券负债查询
struct CShengliCreditSellshortPositionQueryField
{
	///用户ID
	TShengliStockUserIDType			UserID;
	///客户号
	TShengliStockClientIdType		ClientID;
	/// 交易市场
	TShengliStockExchangeIDType		ExchangeID;
	/// 证券代码
	TShengliStockSymbolType			Symbol;
	/// 业务类别
	TShengliStockBusinessType		BussType;
};

///融资负债明细查询
struct CShengliCreditFinanceDebtQueryField
{
	///用户ID
	TShengliStockUserIDType			UserID;
	///客户号
	TShengliStockClientIdType		ClientID;
	/// 交易市场
	TShengliStockExchangeIDType		ExchangeID;
	/// 证券代码
	TShengliStockSymbolType			Symbol;
	///合同编号
	TShengliContractNumber			ContractNumber;
	/// 业务类别
	TShengliStockBusinessType		BussType;
	/// 页码
	TShengliPageNum					PageNum;
	/// 每页数量
	TShengliPageSize				PageSize;
};

///融券负债明细查询
struct CShengliCreditSellshortDebtQueryField
{
	///用户ID
	TShengliStockUserIDType			UserID;
	///客户号
	TShengliStockClientIdType		ClientID;
	/// 交易市场
	TShengliStockExchangeIDType		ExchangeID;
	/// 证券代码
	TShengliStockSymbolType			Symbol;
	///合同编号
	TShengliContractNumber			ContractNumber;
	/// 业务类别
	TShengliStockBusinessType		BussType;
	/// 页码
	TShengliPageNum					PageNum;
	/// 每页数量
	TShengliPageSize				PageSize;
};

/// 担保品列表查询返回
struct CShengliCreditGuarantyListField
{
	
	TShengliStockExchangeIDType			ExchangeID;	/// 交易市场
	TShengliStockSymbolType				Symbol;	/// 证券代码
	TShengliStockSymbolNameType			SecurityName;	/// 证券名称
	TShengliStockSecurityTypeType		SecurityType;///证券类型	
	TShengliStockSecuritySubTypeType	SecuritySubType;///证券子类型
	TShengliStockSubstCashRateType		ConversionRate;/// 折算率
	TShengliStockOrderPriceType			Price;	/// 公允价格
	TShengliStockFairFlag				FairFlag; /// 公允标记
	TShengliStockTradingDateType		EndDate;	/// 有效截止日期
};

/// 可融资标的头寸查询 返回
struct CShengliCreditFinanceCashField
{
	TShengliStockRequestIDType		RequestID; ///请求ID
	TShengliStockUserIDType			UserID;		///用户ID
	TShengliStockClientIdType		ClientID;	///客户号
	TShengliStockExchangeIDType		ExchangeID;	/// 交易市场
	TShengliStockSymbolType			Symbol;	/// 证券代码
	TShengliStockSymbolNameType		SecurityName;	/// 证券名称
	TShengliStockSecurityTypeType		SecurityType;///证券类型	
	TShengliStockSecuritySubTypeType	SecuritySubType;///证券子类型
	TShengliStockBusinessType		BusinessType;///业务类别
	TShengliStockSubstCashRateType	MarginRatio;///融资保证金比例
	TShengliStockTradingDateType	EndDate;///有效截止日期
};

/// 可融券标的头寸查询 返回
struct CShengliCreditSellshortCashField
{
	TShengliStockRequestIDType		RequestID; ///请求ID
	TShengliStockUserIDType			UserID;		///用户ID
	TShengliStockClientIdType		ClientID;	///客户号
	TShengliStockExchangeIDType		ExchangeID;	/// 交易市场
	TShengliStockSymbolType			Symbol;	/// 证券代码
	TShengliStockSymbolNameType		SecurityName;	/// 证券名称
	TShengliStockSecurityTypeType		SecurityType;///证券类型	
	TShengliStockSecuritySubTypeType	SecuritySubType;///证券子类型
	TShengliStockBusinessType		BusinessType;///业务类别
	TShengliStockSubstCashRateType	MarginRatio;///融券保证金比例
	TShengliStockQtyType			AvailQty;///可融数量
	TShengliStockTradingDateType	EndDate;///有效截止日期
};

/// 合约展期查询返回 （放后面）
struct CShengliCreditContractExtensionField
{
	TShengliStockRequestIDType		RequestID; ///请求ID
	TShengliStockUserIDType			UserID;		///用户ID
	TShengliStockClientIdType		ClientID;	///客户号
	TShengliStockTradingDateType	Date;///日期
	TShengliContractNumber			ContractNumber;///合同编号
	TShengliTradeAccount			TradeAccount;///股东账户
	TShengliStockCurrencyType		MonetaryUnit;///货币单位
	TShengliStockExchangeIDType		ExchangeID;	/// 证券市场
	TShengliStockSymbolType			Symbol;	/// 证券代码
	TShengliStockSymbolNameType		SecurityName;	/// 证券名称
	TShengliStockOrderPriceType		EntrustPrice;///委托价格
	TShengliStockQtyType			EntrustQty;///委托数量
	TShengliStockQtyType			ExecQty;///成交数量
	TShengliStockOrderPriceType		ExecPrice;///成交均价
	TShengliStockAmountType			ExecAmount;///成交金额
	TShengliStockSideType			Side;///买卖类别
	TShengliExtensionStatusType		ExtensionStatus;///展期状态
	TShengliStockSubstCashRateType	MarginRatio;///保证金比例
	TShengliStockQtyType			BeginQty;///期初合约数量
	TShengliStockAmountType			BeginAmount;///期初合约金额
	TShengliStockQtyType			RepayQty;///已还合约数量
	TShengliStockAmountType			RepayAmount;///已还合约金额
	TShengliStockAmountType			DebtInterest;///负债利息
	TShengliStockAmountType			RepayInterest;///已还利息
	TShengliStockTradingDateType	BeginDate;///开始日期
	TShengliStockTradingDateType	EndDate;///结束日期

};

/// 账户资金查询返回
struct CShengliCreditAccountField
{
	TShengliStockRequestIDType		RequestID; ///请求ID
	TShengliStockUserIDType			UserID;		///用户ID
	TShengliStockExchangeIDType		ExchangeID;///交易所
	TShengliStockClientIdType		ClientID;///客户号
	TShengliStockAccountType		FundAccount;///资金账户
	TShengliTradeAccount			TradeAccount;///股东账户
	TShengliStockBusinessType		BussType;///业务类别
	TShengliStockAmountType			FinanceLimit;///融资额度
	TShengliStockAmountType			SellshortLimit;///融券额度
	TShengliStockAmountType			FinanceDebt;///融资总负债
	TShengliStockAmountType			SellshortDebt;///融券总负债
	TShengliStockSubstCashRateType	MarginGuarantyRatio;///维持担保比例
	TShengliStockAmountType			AvailMargin;///可用保证金
	TShengliStockAmountType			AvailAmount;///可用金额
	TShengliStockAmountType			FinanceMktValue;///融资市值
	TShengliStockAmountType			SellshortMktValue;///融券市值
	TShengliStockAmountType			GuarantyMktValue;///担保品市值
	TShengliStockAmountType			TotalAssets;///信用账户总资产
	TShengliStockAmountType			GuarantyFrozenAmount;///担保品冻结金额
	TShengliStockAmountType			FinanceFrozenAmount;///融资冻结负债
	TShengliStockAmountType			SellshortFrozenAmount;///融券冻结负债

};
/// 担保品持仓查询返回 
struct CShengliCreditGuarantyPositionField
{
	TShengliStockRequestIDType			RequestID; ///请求ID
	TShengliStockUserIDType				UserID;///用户ID
	TShengliStockClientIdType			ClientID;///客户号
	TShengliStockAccountTypeType		AccountType;///资金帐户类型
	TShengliStockAccountType			FundAccount;///资金帐户
	TShengliStockExchangeIDType			ExchID;///交易所
	TShengliStockSecurityTypeType		SecurityType;///证券类型	
	TShengliStockSecuritySubTypeType	SecuritySubType;///证券子类型
	TShengliStockSymbolType				SecurityCode;///证券代码	
	TShengliStockPosQtyType				InitOvnPosQty;///初始隔夜仓数量	
	TShengliStockPosQtyType				CurOvnQty;///剩余昨仓, 所持量, 不考虑备兑锁定, 平仓锁定等	
	TShengliStockPosQtyType				CurQty;///总仓位，包括今仓, 所持量, 不考虑备兑锁定, 平仓锁定等	
	TShengliStockPosQtyType				AvailQty;///总可平仓数量, 考虑所有锁定数量	
	TShengliStockPosQtyType				ClosePosPendingQty;///总平仓挂单量
	TShengliStockOrderPriceType			AvgPx;/// 持仓均价
};
/// 融资负债查询返回
struct CShengliCreditFinancePositionField
{
	TShengliStockRequestIDType		RequestID; ///请求ID
	TShengliStockUserIDType			UserID;		///用户ID
	TShengliStockExchangeIDType		ExchangeID;///交易所
	TShengliStockClientIdType		ClientID;///客户号
	TShengliStockAccountType		FundAccount;///资金账户
	TShengliTradeAccount			TradeAccount;///股东账户
	TShengliStockSymbolType			Symbol;	/// 证券代码
	TShengliStockSymbolNameType		SecurityName;	/// 证券名称
	TShengliDebtType				DebtType;///负债类别
	TShengliStockBusinessType		BussType;///业务类别
	TShengliStockAmountType			BeginDebtAmount;///期初负债金额
	TShengliStockQtyType			BeginDebtQty;///期初负债数量
	TShengliStockAmountType			CurrentDebtAmount;///当前负债金额
	TShengliStockQtyType			CurrentDebtQty;///当前负债数量
	TShengliStockAmountType			CurrentDebtMktValue;///当前负债市值
	TShengliStockAmountType			FinancePL;///融资盈亏
};
/// 融券负债查询返回 
struct CShengliCreditSellshortPositionField
{
	TShengliStockRequestIDType		RequestID; ///请求ID
	TShengliStockUserIDType			UserID;		///用户ID
	TShengliStockExchangeIDType		ExchangeID;///交易所
	TShengliStockClientIdType		ClientID;///客户号
	TShengliStockAccountType		FundAccount;///资金账户
	TShengliTradeAccount			TradeAccount;///股东账户
	TShengliStockSymbolType			Symbol;	/// 证券代码
	TShengliStockSymbolNameType		SecurityName;	/// 证券名称
	TShengliDebtType				DebtType;///负债类别
	TShengliStockBusinessType		BussType;///业务类别
	TShengliStockAmountType			BeginDebtAmount;///期初负债金额
	TShengliStockQtyType			BeginDebtQty;///期初负债数量
	TShengliStockAmountType			CurrentDebtAmount;///当前负债金额
	TShengliStockQtyType			CurrentDebtQty;///当前负债数量
	TShengliStockAmountType			CurrentDebtMktValue;///当前负债市值
	TShengliStockAmountType			SellshortPL;///融券盈亏
};
/// 融资负债明细返回
struct CShengliCreditFinanceDebtField
{
	TShengliStockRequestIDType		RequestID; ///请求ID
	TShengliStockUserIDType			UserID;		///用户ID
	TShengliStockExchangeIDType		ExchangeID;///交易所
	TShengliStockClientIdType		ClientID;///客户号
	TShengliStockAccountType		FundAccount;///资金账户
	TShengliTradeAccount			TradeAccount;///股东账户
	TShengliStockSymbolType			Symbol;	/// 证券代码
	TShengliStockSymbolNameType		SecurityName;	/// 证券名称
	TShengliStockAmountType			DebtAmount;///负债金额
	TShengliContractNumber			ContractNumber;///合同编号
	TShengliStockTradingDateType	OpenDate;///开仓日期
	TShengliDebtType				DebtType;///负债类别
	TShengliStockBusinessType		BussType;///业务类别
	TShengliStockAmountType			OpenAmount;///开仓金额
	TShengliStockQtyType			OpenQty;///开仓数量
	TShengliStockAmountType			CurrentDebtAmount;///当前负债金额
	TShengliStockQtyType			CurrentDebtQty;///当前负债数量
	TShengliStockAmountType			RepayAmount;///已还金额
	TShengliStockTradingDateType	EndDate;///归还截止日期
	TShengliStockAmountType			FinancePL;///融资盈利
	TShengliTotalNum				TotalNum;///负债记录总数
};
/// 融券负债明细返回
struct CShengliCreditSellshortDebtField
{
	TShengliStockRequestIDType		RequestID; ///请求ID
	TShengliStockUserIDType			UserID;		///用户ID
	TShengliStockExchangeIDType		ExchangeID;///交易所
	TShengliStockClientIdType		ClientID;///客户号
	TShengliStockAccountType		FundAccount;///资金账户
	TShengliTradeAccount			TradeAccount;///股东账户
	TShengliStockSymbolType			Symbol;	/// 证券代码
	TShengliStockSymbolNameType		SecurityName;	/// 证券名称
	TShengliStockAmountType			DebtAmount;///负债金额
	TShengliContractNumber			ContractNumber;///合同编号
	TShengliStockTradingDateType	OpenDate;///开仓日期
	TShengliDebtType				DebtType;///负债类别
	TShengliStockBusinessType		BussType;///业务类别
	TShengliStockAmountType			OpenAmount;///开仓金额
	TShengliStockQtyType			OpenQty;///开仓数量
	TShengliStockAmountType			CurrentDebtAmount;///当前负债成本
	TShengliStockQtyType			CurrentDebtQty;///当前负债数量
	TShengliStockQtyType			RepayQty;///已还数量
	TShengliStockTradingDateType	EndDate;///归还截止日期
	TShengliStockAmountType			SellshortPL;///融券盈利
	TShengliTotalNum				TotalNum;///负债记录总数
};

#pragma pack(pop)

#endif
