﻿/*!
* \file  ShengliStockUserApiErr.h
* \brief 交易和查询客户端公共的头文件
*
* 此文件描述了使用交易和查询客户端的错误类型
*
* \author  SHENGLI
* \version 1.0
* \date    2014-04-18
*/

#pragma  once

#ifndef _EES_TRADE_API_ERROR_H_
#define _EES_TRADE_API_ERROR_H_

/// 没有错误
#ifndef NO_ERROR
#define NO_ERROR                    0	
#endif

/// 连接服务失败
#define CONN_SERVER_FAILED          1

/// 连接服务失败，一般会在服务器断开时候这个错误
#define REMOTE_DISCONN_SERVER       2	

/// 本地网络断开，会在本地主动断开的时候，产生这个错误
#define LOCAL_DISCONN_SERVER        3

/// 网络出错，网络异常，会产生这个错误
#define NEWWORK_ERROR               4

/// 登录服务失败，会在登录的时候产生
#define LOGON_FAILED                5	

/// 用户进行操作，是需要提前登录的，如果没有登录会产生这个错误
#define NOT_LOGON                   6

/// 操作之前，需要连接服务器
#define NO_CONN_SERVER              7	

/// 错误的交易对象句柄
#define HANDLE_ERRNOR               8	 

/// 设置订单 token 错误
#define ORDER_TOKEN_ERROR			9

/// 非法的密码，目前只支持全空密码检测
#define INVALID_PASSWORD_ERROR		10

/// 查询太频繁 。
#define INVALID_QUERY_FLOW_CONTROL		11

/// 不支持的交易类别
#define INVALID_TRADE_TYPE			18

/// 参数非法(包含:参数数量不对[批量报价单数量为0, 组合策略腿不为2, 合并行权腿不为2])
#define PARAM_ERROR					19

/// 协议类型错误
#define PROTO_TYPE_ERROR			20

/// udp未连接
#define UDP_NOT_CONN    			21

/// 不支持该协议
#define NOT_SUPPORT_PROTO           22

/// 预热需要依赖efvi模式
#define NEED_EFVI_MODE              23

#endif

/// 客户号错误
#define CLIENT_ERROR			1000

/// 资金账户错误
#define FUND_ACCT_ERROR			1001

/// 资金错误
#define AMOUNT_ERROR			1002

/// 出入金错误
#define INOT_BP_ERROR			1003

/// 用户ID与客户号绑定信息错误(一般出现为客户号信息未绑定user_id的情况, 有可能是客户号信息填写错误了)
#define CLIENT_NOT_BINDING_USER_ID 1004