#pragma once 

#include <string.h>
#include "ShengliOptTradeRawMsgTypedef.h"

#define SL_MSG_HEARTBEAT    2015    /// 心跳消息码
#define SL_MSG_NEW_ORDER    10      /// 下单，包括，证券，期权，组合，行权
#define SL_MSG_CXL_ORDER    13      /// 撤单

#pragma pack(push, 1)

// 消息头
struct sl_msg_client_header
{
	uInt32	m_MsgType;      /// 消息码，只支持 10 13 
	uInt32	m_MsgLen;       /// 消息长度,包括消息头
} ; 

// 心跳
struct sl_msg_client_heartbeat
{
    sl_msg_client_heartbeat()
    {
        memset(this, 0, sizeof(sl_msg_client_heartbeat)); 

        m_Header.m_MsgType = SL_MSG_HEARTBEAT ; 
        m_Header.m_MsgLen = sizeof(sl_msg_client_heartbeat) ;
    }

    sl_msg_client_header        m_Header ;      /// 消息头
	uInt32					    m_UserID;       /// 用户ID
	uInt8					    m_Reserved[4];  /// 保留字段
} ;

// 下单基础结构体
struct sl_msg_client_req_body
{
    uInt32					m_UserID;               /// 用户ID
	uInt32					m_ClOrdToken;           /// 客户订单号，要自己维护，后面的要大于前面的
	T_CUST_ID				m_cust_id;              /// 客户号
    uInt8		            m_SecurityType;         /// 证券类型，可不填
    uInt8                   m_SecuritySubType ;     /// 证券子类型，可不填
    uInt8   				m_PfpFlag;				/// 盘后定价交易标志，可不填
    uInt8					m_LotType;              /// 可不填
    char                    m_DelegateType;         /// 委托类型
    uInt8                   m_ToBypass2;            /// Bypass,传啥返回啥,根据需要填写
    uInt8                   m_ToBypass3;            /// Bypass,传啥返回啥,根据需要填写
    T_FUND_ACCOUNT			m_FundAccount;          /// 资金账户
    uInt8					m_ForceCoverFlag;		/// 只要不为0，就是强平的原因。
    uInt8   				m_ExchID;				/// 交易所
    uInt8					m_Side;					/// 订单方向
    uInt32					m_OrderQty;				/// 订单数量
    uInt32					m_MinQty;				/// 最小成交数量 
    uInt8			        m_PriceType;			/// 价格类型
    uInt16					m_MaxPriceLevels;		/// 最大价格等级
    uInt8					m_TIF;					/// 订单有效期    
    uInt64			        m_Price;				/// 价格
    uInt64     		    	m_StopPrice;		    /// 止损价，可不填
    T_SECURITY_CODE			m_SecurityCode;         /// 证券代码，合约代码
    uInt8		            m_CashMarginFlag;       /// 可不填
    uInt8					m_SessionID;            /// 交易所连接会话在ID
    uInt8           		m_SessionSelMode;       /// 交易所连接会话选择方式
    uInt32                  m_ToBypass4;            /// Bypass,传啥返回啥,根据需要填写
    uInt32					m_UserInfo1;			/// opstationID
    uInt32					m_UserInfo2;            /// Bypass,传啥返回啥,根据需要填写
};

// 下单结构 
struct  sl_msg_client_new_order 
{
    sl_msg_client_new_order()
    {
        memset(this, 0, sizeof(sl_msg_client_new_order)); 

        m_Header.m_MsgType = SL_MSG_NEW_ORDER ; 
        m_Header.m_MsgLen = sizeof(sl_msg_client_new_order) ;
    }
    sl_msg_client_header       m_Header ;           /// 下单消息头
    sl_msg_client_req_body     m_body;              /// 下单消息体
    
};

// 组合单腿
struct comb_leg
{
	comb_leg()
	{
		memset(this, 0, sizeof(comb_leg));
	}

	T_SECURITY_CODE	m_LegSecurityID;		///	成份合约代码（期权code）
	uInt8			m_Exchange;				///	交易所
	uInt8			m_LegPosDir;			///	持仓方向
	uInt32			m_LegOrderQty;			///	成份合约数量
	uInt8			m_Reserver2;			///	保留
};

// 组合扩展字段
struct sl_msg_comb_extern
{
    T_ExchCombSeqID		m_SecondaryOrderID; ///<	组合策略流水号， 16位有效	构建组合申报时填全 0 ，解除组合申报时填写拟解除组合对应的组合流水号（构建组合申报时返回的执行报告中的OrderID）
	T_SECURITY_CODE		m_StrategyID;		///<	组合策略编码
	uInt8				m_Nolegs;			///<	成分合约个数（最多支持4，目前市场最多是2）
	uInt8				m_Reserve1[5];		///< 	保留
	comb_leg			m_legs[2];			///<	多腿 
} ;

// 组合，拆分 单
struct sl_msg_client_order_comb : sl_msg_client_new_order
{
    sl_msg_client_order_comb()
    {
        memset(this, 0, sizeof(sl_msg_client_order_comb)); 

        m_Header.m_MsgType = SL_MSG_NEW_ORDER ; 
        m_Header.m_MsgLen = sizeof(sl_msg_client_order_comb) ;
    }

    sl_msg_comb_extern m_comb_extern ;      /// 组合扩展信息
} ;

// 组合行权扩展结构体
struct sl_msg_comb_exercise_extern 
{
    uInt8		m_Nolegs;				///	成分合约个数（最多支持4，目前市场最多是2）
	uInt8		m_Reserve[7];			///	保留
	comb_leg	m_legs[2];              /// 行权的两腿 信息
} ;

// 组合行权
struct sl_msg_client_order_comb_exercise : sl_msg_client_new_order
{
    sl_msg_client_order_comb_exercise()
    {
        memset(this, 0, sizeof(sl_msg_client_order_comb_exercise)); 

        m_Header.m_MsgType = SL_MSG_NEW_ORDER ; 
        m_Header.m_MsgLen = sizeof(sl_msg_client_order_comb_exercise) ;
    }

    sl_msg_comb_exercise_extern   m_comb_exercise ;     /// 组合行权扩展结构体
} ;

// 单边平仓 
struct sl_msg_client_one_side_close : sl_msg_client_new_order
{
    sl_msg_client_one_side_close()
    {
        memset(this, 0, sizeof(sl_msg_client_one_side_close)); 

        m_Header.m_MsgType = SL_MSG_NEW_ORDER ; 
        m_Header.m_MsgLen = sizeof(sl_msg_client_one_side_close) ;
    }

    sl_msg_comb_extern              m_comb_extern ;         /// 单边平仓，组合信息
} ;


// 户端撤单请求消息体
struct client_cxl_req_body
{
    uInt32					m_UserID;           /// 用户ID
	uInt32					m_ClOrdToken;       /// 用户下单客户号，自行维护，后面的要大于前面的
	T_CUST_ID				m_ClientID;         /// 客户号
	char                    m_DelegateType;     /// 委托类型
	uInt16                  m_ToBypass1;        /// Bypass,传啥返回啥,根据需要填写
	uInt32					m_OrigUserID;       /// 订单原始用户
	T_FUND_ACCOUNT			m_FundAccount;      /// 资金账户
	uInt8                   m_ToBypass2;        /// Bypass,传啥返回啥,根据需要填写
	uInt8                   m_ToBypass3;        /// Bypass,传啥返回啥,根据需要填写
	uInt8                   m_ToBypass4;        /// Bypass,传啥返回啥,根据需要填写
	uInt32					m_UserInfo1;        /// Bypass,传啥返回啥,根据需要填写
	uInt64					m_OrigOrderID;      /// 原始订单号    
	uInt32					m_OrigClOrdToken;   /// 原始客户单号
	uInt32					m_LeavesQty;        /// 可以不填写
};

// 撤单结构体
struct  sl_msg_client_cxl_order 
{
    sl_msg_client_cxl_order()
    {
        memset(this, 0, sizeof(sl_msg_client_cxl_order)); 

        m_Header.m_MsgType = SL_MSG_CXL_ORDER ; 
        m_Header.m_MsgLen = sizeof(sl_msg_client_cxl_order) ;
    }
    sl_msg_client_header       m_Header ;
    client_cxl_req_body         m_reqBody ;
};

#pragma pack(pop)
