#pragma  once

#include <stdlib.h>
#include <string.h>

#include <string>
using namespace std ;

template< unsigned short Len =32 >
struct fix_str
{
	char	m_val[Len] ;
	fix_str()
	{
		memset(m_val, 0, Len);
	}

    fix_str(const char *str)
    {
        *this = str;
    }

    static unsigned short max_len()
    {
        return Len;
    }
    bool is_empty()
    {
        return m_val[0] == 0x00;
    }

    template <unsigned short Len2>
    fix_str &operator=(const fix_str<Len2> &obj)
	{
        *this = obj.c_str();
		return *this;
	}

	fix_str& operator = (const char* p_str )
	{
		if (p_str == NULL)
		{
			m_val[0] = 0;
			return *this;
		}

		int n_idx = 0 ;
        while (p_str[n_idx] && n_idx < (Len -1))
        {
			m_val[n_idx] = p_str[n_idx] ;
			++n_idx;
		}
		for (int i = n_idx; i < Len; i++)
			m_val[i] = 0x00 ;
		return *this ;
	}

	fix_str& operator = (const string& p_str )
	{
		*this = p_str.c_str() ;
		return *this ;
	}

	fix_str& assign (const char* p_str , int beg_pos, int len)
	{
		if (len > max_len())
		{
			len = max_len() - 1;
		}

		memcpy(m_val, p_str + beg_pos, len);
		m_val[len] = 0x00;
		return *this;
	}

    bool operator<(const char *p_str) const
    {
        return (strcmp(m_val, p_str) < 0);
    }

    bool operator<(const string &str) const
    {
        return (strcmp(m_val, str.c_str()) < 0);
    }

    template <unsigned short Len2>
    bool operator<(const fix_str<Len2> &str) const
    {
        return (strcmp(m_val, str.c_str()) < 0);
    }

    bool operator==(const char *p_str) const
    {
        return (strcmp(m_val, p_str) == 0);
    }

    bool operator==(const string &str) const
    {
        return (strcmp(m_val, str.c_str()) == 0);
    }

    template <unsigned short Len2>
    bool operator==(const fix_str<Len2> &str) const
    {
        return (strcmp(m_val, str.c_str()) == 0);
    }
    bool operator!=(const char *p_str) const
    {
        return (strcmp(m_val, p_str) != 0);
    }

    bool operator!=(const string &str) const
    {
        return (strcmp(m_val, str.c_str()) != 0);
    }

    template <unsigned short Len2>
    bool operator!=(const fix_str<Len2> &str) const
    {
        return (strcmp(m_val, str.c_str()) != 0);
    }

    operator const char *() const
    {
        return m_val;
    }

	operator char*()
	{
		return m_val ;
	}

	char& operator [] (unsigned short offset)
	{
		return m_val[offset];
	}

	int length()
	{
		return strlen(m_val);
	}

	const char* cstr() const
	{
		return m_val;
	}

    const char *c_str() const
    {
        return m_val;
    }

    char *str()
    {
        return m_val;
    }

	fix_str remove_str( const char* old_str)
	{
		return replace_str(old_str, "");
	}

	fix_str replace_str( const char* old_str, const char* new_str )
	{

		if ( old_str == NULL )
			return *this ;

		if ( new_str == NULL )
			return *this ;

		char buf[Len] = { 0x00 };
		int odlLen = strlen(old_str);
		int newLen = strlen(new_str);

		char * p_new_pos = buf;
		char * p_pos = m_val;

		while ( *p_pos )
		{
			if ( memcmp(old_str, p_pos, odlLen) == 0 )
			{
				p_pos += odlLen;
				if (new_str != 0x00)
				{
					strcat(p_new_pos, new_str);
					p_new_pos += newLen;
				}
			}
			else
			{
				*p_new_pos = *p_pos;
				++p_pos;
				++p_new_pos;
			}
		}
		*p_new_pos = 0x00;

		return fix_str(buf);
	}

};

template <unsigned short Len>
ostream &operator<<(ostream &out, const fix_str<Len> &str)
{
    return out << str.c_str();
}

template <unsigned short Len>
bool operator<(const string &str1, const fix_str<Len> &str2)
{
    return (strcmp(str1.c_str(), str2.c_str()) < 0);
}

template <unsigned short Len>
bool operator<(const char *str1, const fix_str<Len> &str2)
{
    return (strcmp(str1, str2.c_str()) < 0);
}

template <unsigned short Len>
bool operator==(const string &str1, const fix_str<Len> &str2)
{
    return (strcmp(str1.c_str(), str2.c_str()) == 0);
}

template <unsigned short Len>
bool operator==(const char *str1, const fix_str<Len> &str2)
{
    return (strcmp(str1, str2.c_str()) == 0);
}

template <unsigned short Len>
bool operator!=(const string &str1, const fix_str<Len> &str2)
{
    return (strcmp(str1.c_str(), str2.c_str()) != 0);
}

template <unsigned short Len>
bool operator!=(const char *str1, const fix_str<Len> &str2)
{
    return (strcmp(str1, str2.c_str()) != 0);
}
